/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import org.openide.ErrorManager;
import org.openide.util.io.NbObjectInputStream;
import org.openide.util.io.NbObjectOutputStream;

public final class NbMarshalledObject
implements Serializable {
    private byte[] objBytes = null;
    private int hash;
    private static final long serialVersionUID = 7842398740921434354L;
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public NbMarshalledObject(Object obj) throws IOException {
        if (obj == null) {
            this.hash = 17;
            return;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        NbObjectOutputStream out = new NbObjectOutputStream(bout);
        out.writeObject(obj);
        out.flush();
        this.objBytes = bout.toByteArray();
        int h = 0;
        int i = 0;
        while (i < this.objBytes.length) {
            h = 37 * h + this.objBytes[i];
            ++i;
        }
        this.hash = h;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get() throws IOException, ClassNotFoundException {
        Object object;
        NbObjectInputStream ois;
        block8: {
            if (this.objBytes == null) {
                return null;
            }
            ByteArrayInputStream bin = new ByteArrayInputStream(this.objBytes);
            ois = new NbObjectInputStream(bin);
            try {
                int i;
                StringBuffer buf;
                IOException ioe;
                try {
                    object = ois.readObject();
                    Object var9_5 = null;
                    break block8;
                }
                catch (RuntimeException weird) {
                    ioe = new IOException(weird.toString());
                    buf = new StringBuffer(this.objBytes.length * 2 + 20);
                    buf.append("Bad ser data: ");
                    i = 0;
                }
                while (true) {
                    if (i >= this.objBytes.length) {
                        ErrorManager.getDefault().annotate(ioe, 0, buf.toString(), null, weird, null);
                        throw ioe;
                    }
                    int b = this.objBytes[i];
                    if (b < 0) {
                        b += 256;
                    }
                    buf.append(HEX[b / 16]);
                    buf.append(HEX[b % 16]);
                    ++i;
                }
            }
            catch (Throwable throwable) {
                Object var9_6 = null;
                ois.close();
                throw throwable;
            }
        }
        ois.close();
        return object;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj instanceof NbMarshalledObject) {
            NbMarshalledObject other = (NbMarshalledObject)obj;
            return Arrays.equals(this.objBytes, other.objBytes);
        }
        return false;
    }
}

