/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.ImageIcon;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

final class IconManager {
    private static final Object NO_ICON = new Object();
    private static final HashMap map = new HashMap();
    private static final HashMap reverseMap = new HashMap();
    private static final Set extraInitialSlashes = new HashSet(200);
    private static ClassLoader currentLoader = null;
    private static Lookup.Result loaderQuery = null;
    private static boolean noLoaderWarned = false;
    static /* synthetic */ Class class$java$lang$ClassLoader;
    static /* synthetic */ Class class$org$openide$util$IconManager;

    IconManager() {
    }

    private static ClassLoader getLoader() {
        if (currentLoader == null) {
            Iterator it;
            if (loaderQuery == null) {
                loaderQuery = Lookup.getDefault().lookup(new Lookup.Template(class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = IconManager.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader));
                loaderQuery.addLookupListener(new LookupListener(){

                    public void resultChanged(LookupEvent ev) {
                        currentLoader = null;
                    }
                });
            }
            if ((it = loaderQuery.allInstances().iterator()).hasNext()) {
                currentLoader = (ClassLoader)it.next();
            } else if (!noLoaderWarned) {
                noLoaderWarned = true;
                ErrorManager.getDefault().log(16, "No ClassLoader instance found in " + Lookup.getDefault());
            }
        }
        return currentLoader;
    }

    static Image getIcon(String name) {
        Object img = map.get(name);
        if (img == NO_ICON) {
            return null;
        }
        if (img != null) {
            img = ((Reference)img).get();
        }
        if (img != null) {
            return (Image)img;
        }
        ClassLoader loader = IconManager.getLoader();
        if (loader == null) {
            return null;
        }
        return IconManager.getIcon(name, loader);
    }

    static Image getIcon(String name, ClassLoader loader) {
        Object img = map.get(name);
        if (img == NO_ICON) {
            return null;
        }
        if (img != null) {
            img = ((Reference)img).get();
        }
        if (img != null) {
            return (Image)img;
        }
        HashMap hashMap = map;
        synchronized (hashMap) {
            String n;
            boolean warn;
            img = map.get(name);
            if (img == NO_ICON) {
                Image image = null;
                return image;
            }
            if (img != null) {
                img = ((Reference)img).get();
            }
            if (img != null) {
                Image image = (Image)img;
                return image;
            }
            if (name.startsWith("/")) {
                warn = true;
                n = name.substring(1);
            } else {
                warn = false;
                n = name;
            }
            URL url = loader != null ? loader.getResource(n) : (class$org$openide$util$IconManager == null ? (class$org$openide$util$IconManager = IconManager.class$("org.openide.util.IconManager")) : class$org$openide$util$IconManager).getClassLoader().getResource(n);
            Image image = img = url == null ? null : Toolkit.getDefaultToolkit().createImage(url);
            if (img != null) {
                if (warn && extraInitialSlashes.add(name)) {
                    ErrorManager.getDefault().log(16, "Initial slashes in Utilities.loadImage deprecated (cf. #20072): " + name);
                }
                Image img2 = IconManager.toBufferedImage((Image)img);
                ActiveRef r = new ActiveRef(img2);
                map.put(name, r);
                Image image2 = img2;
                return image2;
            }
            map.put(name, NO_ICON);
            Image image3 = null;
            return image3;
        }
    }

    static final Image mergeImages(Image im1, Image im2, int x, int y) {
        CompositeImageKey k = new CompositeImageKey(im1, im2, x, y);
        HashMap hashMap = map;
        synchronized (hashMap) {
            Image cached;
            Reference r = (Reference)map.get(k);
            if (r != null && (cached = (Image)r.get()) != null) {
                Image image = cached;
                return image;
            }
            cached = IconManager.doMergeImages(im1, im2, x, y);
            r = new ActiveRef(cached);
            map.put(k, r);
            reverseMap.put(r, k);
            Image image = cached;
            return image;
        }
    }

    static final Image toBufferedImage(Image img) {
        new ImageIcon(img);
        BufferedImage rep = IconManager.createBufferedImage(img.getWidth(null), img.getHeight(null));
        Graphics2D g = rep.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        img.flush();
        return rep;
    }

    private static final Image doMergeImages(Image image1, Image image2, int x, int y) {
        int w = 0;
        int h = 0;
        if (image1 != null) {
            w = image1.getWidth(null);
            h = image1.getHeight(null);
        }
        if (image2 != null) {
            w = image2.getWidth(null) + x > w ? image2.getWidth(null) + x : w;
            int n = h = image2.getHeight(null) + y > h ? image2.getHeight(null) + y : h;
        }
        if (w < 1) {
            w = 16;
        }
        if (h < 1) {
            h = 16;
        }
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(w, h), model.isAlphaPremultiplied(), null);
        Graphics2D g = buffImage.createGraphics();
        if (image1 != null) {
            g.drawImage(image1, 0, 0, null);
        }
        if (image2 != null) {
            g.drawImage(image2, x, y, null);
        }
        g.dispose();
        return buffImage;
    }

    static final BufferedImage createBufferedImage(int width, int height) {
        ColorModel model = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel(2);
        BufferedImage buffImage = new BufferedImage(model, model.createCompatibleWritableRaster(width, height), model.isAlphaPremultiplied(), null);
        return buffImage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ActiveRef
    extends SoftReference
    implements Runnable {
        public ActiveRef(Object o) {
            super(o, Utilities.activeReferenceQueue());
        }

        public void run() {
            HashMap hashMap = map;
            synchronized (hashMap) {
                Object k = reverseMap.remove(this);
                map.remove(k);
            }
        }
    }

    private static class CompositeImageKey {
        Image baseImage;
        Image overlayImage;
        int x;
        int y;

        CompositeImageKey(Image base, Image overlay, int x, int y) {
            this.x = x;
            this.y = y;
            this.baseImage = base;
            this.overlayImage = overlay;
        }

        public boolean equals(Object other) {
            if (!(other instanceof CompositeImageKey)) {
                return false;
            }
            CompositeImageKey k = (CompositeImageKey)other;
            return this.x == k.x && this.y == k.y && this.baseImage == k.baseImage && this.overlayImage == k.overlayImage;
        }

        public int hashCode() {
            int hash = (this.x << 3 ^ this.y) << 4;
            hash = hash ^ this.baseImage.hashCode() ^ this.overlayImage.hashCode();
            return hash;
        }

        public String toString() {
            return "Composite key for " + this.baseImage + " + " + this.overlayImage + " at [" + this.x + ", " + this.y + "]";
        }
    }
}

