/*
 * Decompiled with CFR 0.152.
 */
package org.openide.text;

import java.io.Writer;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.openide.ServiceType;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public abstract class IndentEngine
extends ServiceType {
    static final long serialVersionUID = -8548906260608507035L;
    private static final String HELP_ID = "editing.indentation";
    private static HashMap map = new HashMap(7);
    private static IndentEngine INSTANCE = null;
    static /* synthetic */ Class class$org$openide$text$IndentEngine;

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public abstract int indentLine(Document var1, int var2);

    public abstract int indentNewLine(Document var1, int var2);

    public abstract Writer createWriter(Document var1, int var2, Writer var3);

    protected boolean acceptMimeType(String mime) {
        return false;
    }

    public static synchronized void register(String mime, IndentEngine eng) {
        map.put(mime, eng);
    }

    public static Enumeration indentEngines() {
        return Collections.enumeration(Lookup.getDefault().lookup(new Lookup.Template(class$org$openide$text$IndentEngine == null ? (class$org$openide$text$IndentEngine = IndentEngine.class$("org.openide.text.IndentEngine")) : class$org$openide$text$IndentEngine)).allInstances());
    }

    public static synchronized IndentEngine find(String mime) {
        IndentEngine eng;
        Enumeration en = IndentEngine.indentEngines();
        while (en.hasMoreElements()) {
            eng = (IndentEngine)en.nextElement();
            if (!eng.acceptMimeType(mime)) continue;
            return eng;
        }
        eng = (IndentEngine)map.get(mime);
        if (eng != null) {
            return eng;
        }
        return IndentEngine.getDefault();
    }

    public static IndentEngine find(Document doc) {
        Object o = doc.getProperty("indentEngine");
        if (o instanceof IndentEngine) {
            return (IndentEngine)o;
        }
        o = doc.getProperty("mimeType");
        String s = o instanceof String ? (String)o : "text/plain";
        return IndentEngine.find(s);
    }

    public static synchronized IndentEngine getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new Default();
        }
        return INSTANCE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class Default
    extends IndentEngine {
        private static final long serialVersionUID = 4493180326470838469L;
        static /* synthetic */ Class class$org$openide$text$IndentEngine$Default;

        Default() {
        }

        public int indentLine(Document doc, int offset) {
            return offset;
        }

        public int indentNewLine(Document doc, int offset) {
            try {
                doc.insertString(offset, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return offset + 1;
        }

        public Writer createWriter(Document doc, int offset, Writer writer) {
            return writer;
        }

        protected boolean acceptMimeType(String mime) {
            return true;
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(class$org$openide$text$IndentEngine$Default == null ? (class$org$openide$text$IndentEngine$Default = Default.class$("org.openide.text.IndentEngine$Default")) : class$org$openide$text$IndentEngine$Default);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

