/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSourceDropEvent;
import java.util.Arrays;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.DragDropUtilities;
import org.openide.explorer.view.DropGlassPane;
import org.openide.explorer.view.ExplorerDragSupport;
import org.openide.explorer.view.TreeView;
import org.openide.explorer.view.TreeViewCellEditor;
import org.openide.nodes.Node;

final class TreeViewDragSupport
extends ExplorerDragSupport {
    boolean active = false;
    DragGestureRecognizer defaultGesture;
    TreePath[] curSelection;
    TreePath[] oldSelection;
    protected TreeView view;
    private JTree tree;
    static /* synthetic */ Class class$org$openide$explorer$ExplorerPanel;

    public TreeViewDragSupport(TreeView view, JTree tree) {
        this.view = view;
        this.comp = tree;
        this.tree = tree;
    }

    public void dragGestureRecognized(DragGestureEvent dge) {
        TreeCellEditor tce;
        super.dragGestureRecognized(dge);
        if (this.exDnD.isDnDActive() && (tce = this.tree.getCellEditor()) instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)tce).setDnDActive(true);
        }
    }

    public void dragDropEnd(DragSourceDropEvent dsde) {
        Node[] dropedNodes = this.exDnD.getDraggedNodes();
        super.dragDropEnd(dsde);
        if (DropGlassPane.isOriginalPaneStored()) {
            DropGlassPane.putBackOriginal();
            this.exDnD.setDnDActive(false);
        }
        try {
            ExplorerPanel panel;
            if (dropedNodes != null && (panel = (ExplorerPanel)SwingUtilities.getAncestorOfClass(class$org$openide$explorer$ExplorerPanel == null ? (class$org$openide$explorer$ExplorerPanel = TreeViewDragSupport.class$("org.openide.explorer.ExplorerPanel")) : class$org$openide$explorer$ExplorerPanel, this.view)) != null) {
                panel.getExplorerManager().setSelectedNodes(dropedNodes);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        TreeCellEditor tce = this.tree.getCellEditor();
        if (tce instanceof TreeViewCellEditor) {
            ((TreeViewCellEditor)tce).setDnDActive(false);
        }
    }

    Node[] obtainNodes(DragGestureEvent dge) {
        Point dragOrigin = dge.getDragOrigin();
        TreePath tp = this.tree.getPathForLocation(dragOrigin.x, dragOrigin.y);
        if (tp == null) {
            return null;
        }
        Node n = DragDropUtilities.secureFindNode(tp.getLastPathComponent());
        if (n == null) {
            return null;
        }
        if (this.oldSelection != null && this.wasSelected(n)) {
            this.tree.setSelectionPaths(this.oldSelection);
            this.curSelection = null;
        }
        Node[] result = null;
        if (this.tree.isPathSelected(tp)) {
            TreePath[] tps = this.tree.getSelectionPaths();
            result = new Node[tps.length];
            int i = 0;
            while (i < tps.length) {
                result[i] = DragDropUtilities.secureFindNode(tps[i].getLastPathComponent());
                if (result[i] == null) {
                    return null;
                }
                ++i;
            }
        } else {
            result = new Node[]{n};
        }
        return result;
    }

    public void valueChanged(TreeSelectionEvent tse) {
        Object[] newSelection = this.tree.getSelectionPaths();
        if (newSelection != null && !Arrays.equals(this.curSelection, newSelection)) {
            this.oldSelection = this.curSelection == null ? newSelection : this.curSelection;
            this.curSelection = newSelection;
        }
    }

    boolean wasSelected(Object obj) {
        if (this.oldSelection == null) {
            return false;
        }
        int i = 0;
        while (i < this.oldSelection.length) {
            if (obj.equals(this.oldSelection[i].getLastPathComponent())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

