/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.xml;

import java.awt.AWTException;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.JFCTestHelper;
import junit.extensions.jfcunit.RobotTestHelper;
import junit.extensions.jfcunit.xml.JFCXMLConstants;
import junit.extensions.xml.IXMLProcedure;
import junit.extensions.xml.IXMLTest;
import junit.extensions.xml.IXMLTestCase;
import junit.extensions.xml.XMLException;
import junit.extensions.xml.XMLObjectCache;
import junit.extensions.xml.XMLTagResourceBundle;
import junit.extensions.xml.XMLTestSuite;
import junit.extensions.xml.XMLUtil;
import junit.framework.Test;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public class JFCXMLTestCase
extends JFCTestCase
implements IXMLTestCase,
JFCXMLConstants {
    private Element m_element;
    private String m_filename;
    private Test m_parent;
    private XMLObjectCache m_procedures = new XMLObjectCache();
    private XMLObjectCache m_properties = new XMLObjectCache();

    public JFCXMLTestCase(String filename, Element element) {
        super(filename);
        this.m_filename = filename;
        this.m_element = element;
        boolean robot = XMLUtil.getBooleanAttributeValue(element, "robot");
        if (robot) {
            try {
                this.setHelper(new RobotTestHelper());
            }
            catch (AWTException ex) {
                throw new RuntimeException("Could not create robot." + ex);
            }
        } else {
            this.setHelper(new JFCTestHelper());
        }
        boolean assertExit = XMLUtil.getBooleanAttributeValue(element, "assertexit");
        this.setAssertExit(assertExit);
    }

    public final boolean getDebug() {
        return this.m_properties.get("debug") != null;
    }

    public final void setParent(IXMLTest parent) {
        this.m_parent = parent;
        this.m_properties.setParent(parent.getPropertyCache());
        this.m_procedures.setParent(parent.getProcedureCache());
    }

    public final IXMLProcedure getProcedure(String name) {
        return (IXMLProcedure)this.m_procedures.get(name);
    }

    public final XMLObjectCache getProcedureCache() {
        return this.m_procedures;
    }

    public final Object getProperty(String name) {
        return this.m_properties.get(name);
    }

    public final XMLObjectCache getPropertyCache() {
        return this.m_properties;
    }

    public final String getPropertyName(Object comp) {
        return this.m_properties.getName(comp);
    }

    public final String[] getPropertyNames() {
        return this.m_properties.getNames();
    }

    public final void addProcedure(IXMLProcedure proc) {
        this.m_procedures.put(proc.getName(), proc);
    }

    public final void callProcedure(String name, Element callElement) throws XMLException {
        IXMLProcedure proc;
        XMLObjectCache cache = this.m_properties;
        this.m_properties = new XMLObjectCache();
        this.m_properties.setParent(cache);
        if (callElement != null) {
            NamedNodeMap atts = callElement.getAttributes();
            int size = atts.getLength();
            for (int i = 0; i < size; ++i) {
                Attr node = (Attr)atts.item(i);
                String an = node.getName();
                if ("call".equals(an)) continue;
                String value = XMLUtil.getAttribute(callElement, an);
                value = this.resolveProperties(value);
                this.addProperty(an, value);
            }
        }
        if ((proc = this.getProcedure(name)) == null) {
            this.m_properties.setParent(null);
            this.m_properties = cache;
            if ("setUp".equals(name) || "tearDown".equals(name)) {
                return;
            }
            throw new XMLException("Procedure not found:" + name, null, this.m_element, this.getPropertyCache());
        }
        this.processChildren(proc.getElement());
        this.m_properties.setParent(null);
        this.m_properties = cache;
    }

    public final void processChildren(Element element) throws XMLException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            String name = child.getTagName();
            try {
                XMLTagResourceBundle.getTagHandler(child, this, name).processElement();
            }
            catch (XMLException xe) {
                throw xe;
            }
            catch (Throwable t) {
                XMLException x = new XMLException("Exception (" + t.toString() + " from tag: " + name, t, child, this.getPropertyCache());
                throw x;
            }
            if (child == children.item(i)) continue;
            while (child != children.item(i) && i < children.getLength()) {
                ++i;
            }
            if (i != children.getLength()) continue;
            throw new XMLException("Lost where we were at current node was removed.", null, child, this.getPropertyCache());
        }
    }

    public final void runXMLTest() throws Exception {
        boolean debug = XMLUtil.getBooleanAttributeValue(this.m_element, "debug");
        if (debug) {
            this.m_properties.put("debug", Boolean.TRUE);
        } else {
            this.m_properties.remove("debug");
        }
        this.processChildren(this.m_element);
    }

    public static Test suite() throws Exception {
        return new XMLTestSuite();
    }

    public final void addProperty(String name, Object obj) {
        this.m_properties.put(name, obj);
    }

    public final void clearProperties() {
        this.m_properties.clear();
    }

    public final void removeProperty(String name) {
        this.m_properties.remove(name);
    }

    public String resolveProperties(String s) {
        if (s == null) {
            return null;
        }
        int index = -1;
        String str = new String(s);
        do {
            if ((index = str.lastIndexOf("${")) == -1) continue;
            int lindex = str.indexOf("}", index);
            String variableName = str.substring(index + 2, lindex);
            JFCXMLTestCase.assertTrue((String)("Evaluation of \"" + str + "\" Null Variable name."), (variableName.length() > 0 ? 1 : 0) != 0);
            Object value = this.getProperty(variableName);
            if (value == null) {
                System.err.println("WARNING: Evaluation of \"" + s + "\" Variable not found assuming empty string for:" + variableName);
                value = "";
            }
            String valueString = value.toString();
            str = str.substring(0, index) + valueString + str.substring(lindex + 1);
        } while (index != -1);
        return str;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.clearProperties();
        this.m_procedures.clear();
        this.loadProcedures(this.m_element);
        this.callProcedure("setUp", null);
    }

    protected void runTest() throws Throwable {
        this.runCode(new Runnable(){

            public void run() {
                try {
                    JFCXMLTestCase.this.runXMLTest();
                    JFCXMLTestCase.this.flushAWT();
                }
                catch (Exception exc) {
                    JFCXMLTestCase.this.flushAWT();
                    JFCXMLTestCase.this.setError(exc);
                }
            }
        });
    }

    protected void tearDown() throws Exception {
        this.callProcedure("tearDown", null);
        super.tearDown();
    }

    private void loadProcedures(Element element) throws XMLException {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            if (!(children.item(i) instanceof Element)) continue;
            Element child = (Element)children.item(i);
            String name = child.getTagName();
            String call = child.getAttribute("call");
            if (!"procedure".equals(name) || call.length() != 0) continue;
            XMLTagResourceBundle.getTagHandler(child, this, name).processElement();
        }
    }
}

