/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.keyboard;

public class JFCKeyStroke {
    private boolean m_isTyped;
    private char m_keyChar;
    private int m_keyCode;
    private int m_modifiers;

    public JFCKeyStroke(char c, int code, int modifiers, boolean typed) {
        this.setKeyChar(c);
        this.setKeyCode(code);
        this.setModifiers(modifiers);
        this.setTyped(typed);
    }

    public JFCKeyStroke(JFCKeyStroke stroke) {
        this.setKeyChar(stroke.getKeyChar());
        this.setKeyCode(stroke.getKeyCode());
        this.setModifiers(stroke.getModifiers());
        this.setTyped(stroke.isTyped());
    }

    public final char getKeyChar() {
        return this.m_keyChar;
    }

    public final int getKeyCode() {
        return this.m_keyCode;
    }

    public void setModifiers(int modifiers) {
        this.m_modifiers = modifiers;
    }

    public final int getModifiers() {
        return this.m_modifiers;
    }

    public final boolean isTyped() {
        return this.m_isTyped;
    }

    public boolean equals(Object o) {
        if (o instanceof JFCKeyStroke) {
            JFCKeyStroke stroke = (JFCKeyStroke)o;
            return this.getKeyChar() == stroke.getKeyChar() && this.getKeyCode() == stroke.getKeyCode() && this.getModifiers() == stroke.getModifiers() && this.m_isTyped == stroke.isTyped();
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode() + this.getKeyChar() + this.getKeyCode() + this.getModifiers();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        if (this.getKeyChar() < '\u001a' && this.getModifiers() == 2) {
            buf.append("<control ");
            int x = this.getKeyChar();
            buf.append((char)(x += 64));
            buf.append(">");
        } else {
            buf.append("Char:" + this.getKeyChar());
            buf.append(" Code:" + this.getKeyCode());
            buf.append(" Mods:" + this.getModifiers());
            buf.append(" IsTyped:" + this.isTyped());
        }
        return buf.toString();
    }

    private void setKeyChar(char c) {
        this.m_keyChar = c;
    }

    private void setKeyCode(int code) {
        this.m_keyCode = code;
    }

    private void setTyped(boolean typed) {
        this.m_isTyped = typed;
    }
}

