/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.cmdline.sqltool;

import org.hsqldb.cmdline.sqltool.TokenList;

public class Token {
    public static final int SQL_TYPE = 0;
    public static final int SPECIAL_TYPE = 1;
    public static final int PL_TYPE = 2;
    public static final int EDIT_TYPE = 3;
    public static final int RAW_TYPE = 4;
    public static final int RAWEXEC_TYPE = 5;
    public static final int SYNTAX_ERR_TYPE = 6;
    public static final int UNTERM_TYPE = 7;
    public static final int BUFFER_TYPE = 8;
    public static final int MACRO_TYPE = 9;
    public int line;
    public TokenList nestedBlock = null;
    public String[] typeString = new String[]{"SQL", "SPECIAL", "PL", "EDIT", "RAW", "RAWEXEC", "SYNTAX", "UNTERM", "BUFFER", "MACRO"};
    public char[] typeChar = new char[]{'S', '\\', '*', 'E', 'R', 'X', '!', '<', '>', '/'};
    public String val;
    public int type;

    public String getTypeString() {
        return this.typeString[this.type];
    }

    public char getTypeChar() {
        return this.typeChar[this.type];
    }

    public Token(int n, String string, int n2) {
        this.val = string;
        this.type = n;
        this.line = n2 + 1;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 9: {
                if (this.val == null) {
                    throw new IllegalArgumentException("Null String value for scanner token");
                }
                this.val = this.val.trim();
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.val != null) break;
                throw new IllegalArgumentException("Null String value for scanner token");
            }
            case 0: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error.  Unexpected scanner token type: " + n);
            }
        }
    }

    public Token(int n, StringBuffer stringBuffer, int n2) {
        this(n, stringBuffer.toString(), n2);
    }

    public Token(int n, int n2) {
        this(n, (String)null, n2);
    }

    public String toString() {
        return "@" + this.line + " TYPE=" + this.getTypeString() + ", VALUE=(" + this.val + ')';
    }

    public boolean equals(Token token) {
        if (this.type != token.type) {
            return false;
        }
        if (this.val == null && token.val != null) {
            return false;
        }
        if (this.val != null && token.val == null) {
            return false;
        }
        return this.val == null || this.val.equals(token.val);
    }

    public String reconstitute() {
        return this.reconstitute(false);
    }

    public String reconstitute(boolean bl) {
        if (this.val == null) {
            return "";
        }
        switch (this.type) {
            case 1: 
            case 2: {
                return Character.toString(this.getTypeChar()) + this.val;
            }
            case 0: {
                return this.val + (bl ? ";" : "");
            }
        }
        return "? " + this.val;
    }
}

