/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;

public class IORDump {
    private static void printUsage() {
        System.out.println("Usage: java org.openorb.util.IORDump [Options]");
        System.out.println("Options:");
        System.out.println("  -bind             Giving it a chance to be redirected.");
        System.out.println("  -f <filename|IOR> File containing IORs or explicit IOR.");
    }

    /*
     * WARNING - void declaration
     */
    private static String readString(FileReader fr) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer(256);
        while ((c = fr.read()) != -1) {
            void var1_2;
            if (var1_2 == 13 || var1_2 == 10) {
                return sb.toString();
            }
            sb.append((char)var1_2);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        boolean bind = false;
        ArrayList<String> aList = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-bind") || args[i].equals("--bind")) {
                bind = true;
            } else if (args[i].equals("-help") || args[i].equals("--help")) {
                IORDump.printUsage();
                System.exit(0);
            } else if (args[i].startsWith("-ORB")) {
                if (args.length < i + 1 && !args[i + 1].startsWith("-")) {
                    ++i;
                } else if (args[i].startsWith("-")) {
                    IORDump.printUsage();
                    System.exit(1);
                }
            } else if (args[i].equals("-f")) {
                if (i < args.length) {
                    ++i;
                    try {
                        FileReader fr = new FileReader(new File(args[i]));
                        while (fr.ready()) {
                            String ior = IORDump.readString(fr);
                            if (!ior.startsWith("IOR:")) continue;
                            aList.add(ior);
                        }
                        fr.close();
                    }
                    catch (Exception e) {
                        System.err.println("Exception: " + ((java.lang.Object)e).toString());
                        System.exit(2);
                    }
                } else {
                    IORDump.printUsage();
                    System.exit(1);
                }
            } else if (args[i].startsWith("IOR:")) {
                aList.add(args[i]);
            }
            ++i;
        }
        if (aList.size() == 0) {
            IORDump.printUsage();
            System.exit(1);
        }
        try {
            ORB orb = ORB.init(args, null);
            Iterator it = aList.iterator();
            while (it.hasNext()) {
                String next = (String)it.next();
                Object obj = orb.string_to_object(next);
                if (bind && obj._non_existent()) {
                    System.err.println("Target is non_existent.");
                }
                System.out.println(obj);
            }
        }
        catch (SystemException ex) {
            System.err.println("SystemException: " + ((java.lang.Object)ex).toString());
            System.exit(2);
        }
    }
}

