/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.iiop;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CODESET_INCOMPATIBLE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.GIOP.Version;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedProfile;
import org.openorb.CORBA.Any;
import org.openorb.CORBA.DataOutputStream;
import org.openorb.CORBA.Delegate;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.CORBA.typecode.TypeCodeBase;
import org.openorb.iiop.CodeSetDatabase;
import org.openorb.io.ExtendedOutputStream;
import org.openorb.io.MarshalBuffer;
import org.openorb.util.ExceptionTool;
import org.openorb.util.IdentityKey;
import org.openorb.util.NumberCache;
import org.openorb.util.RepoIDHelper;
import org.openorb.util.Trace;

public class CDROutputStream
extends OutputStream
implements ExtendedOutputStream,
LogEnabled {
    private static final int NO_CODEBASE = 0;
    private static final int CODEBASE = 1;
    private static final int NO_TYPE_INFORMATION = 0;
    private static final int SINGLE_TYPE_INFORMATION = 2;
    private static final int MULTIPLE_TYPE_INFORMATION = 6;
    private static final int CHUNK = 8;
    private static final int NO_CHUNK = 0;
    private static final int CUSTOM_MARSHAL = 1;
    private static final int STREAM_MARSHAL = 2;
    private static final int VALBOX_MARSHAL = 3;
    private static final int EXTENDED_MARSHAL = 4;
    private org.omg.CORBA.ORB m_orb;
    private Version m_version;
    private MarshalBuffer m_buf;
    private String m_char_enc = "ISO-8859-1";
    private String m_wchar_enc = "UnicodeBigUnmarked";
    private int m_wchar_align = 2;
    private int m_index = 0;
    private int m_pending_align = 0;
    private int m_realign = 0;
    private LinkedList m_old_realign;
    private int m_value_level = 0;
    private boolean m_in_chunked_value = false;
    private boolean m_value_init = false;
    private Map m_value_idx;
    private Map m_url_idx;
    private Map m_typecode_list_idx;
    private Map m_typecode_idx;
    private int m_pending_value_closes = 0;
    private boolean m_pending_value_open = false;
    private OctetSeqHolder m_tmp_buf = new OctetSeqHolder();
    private IntHolder m_tmp_off = new IntHolder();
    private String m_system_urls = null;
    private Logger m_logger;
    private static final MarshalBuffer.BlockGenerator ENCAPS_GEN = new MarshalBuffer.BlockGenerator(){

        public void endBlock(byte[] buf, int pos, int len, int size, java.lang.Object cookie) {
            buf[pos] = (byte)((size -= 4) >>> 24);
            buf[pos + 1] = (byte)(size >>> 16);
            buf[pos + 2] = (byte)(size >>> 8);
            buf[pos + 3] = (byte)size;
        }

        public void fragmentBlock(byte[] buf, int pos, int len, int length, MarshalBuffer buffer, java.lang.Object cookie) {
            Trace.signalIllegalCondition(null, "Unable to fragment encapsulation.");
        }
    };
    private static final MarshalBuffer.BlockGenerator CHUNK_GEN = new MarshalBuffer.BlockGenerator(){

        public void endBlock(byte[] buf, int pos, int len, int size, java.lang.Object cookie) {
            if ((size -= 4) <= 0) {
                Trace.signalIllegalCondition(null, "No bytes left in block.");
            }
            buf[pos] = (byte)(size >>> 24);
            buf[pos + 1] = (byte)(size >>> 16);
            buf[pos + 2] = (byte)(size >>> 8);
            buf[pos + 3] = (byte)size;
        }

        public void fragmentBlock(byte[] buf, int off, int len, int size, MarshalBuffer buffer, java.lang.Object cookie) {
            if ((size -= 4) <= 0) {
                Trace.signalIllegalCondition(null, "No bytes left in block.");
            }
            buf[off] = (byte)(size >>> 24);
            buf[off + 1] = (byte)(size >>> 16);
            buf[off + 2] = (byte)(size >>> 8);
            buf[off + 3] = (byte)size;
            ((CDROutputStream)cookie).m_pending_value_open = true;
        }
    };
    private static final IOR NULL_IOR = new IOR("", new TaggedProfile[0]);

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    private Logger getLogger() {
        if (null == this.m_logger) {
            this.m_logger = ((ORBSingleton)this.m_orb).getLogger();
        }
        return this.m_logger;
    }

    public CDROutputStream(org.omg.CORBA.ORB orb, Version version, MarshalBuffer buf) {
        this.m_orb = orb;
        this.m_version = version;
        this.m_buf = buf;
        if (this.m_version.minor == 0) {
            this.m_char_enc = "ISO-8859-1";
            this.m_wchar_enc = null;
        }
    }

    public void setCodesets(int tcsc, int tcsw) {
        if (tcsc != 0) {
            this.m_char_enc = CodeSetDatabase.getNameFromId(tcsc);
            if (this.m_char_enc == null || CodeSetDatabase.getAlignmentFromId(tcsc) > 1) {
                this.m_buf.cancel(new CODESET_INCOMPATIBLE());
                return;
            }
        }
        if (tcsw == 0) {
            this.m_wchar_enc = null;
        } else {
            this.m_wchar_enc = CodeSetDatabase.getNameFromId(tcsw);
            this.m_wchar_align = CodeSetDatabase.getAlignmentFromId(tcsw);
            if (this.m_wchar_enc == null || this.m_version.minor == 1 && this.m_wchar_align != 2) {
                this.m_buf.cancel(new CODESET_INCOMPATIBLE());
                return;
            }
        }
        if (this.getLogger().isDebugEnabled() && Trace.isHigh()) {
            this.getLogger().debug("New encodings for output stream set to [" + this.m_char_enc + "] and [" + this.m_wchar_enc + "].");
        }
    }

    void addHeader(MarshalBuffer.HeaderGenerator gen, int len, boolean frag, java.lang.Object cookie) {
        this.m_buf.addHeader(gen, len, frag, cookie);
        this.m_index += len;
    }

    void allowFragment() {
        this.m_buf.setAllowFragment(true);
    }

    public org.omg.CORBA.ORB orb() {
        return this.m_orb;
    }

    public Version version() {
        return this.m_version;
    }

    public void alignment(int align) {
        if (this.m_pending_value_closes > 0) {
            this.value_end_block();
            if (this.m_in_chunked_value) {
                this.m_pending_value_open = true;
            }
        }
        if (this.m_pending_value_open) {
            this.m_pending_value_open = false;
            this.value_begin_block();
        }
        if (align > 1 || this.m_pending_align > 0) {
            int tmp;
            if (align < this.m_pending_align) {
                align = this.m_pending_align;
                this.m_pending_align = 0;
            }
            if ((tmp = (this.m_index - this.m_realign) % align) != 0) {
                int delta = align - tmp;
                this.m_buf.pad(delta);
                this.m_index += delta;
            }
        }
    }

    public void pending_alignment(int align) {
        this.m_pending_align = align;
    }

    public int index() {
        return this.m_index;
    }

    public void begin_encapsulation() {
        this.alignment(4);
        this.m_buf.beginBlock(ENCAPS_GEN, 4, false, null);
        this.m_index += 4;
        if (this.m_old_realign == null) {
            this.m_old_realign = new LinkedList();
        }
        this.m_old_realign.addLast(NumberCache.getInteger(this.m_realign));
        this.m_realign = (this.m_index - this.m_realign) % 8;
        this.write_boolean(false);
    }

    public void end_encapsulation() {
        if (this.m_old_realign == null || this.m_old_realign.isEmpty()) {
            throw new IllegalStateException("No current encapsulation");
        }
        this.m_buf.endBlock();
        this.m_realign = (Integer)this.m_old_realign.removeLast();
    }

    public void write(int val) {
        this.write_octet((byte)val);
    }

    public void write(byte[] buf) {
        this.write_octet_array(buf, 0, buf.length);
    }

    public void write(byte[] buf, int off, int len) {
        this.write_octet_array(buf, off, len);
    }

    public void close() {
        if (this.m_old_realign != null && !this.m_old_realign.isEmpty()) {
            this.m_buf.cancel(new MARSHAL("closed stream without closing all encapsulation layers", 1146056982, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this.m_value_level - this.m_pending_value_closes > 0) {
            this.m_buf.cancel(new MARSHAL("closed stream before value completley marshalled", 1146056981, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this.m_pending_value_closes > 0) {
            this.value_end_block();
        }
        this.m_buf.close();
    }

    public void flush() {
    }

    public InputStream create_input_stream() {
        this.m_buf.cancel(new NO_IMPLEMENT());
        throw new NO_IMPLEMENT();
    }

    void cancel(SystemException ex) {
        this.m_buf.cancel(ex);
    }

    public void write_boolean(boolean val) {
        this.alignment(1);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 1);
        ++this.m_index;
        this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)(val ? 1 : 0);
    }

    public void write_octet(byte val) {
        this.alignment(1);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 1);
        ++this.m_index;
        this.m_tmp_buf.value[this.m_tmp_off.value] = val;
    }

    public void write_char(char val) {
        try {
            byte[] d = String.valueOf(val).getBytes(this.m_char_enc);
            if (d.length != 1) {
                this.m_buf.cancel(new DATA_CONVERSION("Bad char type", 1330446337, CompletionStatus.COMPLETED_MAYBE));
            }
            this.alignment(1);
            this.m_buf.append(d, 0, 1);
            ++this.m_index;
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", (Throwable)ex);
        }
    }

    public void write_wchar(char val) {
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.m_buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            switch (this.m_version.minor) {
                case 0: {
                    this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    break;
                }
                case 1: {
                    this.alignment(2);
                    byte[] d = String.valueOf(val).getBytes(this.m_wchar_enc);
                    if (d.length != 2) {
                        this.m_buf.cancel(new DATA_CONVERSION("Bad wchar type", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                    }
                    this.m_buf.append(d, 0, 2);
                    this.m_index += 2;
                    break;
                }
                case 2: {
                    this.alignment(1);
                    byte[] d = String.valueOf(val).getBytes(this.m_wchar_enc);
                    this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, d.length + 1);
                    this.m_index += d.length + 1;
                    this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)d.length;
                    System.arraycopy(d, 0, this.m_tmp_buf.value, this.m_tmp_off.value + 1, d.length);
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", (Throwable)ex);
        }
    }

    public void write_short(short val) {
        this.alignment(2);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 2);
        this.m_index += 2;
        this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)(val >>> 8);
        this.m_tmp_buf.value[this.m_tmp_off.value + 1] = (byte)val;
    }

    public void write_ushort(short val) {
        this.write_short(val);
    }

    public void write_long(int val) {
        this.alignment(4);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 4);
        this.m_index += 4;
        this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)(val >>> 24);
        this.m_tmp_buf.value[this.m_tmp_off.value + 1] = (byte)(val >>> 16);
        this.m_tmp_buf.value[this.m_tmp_off.value + 2] = (byte)(val >>> 8);
        this.m_tmp_buf.value[this.m_tmp_off.value + 3] = (byte)val;
    }

    public void write_ulong(int val) {
        this.write_long(val);
    }

    public void write_longlong(long val) {
        this.alignment(8);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, 8);
        this.m_index += 8;
        this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)(val >>> 56);
        this.m_tmp_buf.value[this.m_tmp_off.value + 1] = (byte)(val >>> 48);
        this.m_tmp_buf.value[this.m_tmp_off.value + 2] = (byte)(val >>> 40);
        this.m_tmp_buf.value[this.m_tmp_off.value + 3] = (byte)(val >>> 32);
        this.m_tmp_buf.value[this.m_tmp_off.value + 4] = (byte)(val >>> 24);
        this.m_tmp_buf.value[this.m_tmp_off.value + 5] = (byte)(val >>> 16);
        this.m_tmp_buf.value[this.m_tmp_off.value + 6] = (byte)(val >>> 8);
        this.m_tmp_buf.value[this.m_tmp_off.value + 7] = (byte)val;
    }

    public void write_ulonglong(long val) {
        this.write_longlong(val);
    }

    public void write_float(float val) {
        this.write_long(Float.floatToIntBits(val));
    }

    public void write_double(double val) {
        this.write_longlong(Double.doubleToLongBits(val));
    }

    public void write_string(String val) {
        if (val == null) {
            this.m_buf.cancel(new BAD_PARAM("Cannot marshal null string", 1146056965, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (val.length() == 0) {
            this.write_ulong(1);
            this.write_octet((byte)0);
            return;
        }
        try {
            byte[] buf = (val + '\u0000').getBytes(this.m_char_enc);
            this.write_ulong(buf.length);
            this.m_buf.append(buf, 0, buf.length);
            this.m_index += buf.length;
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", (Throwable)ex);
        }
    }

    public void write_wstring(String val) {
        if (val == null) {
            this.m_buf.cancel(new BAD_PARAM("Cannot marshal null wstring", 1146056965, CompletionStatus.COMPLETED_MAYBE));
            return;
        }
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.m_buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            byte[] buf = null;
            switch (this.m_version.minor) {
                case 0: {
                    this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                case 1: {
                    buf = (val + '\u0000').getBytes(this.m_wchar_enc);
                    this.write_ulong(buf.length / 2);
                    break;
                }
                case 2: {
                    buf = val.getBytes(this.m_wchar_enc);
                    this.write_ulong(buf.length);
                }
            }
            this.m_buf.append(buf, 0, buf.length);
            this.m_index += buf.length;
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", (Throwable)ex);
        }
    }

    public void write_boolean_array(boolean[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, len);
        this.m_index += len;
        int i = 0;
        while (i < len) {
            this.m_tmp_buf.value[this.m_tmp_off.value + i] = (byte)(val[off + i] ? 1 : 0);
            ++i;
        }
    }

    public void write_char_array(char[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        try {
            byte[] buf = new String(val, off, len).getBytes(this.m_char_enc);
            if (buf.length != len) {
                this.m_buf.cancel(new DATA_CONVERSION("Bad char type", 1330446337, CompletionStatus.COMPLETED_MAYBE));
            }
            this.m_buf.append(buf, 0, len);
            this.m_index += len;
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", (Throwable)ex);
        }
    }

    public void write_wchar_array(char[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        if (this.m_wchar_enc == null) {
            if (this.m_version.minor == 0) {
                this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
            } else {
                this.m_buf.cancel(new INV_OBJREF("Missing wchar encoder.", 1146056975, CompletionStatus.COMPLETED_MAYBE));
            }
            return;
        }
        try {
            switch (this.m_version.minor) {
                case 0: {
                    this.m_buf.cancel(new BAD_OPERATION("IIOP 1.0 cannot marshal wchar types", 1146056961, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
                case 1: {
                    this.alignment(2);
                    byte[] buf = new String(val, off, len).getBytes(this.m_wchar_enc);
                    if (buf.length != 2 * len) {
                        this.m_buf.cancel(new DATA_CONVERSION("Bad whar type", 1146056977, CompletionStatus.COMPLETED_MAYBE));
                    }
                    this.m_buf.append(buf, 0, buf.length);
                    this.m_index += buf.length;
                    break;
                }
                case 2: {
                    this.alignment(1);
                    if (this.m_wchar_align == 0) {
                        int i = off;
                        while (i < off + len) {
                            byte[] d = String.valueOf(val[i]).getBytes(this.m_wchar_enc);
                            this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, d.length + 1);
                            this.m_index += d.length + 1;
                            if (this.m_tmp_buf != null) {
                                this.m_tmp_buf.value[this.m_tmp_off.value] = (byte)d.length;
                                System.arraycopy(d, 0, this.m_tmp_buf.value, this.m_tmp_off.value + 1, d.length);
                            }
                            ++i;
                        }
                        break;
                    }
                    this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, len + len * this.m_wchar_align);
                    int pos = this.m_tmp_off.value;
                    int i = off;
                    while (i < off + len) {
                        byte[] d = String.valueOf(val[i]).getBytes(this.m_wchar_enc);
                        if (this.m_tmp_buf != null) {
                            this.m_tmp_buf.value[pos] = (byte)this.m_wchar_align;
                            System.arraycopy(d, 0, this.m_tmp_buf.value, pos + 1, d.length);
                        }
                        pos += this.m_wchar_align + 1;
                        ++i;
                    }
                    this.m_index += len + len * this.m_wchar_align;
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            this.getLogger().error("Unsupported encoding should be impossible.", (Throwable)ex);
        }
    }

    public void write_octet_array(byte[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(1);
        this.m_buf.append(val, off, len);
        this.m_index += len;
    }

    public void write_short_array(short[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(2);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, len * 2);
        this.m_index += len * 2;
        int i = 0;
        while (i < len) {
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 2] = (byte)(val[off + i] >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 2 + 1] = (byte)val[off + i];
            ++i;
        }
    }

    public void write_ushort_array(short[] val, int offset, int length) {
        this.write_short_array(val, offset, length);
    }

    public void write_long_array(int[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(4);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, len * 4);
        this.m_index += len * 4;
        int i = 0;
        while (i < len) {
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4] = (byte)(val[off + i] >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4 + 1] = (byte)(val[off + i] >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4 + 2] = (byte)(val[off + i] >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4 + 3] = (byte)val[off + i];
            ++i;
        }
    }

    public void write_ulong_array(int[] val, int off, int len) {
        this.write_long_array(val, off, len);
    }

    public void write_longlong_array(long[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(8);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, len * 8);
        this.m_index += len * 8;
        int i = 0;
        while (i < len) {
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8] = (byte)(val[off + i] >>> 56);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 1] = (byte)(val[off + i] >>> 48);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 2] = (byte)(val[off + i] >>> 40);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 3] = (byte)(val[off + i] >>> 32);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 4] = (byte)(val[off + i] >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 5] = (byte)(val[off + i] >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 6] = (byte)(val[off + i] >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 7] = (byte)val[off + i];
            ++i;
        }
    }

    public void write_ulonglong_array(long[] val, int off, int len) {
        this.write_longlong_array(val, off, len);
    }

    public void write_float_array(float[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(4);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, len * 4);
        this.m_index += len * 4;
        int i = 0;
        while (i < len) {
            int v = Float.floatToIntBits(val[off + i]);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4] = (byte)(v >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4 + 1] = (byte)(v >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4 + 2] = (byte)(v >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 4 + 3] = (byte)v;
            ++i;
        }
    }

    public void write_double_array(double[] val, int off, int len) {
        if (off + len > val.length || len < 0 || off < 0) {
            this.m_buf.cancel(new BAD_PARAM("Index Out Of Bounds", 1146056966, CompletionStatus.COMPLETED_NO));
            return;
        }
        this.alignment(8);
        this.m_buf.alloc(this.m_tmp_buf, this.m_tmp_off, len * 8);
        this.m_index += len * 8;
        int i = 0;
        while (i < len) {
            long v = Double.doubleToLongBits(val[off + i]);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8] = (byte)(v >>> 56);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 1] = (byte)(v >>> 48);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 2] = (byte)(v >>> 40);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 3] = (byte)(v >>> 32);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 4] = (byte)(v >>> 24);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 5] = (byte)(v >>> 16);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 6] = (byte)(v >>> 8);
            this.m_tmp_buf.value[this.m_tmp_off.value + i * 8 + 7] = (byte)v;
            ++i;
        }
    }

    public void write_Object(Object val) {
        IOR ior;
        if (val == null) {
            ior = NULL_IOR;
        } else {
            try {
                ior = ((Delegate)((ObjectImpl)val)._get_delegate()).ior();
            }
            catch (SystemException ex) {
                this.m_buf.cancel(ex);
                return;
            }
        }
        IORHelper.write(this, ior);
    }

    public void write_TypeCode(TypeCode val) {
        this.write_TypeCodeValue(val, new HashMap());
    }

    private void write_TypeCodeValue(TypeCode val, Map tc_list) {
        int kind = val.kind().value();
        try {
            switch (kind) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.write_long(kind);
                    return;
                }
                case 18: 
                case 27: {
                    this.write_long(kind);
                    this.write_ulong(val.length());
                    return;
                }
                case 28: {
                    this.write_long(kind);
                    this.write_ushort(val.fixed_digits());
                    this.write_ushort(val.fixed_scale());
                    return;
                }
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    break;
                }
                default: {
                    throw new MARSHAL("Unknown type kind", 0, CompletionStatus.COMPLETED_NO);
                }
            }
            Integer pos = (Integer)tc_list.get(val);
            if (pos != null) {
                this.write_long(-1);
                this.write_long(pos - this.m_index);
                return;
            }
            this.alignment(4);
            pos = NumberCache.getInteger(this.m_index);
            tc_list.put(val, pos);
            this.write_long(kind);
            this.begin_encapsulation();
            switch (kind) {
                case 19: 
                case 20: {
                    this.write_TypeCodeValue(val.content_type(), tc_list);
                    this.write_ulong(val.length());
                    break;
                }
                case 14: 
                case 31: 
                case 32: {
                    this.write_string(val.id());
                    this.write_string(val.name());
                    break;
                }
                case 15: 
                case 22: {
                    this.write_string(val.id());
                    this.write_string(val.name());
                    this.write_ulong(val.member_count());
                    int i = 0;
                    while (i < val.member_count()) {
                        this.write_string(val.member_name(i));
                        this.write_TypeCodeValue(val.member_type(i), tc_list);
                        ++i;
                    }
                    break;
                }
                case 16: {
                    this.write_string(val.id());
                    this.write_string(val.name());
                    this.write_TypeCodeValue(val.discriminator_type(), tc_list);
                    this.write_long(val.default_index());
                    this.write_ulong(val.member_count());
                    int i = 0;
                    while (i < val.member_count()) {
                        if (i != val.default_index()) {
                            ((Any)val.member_label(i)).write_value(this);
                        } else {
                            TypeCode base = TypeCodeBase._base_type(val.discriminator_type());
                            switch (base.kind().value()) {
                                case 2: {
                                    this.write_short((short)0);
                                    break;
                                }
                                case 4: {
                                    this.write_ushort((short)0);
                                    break;
                                }
                                case 3: {
                                    this.write_long(0);
                                    break;
                                }
                                case 5: {
                                    this.write_ulong(0);
                                    break;
                                }
                                case 8: {
                                    this.write_boolean(false);
                                    break;
                                }
                                case 9: {
                                    this.write_char('\u0000');
                                    break;
                                }
                                case 17: {
                                    this.write_ulong(0);
                                    break;
                                }
                                default: {
                                    throw new MARSHAL("Unknown type kind");
                                }
                            }
                        }
                        this.write_string(val.member_name(i));
                        this.write_TypeCodeValue(val.member_type(i), tc_list);
                        ++i;
                    }
                    break;
                }
                case 17: {
                    this.write_string(val.id());
                    this.write_string(val.name());
                    this.write_ulong(val.member_count());
                    int i = 0;
                    while (i < val.member_count()) {
                        this.write_string(val.member_name(i));
                        ++i;
                    }
                    break;
                }
                case 21: {
                    this.write_string(val.id());
                    this.write_string(val.name());
                    this.write_TypeCodeValue(val.content_type(), tc_list);
                    break;
                }
                case 29: {
                    this.write_string(val.id());
                    this.write_string(val.name());
                    this.write_short(val.type_modifier());
                    this.write_TypeCodeValue(val.concrete_base_type(), tc_list);
                    this.write_ulong(val.member_count());
                    int i = 0;
                    while (i < val.member_count()) {
                        this.write_string(val.member_name(i));
                        this.write_TypeCodeValue(val.member_type(i), tc_list);
                        this.write_short(val.member_visibility(i));
                        ++i;
                    }
                    break;
                }
                case 30: {
                    this.write_string(val.id());
                    this.write_string(val.name());
                    this.write_TypeCodeValue(val.content_type(), tc_list);
                }
            }
            this.end_encapsulation();
        }
        catch (BadKind ex) {
            this.getLogger().error("BadKind during marshal.", (Throwable)ex);
            throw ExceptionTool.initCause(new MARSHAL("BadKind during marshal (" + ex + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
        catch (Bounds ex) {
            this.getLogger().error("Bounds during marshal.", (Throwable)ex);
            throw ExceptionTool.initCause(new MARSHAL("Bounds during marshal (" + ex + ")", 0, CompletionStatus.COMPLETED_NO), (Throwable)ex);
        }
    }

    public void write_any(org.omg.CORBA.Any val) {
        this.write_TypeCode(val.type());
        val.write_value(this);
    }

    public void write_Principal(Principal val) {
        byte[] b = val.name();
        this.write_ulong(b.length);
        this.write_octet_array(b, 0, b.length);
    }

    public void write_fixed(BigDecimal val) {
        this.write_fixed(val, (short)-1, (short)-1);
    }

    public void write_fixed(BigDecimal val, TypeCode tc) {
        try {
            this.write_fixed(val, tc.fixed_digits(), tc.fixed_scale());
        }
        catch (BadKind ex) {
            this.m_buf.cancel(ExceptionTool.initCause(new BAD_PARAM("Typecode is not a fixed typecode", 1146056963, CompletionStatus.COMPLETED_NO), (Throwable)ex));
        }
    }

    public void write_fixed(BigDecimal val, short digits, short scale) {
        String v = val.abs().movePointRight(val.scale()).toString();
        if (scale >= 0) {
            int scdiff = scale - val.scale();
            if (scdiff < 0) {
                v = v.substring(0, v.length() + scdiff);
                scdiff = 0;
            } else if (scdiff > 0) {
                StringBuffer plspad = new StringBuffer(v);
                while (scdiff-- > 0) {
                    plspad.append('0');
                }
                v = plspad.toString();
            }
        }
        if (digits >= 0 && v.length() > digits) {
            this.m_buf.cancel(new MARSHAL("value too large for type", 1146056980, CompletionStatus.COMPLETED_NO));
            return;
        }
        byte[] buf = new byte[v.length() / 2 + 1];
        int i = 0;
        int j = 0;
        if (v.length() % 2 == 0) {
            buf[i++] = (byte)(v.charAt(j++) - 48);
        }
        while (i < buf.length - 1) {
            buf[i++] = (byte)(v.charAt(j++) - 48 << 4 | v.charAt(j++) - 48);
        }
        buf[i] = (byte)(v.charAt(j) - 48 << 4 | (val.signum() < 0 ? 13 : 12));
        this.write_octet_array(buf, 0, buf.length);
    }

    public void write_Context(Context ctx, ContextList contexts) {
        Vector<String> allCtx = new Vector<String>();
        int i = 0;
        while (i < contexts.count()) {
            try {
                NVList list = ctx.get_values("", 0, contexts.item(i));
                int j = 0;
                while (j < list.count()) {
                    allCtx.addElement(list.item(j).name());
                    allCtx.addElement(list.item(j).value().extract_string());
                    ++j;
                }
            }
            catch (org.omg.CORBA.Bounds ex) {
                // empty catch block
            }
            ++i;
        }
        if (allCtx.size() != 0) {
            this.write_ulong(allCtx.size());
            int j = 0;
            while (j < allCtx.size()) {
                this.write_string((String)allCtx.elementAt(j));
                ++j;
            }
        } else if (contexts.count() != 0) {
            this.write_ulong(0);
        }
    }

    public void write_value(Serializable value) {
        this.write_value(value, null, null);
    }

    public void write_value(Serializable value, String arg_repo_id) {
        this.write_value(value, arg_repo_id, null);
    }

    public void write_value(Serializable value, Class clz) {
        this.write_value(value, null, null);
    }

    public void write_value(Serializable value, BoxedValueHelper boxhelp) {
        this.write_value(value, null, boxhelp);
    }

    private void value_begin_block() {
        this.alignment(4);
        this.m_buf.beginBlock(CHUNK_GEN, 4, true, this);
        this.m_index += 4;
    }

    private void value_end_block() {
        if (!this.m_pending_value_open) {
            this.m_buf.endBlock();
        }
        this.m_value_level -= this.m_pending_value_closes;
        this.m_pending_value_closes = 0;
        this.write_long(-(this.m_value_level + 1));
    }

    /*
     * Unable to fully structure code
     */
    private void write_value(Serializable value, String arg_repo_id, BoxedValueHelper boxhelp) {
        block49: {
            if (this.m_pending_value_closes > 0) {
                this.value_end_block();
                if (this.m_in_chunked_value) {
                    this.m_pending_value_open = true;
                }
            }
            if (value == null) {
                this.write_long(0);
                return;
            }
            if (!this.m_value_init) {
                this.m_value_init = true;
                this.m_value_idx = new HashMap<K, V>();
                this.m_url_idx = new HashMap<K, V>();
                this.m_typecode_list_idx = new HashMap<K, V>();
                this.m_typecode_idx = new HashMap<K, V>();
            }
            replFrom = null;
            tmpV = this.value_extended_replace(value);
            if (tmpV != value) {
                replFrom = value;
                value = tmpV;
            }
            if ((offset = (Integer)this.m_value_idx.get(new IdentityKey(value))) != null) {
                this.write_long(-1);
                this.write_long(offset - this.m_index);
                return;
            }
            this.m_pending_value_open = false;
            tag = 0x7FFFFF00;
            ids = null;
            marshall_type = 0;
            if (boxhelp != null) {
                marshall_type = 3;
                ids = new String[]{boxhelp.get_id()};
            } else if (value instanceof StreamableValue) {
                marshall_type = 2;
                ids = ((ValueBase)value)._truncatable_ids();
            } else if (value instanceof CustomValue) {
                marshall_type = 1;
                ids = ((ValueBase)value)._truncatable_ids();
            } else if (value instanceof ValueBase) {
                marshall_type = 3;
                ids = ((ValueBase)value)._truncatable_ids();
                boxname = RepoIDHelper.idToClass(ids[0], 2);
                try {
                    boxhelp = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(boxname).newInstance();
                }
                catch (Exception ex) {
                    this.m_buf.cancel(ExceptionTool.initCause(new MARSHAL("Unable to load boxed value helper", 1146056981, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex));
                    return;
                }
            } else if (value.getClass().isArray() && arg_repo_id != null && arg_repo_id.startsWith("IDL:")) {
                marshall_type = 3;
                boxname = RepoIDHelper.idToClass(arg_repo_id, 2);
                try {
                    boxhelp = (BoxedValueHelper)Thread.currentThread().getContextClassLoader().loadClass(boxname).newInstance();
                }
                catch (Exception ex) {
                    this.m_buf.cancel(ExceptionTool.initCause(new MARSHAL("Unable to load boxed value helper", 1146056981, CompletionStatus.COMPLETED_MAYBE), (Throwable)ex));
                }
            } else {
                marshall_type = 4;
                ids = this.value_extended_get_IDs(value);
                if (ids == null) {
                    this.m_buf.cancel(new BAD_PARAM("Unable to find IDs for valuetype: " + value, 1146056964, CompletionStatus.COMPLETED_MAYBE));
                    return;
                }
            }
            last_id = ids.length;
            if (arg_repo_id != null) {
                if (ids.length == 1 && ids[0].equals(arg_repo_id)) {
                    last_id = 0;
                } else {
                    last_id = 0;
                    while (last_id < ids.length) {
                        if (arg_repo_id.equals(ids[last_id])) {
                            ++last_id;
                            break;
                        }
                        ++last_id;
                    }
                }
            }
            tag = last_id == 0 ? (tag |= 0) : (last_id == 1 ? (tag |= 2) : (tag |= 6));
            url = this.getURLCodeBase(value);
            tag = url != null ? (tag |= 1) : (tag |= 0);
            chunked = marshall_type == 1 || last_id > 1 || this.m_in_chunked_value != false;
            old_in_chunked_value = this.m_in_chunked_value;
            if (chunked) {
                this.m_in_chunked_value = true;
                tag |= 8;
            } else {
                tag |= 0;
            }
            this.alignment(4);
            this.m_value_idx.put(new IdentityKey(value), NumberCache.getInteger(this.m_index));
            if (replFrom != null) {
                this.m_value_idx.put(new IdentityKey(replFrom), NumberCache.getInteger(this.m_index));
            }
            this.write_long(tag);
            if (url != null) {
                offset = (Integer)this.m_url_idx.get(url);
                if (offset != null) {
                    this.write_ulong(-1);
                    this.write_long(offset - this.m_index);
                } else {
                    this.alignment(4);
                    this.m_url_idx.put(url, NumberCache.getInteger(this.m_index));
                    this.write_string(url);
                }
            }
            if (last_id <= 0) break block49;
            if (last_id <= 1) ** GOTO lbl114
            if (last_id < ids.length) ** GOTO lbl113
            offset = (Integer)this.m_typecode_list_idx.get(value.getClass());
            if (offset != null) {
                this.write_ulong(-1);
                this.write_long(offset - this.m_index);
            } else {
                this.alignment(4);
                this.m_typecode_list_idx.put(value.getClass(), NumberCache.getInteger(this.m_index));
lbl113:
                // 2 sources

                this.write_long(last_id);
lbl114:
                // 2 sources

                i = 0;
                while (i < last_id) {
                    offset = (Integer)this.m_typecode_idx.get(ids[i]);
                    if (offset != null) {
                        this.write_ulong(-1);
                        this.write_long(offset - this.m_index);
                    } else {
                        this.alignment(4);
                        this.m_typecode_idx.put(ids[i], NumberCache.getInteger(this.m_index));
                        this.write_string(ids[i]);
                    }
                    ++i;
                }
            }
        }
        ++this.m_value_level;
        if (chunked) {
            this.m_pending_value_open = true;
        }
        switch (marshall_type) {
            case 2: {
                ((StreamableValue)value)._write(this);
                break;
            }
            case 3: {
                boxhelp.write_value(this, value);
                break;
            }
            case 1: {
                outputStream = new DataOutputStream(this);
                ((CustomValue)value).marshal(outputStream);
                break;
            }
            case 4: {
                try {
                    this.value_extended_marshal(value);
                    break;
                }
                catch (SystemException ex) {
                    this.m_buf.cancel(ex);
                    return;
                }
                catch (Throwable ex) {
                    this.getLogger().error("Exception during extended marshal.", ex);
                    this.m_buf.cancel(ExceptionTool.initCause(new MARSHAL("Exception during extended marshal (" + ex + ")", 1146056981, CompletionStatus.COMPLETED_MAYBE), ex));
                    return;
                }
            }
        }
        if (chunked) {
            ++this.m_pending_value_closes;
            this.m_in_chunked_value = old_in_chunked_value;
        } else {
            --this.m_value_level;
        }
    }

    protected Serializable value_extended_replace(Serializable value) {
        return value;
    }

    protected String[] value_extended_get_IDs(Serializable value) {
        return null;
    }

    protected boolean value_extended_custom(Serializable value) {
        return true;
    }

    protected void value_extended_marshal(Serializable value) {
        this.m_buf.cancel(new BAD_PARAM("Unable to marshal valuetype", 1146056964, CompletionStatus.COMPLETED_MAYBE));
    }

    public void write_abstract_interface(java.lang.Object obj) {
        if (obj != null && obj instanceof Object) {
            this.write_boolean(true);
            this.write_Object((Object)obj);
        } else if (obj == null || obj instanceof Serializable) {
            this.write_boolean(false);
            this.write_value((Serializable)obj);
        } else {
            this.m_buf.cancel(new BAD_PARAM("Attempt to marshal unknown interface type", 1146056967, CompletionStatus.COMPLETED_MAYBE));
        }
    }

    private String getURLCodeBase(java.lang.Object obj) {
        if (this.m_system_urls == null) {
            ORBLoader props = ((ORB)this.m_orb).getLoader();
            this.m_system_urls = props.getStringProperty("openorb.URLCodeBase", "");
        }
        if (this.m_system_urls.length() != 0) {
            return this.m_system_urls;
        }
        ClassLoader loader = obj.getClass().getClassLoader();
        if (!(loader instanceof URLClassLoader)) {
            return null;
        }
        URL[] urls = ((URLClassLoader)loader).getURLs();
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < urls.length) {
            if (!urls[i].getProtocol().equals("file")) {
                buf.append(urls[i].toString()).append(' ');
            }
            ++i;
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }
}

