/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter;

import java.util.HashSet;
import java.util.Iterator;
import org.omg.CORBA.Any;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactory;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.IOR;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentSeqHelper;
import org.omg.IOP.TaggedProfile;
import org.openorb.PI.ComponentSet;
import org.openorb.net.ServerProtocol;
import org.openorb.util.ExceptionTool;

public class IORUtil {
    private static Codec s_component_codec;

    public static IOR construct_ior(String type_id, byte[] object_key, ComponentSet component_set, Object[] protProfIDs, ORB orb) {
        IOR ret = new IOR();
        ret.type_id = type_id;
        int u = 0;
        TaggedComponent[] multi = component_set.getComponents(1);
        if (multi != null && multi.length > 0) {
            ret.profiles = new TaggedProfile[protProfIDs.length / 2 + 1];
        } else {
            multi = null;
            ret.profiles = new TaggedProfile[protProfIDs.length / 2];
        }
        int i = 0;
        while (i < protProfIDs.length) {
            ServerProtocol protocol = (ServerProtocol)protProfIDs[i];
            int profile_tag = (Integer)protProfIDs[i + 1];
            TaggedProfile profile = protocol.create_profile(profile_tag, component_set, object_key);
            if (profile != null) {
                ret.profiles[u++] = profile;
            }
            i += 2;
        }
        if (u == 0) {
            return null;
        }
        if (multi != null) {
            byte[] buf;
            Any any = orb.create_any();
            TaggedComponentSeqHelper.insert(any, multi);
            Codec cmptCodec = IORUtil.getComponentCodec(orb);
            try {
                buf = cmptCodec.encode_value(any);
            }
            catch (InvalidTypeForEncoding ex) {
                throw ExceptionTool.initCause(new INTERNAL("Invalid encoding type"), (Throwable)ex);
            }
            if (buf != null) {
                ret.profiles[u++] = new TaggedProfile(1, buf);
            }
        }
        if (u < ret.profiles.length) {
            TaggedProfile[] tmp = new TaggedProfile[u];
            System.arraycopy(ret.profiles, 0, tmp, 0, u);
            ret.profiles = tmp;
        }
        return ret;
    }

    private static Codec getComponentCodec(ORB orb) {
        if (s_component_codec == null) {
            try {
                CodecFactory factory = (CodecFactory)orb.resolve_initial_references("CodecFactory");
                s_component_codec = factory.create_codec(new Encoding(0, 1, 0));
            }
            catch (UserException ex) {
                throw ExceptionTool.initCause(new INTERNAL("Either resolve of CodecFactory failed or create_codec returned with an exception (" + ex + ")"), (Throwable)ex);
            }
        }
        return s_component_codec;
    }

    public static IOR merge_iors(String type_id, IOR[] iors) {
        HashSet<ProfileMember> pms = new HashSet<ProfileMember>();
        int i = 0;
        while (i < iors.length) {
            int j = 0;
            while (j < iors[i].profiles.length) {
                pms.add(new ProfileMember(iors[i].profiles[j]));
                ++j;
            }
            ++i;
        }
        IOR ret = new IOR(type_id, new TaggedProfile[pms.size()]);
        int i2 = 0;
        Iterator itt = pms.iterator();
        while (itt.hasNext()) {
            ret.profiles[i2++] = ((ProfileMember)itt.next()).profile();
        }
        return ret;
    }

    private static class ProfileMember {
        private int m_hash;
        private TaggedProfile m_profile;

        public ProfileMember(TaggedProfile profile) {
            this.m_profile = profile;
            this.m_hash = this.m_profile.tag;
            int i = 0;
            while (i < this.m_profile.profile_data.length) {
                this.m_hash = 31 * this.m_hash + this.m_profile.profile_data[i];
                ++i;
            }
        }

        public int hashCode() {
            return this.m_hash;
        }

        public TaggedProfile profile() {
            return this.m_profile;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProfileMember)) {
                return false;
            }
            ProfileMember pm2 = (ProfileMember)obj;
            if (this.m_hash != pm2.hashCode() || this.m_profile.tag != pm2.profile().tag || this.m_profile.profile_data.length != pm2.m_profile.profile_data.length) {
                return false;
            }
            int i = 0;
            while (i < this.m_profile.profile_data.length) {
                if (this.m_profile.profile_data[i] != pm2.m_profile.profile_data[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

