/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.PI;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.ORBInitializer;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.openorb.CORBA.LoggableLocalObject;
import org.openorb.CORBA.ORB;
import org.openorb.CORBA.kernel.ORBLoader;
import org.openorb.PI.ClientManager;
import org.openorb.PI.CodecFactoryManager;
import org.openorb.PI.CodecFactoryManagerImpl;
import org.openorb.PI.CurrentImpl;
import org.openorb.PI.FeatureInitInfo;
import org.openorb.PI.FeatureInitializer;
import org.openorb.PI.IORManager;
import org.openorb.PI.ORBInitInfo;
import org.openorb.PI.ServerManager;
import org.openorb.policy.PolicyFactoryManager;
import org.openorb.util.ExceptionTool;

public class OpenORBInitInfo
extends LoggableLocalObject
implements org.omg.PortableInterceptor.ORBInitInfo,
FeatureInitInfo,
ORBInitInfo,
Disposable {
    private ORB m_orb;
    private Logger m_logger;
    private String[] m_args;
    private ORBInitializer[] m_orb_inits;
    private FeatureInitializer[] m_feature_inits;
    private ORBLoader m_loader;
    private int m_slots = 0;
    private ArrayList m_client_interceptors = new ArrayList();
    private ArrayList m_server_interceptors = new ArrayList();
    private ArrayList m_ior_interceptors = new ArrayList();
    private CodecFactoryManager m_codec_manager;
    private int m_phase = 0;
    private static final int PHASE_CREATED = 0;
    private static final int PHASE_PRE_INIT = 1;
    private static final int PHASE_POST_INIT = 3;
    private static final int PHASE_COMPLETE = 4;

    public OpenORBInitInfo(String[] args, ORB orb, ORBInitializer[] orbInits, FeatureInitializer[] featureInits) {
        this.m_args = args;
        this.m_orb = orb;
        this.m_orb_inits = orbInits;
        this.m_feature_inits = featureInits;
        this.m_logger = this.m_orb.getLogger();
        try {
            this.m_loader = (ORBLoader)this.m_orb.getFeature("ORBLoader");
        }
        catch (Exception ex) {
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("Couldn't get ORBLoader feature.", (Throwable)ex);
            }
            throw new CascadingRuntimeException("Could not resolve ORBLoader.", (Throwable)ex);
        }
    }

    public void pre_init() {
        if (this.m_phase != 0) {
            throw new INITIALIZE("Call to pre_init not allowed at this time");
        }
        this.m_phase = 1;
        this.m_codec_manager = new CodecFactoryManagerImpl();
        this.m_orb.addInitialReference("CodecFactory", (Object)((java.lang.Object)this.m_codec_manager));
        this.m_orb.setFeature("CodecFactoryManager", this.m_codec_manager);
        if (this.m_orb_inits != null) {
            int i = 0;
            while (i < this.m_orb_inits.length) {
                this.m_orb_inits[i].pre_init(this);
                ++i;
            }
        }
    }

    public void post_init() {
        if (this.m_phase != 1) {
            throw new INITIALIZE("Call to post_init not allowed at this time");
        }
        this.m_phase = 3;
        if (this.m_feature_inits != null) {
            int i = 0;
            while (i < this.m_feature_inits.length) {
                this.m_feature_inits[i].init(this, this);
                ++i;
            }
        }
        CurrentImpl pi_current = new CurrentImpl(this.m_orb);
        this.m_orb.addInitialReference("PICurrent", pi_current);
        this.m_orb.setFeature("PICurrent", pi_current);
        if (this.m_orb_inits != null) {
            int i = 0;
            while (i < this.m_orb_inits.length) {
                this.m_orb_inits[i].post_init(this);
                ++i;
            }
        }
        pi_current.set_slots(this.m_slots);
        this.create_client_interceptor_manager(pi_current);
        this.create_server_interceptor_manager(pi_current);
        this.create_ior_interceptor_manager();
        this.m_phase = 4;
    }

    private void create_client_interceptor_manager(CurrentImpl pi_current) {
        if (!this.m_loader.getBooleanProperty("openorb.client.enable", true)) {
            return;
        }
        if (this.m_client_interceptors.isEmpty()) {
            return;
        }
        ClientRequestInterceptor[] list = new ClientRequestInterceptor[this.m_client_interceptors.size()];
        this.m_client_interceptors.toArray(list);
        ClientManager manager = null;
        java.lang.Object[] args = new java.lang.Object[]{list, pi_current};
        try {
            manager = (ClientManager)this.m_loader.constructClass("openorb.pi.ClientManagerClass", "org.openorb.PI.SimpleClientManager", args);
        }
        catch (Exception ex) {
            this.getLogger().error("Error constructing class openorb.pi.ClientManagerClass.", (Throwable)ex);
            throw ExceptionTool.initCause(new INITIALIZE("Error constructing class openorb.pi.ClientManagerClass (" + ex + ")"), (Throwable)ex);
        }
        if (manager != null) {
            this.m_orb.setFeature("ClientInterceptorManager", manager);
        }
    }

    private void create_server_interceptor_manager(CurrentImpl pi_current) {
        if (!this.m_loader.getBooleanProperty("openorb.server.enable", true)) {
            return;
        }
        if (this.m_server_interceptors.isEmpty()) {
            return;
        }
        ServerRequestInterceptor[] list = new ServerRequestInterceptor[this.m_server_interceptors.size()];
        this.m_server_interceptors.toArray(list);
        ServerManager manager = null;
        java.lang.Object[] args = new java.lang.Object[]{list, pi_current};
        try {
            manager = (ServerManager)this.m_loader.constructClass("openorb.pi.ServerManagerClass", "org.openorb.PI.SimpleServerManager", args);
        }
        catch (Exception ex) {
            this.getLogger().error("Error constructing class openorb.pi.ServerManagerClass.", (Throwable)ex);
            throw ExceptionTool.initCause(new INITIALIZE("Error constructing class openorb.pi.ServerManagerClass (" + ex + ")"), (Throwable)ex);
        }
        if (manager != null) {
            this.m_orb.setFeature("ServerInterceptorManager", manager);
        }
    }

    private void create_ior_interceptor_manager() {
        if (!this.m_loader.getBooleanProperty("openorb.server.enable", true)) {
            return;
        }
        IORInterceptor[] list = new IORInterceptor[this.m_ior_interceptors.size()];
        this.m_ior_interceptors.toArray(list);
        IORManager manager = null;
        java.lang.Object[] args = new java.lang.Object[]{list};
        try {
            manager = (IORManager)this.m_loader.constructClass("org.openorb.PI.IORManagerClass", "org.openorb.PI.SimpleIORManager", args);
        }
        catch (Exception ex) {
            this.getLogger().error("Error constructing class org.openorb.PI.IORManagerClass.", (Throwable)ex);
            throw ExceptionTool.initCause(new INITIALIZE("Error constructing class org.openorb.PI.IORManagerClass (" + ex + ")"), (Throwable)ex);
        }
        if (manager != null) {
            this.m_orb.setFeature("IORInterceptorManager", manager);
        }
    }

    public ORB orb() {
        return this.m_orb;
    }

    public ORBLoader getLoader() {
        return this.m_orb.getLoader();
    }

    public void setFeature(String feature, java.lang.Object reference) {
        this.m_orb.setFeature(feature, reference);
    }

    public java.lang.Object getFeature(String feature) {
        return this.m_orb.getFeature(feature);
    }

    public String[] arguments() {
        return this.m_args;
    }

    public String orb_id() {
        return "OpenORB";
    }

    public CodecFactory codec_factory() {
        return (CodecFactory)((java.lang.Object)this.m_codec_manager);
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        try {
            Object res = this.resolve_initial_references(id);
        }
        catch (InvalidName ex) {
            this.m_orb.addInitialReference(id, obj);
            return;
        }
        throw new InvalidName();
    }

    public Object resolve_initial_references(String id) throws InvalidName {
        try {
            return this.m_orb.resolve_initial_references(id);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName ex) {
            throw (InvalidName)ExceptionTool.initCause(new InvalidName(), (Throwable)ex);
        }
    }

    public void add_client_request_interceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        this.check_duplicate(this.m_client_interceptors, interceptor.name());
        this.m_client_interceptors.add(interceptor);
    }

    public void add_server_request_interceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        this.check_duplicate(this.m_server_interceptors, interceptor.name());
        this.m_server_interceptors.add(interceptor);
    }

    public void add_ior_interceptor(IORInterceptor interceptor) throws DuplicateName {
        this.check_duplicate(this.m_ior_interceptors, interceptor.name());
        this.m_ior_interceptors.add(interceptor);
    }

    public int allocate_slot_id() {
        return this.m_slots++;
    }

    public void register_policy_factory(int type, PolicyFactory policy_factory) {
        PolicyFactoryManager policyFactoryManager = (PolicyFactoryManager)this.m_orb.getFeature("PolicyFactoryManager");
        policyFactoryManager.add_policy_factory(type, policy_factory);
    }

    private void check_duplicate(ArrayList list, String name) throws DuplicateName {
        if (name.length() == 0) {
            return;
        }
        Iterator itt = list.iterator();
        while (itt.hasNext()) {
            if (!name.equals(((Interceptor)itt.next()).name())) continue;
            throw new DuplicateName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        HashSet<java.lang.Object> list = new HashSet<java.lang.Object>();
        int i = 0;
        while (i < this.m_orb_inits.length) {
            block12: {
                ORBInitializer object = this.m_orb_inits[i];
                if (!list.contains(object) && object instanceof Disposable) {
                    java.lang.Object var7_9;
                    try {
                        try {
                            ((Disposable)object).dispose();
                        }
                        catch (Throwable e) {
                            String warn = "Ignoring error during initializer disposal.";
                            this.getLogger().warn("Ignoring error during initializer disposal.", e);
                            var7_9 = null;
                            list.add(object);
                            break block12;
                        }
                        var7_9 = null;
                        list.add(object);
                    }
                    catch (Throwable throwable) {
                        var7_9 = null;
                        list.add(object);
                        throw throwable;
                    }
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.m_feature_inits.length) {
            block13: {
                FeatureInitializer object = this.m_feature_inits[i2];
                if (!list.contains(object) && object instanceof Disposable) {
                    java.lang.Object var9_12;
                    try {
                        try {
                            ((Disposable)object).dispose();
                        }
                        catch (Throwable e) {
                            String warn = "Ignoring error during feature disposal.";
                            this.getLogger().warn("Ignoring error during feature disposal.", e);
                            var9_12 = null;
                            list.add(object);
                            break block13;
                        }
                        var9_12 = null;
                        list.add(object);
                    }
                    catch (Throwable throwable) {
                        var9_12 = null;
                        list.add(object);
                        throw throwable;
                    }
                }
            }
            ++i2;
        }
    }
}

