package org.omg.CORBA;

/**
 * INV_POLICY is raised when an invocation cannot be made due to an
 * incompatibility between Policy overrides that apply to the
 * particular invocation.
 * 
 * @since  CORBA 2.3
 */

public class INV_POLICY extends org.omg.CORBA.SystemException
{
    //
    // Default constructor
    //
    public INV_POLICY()
    {
        super( null, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with reason string
    //
    public INV_POLICY( String orb_reason )
    {
        super( orb_reason, 0, CompletionStatus.COMPLETED_MAYBE );
    }

    //
    // Constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public INV_POLICY( int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( null, minor, completed );
    }

    //
    // Full constructor with fields initialization
    // @param minor minor exception member
    // @param completed completed exception member
    //
    public INV_POLICY( String orb_reason, int minor, org.omg.CORBA.CompletionStatus completed )
    {
        super( orb_reason, minor, completed );
    }
}
