/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.adapter.poa;

import org.apache.avalon.framework.logger.Logger;
import org.omg.CORBA.DomainManager;
import org.omg.CORBA.DomainManagerHelper;
import org.omg.CORBA.INV_POLICY;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.InvalidPolicy;
import org.omg.PortableServer.POAPackage.WrongPolicy;
import org.openorb.CORBA.ORBSingleton;
import org.openorb.PI.ComponentSet;
import org.openorb.adapter.poa.POA;
import org.openorb.adapter.poa.POADomainManagerImpl;
import org.openorb.net.ServerManager;
import org.openorb.util.ExceptionTool;

class RootPOA
extends POA {
    private static final String[] ROOT_POA_NAME = new String[]{"POA"};
    private static final String[] PERSIST_DOMAIN_POA_NAME = new String[]{"POAPDM"};
    private static final String[] DOMAIN_POA_NAME = new String[]{"POADM"};
    private POA m_domain_manager_poa;
    private POA m_persist_domain_manager_poa;

    private RootPOA(ORB orb, Policy[] policies) throws InvalidPolicy {
        super(orb, null, ROOT_POA_NAME, null, policies);
    }

    static POA create_root_poa(ServerManager svrmgr, Policy[] policies) {
        try {
            RootPOA root;
            block7: {
                block6: {
                    Policy[] pols = new Policy[policies.length + 1];
                    System.arraycopy(policies, 0, pols, 0, policies.length);
                    pols[policies.length] = POA.getPolicyFactory().create_implicit_activation_policy(0);
                    ORB orb = svrmgr.orb();
                    root = new RootPOA(orb, pols);
                    pols = new Policy[policies.length + 4];
                    pols[policies.length] = POA.getPolicyFactory().create_id_assignment_policy(0);
                    pols[policies.length + 1] = POA.getPolicyFactory().create_lifespan_policy(0);
                    pols[policies.length + 2] = POA.getPolicyFactory().create_servant_retention_policy(1);
                    pols[policies.length + 3] = POA.getPolicyFactory().create_request_processing_policy(1);
                    root.m_domain_manager_poa = new DomainManagerPOA(orb, root, DOMAIN_POA_NAME, null, pols);
                    pols[policies.length + 1] = POA.getPolicyFactory().create_lifespan_policy(1);
                    root.m_persist_domain_manager_poa = new DomainManagerPOA(orb, root, PERSIST_DOMAIN_POA_NAME, root.m_domain_manager_poa.getAdapterManager(), pols);
                    POADomainManagerImpl defl = new POADomainManagerImpl(root);
                    try {
                        root.m_domain_manager_poa.set_servant(defl);
                        root.m_persist_domain_manager_poa.set_servant(defl);
                    }
                    catch (WrongPolicy ex) {
                        if (!root.getLogger().isErrorEnabled()) break block6;
                        root.getLogger().error("WrongPolicy when setting servant.", (Throwable)ex);
                    }
                }
                try {
                    root.m_domain_manager_poa.getAdapterManager().activate();
                }
                catch (AdapterInactive ex) {
                    if (!root.getLogger().isErrorEnabled()) break block7;
                    root.getLogger().error("Newly created adapter inactive.", (Throwable)ex);
                }
            }
            svrmgr.register_adapter(root.getAid(), root);
            svrmgr.register_adapter(root.m_domain_manager_poa.getAid(), root.m_domain_manager_poa);
            svrmgr.register_adapter(root.m_persist_domain_manager_poa.getAid(), root.m_persist_domain_manager_poa);
            return root;
        }
        catch (InvalidPolicy ex) {
            Logger logger = ((ORBSingleton)svrmgr.orb()).getLogger();
            logger.error("Invalid policy specified.", (Throwable)ex);
            throw ExceptionTool.initCause(new INV_POLICY("Invalid policy specified (" + ex + ")"), (Throwable)ex);
        }
    }

    DomainManager create_poa_domain_manager(byte[] aid, boolean persist) {
        if (persist) {
            return DomainManagerHelper.narrow(this.m_persist_domain_manager_poa.create_reference_with_id(aid, DomainManagerHelper.id()));
        }
        return DomainManagerHelper.narrow(this.m_domain_manager_poa.create_reference_with_id(aid, DomainManagerHelper.id()));
    }

    private static class DomainManagerPOA
    extends POA {
        public DomainManagerPOA(ORB orb, POA parent, String[] poa_name, ServerManager.AdapterManager poa_manager, Policy[] policies) throws InvalidPolicy {
            super(orb, parent, poa_name, poa_manager, policies);
        }

        protected Object create_reference(byte[] oid, String intf) {
            if (this.getPoaCompSet() == null) {
                this.setPoaCompSet(new ComponentSet(this.getServerManager().orb(), this.getPolicySet(), null));
                this.getPoaCompSet().interception_point();
            }
            return super.create_reference(oid, intf);
        }
    }
}

