/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows;

import java.awt.EventQueue;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.core.windows.StateManager;

public class DeferredPerformer
implements StateManager.StateListener {
    static final int NOT_INITIALIZED = 0;
    static final int READY = 1;
    static final int DEFERRED = 2;
    int state = 0;
    ArrayList requests;
    private static DeferredPerformer defaultInstance;
    private int processes = 0;
    private Object LOCK = new Object();

    private DeferredPerformer() {
    }

    public static synchronized DeferredPerformer getDefault() {
        if (defaultInstance == null) {
            defaultInstance = new DeferredPerformer();
        }
        return defaultInstance;
    }

    public void putRequest(DeferredCommand dc, Object context) {
        this.putRequest(dc, new DeferredContext(context, false));
    }

    public void putRequest(DeferredCommand dc, DeferredContext context) {
        if (context == null) {
            context = new DeferredContext(null, false);
        }
        DeferredPerformer deferredPerformer = this;
        synchronized (deferredPerformer) {
            if (this.state == 0) {
                this.initialize();
            }
            if (this.state == 2) {
                DeferredEntry entry = new DeferredEntry();
                entry.command = dc;
                entry.context = context;
                this.requests.add(entry);
                return;
            }
        }
        this.processCommand(dc, context);
    }

    public boolean removeRequest(DeferredCommand command) {
        DeferredEntry curEntry = null;
        DeferredPerformer deferredPerformer = this;
        synchronized (deferredPerformer) {
            Iterator iter = ((AbstractList)this.requests).iterator();
            while (iter.hasNext()) {
                curEntry = (DeferredEntry)iter.next();
                if (!curEntry.command.equals(command)) continue;
                ((AbstractCollection)this.requests).remove(curEntry);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public boolean canImmediatelly() {
        return this.state == 1;
    }

    public boolean isProcessing() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = this.processes != 0;
            return bl;
        }
    }

    private void incProcesses() {
        Object object = this.LOCK;
        synchronized (object) {
            ++this.processes;
        }
    }

    private void decProcesses() {
        Object object = this.LOCK;
        synchronized (object) {
            --this.processes;
        }
    }

    private void initialize() {
        this.requests = new ArrayList(40);
        this.updateState();
        StateManager.getDefault().addStateListener(this);
    }

    public void stateChanged(int newState) {
        DeferredEntry[] entries = null;
        DeferredPerformer deferredPerformer = this;
        synchronized (deferredPerformer) {
            int oldState = this.state;
            this.updateState();
            if (this.state != oldState && this.state == 1) {
                entries = this.requests.toArray(new DeferredEntry[0]);
                this.requests.clear();
            }
        }
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                this.processCommand(entries[i].command, entries[i].context);
                ++i;
            }
        }
    }

    private void updateState() {
        StateManager stateManager = StateManager.getDefault();
        int wmState = stateManager.getState();
        this.state = ((wmState & 1) != 0 || (wmState & 4) != 0) && (wmState & 0x120) != 0 ? 1 : 2;
    }

    private void processCommand(final DeferredCommand dc, final DeferredContext context) {
        if (context.isRunInEventThread() && !EventQueue.isDispatchThread()) {
            this.incProcesses();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        dc.performCommand(context);
                        Object var2_1 = null;
                    }
                    catch (Throwable throwable) {
                        Object var2_2 = null;
                        DeferredPerformer.this.decProcesses();
                        throw throwable;
                    }
                    DeferredPerformer.this.decProcesses();
                }
            });
        } else {
            dc.performCommand(context);
        }
    }

    private static final class DeferredEntry {
        DeferredCommand command;
        DeferredContext context;

        DeferredEntry() {
        }
    }

    public static class DeferredContext {
        private Object data;
        private boolean runInEventThread;

        public DeferredContext(Object data, boolean runInEventThread) {
            this.data = data;
            this.runInEventThread = runInEventThread;
        }

        public Object getData() {
            return this.data;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public boolean isRunInEventThread() {
            return this.runInEventThread;
        }

        public void setRunInEventThread(boolean runInEventThread) {
            this.runInEventThread = runInEventThread;
        }
    }

    public static interface DeferredCommand {
        public void performCommand(DeferredContext var1);
    }
}

