/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.taskDemo;

import EDU.oswego.cs.dl.util.concurrent.FJTask;
import EDU.oswego.cs.dl.util.concurrent.FJTaskRunnerGroup;

public class Fib
extends FJTask {
    static int sequentialThreshold = 0;
    volatile int number;

    public static void main(String[] args) {
        try {
            int num;
            int procs;
            try {
                procs = Integer.parseInt(args[0]);
                num = Integer.parseInt(args[1]);
                if (args.length > 2) {
                    sequentialThreshold = Integer.parseInt(args[2]);
                }
            }
            catch (Exception e) {
                System.out.println("Usage: java Fib <threads> <number> [<sequntialThreshold>]");
                return;
            }
            FJTaskRunnerGroup g = new FJTaskRunnerGroup(procs);
            Fib f = new Fib(num);
            g.invoke(f);
            g.stats();
            long result = f.getAnswer();
            System.out.println("Fib: Size: " + num + " Answer: " + result);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    Fib(int n) {
        this.number = n;
    }

    int getAnswer() {
        if (!this.isDone()) {
            throw new Error("Not yet computed");
        }
        return this.number;
    }

    public void run() {
        int n = this.number;
        if (n > 1) {
            if (n <= sequentialThreshold) {
                this.number = Fib.seqFib(n);
            } else {
                Fib f1 = new Fib(n - 1);
                Fib f2 = new Fib(n - 2);
                FJTask.coInvoke(f1, f2);
                this.number = f1.number + f2.number;
            }
        }
    }

    static int seqFib(int n) {
        if (n <= 1) {
            return n;
        }
        return Fib.seqFib(n - 1) + Fib.seqFib(n - 2);
    }
}

