/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderList;
import org.openide.loaders.FolderListListener;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.WeakListener;

public abstract class FolderInstance
extends Task
implements InstanceCookie {
    private static final RequestProcessor PROCESSOR = new RequestProcessor("Folder Instance Processor");
    private static final ThreadLocal CURRENT = new ThreadLocal();
    private static final ThreadLocal LAST_CURRENT = new ThreadLocal();
    protected DataFolder folder;
    private DataObject.Container container;
    private HashMap map = new HashMap(17);
    private Task[] waitFor;
    private Object object = CURRENT;
    private Listener listener;
    private ErrorManager err;
    private Task recognizingTask;
    private Task creationTask;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$loaders$DataObject$Container;

    public FolderInstance(DataFolder df) {
        this((DataObject.Container)df);
    }

    public FolderInstance(DataObject.Container container) {
        this(container, null);
    }

    private FolderInstance(DataObject.Container container, String logName) {
        if (container instanceof DataFolder) {
            this.folder = (DataFolder)container;
            if (logName == null) {
                logName = this.folder.getPrimaryFile().getPath().replace('/', '.');
            }
            container = FolderList.find(this.folder.getPrimaryFile(), true);
        }
        this.listener = new Listener();
        logName = logName == null ? "org.openide.loaders.FolderInstance" : "org.openide.loaders.FolderInstance." + logName;
        this.err = ErrorManager.getDefault().getInstance(logName);
        this.container = container;
        container.addPropertyChangeListener(WeakListener.propertyChange(this.listener, container));
    }

    public String instanceName() {
        try {
            return this.instanceClass().getName();
        }
        catch (IOException ex) {
            return "java.lang.Object";
        }
        catch (ClassNotFoundException ex) {
            return "java.lang.Object";
        }
    }

    public Class instanceClass() throws IOException, ClassNotFoundException {
        Object object = this.object;
        if (object != null) {
            if (object instanceof IOException) {
                throw (IOException)object;
            }
            if (object instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)object;
            }
            return object.getClass();
        }
        return class$java$lang$Object == null ? (class$java$lang$Object = FolderInstance.class$("java.lang.Object")) : class$java$lang$Object;
    }

    public Object instanceCreate() throws IOException, ClassNotFoundException {
        Object object = CURRENT.get();
        if (object == null || LAST_CURRENT.get() != this) {
            this.waitFinished();
            object = this.object;
        }
        if (object instanceof IOException) {
            throw (IOException)object;
        }
        if (object instanceof ClassNotFoundException) {
            throw (ClassNotFoundException)object;
        }
        if (object == CURRENT) {
            throw new IOException("Cyclic reference. Somebody is trying to get value from FolderInstance (" + this.getClass().getName() + ") from the same thread that is processing the instance");
        }
        return object;
    }

    public final void instanceFinished() {
        this.waitFinished();
    }

    public void waitFinished() {
        Task originalRecognizing;
        do {
            Task[] toWait;
            FolderInstance.waitProcessingFinished(this.container);
            originalRecognizing = this.checkRecognizingStarted();
            originalRecognizing.waitFinished();
            Task t = this.creationTask;
            if (t != null) {
                t.waitFinished();
            }
            if ((toWait = this.waitFor) == null) continue;
            int i = 0;
            while (i < toWait.length) {
                toWait[i].waitFinished();
                ++i;
            }
        } while (originalRecognizing != this.checkRecognizingStarted());
    }

    public void run() {
        this.recreate();
        this.instanceFinished();
    }

    protected InstanceCookie acceptDataObject(DataObject dob) {
        DataObject.Container c;
        DataFolder folder;
        InstanceCookie cookie = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? (class$org$openide$cookies$InstanceCookie = FolderInstance.class$("org.openide.cookies.InstanceCookie")) : class$org$openide$cookies$InstanceCookie);
        try {
            cookie = cookie == null ? null : this.acceptCookie(cookie);
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, ex);
            cookie = null;
        }
        catch (ClassNotFoundException ex) {
            ErrorManager.getDefault().notify(1, ex);
            cookie = null;
        }
        if (cookie == null && (folder = (DataFolder)dob.getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = FolderInstance.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder)) != null) {
            HoldInstance previous = (HoldInstance)this.map.get(folder.getPrimaryFile());
            cookie = previous != null && previous.cookie != null ? previous : this.acceptFolder(folder);
        }
        if (cookie == null && (c = (DataObject.Container)dob.getCookie(class$org$openide$loaders$DataObject$Container == null ? (class$org$openide$loaders$DataObject$Container = FolderInstance.class$("org.openide.loaders.DataObject$Container")) : class$org$openide$loaders$DataObject$Container)) != null) {
            cookie = this.acceptContainer(c);
        }
        if (this.err.isLoggable(1)) {
            this.err.log(1, "acceptDataObject: " + dob + " cookie: " + cookie);
        }
        return cookie;
    }

    protected InstanceCookie acceptCookie(InstanceCookie cookie) throws IOException, ClassNotFoundException {
        return cookie;
    }

    protected InstanceCookie acceptFolder(DataFolder df) {
        return this.acceptContainer(df);
    }

    protected InstanceCookie acceptContainer(DataObject.Container container) {
        return null;
    }

    protected abstract Object createInstance(InstanceCookie[] var1) throws IOException, ClassNotFoundException;

    protected Object instanceForCookie(DataObject obj, InstanceCookie cookie) throws IOException, ClassNotFoundException {
        return cookie.instanceCreate();
    }

    public synchronized void recreate() {
        this.err.log("recreate");
        this.recognizingTask = FolderInstance.computeChildrenList(this.container, this.listener);
        this.notifyRunning();
    }

    final void checkRecreate() {
        if (this.isFinished()) {
            this.recreate();
        }
    }

    private final Task checkRecognizingStarted() {
        if (this.recognizingTask == null) {
            this.recreate();
        }
        return this.recognizingTask;
    }

    private static void waitProcessingFinished(DataObject.Container c) {
        if (c instanceof FolderList) {
            ((FolderList)c).waitProcessingFinished();
        }
    }

    private static Task computeChildrenList(final DataObject.Container container, final FolderListListener listener) {
        if (container instanceof FolderList) {
            FolderList list = (FolderList)container;
            return list.computeChildrenList(listener);
        }
        return PROCESSOR.post(new Runnable(){

            public void run() {
                DataObject[] arr = container.getChildren();
                ArrayList list = new ArrayList(arr.length);
                int i = 0;
                while (i < arr.length) {
                    listener.process(arr[i], list);
                    ++i;
                }
                listener.finished(list);
            }
        });
    }

    final void processObjects(final Collection arr) {
        this.creationTask = this.postCreationTask(new Runnable(){

            public void run() {
                FolderInstance.this.defaultProcessObjects(arr);
            }
        });
    }

    /*
     * Loose catch block
     */
    private final void defaultProcessObjects(Collection arr) {
        block28: {
            Object v0;
            HashSet toRemove;
            this.err.log("defaultProcessObjects");
            ArrayList<HoldInstance> cookies = new ArrayList<HoldInstance>();
            ThreadLocal threadLocal = CURRENT;
            synchronized (threadLocal) {
                toRemove = new HashSet(this.map.keySet());
            }
            Iterator dataObjects = arr.iterator();
            while (dataObjects.hasNext()) {
                HoldInstance hold;
                DataObject obj = (DataObject)dataObjects.next();
                if (!obj.isValid()) continue;
                InstanceCookie cookie = this.acceptDataObject(obj);
                if (cookie != null) {
                    FileObject fo = obj.getPrimaryFile();
                    HoldInstance prevCookie = null;
                    if (toRemove.remove(fo) && (prevCookie = (HoldInstance)this.map.get(fo)) != null && prevCookie.cookie == null) {
                        prevCookie = null;
                    }
                    if (prevCookie == null) {
                        hold = cookie instanceof HoldInstance ? (HoldInstance)cookie : (cookie instanceof InstanceCookie.Origin ? new HoldInstanceOrigin(obj, (InstanceCookie.Origin)cookie) : new HoldInstance(obj, cookie));
                        ThreadLocal threadLocal2 = CURRENT;
                        synchronized (threadLocal2) {
                            this.map.put(fo, hold);
                        }
                        obj.addPropertyChangeListener(WeakListener.propertyChange(this.listener, obj));
                        cookies.add(hold);
                        continue;
                    }
                    cookies.add(prevCookie);
                    continue;
                }
                ThreadLocal threadLocal3 = CURRENT;
                synchronized (threadLocal3) {
                    FileObject fo = obj.getPrimaryFile();
                    toRemove.remove(fo);
                    hold = (HoldInstance)this.map.get(fo);
                    if (hold != null && hold.cookie == null) {
                        continue;
                    }
                    hold = new HoldInstance(obj, null);
                    this.map.put(fo, hold);
                }
                obj.addPropertyChangeListener(WeakListener.propertyChange(this.listener, obj));
            }
            ThreadLocal threadLocal4 = CURRENT;
            synchronized (threadLocal4) {
                this.map.keySet().removeAll(toRemove);
            }
            InstanceCookie[] all = new HoldInstance[cookies.size()];
            cookies.toArray(all);
            this.updateWaitFor((HoldInstance[])all);
            Object result = null;
            result = this.createInstance(all);
            Object var19_18 = null;
            this.err.log("notifying finished");
            this.object = result;
            Object prevResult = CURRENT.get();
            CURRENT.set(result);
            Object prevLast = LAST_CURRENT.get();
            LAST_CURRENT.set(this);
            try {
                this.notifyFinished();
                v0 = null;
            }
            catch (Throwable throwable) {
                v0 = null;
            }
            Object var23_34 = v0;
            CURRENT.set(prevResult);
            LAST_CURRENT.set(prevLast);
            {
                break block28;
                catch (IOException ex) {
                    Object v1;
                    result = ex;
                    Object var19_19 = null;
                    this.err.log("notifying finished");
                    this.object = result;
                    prevResult = CURRENT.get();
                    CURRENT.set(result);
                    prevLast = LAST_CURRENT.get();
                    LAST_CURRENT.set(this);
                    try {
                        this.notifyFinished();
                        v1 = null;
                    }
                    catch (Throwable throwable) {
                        v1 = null;
                    }
                    Object var23_35 = v1;
                    CURRENT.set(prevResult);
                    LAST_CURRENT.set(prevLast);
                    break block28;
                }
                catch (ClassNotFoundException ex) {
                    Object v2;
                    result = ex;
                    Object var19_20 = null;
                    this.err.log("notifying finished");
                    this.object = result;
                    prevResult = CURRENT.get();
                    CURRENT.set(result);
                    prevLast = LAST_CURRENT.get();
                    LAST_CURRENT.set(this);
                    try {
                        this.notifyFinished();
                        v2 = null;
                    }
                    catch (Throwable throwable) {
                        v2 = null;
                    }
                    Object var23_36 = v2;
                    CURRENT.set(prevResult);
                    LAST_CURRENT.set(prevLast);
                }
            }
            catch (Throwable throwable) {
                Object v3;
                Object var19_21 = null;
                this.err.log("notifying finished");
                this.object = result;
                prevResult = CURRENT.get();
                CURRENT.set(result);
                prevLast = LAST_CURRENT.get();
                LAST_CURRENT.set(this);
                try {
                    this.notifyFinished();
                    v3 = null;
                }
                catch (Throwable throwable2) {
                    v3 = null;
                }
                Object var23_37 = v3;
                CURRENT.set(prevResult);
                LAST_CURRENT.set(prevLast);
                throw throwable;
            }
        }
    }

    private void updateWaitFor(HoldInstance[] arr) {
        ArrayList<Task> out = new ArrayList<Task>(arr.length);
        int i = 0;
        while (i < arr.length) {
            Task t = arr[i].getTask();
            if (t != null) {
                out.add(t);
            }
            ++i;
        }
        this.waitFor = out.toArray(new Task[out.size()]);
    }

    protected Task postCreationTask(Runnable run) {
        return PROCESSOR.post(run);
    }

    final ErrorManager err() {
        return this.err;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class HoldInstanceOrigin
    extends HoldInstance
    implements InstanceCookie.Origin {
        public HoldInstanceOrigin(DataObject source, InstanceCookie.Origin cookie) {
            super(source, cookie);
        }

        public FileObject instanceOrigin() {
            return ((InstanceCookie.Origin)this.cookie).instanceOrigin();
        }
    }

    private class HoldInstance
    implements InstanceCookie.Of,
    TaskListener {
        private final DataObject source;
        protected final InstanceCookie cookie;
        static /* synthetic */ Class class$org$openide$util$TaskListener;

        public HoldInstance(DataObject source, InstanceCookie cookie) {
            this.cookie = cookie;
            this.source = source;
            if (cookie instanceof Task) {
                Task t = (Task)((Object)cookie);
                t.addTaskListener((TaskListener)WeakListener.create(class$org$openide$util$TaskListener == null ? (class$org$openide$util$TaskListener = HoldInstance.class$("org.openide.util.TaskListener")) : class$org$openide$util$TaskListener, this, t));
            }
        }

        public String instanceName() {
            return this.cookie.instanceName();
        }

        public boolean instanceOf(Class type) {
            if (this.cookie instanceof InstanceCookie.Of) {
                InstanceCookie.Of of = (InstanceCookie.Of)this.cookie;
                return of.instanceOf(type);
            }
            try {
                Class clazz = this.cookie.instanceClass();
                return type.isAssignableFrom(clazz);
            }
            catch (IOException ex) {
                return false;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }

        public Class instanceClass() throws IOException, ClassNotFoundException {
            return this.cookie.instanceClass();
        }

        public Object instanceCreate() throws IOException, ClassNotFoundException {
            return FolderInstance.this.instanceForCookie(this.source, this.cookie);
        }

        public void taskFinished(Task task) {
            FolderInstance.this.checkRecreate();
        }

        public Task getTask() {
            if (this.cookie instanceof Task) {
                return (Task)((Object)this.cookie);
            }
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class Listener
    implements PropertyChangeListener,
    FolderListListener {
        Listener() {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            Object s = ev.getSource();
            if (s == FolderInstance.this.container) {
                if ("children".equals(ev.getPropertyName())) {
                    FolderInstance.this.err.log("PROP_CHILDREN");
                    FolderInstance.this.recreate();
                }
                return;
            }
            if ("name".equals(ev.getPropertyName()) && s instanceof DataObject) {
                FolderInstance.this.err.log("PROP_NAME");
                FolderInstance.this.recreate();
            }
            if ("cookie".equals(ev.getPropertyName()) && s instanceof DataObject) {
                HoldInstance hi;
                DataObject source = (DataObject)s;
                InstanceCookie ic = FolderInstance.this.acceptDataObject(source);
                FileObject fo = source.getPrimaryFile();
                ThreadLocal threadLocal = CURRENT;
                synchronized (threadLocal) {
                    hi = (HoldInstance)FolderInstance.this.map.get(fo);
                }
                if (hi != null && (ic == null || ic != hi && !ic.equals(hi.cookie))) {
                    hi = ic instanceof InstanceCookie.Origin ? new HoldInstanceOrigin(source, (InstanceCookie.Origin)ic) : new HoldInstance(source, ic);
                    ThreadLocal threadLocal2 = CURRENT;
                    synchronized (threadLocal2) {
                        FolderInstance.this.map.put(fo, hi);
                    }
                    FolderInstance.this.recreate();
                }
            }
        }

        public void finished(List arr) {
            FolderInstance.this.processObjects(arr);
        }

        public void process(DataObject obj, List arr) {
            arr.add(obj);
        }
    }
}

