/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.util.NbBundle;

public class FileEntry
extends MultiDataObject.Entry {
    static final long serialVersionUID = 5972727204237511983L;

    public FileEntry(MultiDataObject obj, FileObject fo) {
        super(obj, fo);
    }

    public FileObject copy(FileObject f, String suffix) throws IOException {
        FileObject fo = this.getFile();
        String newName = fo.getName() + suffix;
        return fo.copy(f, newName, fo.getExt());
    }

    public FileObject rename(String name) throws IOException {
        boolean locked = this.isLocked();
        FileLock lock = this.takeLock();
        try {
            this.getFile().rename(lock, name, this.getFile().getExt());
            Object var5_4 = null;
            if (!locked) {
                lock.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!locked) {
                lock.releaseLock();
            }
            throw throwable;
        }
        return this.getFile();
    }

    public FileObject move(FileObject f, String suffix) throws IOException {
        boolean locked = this.isLocked();
        FileObject fo = this.getFile();
        FileLock lock = this.takeLock();
        try {
            FileObject dest;
            String newName = fo.getName() + suffix;
            FileObject fileObject = dest = fo.move(lock, f, newName, fo.getExt());
            Object var10_9 = null;
            if (!locked) {
                lock.releaseLock();
            }
            return fileObject;
        }
        catch (Throwable throwable) {
            block3: {
                Object var10_10 = null;
                if (locked) break block3;
                lock.releaseLock();
            }
            throw throwable;
        }
    }

    public void delete() throws IOException {
        boolean locked = this.isLocked();
        FileLock lock = this.takeLock();
        try {
            this.getFile().delete(lock);
            Object var4_3 = null;
            if (!locked) {
                lock.releaseLock();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!locked) {
                lock.releaseLock();
            }
            throw throwable;
        }
    }

    public FileObject createFromTemplate(FileObject f, String name) throws IOException {
        if (name == null) {
            name = FileUtil.findFreeFileName(f, this.getFile().getName(), this.getFile().getExt());
        }
        FileObject fo = this.getFile().copy(f, name, this.getFile().getExt());
        DataObject.setTemplate(fo, false);
        return fo;
    }

    public static final class Folder
    extends MultiDataObject.Entry {
        public Folder(MultiDataObject obj, FileObject fo) {
            super(obj, fo);
        }

        public FileObject copy(FileObject f, String suffix) throws IOException {
            String add = suffix + (this.getFile().getExt().length() > 0 ? "." + this.getFile().getExt() : "");
            FileObject fo = FileUtil.createFolder(f, this.getFile().getName() + add);
            FileUtil.copyAttributes(this.getFile(), fo);
            return fo;
        }

        public FileObject move(FileObject f, String suffix) throws IOException {
            return this.copy(f, suffix);
        }

        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            if (name == null) {
                name = FileUtil.findFreeFileName(f, this.getFile().getName(), this.getFile().getExt());
            }
            FileObject fo = FileUtil.createFolder(f, name);
            FileUtil.copyAttributes(this.getFile(), fo);
            DataObject.setTemplate(fo, false);
            return fo;
        }

        public FileObject rename(String name) throws IOException {
            boolean locked = this.isLocked();
            FileLock lock = this.takeLock();
            try {
                this.getFile().rename(lock, name, null);
                Object var5_4 = null;
                if (!locked) {
                    lock.releaseLock();
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (!locked) {
                    lock.releaseLock();
                }
                throw throwable;
            }
            return this.getFile();
        }

        public void delete() throws IOException {
            boolean locked = this.isLocked();
            FileLock lock = this.takeLock();
            try {
                this.getFile().delete(lock);
                Object var4_3 = null;
                if (!locked) {
                    lock.releaseLock();
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (!locked) {
                    lock.releaseLock();
                }
                throw throwable;
            }
        }
    }

    public static final class Numb
    extends MultiDataObject.Entry {
        static final long serialVersionUID = -6572157492885890612L;
        static /* synthetic */ Class class$org$openide$loaders$FileEntry;

        public Numb(MultiDataObject obj, FileObject fo) {
            super(obj, fo);
        }

        public boolean isImportant() {
            return false;
        }

        public FileObject copy(FileObject f, String suffix) {
            return null;
        }

        public FileObject rename(String name) throws IOException {
            this.stdBehaving();
            return null;
        }

        public FileObject move(FileObject f, String suffix) throws IOException {
            this.stdBehaving();
            return null;
        }

        public void delete() throws IOException {
            this.stdBehaving();
        }

        private void stdBehaving() throws IOException {
            if (this.getFile() == null) {
                return;
            }
            if (this.isLocked()) {
                throw new IOException(NbBundle.getBundle(class$org$openide$loaders$FileEntry == null ? (class$org$openide$loaders$FileEntry = Numb.class$("org.openide.loaders.FileEntry")) : class$org$openide$loaders$FileEntry).getString("EXC_SharedAccess"));
            }
            FileLock lock = this.takeLock();
            try {
                this.getFile().delete(lock);
                Object var3_2 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (lock != null) {
                    lock.releaseLock();
                }
                throw throwable;
            }
        }

        public FileObject createFromTemplate(FileObject f, String name) {
            return null;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static abstract class Format
    extends FileEntry {
        static final long serialVersionUID = 8896750589709521197L;

        public Format(MultiDataObject obj, FileObject fo) {
            super(obj, fo);
        }

        /*
         * WARNING - void declaration
         */
        public FileObject createFromTemplate(FileObject f, String name) throws IOException {
            String ext = this.getFile().getExt();
            if (name == null) {
                name = FileUtil.findFreeFileName(f, this.getFile().getName(), ext);
            }
            FileObject fo = f.createData(name, ext);
            java.text.Format frm = this.createFormat(f, name, ext);
            BufferedReader r = new BufferedReader(new InputStreamReader(this.getFile().getInputStream()));
            try {
                FileLock lock = fo.lock();
                try {
                    BufferedWriter w = new BufferedWriter(new OutputStreamWriter(fo.getOutputStream(lock)));
                    try {
                        String current;
                        while ((current = r.readLine()) != null) {
                            void var9_9;
                            w.write(frm.format(var9_9));
                            w.newLine();
                        }
                        Object var11_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var11_11 = null;
                        w.close();
                        throw throwable;
                    }
                    w.close();
                    Object var13_13 = null;
                    lock.releaseLock();
                }
                catch (Throwable throwable) {
                    Object var13_14 = null;
                    lock.releaseLock();
                    throw throwable;
                }
                Object var15_16 = null;
            }
            catch (Throwable throwable) {
                Object var15_17 = null;
                r.close();
                throw throwable;
            }
            r.close();
            FileUtil.copyAttributes(this.getFile(), fo);
            DataObject.setTemplate(fo, false);
            return fo;
        }

        protected abstract java.text.Format createFormat(FileObject var1, String var2, String var3);
    }
}

