/*
 * Decompiled with CFR 0.152.
 */
package org.openide.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import org.openide.ErrorManager;
import org.openide.awt.Actions;
import org.openide.awt.JMenuPlus;
import org.openide.explorer.view.MenuView;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataShadow;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAcceptor;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.HelpCtx;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListener;
import org.openide.util.actions.NodeAction;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class NewTemplateAction
extends NodeAction {
    static final long serialVersionUID = 5408651725508985475L;
    private static DataObject selectedTemplate;
    private static DataFolder targetFolder;
    private static int MAX_RECENT_ITEMS;
    private boolean active = false;
    private DataFolder privilegedListFolder;
    private DataFolder recentListFolder;
    private boolean recentChanged = true;
    private List recentList = new ArrayList(0);
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction$Cookie;
    static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;

    static TemplateWizard getWizard(Node n) {
        TemplateWizard t;
        Cookie c;
        Node[] arr;
        if (n == null && (arr = WindowManager.getDefault().getRegistry().getActivatedNodes()).length == 1) {
            n = arr[0];
        }
        Node folder = n;
        targetFolder = null;
        while (targetFolder == null && folder != null) {
            targetFolder = folder == null ? null : (DataFolder)folder.getCookie(class$org$openide$loaders$DataFolder == null ? NewTemplateAction.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder);
            folder = folder.getParentNode();
        }
        Cookie cookie = n == null ? null : (c = (Cookie)n.getCookie(class$org$openide$actions$NewTemplateAction$Cookie == null ? (class$org$openide$actions$NewTemplateAction$Cookie = NewTemplateAction.class$("org.openide.actions.NewTemplateAction$Cookie")) : class$org$openide$actions$NewTemplateAction$Cookie));
        if (c != null && (t = c.getTemplateWizard()) != null) {
            return t;
        }
        return new DefaultTemplateWizard();
    }

    /*
     * Loose catch block
     */
    protected void performAction(Node[] activatedNodes) {
        block19: {
            if (this.active) {
                return;
            }
            this.active = true;
            Node n = activatedNodes.length == 1 ? activatedNodes[0] : null;
            TemplateWizard wizard = NewTemplateAction.getWizard(n);
            if (wizard instanceof DefaultTemplateWizard) {
                if (targetFolder != null && targetFolder.isValid()) {
                    wizard.setTargetFolder(targetFolder);
                }
                if (selectedTemplate != null && selectedTemplate.isValid()) {
                    wizard.setTemplate(selectedTemplate);
                }
            }
            try {
                wizard.setTargetName(null);
                wizard.instantiate();
                Object var7_4 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (wizard instanceof DefaultTemplateWizard) {
                    try {
                        selectedTemplate = wizard.getTemplate();
                        if (selectedTemplate != null) {
                            this.addRecent(selectedTemplate);
                        }
                        targetFolder = wizard.getTargetFolder();
                    }
                    catch (IOException ignore) {
                        selectedTemplate = null;
                        targetFolder = null;
                    }
                }
                this.active = false;
                throw throwable;
            }
            if (wizard instanceof DefaultTemplateWizard) {
                try {
                    selectedTemplate = wizard.getTemplate();
                    if (selectedTemplate != null) {
                        this.addRecent(selectedTemplate);
                    }
                    targetFolder = wizard.getTargetFolder();
                }
                catch (IOException ignore) {
                    selectedTemplate = null;
                    targetFolder = null;
                }
            }
            this.active = false;
            {
                break block19;
                catch (IOException e) {
                    ErrorManager em = ErrorManager.getDefault();
                    em.annotate((Throwable)e, NbBundle.getMessage(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = NewTemplateAction.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction, "EXC_TemplateFailed"));
                    em.notify(e);
                    Object var7_5 = null;
                    if (wizard instanceof DefaultTemplateWizard) {
                        try {
                            selectedTemplate = wizard.getTemplate();
                            if (selectedTemplate != null) {
                                this.addRecent(selectedTemplate);
                            }
                            targetFolder = wizard.getTargetFolder();
                        }
                        catch (IOException ignore) {
                            selectedTemplate = null;
                            targetFolder = null;
                        }
                    }
                    this.active = false;
                }
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        Cookie c = (Cookie)activatedNodes[0].getCookie(class$org$openide$actions$NewTemplateAction$Cookie == null ? (class$org$openide$actions$NewTemplateAction$Cookie = NewTemplateAction.class$("org.openide.actions.NewTemplateAction$Cookie")) : class$org$openide$actions$NewTemplateAction$Cookie);
        if (c != null) {
            return c.getTemplateWizard() != null;
        }
        DataFolder cookie = (DataFolder)activatedNodes[0].getCookie(class$org$openide$loaders$DataFolder == null ? (class$org$openide$loaders$DataFolder = NewTemplateAction.class$("org.openide.loaders.DataFolder")) : class$org$openide$loaders$DataFolder);
        return cookie != null && !cookie.getPrimaryFile().isReadOnly();
    }

    public String getName() {
        return NbBundle.getMessage(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = NewTemplateAction.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction, "NewTemplate");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = NewTemplateAction.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction);
    }

    protected String iconResource() {
        return "org/openide/resources/actions/new.gif";
    }

    public JMenuItem getMenuPresenter() {
        return new Actions.MenuItem(this, true){

            public void setEnabled(boolean e) {
                super.setEnabled(true);
            }
        };
    }

    public Component getToolbarPresenter() {
        return new Actions.ToolbarButton(this){

            public void setEnabled(boolean e) {
                super.setEnabled(true);
            }
        };
    }

    public JMenuItem getPopupPresenter() {
        TemplateWizard tw = NewTemplateAction.getWizard(null);
        if (tw instanceof DefaultTemplateWizard) {
            return new MenuWithRecent();
        }
        MenuView.Menu menu = new MenuView.Menu(null, new TemplateActionListener(), false){

            public JPopupMenu getPopupMenu() {
                if (this.node == null) {
                    this.node = NewTemplateAction.getTemplateRoot();
                }
                return super.getPopupMenu();
            }
        };
        Actions.connect((JMenuItem)menu, this, true);
        return menu;
    }

    private List getPrivilegedList() {
        FileObject fo;
        if (this.privilegedListFolder == null && (fo = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Privileged")) != null) {
            this.privilegedListFolder = DataFolder.findFolder(fo);
        }
        if (this.privilegedListFolder != null) {
            DataObject[] data = this.privilegedListFolder.getChildren();
            ArrayList<DataObject> l2 = new ArrayList<DataObject>(data.length);
            int i = 0;
            while (i < data.length) {
                DataObject dobj = data[i];
                if (dobj instanceof DataShadow) {
                    dobj = ((DataShadow)dobj).getOriginal();
                }
                if (this.isValidTemplate(dobj)) {
                    l2.add(dobj);
                }
                ++i;
            }
            return l2;
        }
        return new ArrayList(0);
    }

    private void doShowWizard(DataObject template) {
        targetFolder = null;
        TemplateWizard wizard = NewTemplateAction.getWizard(null);
        try {
            wizard.setTargetName(null);
            Set created = wizard.instantiate(template, targetFolder);
            if (created != null && wizard instanceof DefaultTemplateWizard && (selectedTemplate = wizard.getTemplate()) != null) {
                this.addRecent(selectedTemplate);
            }
        }
        catch (IOException e) {
            ErrorManager em = ErrorManager.getDefault();
            em.annotate((Throwable)e, NbBundle.getMessage(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = NewTemplateAction.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction, "EXC_TemplateFailed"));
            em.notify(e);
        }
    }

    private DataFolder getRecentFolder() {
        FileObject fo;
        if (this.recentListFolder == null && (fo = Repository.getDefault().getDefaultFileSystem().findResource("Templates/Recent")) != null) {
            this.recentListFolder = DataFolder.findFolder(fo);
        }
        return this.recentListFolder;
    }

    private List getRecentList() {
        if (!this.recentChanged) {
            return this.recentList;
        }
        if (this.getRecentFolder() != null) {
            DataObject[] data = this.getRecentFolder().getChildren();
            ArrayList<DataObject> l2 = new ArrayList<DataObject>(data.length);
            int i = 0;
            while (i < data.length) {
                DataObject dobj = data[i];
                if (dobj instanceof DataShadow) {
                    dobj = ((DataShadow)dobj).getOriginal();
                }
                if (this.isValidTemplate(dobj)) {
                    l2.add(dobj);
                } else {
                    this.removeRecent(data[i]);
                }
                ++i;
            }
            this.recentList = l2;
        } else {
            this.recentList = new ArrayList(0);
        }
        return this.recentList;
    }

    private boolean isValidTemplate(DataObject template) {
        return template != null && template.isTemplate();
    }

    private boolean addRecent(DataObject template) {
        DataFolder folder = this.getRecentFolder();
        if (folder == null) {
            return false;
        }
        if (this.getPrivilegedList().contains(template)) {
            return false;
        }
        if (this.isRecent(template)) {
            return false;
        }
        DataObject[] templates = folder.getChildren();
        DataObject[] newOrder = new DataObject[templates.length + 1];
        int i = 1;
        while (i < newOrder.length) {
            newOrder[i] = templates[i - 1];
            ++i;
        }
        try {
            newOrder[0] = template.createShadow(folder);
            folder.setOrder(newOrder);
        }
        catch (IOException ioe) {
            ErrorManager em = ErrorManager.getDefault();
            em.notify(1, ioe);
            return false;
        }
        templates = folder.getChildren();
        int size = templates.length;
        while (size > MAX_RECENT_ITEMS) {
            this.removeRecent(templates[size - 1]);
            --size;
        }
        this.recentChanged = true;
        return true;
    }

    private boolean removeRecent(DataObject template) {
        DataFolder folder = this.getRecentFolder();
        if (folder == null) {
            return false;
        }
        try {
            template.delete();
            this.recentChanged = true;
            return true;
        }
        catch (IOException ioe) {
            ErrorManager em = ErrorManager.getDefault();
            em.notify(1, ioe);
            return false;
        }
    }

    private boolean isRecent(DataObject template) {
        return this.recentList.contains(template);
    }

    public static Node getTemplateRoot() {
        RootChildren ch = new RootChildren();
        return new DataFolder.FolderNode(ch.getRootFolder(), (Children)ch);
    }

    private static boolean acceptObj(DataObject obj) {
        if (obj.isTemplate()) {
            return true;
        }
        if (obj instanceof DataFolder) {
            Object o = obj.getPrimaryFile().getAttribute("simple");
            return o == null || Boolean.TRUE.equals(o);
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        MAX_RECENT_ITEMS = 5;
    }

    private static class DefaultTemplateWizard
    extends TemplateWizard {
        DefaultTemplateWizard() {
        }
    }

    private static class DataShadowFilterNode
    extends FilterNode {
        private String name;

        public DataShadowFilterNode(Node or, Children children, String name) {
            super(or, children);
            this.name = name;
            this.disableDelegation(4);
        }

        public String getDisplayName() {
            return this.name;
        }
    }

    private static class TemplateChildren
    extends FilterNode.Children {
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public TemplateChildren(Node or) {
            super(or);
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            String nodeName = n.getDisplayName();
            DataObject obj = null;
            DataShadow shadow = (DataShadow)n.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = TemplateChildren.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
            if (shadow != null) {
                DataNode dn = new DataNode(shadow, Children.LEAF);
                nodeName = dn.getDisplayName();
                obj = shadow.getOriginal();
                n = obj.getNodeDelegate();
            }
            if (obj == null) {
                obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            }
            if (obj != null) {
                if (obj.isTemplate()) {
                    return new Node[]{new DataShadowFilterNode(n, Children.LEAF, nodeName)};
                }
                if (NewTemplateAction.acceptObj(obj)) {
                    return new Node[]{new DataShadowFilterNode(n, new TemplateChildren(n), nodeName)};
                }
            }
            return new Node[0];
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class RootChildren
    extends Children.Keys
    implements NodeListener {
        private TemplateWizard wizard;
        private DataFolder rootFolder;
        private WeakReference current;
        private NodeListener listener = WeakListener.node(this, null);
        static /* synthetic */ Class class$org$openide$loaders$DataShadow;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;

        public RootChildren() {
            TopComponent.Registry reg = WindowManager.getDefault().getRegistry();
            reg.addPropertyChangeListener(WeakListener.propertyChange(this, reg));
            this.updateWizard(NewTemplateAction.getWizard(null));
        }

        public DataFolder getRootFolder() {
            if (this.rootFolder == null) {
                this.doSetKeys();
            }
            return this.rootFolder;
        }

        protected Node[] createNodes(Object key) {
            Node n = (Node)key;
            String nodeName = n.getDisplayName();
            DataObject obj = null;
            DataShadow shadow = (DataShadow)n.getCookie(class$org$openide$loaders$DataShadow == null ? (class$org$openide$loaders$DataShadow = RootChildren.class$("org.openide.loaders.DataShadow")) : class$org$openide$loaders$DataShadow);
            if (shadow != null) {
                DataNode dn = new DataNode(shadow, Children.LEAF);
                nodeName = dn.getDisplayName();
                obj = shadow.getOriginal();
                n = obj.getNodeDelegate();
            }
            if (obj == null) {
                obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = RootChildren.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            }
            if (obj != null) {
                if (obj.isTemplate()) {
                    return new Node[]{new DataShadowFilterNode(n, Children.LEAF, nodeName)};
                }
                if (NewTemplateAction.acceptObj(obj)) {
                    return new Node[]{new DataShadowFilterNode(n, new TemplateChildren(n), nodeName)};
                }
            }
            return null;
        }

        private void updateNode(Node n) {
            if (this.current != null && this.current.get() == n) {
                return;
            }
            if (this.current != null && this.current.get() != null) {
                ((Node)this.current.get()).removeNodeListener(this.listener);
            }
            n.addNodeListener(this.listener);
            this.current = new WeakReference<Node>(n);
        }

        private void updateWizard(TemplateWizard w) {
            if (this.wizard == w) {
                return;
            }
            if (this.wizard != null) {
                Node n = this.wizard.getTemplatesFolder().getNodeDelegate();
                n.removeNodeListener(this.listener);
            }
            Node newNode = w.getTemplatesFolder().getNodeDelegate();
            newNode.addNodeListener(this.listener);
            this.wizard = w;
            this.updateKeys();
        }

        private void updateKeys() {
            RequestProcessor.getDefault().post(new Runnable(this){
                private final /* synthetic */ RootChildren this$0;
                {
                    this.this$0 = this$0;
                }

                public void run() {
                    RootChildren.access$600(this.this$0);
                }
            });
        }

        private void doSetKeys() {
            DataFolder df = this.wizard.getTemplatesFolder();
            this.setKeys(df.getNodeDelegate().getChildren().getNodes(true));
            this.rootFolder = df;
        }

        public void childrenReordered(NodeReorderEvent ev) {
            this.updateKeys();
        }

        public void childrenRemoved(NodeMemberEvent ev) {
            this.updateKeys();
        }

        public void childrenAdded(NodeMemberEvent ev) {
            this.updateKeys();
        }

        public void nodeDestroyed(NodeEvent ev) {
        }

        public void propertyChange(PropertyChangeEvent ev) {
            Node[] arr;
            String pn = ev.getPropertyName();
            if (this.current != null && ev.getSource() == this.current.get()) {
                if ("cookie".equals(pn)) {
                    Node node = (Node)this.current.get();
                    Mutex.EVENT.readAccess(new Runnable(this, node){
                        private final /* synthetic */ Node val$node;
                        private final /* synthetic */ RootChildren this$0;
                        {
                            this.this$0 = this$0;
                            this.val$node = val$node;
                        }

                        public void run() {
                            RootChildren.access$700(this.this$0, NewTemplateAction.getWizard(this.val$node));
                        }
                    });
                }
            } else if ("activatedNodes".equals(pn) && (arr = WindowManager.getDefault().getRegistry().getActivatedNodes()).length == 1) {
                this.updateNode(arr[0]);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        static /* synthetic */ void access$600(RootChildren x0) {
            x0.doSetKeys();
        }

        static /* synthetic */ void access$700(RootChildren x0, TemplateWizard x1) {
            x0.updateWizard(x1);
        }
    }

    private static class TemplateActionListener
    implements NodeAcceptor,
    DataFilter {
        static final long serialVersionUID = 1214995994333505784L;
        static /* synthetic */ Class class$org$openide$loaders$DataObject;
        static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;

        TemplateActionListener() {
        }

        public boolean acceptNodes(Node[] nodes) {
            if (nodes == null || nodes.length != 1) {
                return false;
            }
            Node n = nodes[0];
            DataObject obj = (DataObject)n.getCookie(class$org$openide$loaders$DataObject == null ? (class$org$openide$loaders$DataObject = TemplateActionListener.class$("org.openide.loaders.DataObject")) : class$org$openide$loaders$DataObject);
            if (obj == null || !obj.isTemplate()) {
                return false;
            }
            TemplateWizard wizard = NewTemplateAction.getWizard(null);
            try {
                wizard.setTargetName(null);
                wizard.instantiate(obj, targetFolder);
            }
            catch (IOException e) {
                ErrorManager em = ErrorManager.getDefault();
                em.annotate((Throwable)e, NbBundle.getMessage(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = TemplateActionListener.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction, "EXC_TemplateFailed"));
                em.notify(e);
            }
            return true;
        }

        public boolean acceptDataObject(DataObject obj) {
            return NewTemplateAction.acceptObj(obj);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    public static interface Cookie
    extends Node.Cookie {
        public TemplateWizard getTemplateWizard();
    }

    private class MenuWithRecent
    extends JMenuPlus {
        private boolean initialized = false;

        public MenuWithRecent() {
            Actions.setMenuText(this, NewTemplateAction.this.getName(), false);
        }

        public JPopupMenu getPopupMenu() {
            JPopupMenu popup = super.getPopupMenu();
            if (!this.initialized) {
                popup.add(new Item(null, true));
                List privileged = NewTemplateAction.this.getPrivilegedList();
                if (privileged.size() > 0) {
                    popup.add(new JSeparator());
                }
                Iterator it = privileged.iterator();
                while (it.hasNext()) {
                    DataObject dobj = (DataObject)it.next();
                    if (dobj instanceof DataShadow) {
                        dobj = ((DataShadow)dobj).getOriginal();
                    }
                    popup.add(new Item(dobj, true));
                }
                if (NewTemplateAction.this.getRecentList().size() > 0) {
                    popup.add(new JSeparator());
                }
                Iterator it2 = NewTemplateAction.this.getRecentList().iterator();
                while (it2.hasNext()) {
                    popup.add(new Item((DataObject)it2.next(), false));
                }
                this.initialized = true;
            }
            return popup;
        }

        private class Item
        extends JMenuItem
        implements HelpCtx.Provider,
        ActionListener {
            DataObject template;
            boolean fixed;
            static /* synthetic */ Class class$org$openide$actions$NewTemplateAction;

            public Item(DataObject template, boolean fixed) {
                this.template = template;
                this.fixed = fixed;
                this.setText(template == null ? NbBundle.getMessage(class$org$openide$actions$NewTemplateAction == null ? (class$org$openide$actions$NewTemplateAction = Item.class$("org.openide.actions.NewTemplateAction")) : class$org$openide$actions$NewTemplateAction, "NewTemplateAction") : template.getNodeDelegate().getDisplayName());
                if (template == null) {
                    this.setIcon(NewTemplateAction.this.getIcon());
                } else {
                    this.setIcon(new ImageIcon(template.getNodeDelegate().getIcon(1)));
                }
                this.addActionListener(this);
            }

            public HelpCtx getHelpCtx() {
                if (this.template != null) {
                    return this.template.getHelpCtx();
                }
                return NewTemplateAction.this.getHelpCtx();
            }

            public void actionPerformed(ActionEvent e) {
                NewTemplateAction.this.doShowWizard(this.template);
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        }
    }
}

