/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import bsh.ConsoleInterface;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;

public class JConsole
extends JScrollPane
implements ConsoleInterface,
Runnable,
KeyListener,
MouseListener,
ActionListener,
PropertyChangeListener {
    private static final String CUT = "Cut";
    private static final String COPY = "Copy";
    private static final String PASTE = "Paste";
    private OutputStream outPipe;
    private InputStream inPipe;
    private InputStream in;
    private PrintStream out;
    private int cmdStart = 0;
    private Vector history = new Vector();
    private String startedLine;
    private int histLine = 0;
    private JPopupMenu menu;
    private JTextArea text;

    public JConsole() {
        this(12, 80, null, null);
    }

    public JConsole(int n, int n2, InputStream inputStream, OutputStream outputStream) {
        Font font = new Font("Monospaced", 0, 14);
        this.text = new JTextArea(n, n2);
        this.text.setText("");
        this.text.setFont(font);
        this.text.setEditable(true);
        this.text.setLineWrap(true);
        this.text.setWrapStyleWord(true);
        this.text.setMargin(new Insets(7, 5, 7, 5));
        this.text.addKeyListener(this);
        this.setViewportView(this.text);
        this.menu = new JPopupMenu("JConsole Menu");
        this.menu.add(new JMenuItem(CUT)).addActionListener(this);
        this.menu.add(new JMenuItem(COPY)).addActionListener(this);
        this.menu.add(new JMenuItem(PASTE)).addActionListener(this);
        this.text.addMouseListener(this);
        UIManager.addPropertyChangeListener(this);
        this.outPipe = outputStream;
        if (this.outPipe == null) {
            this.outPipe = new PipedOutputStream();
            try {
                this.in = new PipedInputStream((PipedOutputStream)this.outPipe);
            }
            catch (IOException iOException) {
                this.print("Console internal error...");
            }
        }
        this.inPipe = inputStream;
        new Thread(this).start();
        this.requestFocus();
    }

    public JConsole(InputStream inputStream, OutputStream outputStream) {
        this(12, 80, inputStream, outputStream);
    }

    private void acceptLine(String string) {
        if (this.outPipe == null) {
            this.print("Console internal error...");
        } else {
            try {
                this.outPipe.write(string.getBytes());
                this.outPipe.flush();
            }
            catch (IOException iOException) {
                this.outPipe = null;
                throw new RuntimeException("Console pipe broken...");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(CUT)) {
            this.text.cut();
        } else if (string.equals(COPY)) {
            this.text.copy();
        } else if (string.equals(PASTE)) {
            this.text.paste();
        }
    }

    private void enter() {
        String string = this.getCmd();
        if (string.length() == 0) {
            string = ";\n";
        } else {
            this.history.addElement(string);
            string = String.valueOf(string) + "\n";
        }
        this.text.append("\n");
        this.histLine = 0;
        this.acceptLine(string);
    }

    private void forceCaretMoveToEnd() {
        if (this.text.getCaretPosition() < this.cmdStart) {
            this.text.setCaretPosition(this.text.getText().length());
        }
    }

    private void forceCaretMoveToStart() {
        this.text.getCaretPosition();
    }

    private String getCmd() {
        String string = "";
        try {
            string = this.text.getText(this.cmdStart, this.text.getText().length() - this.cmdStart);
        }
        catch (BadLocationException badLocationException) {
            System.out.println("Internal JConsole Error: " + badLocationException);
        }
        return string;
    }

    public PrintStream getErrStream() {
        return this.out;
    }

    public InputStream getInStream() {
        return this.in;
    }

    public PrintStream getOutStream() {
        return this.out;
    }

    private void historyDown() {
        if (this.histLine == 0) {
            return;
        }
        --this.histLine;
        this.showHistoryLine();
    }

    private void historyUp() {
        if (this.history.size() == 0) {
            return;
        }
        if (this.histLine == 0) {
            this.startedLine = this.getCmd();
        }
        if (this.histLine < this.history.size()) {
            ++this.histLine;
            this.showHistoryLine();
        }
    }

    private void inPipeWatcher() throws IOException {
        int n;
        Object object;
        if (this.inPipe == null) {
            object = new PipedOutputStream();
            this.out = new PrintStream((OutputStream)object);
            this.inPipe = new PipedInputStream((PipedOutputStream)object);
        }
        object = new byte[256];
        while ((n = this.inPipe.read((byte[])object)) != -1) {
            this.print(new String((byte[])object, 0, n));
        }
        this.println("Console: Input closed...");
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.type(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.type(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.type(keyEvent);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.menu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public synchronized void print(String string) {
        this.text.append(string);
        this.cmdStart = this.text.getText().length();
        this.text.setCaretPosition(this.cmdStart);
    }

    public void println(String string) {
        this.print(String.valueOf(string) + "\n");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("lookAndFeel")) {
            SwingUtilities.updateComponentTreeUI(this.menu);
        }
    }

    public void run() {
        try {
            this.inPipeWatcher();
        }
        catch (IOException iOException) {
            this.println("Console: I/O Error...");
        }
    }

    private void showHistoryLine() {
        String string = this.histLine == 0 ? this.startedLine : (String)this.history.elementAt(this.history.size() - this.histLine);
        this.text.replaceRange(string, this.cmdStart, this.text.getText().length());
        this.text.setCaretPosition(this.text.getText().length());
    }

    public String toString() {
        return "BeanShell console";
    }

    private void type(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 10: {
                if (keyEvent.getID() != 401) break;
                this.enter();
                this.cmdStart = this.text.getText().length();
                this.text.setCaretPosition(this.cmdStart);
                keyEvent.consume();
                break;
            }
            case 38: {
                if (keyEvent.getID() == 401) {
                    this.historyUp();
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                if (keyEvent.getID() == 401) {
                    this.historyDown();
                }
                keyEvent.consume();
                break;
            }
            case 8: 
            case 37: 
            case 127: {
                if (this.text.getCaretPosition() > this.cmdStart) break;
                keyEvent.consume();
                break;
            }
            case 39: {
                this.forceCaretMoveToStart();
                break;
            }
            case 36: {
                this.text.setCaretPosition(this.cmdStart);
                keyEvent.consume();
                break;
            }
            case 85: {
                if ((keyEvent.getModifiers() & 2) <= 0) break;
                this.text.replaceRange("", this.cmdStart, this.text.getText().length());
                this.histLine = 0;
                keyEvent.consume();
                break;
            }
            case 67: {
                if (this.text.getSelectedText() != null) break;
                if ((keyEvent.getModifiers() & 2) > 0 && keyEvent.getID() == 401) {
                    this.text.append("^C");
                }
                keyEvent.consume();
                break;
            }
            default: {
                if ((keyEvent.getModifiers() & 0xE) != 0) break;
                this.forceCaretMoveToEnd();
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 27: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 145: 
            case 154: 
            case 155: 
            case 157: 
        }
    }

    class JTextArea
    extends javax.swing.JTextArea {
        public JTextArea(int n, int n2) {
            super(n, n2);
        }

        public void cut() {
            if (JConsole.this.text.getCaretPosition() < JConsole.this.cmdStart) {
                super.copy();
            } else {
                super.cut();
            }
        }

        public void paste() {
            JConsole.this.forceCaretMoveToEnd();
            super.paste();
        }
    }
}

