/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.SwingUtilities;

public final class JFCUtilities {
    private JFCUtilities() {
    }

    public static void center(Window win) {
        JFCUtilities.center(win, null);
    }

    public static void center(Window win, Component comp) {
        Window parentWin = null;
        if (comp != null) {
            parentWin = SwingUtilities.windowForComponent(comp);
        }
        Dimension winSize = win.getSize();
        Dimension parentSize = Toolkit.getDefaultToolkit().getScreenSize();
        int startX = 0;
        int startY = 0;
        if (parentWin != null) {
            startX = parentWin.getLocation().x;
            startY = parentWin.getLocation().y;
            parentSize = parentWin.getSize();
        }
        win.setLocation(Math.max(0, startX + (parentSize.width - winSize.width) / 2), Math.max(0, startY + (parentSize.height - winSize.height) / 2));
    }

    public static Component findComponentInHierarchy(Component comp, Class clazz) {
        Container parent;
        if (comp == null) {
            return null;
        }
        for (parent = comp.getParent(); parent != null && !clazz.isInstance(parent); parent = parent.getParent()) {
        }
        if (clazz.isInstance(parent)) {
            return parent;
        }
        return null;
    }
}

