/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractKeyEventData;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;
import org.w3c.dom.Element;

public class StringEventData
extends AbstractKeyEventData {
    private Component m_comp = null;
    private String m_string = "";

    public StringEventData() {
        this.setValid(false);
    }

    public StringEventData(JFCTestCase testCase, Component comp, String string) {
        this(testCase, comp, string, 0, 300L);
    }

    public StringEventData(JFCTestCase testCase, Component comp, String string, long sleepTime) {
        this(testCase, comp, string, 0, sleepTime);
    }

    public StringEventData(JFCTestCase testCase, Component comp, String string, int modifiers, long sleepTime) {
        this.setTestCase(testCase);
        this.setSource(comp);
        this.setString(string);
        this.setModifiers(modifiers);
        this.setSleepTime(sleepTime);
        this.setValid(true);
    }

    public final void setSource(Component comp) {
        this.m_comp = comp;
    }

    public final Component getSource() {
        return this.m_comp;
    }

    public final void setString(String string) {
        this.m_string = string;
        this.setupKeyStrokes();
    }

    public Component getComponent() {
        return this.getSource();
    }

    public String getString() {
        return this.m_string;
    }

    public boolean canConsume(AWTEvent ae) {
        if (!(ae instanceof KeyEvent)) {
            return false;
        }
        JFCKeyStroke[] stroke = StringEventData.getKeyMapping().getKeyStrokes(((KeyEvent)ae).getKeyChar());
        char c = ((KeyEvent)ae).getKeyChar();
        if (Character.isISOControl(c)) {
            return false;
        }
        if (this.isValid()) {
            int mods = ((KeyEvent)ae).getModifiers();
            if (this.getModifiers() != mods) {
                return false;
            }
        }
        return stroke != null && stroke.length > 0 && super.canConsume(ae) && (this.isMetaChar(((KeyEvent)ae).getKeyCode()) || ((KeyEvent)ae).getKeyChar() != '\uffff');
    }

    public boolean consume(AWTEvent ae) {
        if (super.consume(ae)) {
            return true;
        }
        this.setSource((Component)ae.getSource());
        StringBuffer buf = new StringBuffer();
        if (this.isValid()) {
            buf.append(this.getString());
        }
        buf.append(((KeyEvent)ae).getKeyChar());
        this.setSleepTime(this.getDefaultSleepTime());
        int mods = ((KeyEvent)ae).getModifiers();
        super.setModifiers(mods);
        this.setString(buf.toString());
        this.setValid(true);
        return true;
    }

    public void populate(Element e) {
        super.populate(e);
        e.setAttribute("string", this.m_string);
    }

    public String toString() {
        return "StringEventData:" + this.getString() + " on " + this.getComponent() + " " + this.getModifiers() + " " + this.getSleepTime();
    }

    protected void setupKeyStrokes() {
        KeyMapping km = TestHelper.getKeyMapping();
        this.clearKeyStrokes();
        for (int i = 0; i < this.m_string.length(); ++i) {
            JFCKeyStroke[] strokes = km.getKeyStrokes(this.m_string.charAt(i));
            this.addKeyStrokes(strokes);
        }
        this.applyModifier(this.getModifiers());
    }
}

