/*
 * Decompiled with CFR 0.152.
 */
package org.openorb.policy;

import org.omg.BiDirPolicy.BidirectionalPolicy;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.CORBA.PolicyError;
import org.omg.CORBA.TCKind;
import org.omg.PortableInterceptor.PolicyFactory;
import org.openorb.policy.ForceMarshalPolicy;
import org.openorb.policy.PolicyFactoryManager;

public class OpenORBPolicyFactoryImpl
extends LocalObject
implements PolicyFactory {
    private ORB m_orb;
    private Policy m_bidir_normal_policy;
    private Policy m_bidir_both_policy;
    private Policy m_local_disallow_policy;
    private Policy m_local_allow_policy;

    public OpenORBPolicyFactoryImpl(ORB orb, PolicyFactoryManager policymanagerimpl, boolean enable_server, boolean enable_client) {
        this.m_orb = orb;
        if (enable_server) {
            policymanagerimpl.add_policy_factory(37, this);
            policymanagerimpl.add_policy_factory(1146057218, this);
        }
    }

    public Policy create_policy(int type, Any value) throws PolicyError {
        switch (type) {
            case 37: {
                return this.create_bidir(value);
            }
            case 1146057218: {
                return this.create_local_invoke(value);
            }
        }
        throw new PolicyError(0);
    }

    private Policy create_local_invoke(Any value) throws PolicyError {
        boolean disallow = true;
        switch (value.type().kind().value()) {
            case 8: {
                disallow = value.extract_boolean();
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new PolicyError(2);
            }
        }
        if (disallow) {
            if (this.m_local_disallow_policy == null) {
                this.m_local_disallow_policy = new ForceMarshalPolicyImpl(disallow);
            }
            return this.m_local_disallow_policy;
        }
        if (this.m_local_allow_policy == null) {
            this.m_local_allow_policy = new ForceMarshalPolicyImpl(disallow);
        }
        return this.m_local_allow_policy;
    }

    private Policy create_bidir(Any value) throws PolicyError {
        if (value.type().kind() != TCKind.tk_ushort) {
            throw new PolicyError(2);
        }
        short val = value.extract_ushort();
        switch (val) {
            case 0: {
                if (this.m_bidir_normal_policy == null) {
                    this.m_bidir_normal_policy = new BiDirPolicyImpl(val);
                }
                return this.m_bidir_normal_policy;
            }
            case 1: {
                if (this.m_bidir_both_policy == null) {
                    this.m_bidir_both_policy = new BiDirPolicyImpl(val);
                }
                return this.m_bidir_both_policy;
            }
        }
        throw new PolicyError(3);
    }

    private static class BiDirPolicyImpl
    extends LocalObject
    implements BidirectionalPolicy {
        private short m_value;

        BiDirPolicyImpl(short value) {
            this.m_value = value;
        }

        public int policy_type() {
            return 37;
        }

        public Policy copy() {
            return this;
        }

        public void destroy() {
        }

        public short value() {
            return this.m_value;
        }
    }

    private static class ForceMarshalPolicyImpl
    extends LocalObject
    implements ForceMarshalPolicy {
        private boolean m_value;

        ForceMarshalPolicyImpl(boolean value) {
            this.m_value = value;
        }

        public int policy_type() {
            return 1146057218;
        }

        public Policy copy() {
            return this;
        }

        public void destroy() {
        }

        public boolean forceMarshal() {
            return this.m_value;
        }
    }
}

