/*
 * Decompiled with CFR 0.152.
 */
package com.codestreet.selector.rv;

import com.codestreet.selector.parser.IValueProvider;
import com.codestreet.selector.parser.Identifier;
import com.codestreet.selector.parser.NumericValue;
import com.tibco.tibrv.TibrvException;
import com.tibco.tibrv.TibrvMsg;
import com.tibco.tibrv.TibrvMsgField;
import java.util.StringTokenizer;

public class ValueProvider
implements IValueProvider {
    private final TibrvMsg msg_;

    public static ValueProvider valueOf(TibrvMsg msg) {
        return new ValueProvider(msg);
    }

    private ValueProvider(TibrvMsg msg) {
        this.msg_ = msg;
    }

    public Object getValue(Object identifier, Object correlation) {
        try {
            return ValueProvider.getValueFromDot(this.msg_, (Identifier)identifier);
        }
        catch (TibrvException ex) {
            throw new IllegalArgumentException(ex.toString());
        }
    }

    private static Object getValueFromDot(TibrvMsg msg, Identifier identifier) throws TibrvException {
        TibrvMsg workMsg = msg;
        TibrvMsgField fld = null;
        String id = identifier.getIdentifier();
        int ind = id.indexOf(46);
        if (ind == 0) {
            id = id.substring(1);
            ind = id.indexOf(46);
        }
        if (ind < 0) {
            fld = workMsg.getField(id);
        } else {
            StringTokenizer strTok = new StringTokenizer(id, ".", false);
            while (strTok.hasMoreTokens()) {
                if (fld != null) {
                    workMsg = (TibrvMsg)fld.data;
                }
                String fldName = strTok.nextToken();
                fld = workMsg.getField(fldName);
            }
        }
        if (fld != null) {
            if (fld.data instanceof Integer) {
                return new NumericValue((Integer)fld.data);
            }
            if (fld.data instanceof Float) {
                return new NumericValue((Float)fld.data);
            }
            if (fld.data instanceof Double) {
                return new NumericValue((Double)fld.data);
            }
            if (fld.data instanceof Long) {
                return new NumericValue((Long)fld.data);
            }
            if (fld.data instanceof Short) {
                return new NumericValue((Short)fld.data);
            }
            if (fld.data instanceof Byte) {
                return new NumericValue((Byte)fld.data);
            }
            return fld.data;
        }
        return null;
    }
}

