'\"
'\" Generated from file 'ntextWordBreak\&.man' by tcllib/doctools with format 'nroff'
'\"
'\" The definitions below are for supplemental macros used in Tcl/Tk
'\" manual entries.
'\"
'\" .AP type name in/out ?indent?
'\"	Start paragraph describing an argument to a library procedure.
'\"	type is type of argument (int, etc.), in/out is either "in", "out",
'\"	or "in/out" to describe whether procedure reads or modifies arg,
'\"	and indent is equivalent to second arg of .IP (shouldn't ever be
'\"	needed;  use .AS below instead)
'\"
'\" .AS ?type? ?name?
'\"	Give maximum sizes of arguments for setting tab stops.  Type and
'\"	name are examples of largest possible arguments that will be passed
'\"	to .AP later.  If args are omitted, default tab stops are used.
'\"
'\" .BS
'\"	Start box enclosure.  From here until next .BE, everything will be
'\"	enclosed in one large box.
'\"
'\" .BE
'\"	End of box enclosure.
'\"
'\" .CS
'\"	Begin code excerpt.
'\"
'\" .CE
'\"	End code excerpt.
'\"
'\" .VS ?version? ?br?
'\"	Begin vertical sidebar, for use in marking newly-changed parts
'\"	of man pages.  The first argument is ignored and used for recording
'\"	the version when the .VS was added, so that the sidebars can be
'\"	found and removed when they reach a certain age.  If another argument
'\"	is present, then a line break is forced before starting the sidebar.
'\"
'\" .VE
'\"	End of vertical sidebar.
'\"
'\" .DS
'\"	Begin an indented unfilled display.
'\"
'\" .DE
'\"	End of indented unfilled display.
'\"
'\" .SO
'\"	Start of list of standard options for a Tk widget.  The
'\"	options follow on successive lines, in four columns separated
'\"	by tabs.
'\"
'\" .SE
'\"	End of list of standard options for a Tk widget.
'\"
'\" .OP cmdName dbName dbClass
'\"	Start of description of a specific option.  cmdName gives the
'\"	option's name as specified in the class command, dbName gives
'\"	the option's name in the option database, and dbClass gives
'\"	the option's class in the option database.
'\"
'\" .UL arg1 arg2
'\"	Print arg1 underlined, then print arg2 normally.
'\"
'\" RCS: @(#) $Id: man.macros,v 1.1 2009/01/30 04:56:47 andreas_kupries Exp $
'\"
'\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
'\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1	\\fI\\$2\\fP	(\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
'\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
'\"	# BS - start boxed text
'\"	# ^y = starting y location
'\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
'\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
'\"	# VS - start vertical sidebar
'\"	# ^Y = starting y location
'\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
'\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
'\"	# Special macro to handle page bottom:  finish off current
'\"	# box/sidebar if in box/sidebar mode, then invoked standard
'\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
'\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
'\"	# DE - end display
.de DE
.fi
.RE
.sp
..
'\"	# SO - start of list of standard options
.de SO
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
.ft B
..
'\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\fBoptions\\fR manual entry for details on the standard options.
..
'\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
'\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
'\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.de UL
\\$1\l'|0\(ul'\\$2
..
.TH "ntextWordBreak" n 0\&.81 tklib "ntext Word Boundary Detection for the Text Widget"
.BS
.SH NAME
ntextWordBreak \- ntext Word Boundary Detection for the Text Widget
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBTk  8\&.5\fR
.sp
package require \fBntext  ?0\&.81?\fR
.sp
.BE
.SH DESCRIPTION
The \fBntext\fR package provides a binding tag named \fINtext\fR for use by text widgets in place of the default \fIText\fR binding tag\&.
.PP
Navigation and selection in a text widget require the detection of words and their boundaries\&.  The word boundary detection facilities provided by Tcl/Tk through the \fIText\fR binding tag are limited because they define only one class of "word" characters and one class of "non-word" characters\&.  The \fINtext\fR binding tag uses more general rules for word boundary detection, that define \fItwo\fR classes of "word" characters and one class of "non-word" characters\&.
.PP
.SH "CONFIGURATION OPTIONS"
The behaviour of \fINtext\fR may be configured application-wide by setting the values of a number of namespace variables\&.  One of these is relevant to word boundary detection:
.PP
\fB::ntext::classicWordBreak\fR
.IP \(bu
\fB0\fR - (default value) selects \fINtext\fR behaviour, i\&.e\&. platform-independent, two classes of word characters and one class of non-word characters\&.
.IP \(bu
\fB1\fR - selects classic \fIText\fR behaviour, i\&.e\&. platform-dependent, one class of word characters and one class of non-word characters
.IP \(bu
After changing this value, \fINtext\fR 's regexp matching patterns should be recalculated\&.  See \fBFUNCTIONS\fR for details and advanced configuration options\&.
.PP
.PP
.SH "ADVANCED USE"
.SH "VARIABLES (ADVANCED USE)"
\fB::ntext::tcl_match_wordBreakAfter\fR
.PP
\fB::ntext::tcl_match_wordBreakBefore\fR
.PP
\fB::ntext::tcl_match_endOfWord\fR
.PP
\fB::ntext::tcl_match_startOfNextWord\fR
.PP
\fB::ntext::tcl_match_startOfPreviousWord\fR
.PP
These variables hold the regexp patterns that are used by \fINtext\fR to search for word boundaries\&.  If they are changed, subsequent searches are immediately altered\&.  In many situations, it it unnecessary to alter the values of these variables directly: instead call one of the functions \fB::ntext::initializeMatchPatterns\fR, \fB::ntext::createMatchPatterns\fR\&.
.PP
In the \fIText\fR binding tag one can change the search rules by changing the values of the global variables \fBtcl_wordchars\fR and \fBtcl_nonwordchars\fR\&.  The equivalent operation in the \fINtext\fR binding tag is to call \fB::ntext::createMatchPatterns\fR with appropriate arguments\&.
.SH "FUNCTIONS (ADVANCED USE)"
If a simple regexp search should prove insufficient, the following functions (analogous to the Tcl/Tk core's \fBtcl_wordBreakAfter\fR etc) may be replaced by the developer:
.PP
\fBntext::new_wordBreakAfter\fR
.PP
\fBntext::new_wordBreakBefore\fR
.PP
\fBntext::new_endOfWord\fR
.PP
\fBntext::new_startOfNextWord\fR
.PP
\fBntext::new_startOfPreviousWord\fR
.PP
.SH FUNCTIONS
Each function calculates the five regexp search patterns that define the word boundary searches\&.  These values are stored in the namespace variables listed above\&.
.PP
\fB::ntext::initializeMatchPatterns\fR
.IP \(bu
This function is called when \fINtext\fR is first used, and needs to be called again only if the script changes the value of either \fB::ntext::classicWordBreak\fR or \fB::tcl_platform(platform)\fR\&.  The function is called with no arguments\&.  It is useful when the desired search patterns are the default patterns for either the \fINtext\fR or \fIText\fR binding tag, and so are implicitly specified by the values of \fB::ntext::classicWordBreak\fR and \fB::tcl_platform(platform)\fR alone\&.
.PP
\fB::ntext::createMatchPatterns\fR \fInew_nonwordchars\fR \fInew_word1chars\fR ?new_word2chars?
.IP \(bu
This function is useful in a wider range of situations than \fB::ntext::initializeMatchPatterns\fR\&.  It calculates the regexp search patterns for any case with one class of "non-word" characters and one or two classes of "word" characters\&.
.sp
Each argument should be a regexp expression defining a class of characters\&.  An argument will usually be a bracket expression, but might alternatively be a class-shorthand escape, or a single character\&.  The third argument may be omitted, or supplied as the empty string, in which case it is unused\&.
.sp
The first argument is interpreted as the class of non-word characters; the second argument (and the third, if present) are classes of word characters\&.  The classes should include all possible characters and will normally be mutually exclusive: it is often convenient to define one class as the negation of the other two\&.
.PP
.SH "WORD BOUNDARY MATCHING"
The problem of word boundary selection is a vexed one, because text is used to represent a universe of different types of information, and there are no simple rules that are useful for all data types or for all purposes\&.
.PP
\fINtext\fR attempts to improve on the facilities available in classic \fIText\fR by providing facilities for more complex definitions of words (with three classes of characters instead of two)\&.
.PP
\fIWhat is a word?  Why two classes of word?\fR
.PP
When using the modified cursor keys <Control-Left> and <Control-Right> to navigate through a \fINtext\fR widget, the cursor is placed at the start of a word\&.  A word is defined as a sequence of one or more characters from only one of the two defined "word" classes; it may be preceded by a character from the other "word" class or from the "non-word" class\&.
.PP
The double-click of mouse button 1 selects a word of text, where in this case a "word" may be as defined above, or alternatively may be a sequence of one or more characters from the "non-word" class of characters\&.
.PP
Traditionally Tcl has defined only one word class and one non-word class: on Windows, the non-word class is whitespace, and so alphanumerics and punctuation belong to the same class\&.  On other platforms, punctuation is bundled with whitespace as "non-word" characters\&.  In either case, the navigation and selection of text are unnecessarily coarse-grained, and sometimes give unhelpful results\&.
.PP
The use of three classes of characters might make selection too fine-grained; but in this case, holding down the \fIShift\fR key and double-clicking another word is an excellent way to select a longer range of text (a useful binding that Tcl/Tk has long provided but which is missing in other systems)\&.
.PP
As well as its defaults, \fINtext\fR permits the developer to define their own classes of characters, or to revert to the classic \fIText\fR definitions, or to specify their own regexp matching patterns\&.
.SH EXAMPLE
To use \fINtext\fR with Tcl/Tk's usual word-boundary detection rules:
.CS


package require ntext
text \&.t
bindtags \&.t {\&.t Ntext \&. all}
set ::ntext::classicWordBreak 1
::ntext::initializeMatchPatterns

.CE
See bindtags for more information\&.
.PP
To define a different set of word-boundary detection rules:
.CS


package require ntext
text \&.t
bindtags \&.t {\&.t Ntext \&. all}
::ntext::createMatchPatterns  {[[:space:][:cntrl:]]} {[[:punct:]]} {[^[:punct:][:space:][:cntrl:]]}

.CE
See regexp, re_syntax for more information\&.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIntext\fR of the
\fITklib Trackers\fR [http://core\&.tcl\&.tk/tklib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH "SEE ALSO"
bindtags, ntext, re_syntax, regexp, text
.SH KEYWORDS
bindtags, re_syntax, regexp, text