/*
**      mod_w3msql.c       -  Anything specific to w3-msql
**
**
** Copyright (c) 1995-96  Hughes Technologies Pty Ltd
**
** Permission to use, copy, and distribute for non-commercial purposes,
** is hereby granted without fee, providing that the above copyright
** notice appear in all copies and that both the copyright notice and this
** permission notice appear in supporting documentation.
**
** The software may be modified for your own purposes, but modified versions
** may not be distributed.
**
** This software is provided "as is" without any expressed or implied warranty.
**
*/


#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <fcntl.h>

#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <sys/socket.h>

#include <common/portability.h>
#include "lite.h"
#include "regexp/regexp.h"

#include <time.h>

extern  sym_t   *externReturn;

char *HTEscape();

void doFatal(params)
	plist_t	*params;
{
        checkContentType();
        printf("</h1></h2></h3></h4></h5></h6>\n");
        printf("</select></ul></dl></ol></table>\n");
        printf(params->sym->val);
        printf("<P>Error at line %d",simGetLineNum());
        exit(1);

}


void doUrlEncode(params)
        plist_t *params;
{
        char    *str,
                *new,
                *cp;

        str = params->sym->val;
        new = (char *)HTEscape(str);
        cp = new;
        while(*cp)
        {
                if (*cp == ' ')
                        *cp = '+';
                cp++;
        }
        externReturn = createCharSymbol(new);
        free(new);
}


void doHttpAuth(params)
	plist_t	*params;
{
	char	uname[64],
		passwd[64],
		*htmlFile,
		*area;
	sym_t	*array,
		*sym;

        area = params->sym->val;
        htmlFile = params->next->sym->val;
	httpAuth(uname, passwd, area, htmlFile);

	array = createArray();
	sym = createCharSymbol(uname);
	symSetArrayElement(array,0,sym);
	sym = createCharSymbol(passwd);
	symSetArrayElement(array,1,sym);
	externReturn = array;
}




void doForceHttpAuth(params)
	plist_t	*params;
{
	char	*area;

        area = params->sym->val;
	sendAuthHeader(area,"Authentication failed");
	exit(1);
}


void doAddHttpHeader(params)
	plist_t	*params;
{
	char 	*header;
	extern	char customHdrBuf[];
	extern	int  customHdrMax,
		     customHdrLen;

	header = params->sym->val;

	if (customHdrLen >= customHdrMax ||
		customHdrLen + strlen(header) >= customHdrMax)
	{
                externReturn = createIntSymbol(-1);
                setError("Total header size too large");
		return;
	}
	strcat(customHdrBuf, header);
	strcat(customHdrBuf,"\n");
	customHdrLen += strlen(header)+1;
	externReturn = createIntSymbol(0);
}


void doSetHttpResponse(params)
	plist_t *params;
{
	char	*resp;
	extern	char customRespBuf[];
	extern	int  customRespLen;

	resp = params->sym->val;

	strncpy(customRespBuf, resp, customRespLen);
}
