# -*- python -*-
#                           Package   : omniidl
# __init__.py               Created on: 1999/11/11
#			    Author    : David Scott (djs)
#
#    Copyright (C) 2011 Apasphere Ltd
#    Copyright (C) 1999 AT&T Laboratories Cambridge
#
#  This file is part of omniidl.
#
#  omniidl is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#  General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
#  02111-1307, USA.
#
# Description:
#
#   Entrypoint to skeleton generation code

from omniidl_be.cxx import config, output, id
import omniidl_be.cxx.skel.main
import omniidl_be.cxx.skel.poa

from omniidl_be.cxx.skel import template


def monolithic(stream, tree):
    """Creates one large skeleton with all code inside"""

    if config.state['AMI']:
        ami_inc = "#include <omniORB4/ami.h>"
    else:
        ami_inc = ""

    stream.out(template.boilerplate,
               program  = config.state['Program Name'],
               library  = config.state['Library Version'],
               basename = config.state['Basename'],
               hh       = config.state['HH Suffix'],
               prefix   = config.state['Private Prefix'],
               ami_inc  = ami_inc)

    skel = omniidl_be.cxx.skel.main.init(stream)
    tree.accept(skel)

    poa_skel = omniidl_be.cxx.skel.poa.init(stream)
    tree.accept(poa_skel)


def fragment(stream, tree):
    """Used in fragment mode"""

    stream.out("""\
// This file is generated by @program@- @library@. Do not edit.

#include <omniORB4/objTracker.h>
""",
               program = config.state['Program Name'],
               library = config.state['Library Version'])

    skel = omniidl_be.cxx.skel.main.init(stream)
    tree.accept(skel)

    poa_skel = omniidl_be.cxx.skel.poa.init(stream)
    tree.accept(poa_skel)


def run(tree):
    # create somewhere to put the output
    skel_filename = config.state['Basename'] +\
                    config.state['SK Suffix']
    stream = output.Stream(output.createFile(skel_filename), 2)


    if config.state['Fragment']:
        fragment(stream, tree)
    else:
        # generate one big chunk of code
        monolithic(stream, tree)

    stream.close()
