/*
 *        JacORB  - a free Java ORB
 *
 *   Copyright (C) 1997-2014 Gerald Brose / The JacORB Team.
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Library General Public
 *   License as published by the Free Software Foundation; either
 *   version 2 of the License, or (at your option) any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

package org.jacorb.orb;

import org.jacorb.config.Configuration;

/**
 * @author Alphonse Bendt
 */
public interface BufferManagerFactory
{
    String PARAM_NAME = "jacorb.buffermanager.factory";

    /**
     * invoked during construction of the singleton ORB
     * @param config the current configuration (ORB is not set, no custom properties available)
     * @return the BufferManager that should be used for the singleton ORB.
     */
    IBufferManager newSingletonBufferManager(Configuration config);

    /**
     * invoked during construction of an ORB
     * @param config the current configuration for the new ORB
     * @param parent the singleton ORB's BufferManager
     * @return the BufferManager that should be used for the new ORB.
     */
    IBufferManager newBufferManager(IBufferManager parent, Configuration config);
}
