/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.SegmentReader;

final class DirectoryOwningReader
extends FilterIndexReader
implements Cloneable {
    private final SegmentReader.Ref ref;
    static final /* synthetic */ boolean $assertionsDisabled;

    DirectoryOwningReader(IndexReader in) {
        super(in);
        this.ref = new SegmentReader.Ref();
        if (!$assertionsDisabled && this.ref.refCount() != 1) {
            throw new AssertionError();
        }
    }

    private DirectoryOwningReader(IndexReader in, SegmentReader.Ref ref) {
        super(in);
        this.ref = ref;
        ref.incRef();
    }

    public IndexReader reopen() throws CorruptIndexException, IOException {
        this.ensureOpen();
        IndexReader r = this.in.reopen();
        if (r != this.in) {
            return new DirectoryOwningReader(r, this.ref);
        }
        return this;
    }

    public IndexReader reopen(boolean openReadOnly) throws CorruptIndexException, IOException {
        this.ensureOpen();
        IndexReader r = this.in.reopen(openReadOnly);
        if (r != this.in) {
            return new DirectoryOwningReader(r, this.ref);
        }
        return this;
    }

    public IndexReader reopen(IndexCommit commit) throws CorruptIndexException, IOException {
        this.ensureOpen();
        IndexReader r = this.in.reopen(commit);
        if (r != this.in) {
            return new DirectoryOwningReader(r, this.ref);
        }
        return this;
    }

    public Object clone() {
        this.ensureOpen();
        return new DirectoryOwningReader((IndexReader)this.in.clone(), this.ref);
    }

    public IndexReader clone(boolean openReadOnly) throws CorruptIndexException, IOException {
        this.ensureOpen();
        return new DirectoryOwningReader(this.in.clone(openReadOnly), this.ref);
    }

    protected void doClose() throws IOException {
        IOException ioe;
        block6: {
            ioe = null;
            try {
                super.doClose();
            }
            catch (IOException e) {
                ioe = e;
            }
            if (this.ref.decRef() == 0) {
                try {
                    this.in.directory().close();
                }
                catch (IOException e) {
                    if (ioe != null) break block6;
                    ioe = e;
                }
            }
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    static {
        $assertionsDisabled = !DirectoryOwningReader.class.desiredAssertionStatus();
    }
}

