/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.CVSEntryLineTag;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;

public class RemoteFolderSandbox
extends RemoteFolder {
    public RemoteFolderSandbox(RemoteFolder parent, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag) {
        super(parent, repository, repositoryRelativePath, tag);
        this.setChildren(new ICVSRemoteResource[0]);
    }

    public RemoteFolderSandbox(RemoteFolder parent, String name, CVSRepositoryLocation repository, String repositoryRelativePath, CVSEntryLineTag tag, boolean isStatic) {
        super(parent, name, repository, repositoryRelativePath, tag, isStatic);
        this.setChildren(new ICVSRemoteResource[0]);
    }

    public ICVSFile getFile(String name) throws CVSException {
        try {
            return super.getFile(name);
        }
        catch (CVSException e) {
            if (e.getStatus().getCode() == 1000) {
                Path path = new Path(null, name);
                String fileName = path.lastSegment();
                RemoteFolderSandbox parent = this.getParentFolder((IPath)path);
                RemoteFile file = new RemoteFile(parent, 0, fileName, null, null, this.getTag());
                parent.addChild(file);
                return file;
            }
            throw e;
        }
    }

    private void addChild(RemoteResource resource) {
        ICVSRemoteResource[] children = this.getChildren();
        ICVSRemoteResource[] newChildren = new ICVSRemoteResource[children.length + 1];
        System.arraycopy(children, 0, newChildren, 0, children.length);
        newChildren[children.length] = resource;
        this.setChildren(newChildren);
    }

    private RemoteFolderSandbox getParentFolder(IPath path) throws CVSException {
        IPath parentPath = path.removeLastSegments(1);
        String parentString = parentPath.isEmpty() ? "." : path.removeLastSegments(1).toString();
        RemoteFolderSandbox parent = (RemoteFolderSandbox)this.getFolder(parentString);
        return parent;
    }

    public ICVSFolder getFolder(String name) throws CVSException {
        try {
            return super.getFolder(name);
        }
        catch (CVSException e) {
            if (e.getStatus().getCode() == 1000) {
                Path path = new Path(null, name);
                RemoteFolderSandbox parent = this.getParentFolder((IPath)path);
                String repoPath = new Path(null, parent.getRepositoryRelativePath()).append(path.lastSegment()).removeTrailingSeparator().toString();
                RemoteFolderSandbox folder = new RemoteFolderSandbox(parent, this.getRepository(), repoPath, this.getTag());
                parent.addChild(folder);
                return folder;
            }
            throw e;
        }
    }

    public ICVSRemoteResource[] getMembers(IProgressMonitor monitor) throws TeamException {
        return this.getChildren();
    }

    public void acceptChildren(ICVSResourceVisitor visitor) throws CVSException {
        ICVSRemoteResource[] children = this.getChildren();
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            children[i].accept(visitor);
            ++i;
        }
    }

    public void remove(RemoteFile file) {
        ICVSRemoteResource[] children = this.getChildren();
        ArrayList<ICVSRemoteResource> results = new ArrayList<ICVSRemoteResource>();
        int i = 0;
        while (i < children.length) {
            if (children[i] != file) {
                results.add(children[i]);
            }
            ++i;
        }
        this.setChildren(results.toArray(new ICVSRemoteResource[results.size()]));
    }
}

