/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.target;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.frameworkadmin.BundleInfo;
import org.eclipse.equinox.internal.p2.director.PermissiveSlicer;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.PhaseSetFactory;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.planner.IProfileChangeRequest;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.touchpoint.eclipse.query.OSGiBundleQuery;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.target.AbstractBundleContainer;
import org.eclipse.pde.internal.core.target.AbstractTargetHandle;
import org.eclipse.pde.internal.core.target.Messages;
import org.eclipse.pde.internal.core.target.ResolvedBundle;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.IResolvedBundle;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.NameVersionDescriptor;

public class IUBundleContainer
extends AbstractBundleContainer {
    public static final String TYPE = "InstallableUnit";
    private static final String FEATURE_ID_SUFFIX = ".feature.group";
    private String[] fIds;
    private Version[] fVersions;
    private IInstallableUnit[] fUnits;
    private NameVersionDescriptor[] fFeatures;
    private URI[] fRepos;
    private boolean fIncludeAllRequired = true;
    private boolean fIncludeMultipleEnvironments = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    IUBundleContainer(String[] ids, String[] versions, URI[] repositories) {
        this.fIds = ids;
        this.fVersions = new Version[versions.length];
        int i = 0;
        while (i < versions.length) {
            this.fVersions[i] = Version.create((String)versions[i]);
            ++i;
        }
        this.fRepos = repositories == null || repositories.length == 0 ? null : repositories;
    }

    IUBundleContainer(IInstallableUnit[] units, URI[] repositories) {
        this.fUnits = units;
        this.fIds = new String[units.length];
        this.fVersions = new Version[units.length];
        int i = 0;
        while (i < units.length) {
            this.fIds[i] = units[i].getId();
            this.fVersions[i] = units[i].getVersion();
            ++i;
        }
        this.fRepos = repositories == null || repositories.length == 0 ? null : repositories;
    }

    public String getLocation(boolean resolve) throws CoreException {
        return AbstractTargetHandle.BUNDLE_POOL.toOSString();
    }

    public String getType() {
        return TYPE;
    }

    protected IFeatureModel[] resolveFeatures(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        if (this.fFeatures == null || this.fFeatures.length == 0 || !(definition instanceof TargetDefinition)) {
            return new IFeatureModel[0];
        }
        IFeatureModel[] allFeatures = ((TargetDefinition)definition).getFeatureModels(this.getLocation(false), monitor);
        HashMap<String, NameVersionDescriptor> containerFeatures = new HashMap<String, NameVersionDescriptor>();
        int i = 0;
        while (i < this.fFeatures.length) {
            containerFeatures.put(this.fFeatures[i].getId(), this.fFeatures[i]);
            ++i;
        }
        ArrayList<IFeatureModel> includedFeatures = new ArrayList<IFeatureModel>();
        int i2 = 0;
        while (i2 < allFeatures.length) {
            NameVersionDescriptor candidate = (NameVersionDescriptor)containerFeatures.get(allFeatures[i2].getFeature().getId());
            if (candidate != null && candidate.getVersion().equals(allFeatures[i2].getFeature().getVersion())) {
                includedFeatures.add(allFeatures[i2]);
            }
            ++i2;
        }
        return includedFeatures.toArray(new IFeatureModel[includedFeatures.size()]);
    }

    protected IResolvedBundle[] resolveBundles(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        this.fFeatures = null;
        if (this.fIncludeAllRequired) {
            return this.resolveWithPlanner(definition, monitor);
        }
        return this.resolveWithSlicer(definition, monitor);
    }

    private IResolvedBundle[] resolveWithPlanner(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        subMonitor.beginTask(Messages.IUBundleContainer_0, 210);
        IProfile profile = ((TargetDefinition)definition).getProfile();
        subMonitor.worked(10);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IInstallableUnit[] units = this.getInstallableUnits(profile);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        ProfileChangeRequest request = new ProfileChangeRequest(profile);
        request.addAll(Arrays.asList(units));
        int i = 0;
        while (i < units.length) {
            IInstallableUnit unit = units[i];
            request.setInstallableUnitProfileProperty(unit, "org.eclipse.pde.core.installed_iu", Boolean.toString(true));
            ++i;
        }
        IPlanner planner = this.getPlanner();
        URI[] repositories = this.resolveRepositories();
        ProvisioningContext context = new ProvisioningContext(this.getAgent());
        context.setMetadataRepositories(repositories);
        context.setArtifactRepositories(repositories);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IProvisioningPlan plan = planner.getProvisioningPlan((IProfileChangeRequest)request, context, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        IStatus status = plan.getStatus();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
        IProvisioningPlan installerPlan = plan.getInstallerPlan();
        if (installerPlan != null) {
            PDECore.log((IStatus)new Status(1, "org.eclipse.pde.core", Messages.IUBundleContainer_6));
        }
        subMonitor.worked(10);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IPhaseSet phases = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_CHECK_TRUST, PhaseSetFactory.PHASE_CONFIGURE, PhaseSetFactory.PHASE_UNCONFIGURE, PhaseSetFactory.PHASE_UNINSTALL});
        IEngine engine = this.getEngine();
        plan.setProfileProperty("org.eclipse.pde.core.provision_mode", "planner");
        plan.setProfileProperty("org.eclipse.pde.core.all_environments", Boolean.toString(false));
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 140));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        PermissiveSlicer slicer = new PermissiveSlicer((IQueryable)profile, (Map)new Properties(), true, false, true, false, false);
        IQueryable slice = slicer.slice(units, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        OSGiBundleQuery query = new OSGiBundleQuery();
        IQueryResult queryResult = slice.query((IQuery)query, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        this.queryForFeatures(slice);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        LinkedHashMap<BundleInfo, IResolvedBundle> bundles = new LinkedHashMap<BundleInfo, IResolvedBundle>();
        IFileArtifactRepository repo = this.getBundlePool(profile);
        Iterator iterator = queryResult.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)iterator.next();
            Collection artifacts = unit.getArtifacts();
            Iterator iterator2 = artifacts.iterator();
            while (iterator2.hasNext()) {
                IResolvedBundle bundle;
                File file = repo.getArtifactFile((IArtifactKey)iterator2.next());
                if (file == null || (bundle = this.generateBundle(file)) == null) continue;
                bundles.put(bundle.getBundleInfo(), bundle);
            }
        }
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IBundleContainer[] containers = definition.getBundleContainers();
        int i2 = 0;
        while (i2 < containers.length) {
            IUBundleContainer bc;
            IResolvedBundle[] included;
            IBundleContainer container = containers[i2];
            if (container == this) break;
            if (container instanceof IUBundleContainer && (included = (bc = (IUBundleContainer)container).getBundles()) != null) {
                int j = 0;
                while (j < included.length) {
                    bundles.remove(included[j].getBundleInfo());
                    ++j;
                }
            }
            ++i2;
        }
        subMonitor.worked(10);
        subMonitor.done();
        return bundles.values().toArray(new ResolvedBundle[bundles.size()]);
    }

    private IResolvedBundle[] resolveWithSlicer(ITargetDefinition definition, IProgressMonitor monitor) throws CoreException {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 10);
        subMonitor.beginTask(Messages.IUBundleContainer_0, 200);
        IProfile profile = ((TargetDefinition)definition).getProfile();
        subMonitor.worked(10);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IInstallableUnit[] units = this.getInstallableUnits(profile);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        URI[] repositories = this.resolveRepositories();
        int repoCount = repositories.length;
        if (repoCount == 0) {
            return new IResolvedBundle[0];
        }
        SubProgressMonitor loadMonitor = new SubProgressMonitor((IProgressMonitor)subMonitor, 10);
        loadMonitor.beginTask(null, repoCount * 10);
        ArrayList<IMetadataRepository> metadataRepos = new ArrayList<IMetadataRepository>(repoCount);
        MultiStatus repoStatus = new MultiStatus("org.eclipse.pde.core", 0, Messages.IUBundleContainer_ProblemsLoadingRepositories, null);
        IMetadataRepositoryManager manager = this.getRepoManager();
        int i = 0;
        while (i < repoCount) {
            try {
                IMetadataRepository repo = manager.loadRepository(repositories[i], (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)loadMonitor, 10));
                metadataRepos.add(repo);
            }
            catch (ProvisionException e) {
                repoStatus.add(e.getStatus());
            }
            ++i;
        }
        loadMonitor.done();
        if (metadataRepos.size() == 0) {
            throw new CoreException((IStatus)repoStatus);
        }
        IQueryable allMetadata = metadataRepos.size() == 1 ? (IQueryable)metadataRepos.get(0) : QueryUtil.compoundQueryable(metadataRepos);
        PermissiveSlicer slicer = null;
        if (this.getIncludeAllEnvironments()) {
            slicer = new PermissiveSlicer(allMetadata, (Map)new Properties(), true, false, true, true, false);
        } else {
            Properties props = new Properties();
            props.setProperty("osgi.os", definition.getOS() != null ? definition.getOS() : Platform.getOS());
            props.setProperty("osgi.ws", definition.getWS() != null ? definition.getWS() : Platform.getWS());
            props.setProperty("osgi.arch", definition.getArch() != null ? definition.getArch() : Platform.getOSArch());
            props.setProperty("osgi.nl", definition.getNL() != null ? definition.getNL() : Platform.getNL());
            props.setProperty("org.eclipse.update.install.features", Boolean.TRUE.toString());
            slicer = new PermissiveSlicer(allMetadata, (Map)props, true, false, false, true, false);
        }
        IQueryable slice = slicer.slice(units, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (slice == null) {
            return new IResolvedBundle[0];
        }
        IQueryResult queryResult = slice.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled() || queryResult.isEmpty()) {
            return new IResolvedBundle[0];
        }
        IEngine engine = this.getEngine();
        ProvisioningContext context = new ProvisioningContext(this.getAgent());
        context.setMetadataRepositories(repositories);
        context.setArtifactRepositories(repositories);
        IProvisioningPlan plan = engine.createPlan(profile, context);
        Set querySet = queryResult.toUnmodifiableSet();
        Iterator itor = querySet.iterator();
        while (itor.hasNext()) {
            plan.addInstallableUnit((IInstallableUnit)itor.next());
        }
        int i2 = 0;
        while (i2 < units.length) {
            IInstallableUnit unit = units[i2];
            plan.setInstallableUnitProfileProperty(unit, "org.eclipse.pde.core.installed_iu", Boolean.toString(true));
            ++i2;
        }
        plan.setProfileProperty("org.eclipse.pde.core.provision_mode", "slicer");
        plan.setProfileProperty("org.eclipse.pde.core.all_environments", Boolean.toString(this.getIncludeAllEnvironments()));
        IPhaseSet phases = PhaseSetFactory.createDefaultPhaseSetExcluding((String[])new String[]{PhaseSetFactory.PHASE_CHECK_TRUST, PhaseSetFactory.PHASE_CONFIGURE, PhaseSetFactory.PHASE_UNCONFIGURE, PhaseSetFactory.PHASE_UNINSTALL});
        IStatus result = engine.perform(plan, phases, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 140));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        if (!result.isOK()) {
            throw new CoreException(result);
        }
        slicer = new PermissiveSlicer((IQueryable)profile, (Map)new Properties(), true, false, true, false, false);
        slice = slicer.slice(units, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        queryResult = slice.query((IQuery)new OSGiBundleQuery(), (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subMonitor, 10));
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        this.queryForFeatures(slice);
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        LinkedHashMap<BundleInfo, IResolvedBundle> bundles = new LinkedHashMap<BundleInfo, IResolvedBundle>();
        IFileArtifactRepository repo = this.getBundlePool(profile);
        Iterator iterator = queryResult.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)iterator.next();
            Collection artifacts = unit.getArtifacts();
            Iterator iterator2 = artifacts.iterator();
            while (iterator2.hasNext()) {
                IResolvedBundle bundle;
                File file = repo.getArtifactFile((IArtifactKey)iterator2.next());
                if (file == null || (bundle = this.generateBundle(file)) == null) continue;
                bundles.put(bundle.getBundleInfo(), bundle);
            }
        }
        if (subMonitor.isCanceled()) {
            return new IResolvedBundle[0];
        }
        IBundleContainer[] containers = definition.getBundleContainers();
        int i3 = 0;
        while (i3 < containers.length) {
            IUBundleContainer bc;
            IResolvedBundle[] included;
            IBundleContainer container = containers[i3];
            if (container == this) break;
            if (container instanceof IUBundleContainer && (included = (bc = (IUBundleContainer)container).getBundles()) != null) {
                int j = 0;
                while (j < included.length) {
                    bundles.remove(included[j].getBundleInfo());
                    ++j;
                }
            }
            ++i3;
        }
        subMonitor.worked(10);
        subMonitor.done();
        return bundles.values().toArray(new ResolvedBundle[bundles.size()]);
    }

    private void queryForFeatures(IQueryable queryable) {
        IQuery featureQuery = QueryUtil.createMatchQuery((String)"properties[$0] == $1", (Object[])new Object[]{"org.eclipse.equinox.p2.type.group", Boolean.TRUE.toString()});
        IQueryResult featureResult = queryable.query(featureQuery, null);
        ArrayList<NameVersionDescriptor> features = new ArrayList<NameVersionDescriptor>();
        Iterator iterator = featureResult.iterator();
        while (iterator.hasNext()) {
            IInstallableUnit unit = (IInstallableUnit)iterator.next();
            String id = unit.getId();
            if (id.endsWith(FEATURE_ID_SUFFIX)) {
                id = id.substring(0, id.length() - FEATURE_ID_SUFFIX.length());
            }
            String version = unit.getVersion().toString();
            features.add(new NameVersionDescriptor(id, version, "feature"));
        }
        this.fFeatures = features.toArray(new NameVersionDescriptor[features.size()]);
    }

    public synchronized IInstallableUnit[] getInstallableUnits(IProfile profile) throws CoreException {
        if (this.fUnits == null) {
            this.fUnits = new IInstallableUnit[this.fIds.length];
            int i = 0;
            while (i < this.fIds.length) {
                IQuery query = QueryUtil.createIUQuery((String)this.fIds[i], (Version)this.fVersions[i]);
                IQueryResult queryResult = profile.query(query, null);
                if (queryResult.isEmpty()) {
                    URI[] repositories = this.resolveRepositories();
                    int j = 0;
                    while (j < repositories.length) {
                        try {
                            IMetadataRepository repository = this.getRepository(repositories[j]);
                            queryResult = repository.query(query, null);
                            if (!queryResult.isEmpty()) {
                                break;
                            }
                        }
                        catch (ProvisionException provisionException) {}
                        ++j;
                    }
                }
                if (queryResult.isEmpty()) {
                    this.fUnits = null;
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", NLS.bind((String)Messages.IUBundleContainer_1, (Object)this.fIds[i])));
                }
                this.fUnits[i] = (IInstallableUnit)queryResult.iterator().next();
                ++i;
            }
        }
        return this.fUnits;
    }

    private IMetadataRepository getRepository(URI uri) throws CoreException {
        IMetadataRepositoryManager manager = this.getRepoManager();
        IMetadataRepository repo = manager.loadRepository(uri, null);
        return repo;
    }

    private IMetadataRepositoryManager getRepoManager() throws CoreException {
        IProvisioningAgent agent = (IProvisioningAgent)PDECore.getDefault().acquireService(IProvisioningAgent.SERVICE_NAME);
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_7));
        }
        IMetadataRepositoryManager manager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (manager == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_2));
        }
        return manager;
    }

    private IFileArtifactRepository getBundlePool(IProfile profile) throws CoreException {
        String path = profile.getProperty("org.eclipse.equinox.p2.cache");
        if (path != null) {
            URI uri = new File(path).toURI();
            IArtifactRepositoryManager manager = this.getArtifactRepositoryManager();
            try {
                return (IFileArtifactRepository)manager.loadRepository(uri, null);
            }
            catch (ProvisionException provisionException) {}
        }
        return null;
    }

    private IArtifactRepositoryManager getArtifactRepositoryManager() throws CoreException {
        IArtifactRepositoryManager manager;
        IProvisioningAgent agent = (IProvisioningAgent)PDECore.getDefault().acquireService(IProvisioningAgent.SERVICE_NAME);
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_7));
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((manager = (IArtifactRepositoryManager)agent.getService(clazz.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_3));
        }
        return manager;
    }

    private IEngine getEngine() throws CoreException {
        IEngine engine;
        IProvisioningAgent agent = (IProvisioningAgent)PDECore.getDefault().acquireService(IProvisioningAgent.SERVICE_NAME);
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_7));
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.equinox.p2.engine.IEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((engine = (IEngine)agent.getService(clazz.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_4));
        }
        return engine;
    }

    private IPlanner getPlanner() throws CoreException {
        IPlanner planner;
        IProvisioningAgent iProvisioningAgent = this.getAgent();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.equinox.p2.planner.IPlanner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((planner = (IPlanner)iProvisioningAgent.getService(clazz.getName())) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_5));
        }
        return planner;
    }

    private IProvisioningAgent getAgent() throws CoreException {
        IProvisioningAgent agent = (IProvisioningAgent)PDECore.getDefault().acquireService(IProvisioningAgent.SERVICE_NAME);
        if (agent == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.IUBundleContainer_7));
        }
        return agent;
    }

    public boolean isContentEqual(AbstractBundleContainer container) {
        IUBundleContainer iuContainer;
        if (container instanceof IUBundleContainer && (iuContainer = (IUBundleContainer)container).getIncludeAllRequired() == this.getIncludeAllRequired() && (this.getIncludeAllRequired() || iuContainer.getIncludeAllEnvironments() == this.getIncludeAllEnvironments())) {
            return this.isEqualOrNull(this.fIds, iuContainer.fIds) && this.isEqualOrNull(this.fVersions, iuContainer.fVersions) && this.isEqualOrNull(this.fRepos, iuContainer.fRepos);
        }
        return false;
    }

    private boolean isEqualOrNull(Object[] objects1, Object[] objects2) {
        if (objects1 == null) {
            return objects2 == null;
        }
        if (objects2 == null) {
            return false;
        }
        if (objects1.length == objects2.length) {
            int i = 0;
            while (i < objects1.length) {
                if (!objects1[i].equals(objects2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public URI[] getRepositories() {
        return this.fRepos;
    }

    private URI[] resolveRepositories() throws CoreException {
        if (this.fRepos == null) {
            IMetadataRepositoryManager manager = this.getRepoManager();
            return manager.getKnownRepositories(0);
        }
        return this.fRepos;
    }

    public void setIncludeAllRequired(boolean include, ITargetDefinition definition) {
        IBundleContainer[] containers;
        this.fIncludeAllRequired = include;
        if (definition != null && (containers = definition.getBundleContainers()) != null) {
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IUBundleContainer && containers[i] != this) {
                    ((IUBundleContainer)containers[i]).setIncludeAllRequired(include, null);
                }
                ++i;
            }
        }
    }

    public boolean getIncludeAllRequired() {
        return this.fIncludeAllRequired;
    }

    public void setIncludeAllEnvironments(boolean include, ITargetDefinition definition) {
        IBundleContainer[] containers;
        this.fIncludeMultipleEnvironments = include;
        if (definition != null && (containers = definition.getBundleContainers()) != null) {
            int i = 0;
            while (i < containers.length) {
                if (containers[i] instanceof IUBundleContainer && containers[i] != this) {
                    ((IUBundleContainer)containers[i]).setIncludeAllEnvironments(include, null);
                }
                ++i;
            }
        }
    }

    public boolean getIncludeAllEnvironments() {
        return this.fIncludeMultipleEnvironments;
    }

    public void removeInstallableUnit(IInstallableUnit unit) {
        ArrayList<IInstallableUnit> newUnits = new ArrayList<IInstallableUnit>(this.fUnits.length);
        int i = 0;
        while (i < this.fUnits.length) {
            if (!this.fUnits[i].equals((Object)unit)) {
                newUnits.add(this.fUnits[i]);
            }
            ++i;
        }
        this.fUnits = newUnits.toArray(new IInstallableUnit[newUnits.size()]);
        this.fIds = new String[this.fUnits.length];
        this.fVersions = new Version[this.fUnits.length];
        i = 0;
        while (i < this.fUnits.length) {
            this.fIds[i] = this.fUnits[i].getId();
            this.fVersions[i] = this.fUnits[i].getVersion();
            ++i;
        }
        this.clearResolutionStatus();
    }

    String[] getIds() {
        return this.fIds;
    }

    Version[] getVersions() {
        return this.fVersions;
    }
}

