/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.scope.CriteriaHelpScope;
import org.eclipse.help.internal.criteria.CriterionResource;
import org.eclipse.help.internal.search.ISearchHitCollector;
import org.eclipse.help.internal.search.QueryTooComplexException;
import org.eclipse.help.internal.search.SearchHit;
import org.eclipse.help.internal.toc.Toc;
import org.eclipse.help.internal.util.URLCoder;
import org.eclipse.help.internal.workingset.AdaptableHelpResource;
import org.eclipse.help.internal.workingset.AdaptableSelectedToc;
import org.eclipse.help.internal.workingset.AdaptableSelectedTopic;
import org.eclipse.help.internal.workingset.AdaptableToc;
import org.eclipse.help.internal.workingset.AdaptableTopic;
import org.eclipse.help.internal.workingset.WorkingSet;

public class SearchResults
implements ISearchHitCollector {
    private ArrayList scopes;
    private int maxHits;
    private String locale;
    private AbstractHelpScope filter;
    private CriteriaHelpScope criteriaScope;
    protected SearchHit[] searchHits = new SearchHit[0];
    private QueryTooComplexException searchException = null;
    private boolean isQuickSearch;
    static /* synthetic */ Class class$0;

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale) {
        this(workingSets, maxHits, locale, false);
    }

    public SearchResults(WorkingSet[] workingSets, int maxHits, String locale, boolean isQuickSearch) {
        this.maxHits = maxHits;
        this.locale = locale;
        this.scopes = this.getScopes(workingSets);
        this.criteriaScope = new CriteriaHelpScope(this.getCriteriaScopes(workingSets));
        this.isQuickSearch = isQuickSearch;
    }

    public void setFilter(AbstractHelpScope filter) {
        this.filter = filter;
    }

    public void addHits(List hits, String highlightTerms) {
        String urlEncodedWords = URLCoder.encode((String)highlightTerms);
        ArrayList<SearchHit> searchHitList = new ArrayList<SearchHit>();
        float scoreScale = 1.0f;
        boolean scoreScaleSet = false;
        Iterator iter = hits.iterator();
        int filteredHits = 0;
        while (filteredHits < this.maxHits && iter.hasNext()) {
            ITopic t;
            SearchHit rawHit = (SearchHit)iter.next();
            String href = rawHit.getHref();
            IToc toc = null;
            AdaptableHelpResource scope = null;
            if (this.scopes == null) {
                toc = this.getTocForTopic(href, this.locale);
                if (toc == null && !rawHit.canOpen()) {
                    continue;
                }
            } else {
                scope = this.getScopeForTopic(href);
                if (scope == null) continue;
                if (scope instanceof AdaptableToc || scope instanceof AdaptableSelectedToc) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.help.IToc");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    toc = (IToc)scope.getAdapter(clazz);
                } else if (scope instanceof AdaptableTopic || scope instanceof AdaptableSelectedTopic) {
                    IAdaptable iAdaptable = scope.getParent();
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = Class.forName("org.eclipse.help.IToc");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    toc = (IToc)iAdaptable.getAdapter((Class)clazz);
                }
            }
            float score = rawHit.getScore();
            if (!scoreScaleSet) {
                if (score > 0.0f) {
                    scoreScale = 0.99f / score;
                    score = 1.0f;
                }
                scoreScaleSet = true;
            } else {
                score = score * scoreScale + 0.01f;
            }
            String label = rawHit.getLabel();
            if ("".equals(label) && toc != null && (t = scope != null ? scope.getTopic(href) : toc.getTopic(href)) != null) {
                label = t.getLabel();
            }
            if (label == null || "".equals(label)) {
                label = href;
            }
            if (urlEncodedWords.length() > 0) {
                href = String.valueOf(href) + "?resultof=" + urlEncodedWords;
            }
            ++filteredHits;
            searchHitList.add(new SearchHit(href, label, rawHit.getSummary(), score, toc, rawHit.getRawId(), rawHit.getParticipantId(), rawHit.isPotentialHit()));
        }
        this.searchHits = searchHitList.toArray(new SearchHit[searchHitList.size()]);
    }

    private AdaptableHelpResource getScopeForTopic(String href) {
        boolean enabled = HelpPlugin.getCriteriaManager().isCriteriaEnabled();
        int i = 0;
        while (i < this.scopes.size()) {
            String owningTocHref;
            Toc toc;
            IToc tocRoot;
            AdaptableHelpResource scope = (AdaptableHelpResource)this.scopes.get(i);
            ITopic inScopeTopic = scope.getTopic(href);
            if (inScopeTopic != null && (this.filter == null || this.filter.inScope(inScopeTopic)) && (!enabled || enabled && this.criteriaScope.inScope(inScopeTopic))) {
                return scope;
            }
            if (!this.isQuickSearch && (tocRoot = this.getTocForScope(scope, this.locale)) != null && (toc = HelpPlugin.getTocManager().getOwningToc(href)) != null && (owningTocHref = toc.getHref()) == tocRoot.getHref() && (this.filter == null || this.filter.inScope(inScopeTopic)) && (!enabled || enabled && this.criteriaScope.inScope(inScopeTopic))) {
                return scope;
            }
            ++i;
        }
        return null;
    }

    private IToc getTocForScope(AdaptableHelpResource scope, String locale) {
        if (scope == null) {
            return null;
        }
        String href = scope.getHref();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.help.IToc");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (scope.getAdapter(clazz) instanceof IToc) {
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("org.eclipse.help.IToc");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IToc toc = (IToc)scope.getAdapter(clazz2);
            href = toc.getTopic(null).getHref();
        }
        if (href != null && href.length() > 0) {
            return this.getTocForTopic(href, locale);
        }
        AdaptableHelpResource[] childrenScopes = scope.getChildren();
        if (childrenScopes != null) {
            int i = 0;
            while (i < childrenScopes.length) {
                IToc toc = this.getTocForScope(childrenScopes[i], locale);
                if (toc != null) {
                    return toc;
                }
                ++i;
            }
        }
        return null;
    }

    private IToc getTocForTopic(String href, String locale) {
        Toc toc;
        Toc[] tocs = HelpPlugin.getTocManager().getTocs(locale);
        boolean foundInToc = false;
        int i = 0;
        while (i < tocs.length) {
            ITopic topic = tocs[i].getTopic(href);
            if (topic != null) {
                foundInToc = true;
                if (this.filter == null || this.filter.inScope(topic)) {
                    return tocs[i];
                }
            }
            ++i;
        }
        if (!foundInToc && (toc = HelpPlugin.getTocManager().getOwningToc(href)) != null) {
            foundInToc = true;
            if (this.filter == null || this.filter.inScope((IToc)toc)) {
                return toc;
            }
        }
        return null;
    }

    public SearchHit[] getSearchHits() {
        return this.searchHits;
    }

    public QueryTooComplexException getException() {
        return this.searchException;
    }

    private ArrayList getScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        this.scopes = new ArrayList(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            AdaptableHelpResource[] elements = wSets[w].getElements();
            int i = 0;
            while (i < elements.length) {
                this.scopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return this.scopes;
    }

    private ArrayList getCriteriaScopes(WorkingSet[] wSets) {
        if (wSets == null) {
            return null;
        }
        ArrayList<CriterionResource> criteriaScopes = new ArrayList<CriterionResource>(wSets.length);
        int w = 0;
        while (w < wSets.length) {
            CriterionResource[] elements = wSets[w].getCriteria();
            int i = 0;
            while (i < elements.length) {
                criteriaScopes.add(elements[i]);
                ++i;
            }
            ++w;
        }
        return criteriaScopes;
    }

    public void addQTCException(QueryTooComplexException exception) throws QueryTooComplexException {
        this.searchException = exception;
    }
}

