/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.filehistory;

import java.net.URI;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.ITag;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;

public class CVSFileRevision
extends FileRevision
implements IAdaptable {
    protected ILogEntry entry;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public CVSFileRevision(ILogEntry entry) {
        this.entry = entry;
    }

    public long getTimestamp() {
        return this.entry.getDate().getTime();
    }

    public String getAuthor() {
        return this.entry.getAuthor();
    }

    public String getComment() {
        return this.entry.getComment();
    }

    public boolean isPredecessorOf(IFileRevision revision) {
        long compareRevisionTime = revision.getTimestamp();
        return this.getTimestamp() < compareRevisionTime;
    }

    public boolean isDescendentOf(IFileRevision revision) {
        long compareRevisionTime = revision.getTimestamp();
        return this.getTimestamp() > compareRevisionTime;
    }

    public IStorage getStorage(IProgressMonitor monitor) throws TeamException {
        RemoteFile remoteFile = (RemoteFile)this.entry.getRemoteFile();
        return remoteFile.getStorage(monitor);
    }

    public String getName() {
        return this.entry.getRemoteFile().getName();
    }

    public String getContentIdentifier() {
        return this.entry.getRevision();
    }

    public boolean equals(Object obj) {
        CVSFileRevision objRevision;
        ICVSRemoteFile remFile;
        return obj instanceof CVSFileRevision && (remFile = (objRevision = (CVSFileRevision)((Object)obj)).getCVSRemoteFile()).equals(this.getCVSRemoteFile()) && objRevision.getContentIdentifier().equals(this.getContentIdentifier());
    }

    public URI getURI() {
        ICVSRemoteFile file = this.entry.getRemoteFile();
        return ((RemoteFile)file).toCVSURI().toURI();
    }

    public ITag[] getTags() {
        return this.entry.getTags();
    }

    public boolean exists() {
        return !this.entry.isDeletion();
    }

    public ICVSRemoteFile getCVSRemoteFile() {
        return this.entry.getRemoteFile();
    }

    public boolean isPropertyMissing() {
        return this.entry.getAuthor() == null;
    }

    public IFileRevision withAllProperties(IProgressMonitor monitor) throws CoreException {
        return new CVSFileRevision(this.getCVSRemoteFile().getLogEntry(monitor));
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.team.internal.ccvs.core.ICVSFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getCVSRemoteFile();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.team.core.variants.IResourceVariant");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return this.getCVSRemoteFile();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

