/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.jdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveLinkedFolderDialog;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;

public class RemoveFromBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public RemoveFromBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_REMOVE_FROM_BP);
    }

    public RemoveFromBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_REMOVE_AS_SOURCE_FOLDER);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_REMOVE_AS_SOURCE_FOLDER);
    }

    public RemoveFromBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 1);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_FromBuildpath;
        }
        Object elem = this.getSelectedElements().get(0);
        if (elem instanceof IJavaProject) {
            String name = ClasspathModifier.escapeSpecialChars(JavaElementLabels.getElementLabel((IJavaElement)elem, JavaElementLabels.ALL_DEFAULT));
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectFromBuildpath, name);
        }
        if (elem instanceof IPackageFragmentRoot) {
            String name = ClasspathModifier.escapeSpecialChars(JavaElementLabels.getElementLabel((IJavaElement)elem, JavaElementLabels.ALL_DEFAULT));
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_fromBuildpath, name);
        }
        if (elem instanceof ClassPathContainer) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_FromBuildpath;
        }
        return null;
    }

    public void run() {
        try {
            IJavaProject project;
            Object object = this.getSelectedElements().get(0);
            if (object instanceof IJavaProject) {
                project = (IJavaProject)object;
            } else if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)object;
                project = root.getJavaProject();
            } else {
                ClassPathContainer container = (ClassPathContainer)object;
                project = container.getJavaProject();
            }
            final ArrayList elementsToRemove = new ArrayList();
            final ArrayList foldersToDelete = new ArrayList();
            this.queryToRemoveLinkedFolders(elementsToRemove, foldersToDelete);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, foldersToDelete.size() + 10);
                            CPJavaProject cpProject = CPJavaProject.createFromExisting(project);
                            CPListElement[] toRemove = new CPListElement[elementsToRemove.size()];
                            int i = 0;
                            Iterator iterator = elementsToRemove.iterator();
                            while (iterator.hasNext()) {
                                Object element = iterator.next();
                                toRemove[i] = element instanceof IJavaProject ? ClasspathModifier.getListElement(((IJavaProject)element).getPath(), cpProject.getCPListElements()) : (element instanceof IPackageFragmentRoot ? CPListElement.createFromExisting(((IPackageFragmentRoot)element).getRawClasspathEntry(), project) : CPListElement.createFromExisting(((ClassPathContainer)element).getClasspathEntry(), project));
                                ++i;
                            }
                            BuildpathDelta delta = ClasspathModifier.removeFromBuildpath(toRemove, cpProject);
                            ClasspathModifier.commitClassPath(cpProject, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                            RemoveFromBuildpathAction.this.deleteFolders(foldersToDelete, (IProgressMonitor)new SubProgressMonitor(monitor, foldersToDelete.size()));
                            RemoveFromBuildpathAction.this.informListeners(delta);
                            if (delta.getDeletedResources().length == foldersToDelete.size()) {
                                RemoveFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection((Object)project));
                            } else {
                                ArrayList<IResource> result = new ArrayList<IResource>(Arrays.asList(delta.getDeletedResources()));
                                result.removeAll(foldersToDelete);
                                RemoveFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (CoreException e) {
            this.showExceptionDialog(e, NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void deleteFolders(List folders, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, folders.size());
            Iterator iter = folders.iterator();
            while (iter.hasNext()) {
                IFolder folder = (IFolder)iter.next();
                folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void queryToRemoveLinkedFolders(List elementsToRemove, List foldersToDelete) throws JavaModelException {
        Shell shell = this.getShell();
        Iterator iter = this.getSelectedElements().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IPackageFragmentRoot) {
                IFolder folder = this.getLinkedSourceFolder((IPackageFragmentRoot)element);
                if (folder != null) {
                    int result;
                    RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell, folder);
                    int n = result = dialog.open() == 0 ? dialog.getRemoveStatus() : 0;
                    if (result == 0) continue;
                    if (result == 1) {
                        elementsToRemove.add(element);
                        continue;
                    }
                    if (result != 2) continue;
                    elementsToRemove.add(element);
                    foldersToDelete.add(folder);
                    continue;
                }
                elementsToRemove.add(element);
                continue;
            }
            elementsToRemove.add(element);
        }
    }

    private IFolder getLinkedSourceFolder(IPackageFragmentRoot root) throws JavaModelException {
        if (root.getKind() != 1) {
            return null;
        }
        IResource resource = root.getCorrespondingResource();
        if (!(resource instanceof IFolder)) {
            return null;
        }
        IFolder folder = (IFolder)resource;
        if (!folder.isLinked()) {
            return null;
        }
        return folder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            Object element;
            block7: {
                Iterator iter = elements.iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        return true;
                    }
                    element = iter.next();
                    if (element instanceof IJavaProject) {
                        IJavaProject project = (IJavaProject)element;
                        if (ClasspathModifier.isSourceFolder(project)) continue;
                        return false;
                    }
                    if (!(element instanceof IPackageFragmentRoot)) break block7;
                    IClasspathEntry entry = JavaModelUtil.getClasspathEntry((IPackageFragmentRoot)element);
                    if (entry.getEntryKind() == 5) {
                        return false;
                    }
                    if (entry.getReferencingEntry() != null) break;
                }
                return false;
            }
            return element instanceof ClassPathContainer;
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }
}

