/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.search.SearchParticipantDescriptor;
import org.eclipse.jdt.internal.ui.search.SearchParticipantRecord;

public class SearchParticipantsExtensionPoint {
    private Set fActiveParticipants = null;
    private static SearchParticipantsExtensionPoint fgInstance;

    public boolean hasAnyParticipants() {
        return Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jdt.ui.queryParticipants").length > 0;
    }

    private synchronized Set getAllParticipants() {
        if (this.fActiveParticipants != null) {
            return this.fActiveParticipants;
        }
        IConfigurationElement[] allParticipants = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.jdt.ui.queryParticipants");
        this.fActiveParticipants = new HashSet(allParticipants.length);
        int i = 0;
        while (i < allParticipants.length) {
            SearchParticipantDescriptor descriptor = new SearchParticipantDescriptor(allParticipants[i]);
            IStatus status = descriptor.checkSyntax();
            if (status.isOK()) {
                this.fActiveParticipants.add(descriptor);
            } else {
                JavaPlugin.log(status);
            }
            ++i;
        }
        return this.fActiveParticipants;
    }

    private void collectParticipants(Set participants, IProject[] projects) {
        Iterator activeParticipants = this.getAllParticipants().iterator();
        HashSet<String> seenParticipants = new HashSet<String>();
        block2: while (activeParticipants.hasNext()) {
            SearchParticipantDescriptor participant = (SearchParticipantDescriptor)activeParticipants.next();
            String id = participant.getID();
            if (!participant.isEnabled() || seenParticipants.contains(id)) continue;
            int i = 0;
            while (i < projects.length) {
                try {
                    if (projects[i].hasNature(participant.getNature())) {
                        participants.add(new SearchParticipantRecord(participant, participant.create()));
                        seenParticipants.add(id);
                        continue block2;
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e.getStatus());
                    participant.disable();
                }
                ++i;
            }
        }
    }

    public SearchParticipantRecord[] getSearchParticipants(IProject[] concernedProjects) {
        HashSet participantSet = new HashSet();
        this.collectParticipants(participantSet, concernedProjects);
        SearchParticipantRecord[] participants = new SearchParticipantRecord[participantSet.size()];
        return participantSet.toArray(participants);
    }

    public static SearchParticipantsExtensionPoint getInstance() {
        if (fgInstance == null) {
            fgInstance = new SearchParticipantsExtensionPoint();
        }
        return fgInstance;
    }

    public static void debugSetInstance(SearchParticipantsExtensionPoint instance) {
        fgInstance = instance;
    }
}

