/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.callhierarchy;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.internal.corext.callhierarchy.CallHierarchyVisitor;
import org.eclipse.jdt.internal.corext.callhierarchy.MethodCall;
import org.eclipse.jdt.internal.corext.callhierarchy.RealCallers;
import org.eclipse.jdt.internal.ui.callhierarchy.MethodWrapperWorkbenchAdapter;

public abstract class MethodWrapper
extends PlatformObject {
    private Map fElements = null;
    private Map fMethodCache;
    private final MethodCall fMethodCall;
    private final MethodWrapper fParent;
    private int fLevel;
    private int fFieldSearchMode;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MethodWrapper(MethodWrapper parent, MethodCall methodCall) {
        Assert.isNotNull((Object)methodCall);
        if (parent == null) {
            this.setMethodCache(new HashMap());
            this.fLevel = 1;
        } else {
            this.setMethodCache(parent.getMethodCache());
            this.fLevel = parent.getLevel() + 1;
        }
        this.fMethodCall = methodCall;
        this.fParent = parent;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this.getMember();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz2) {
            return new MethodWrapperWorkbenchAdapter(this);
        }
        return null;
    }

    public MethodWrapper[] getCalls(IProgressMonitor progressMonitor) {
        if (this.fElements == null) {
            this.doFindChildren(progressMonitor);
        }
        MethodWrapper[] result = new MethodWrapper[this.fElements.size()];
        int i = 0;
        Iterator iter = this.fElements.keySet().iterator();
        while (iter.hasNext()) {
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iter.next());
            result[i++] = this.createMethodWrapper(methodCall);
        }
        return result;
    }

    public int getLevel() {
        return this.fLevel;
    }

    public IMember getMember() {
        return this.getMethodCall().getMember();
    }

    public MethodCall getMethodCall() {
        return this.fMethodCall;
    }

    public String getName() {
        if (this.getMethodCall() != null) {
            return this.getMethodCall().getMember().getElementName();
        }
        return "";
    }

    public MethodWrapper getParent() {
        return this.fParent;
    }

    public int getFieldSearchMode() {
        if (this.fFieldSearchMode != 0) {
            return this.fFieldSearchMode;
        }
        MethodWrapper parent = this.getParent();
        while (parent != null) {
            if (parent.fFieldSearchMode != 0) {
                return parent.fFieldSearchMode;
            }
            parent = parent.getParent();
        }
        return 2;
    }

    public void setFieldSearchMode(int fieldSearchMode) {
        this.fFieldSearchMode = fieldSearchMode;
    }

    public boolean equals(Object oth) {
        if (this == oth) {
            return true;
        }
        if (oth == null) {
            return false;
        }
        if (oth instanceof MethodWrapperWorkbenchAdapter) {
            oth = ((MethodWrapperWorkbenchAdapter)oth).getMethodWrapper();
        }
        if (oth.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        MethodWrapper other = (MethodWrapper)((Object)oth);
        if (this.fParent == null ? other.fParent != null : !this.fParent.equals((Object)other.fParent)) {
            return false;
        }
        return !(this.getMethodCall() == null ? other.getMethodCall() != null : !this.getMethodCall().equals(other.getMethodCall()));
    }

    public int hashCode() {
        int result = 0;
        if (this.fParent != null) {
            result = 1000003 * result + this.fParent.hashCode();
        }
        if (this.getMethodCall() != null) {
            result = 1000003 * result + this.getMethodCall().getMember().hashCode();
        }
        return result;
    }

    private void setMethodCache(Map methodCache) {
        this.fMethodCache = methodCache;
    }

    protected abstract String getTaskName();

    private void addCallToCache(MethodCall methodCall) {
        Map cachedCalls = this.lookupMethod(this.getMethodCall());
        cachedCalls.put(methodCall.getKey(), methodCall);
    }

    protected abstract MethodWrapper createMethodWrapper(MethodCall var1);

    private void doFindChildren(IProgressMonitor progressMonitor) {
        Map existingResults = this.lookupMethod(this.getMethodCall());
        if (existingResults != null && !existingResults.isEmpty()) {
            this.fElements = new HashMap();
            this.fElements.putAll(existingResults);
        } else {
            this.initCalls();
            if (progressMonitor != null) {
                progressMonitor.beginTask(this.getTaskName(), 100);
            }
            try {
                try {
                    this.performSearch(progressMonitor);
                }
                catch (OperationCanceledException e) {
                    this.fElements = null;
                    throw e;
                }
            }
            finally {
                if (progressMonitor != null) {
                    progressMonitor.done();
                }
            }
        }
    }

    public boolean isRecursive() {
        if (this.fParent instanceof RealCallers) {
            return false;
        }
        MethodWrapper current = this.getParent();
        while (current != null) {
            if (this.getMember().getHandleIdentifier().equals(current.getMember().getHandleIdentifier())) {
                return true;
            }
            current = current.getParent();
        }
        return false;
    }

    public abstract boolean canHaveChildren();

    protected abstract Map findChildren(IProgressMonitor var1);

    private Map getMethodCache() {
        return this.fMethodCache;
    }

    private void initCalls() {
        this.fElements = new HashMap();
        this.initCacheForMethod();
    }

    private Map lookupMethod(MethodCall methodCall) {
        return (Map)this.getMethodCache().get(methodCall.getKey());
    }

    private void performSearch(IProgressMonitor progressMonitor) {
        this.fElements = this.findChildren(progressMonitor);
        Iterator iter = this.fElements.keySet().iterator();
        while (iter.hasNext()) {
            this.checkCanceled(progressMonitor);
            MethodCall methodCall = this.getMethodCallFromMap(this.fElements, iter.next());
            this.addCallToCache(methodCall);
        }
    }

    private MethodCall getMethodCallFromMap(Map elements, Object key) {
        return (MethodCall)elements.get(key);
    }

    private void initCacheForMethod() {
        HashMap cachedCalls = new HashMap();
        this.getMethodCache().put(this.getMethodCall().getKey(), cachedCalls);
    }

    protected void checkCanceled(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    public void accept(CallHierarchyVisitor visitor, IProgressMonitor progressMonitor) {
        if (this.getParent() != null && this.getParent().isRecursive()) {
            return;
        }
        this.checkCanceled(progressMonitor);
        visitor.preVisit(this);
        if (visitor.visit(this)) {
            MethodWrapper[] methodWrappers = this.getCalls(progressMonitor);
            int i = 0;
            while (i < methodWrappers.length) {
                methodWrappers[i].accept(visitor, progressMonitor);
                ++i;
            }
        }
        visitor.postVisit(this);
        if (progressMonitor != null) {
            progressMonitor.worked(1);
        }
    }

    public void removeFromCache() {
        this.fElements = null;
        this.fMethodCache.remove(this.getMethodCall().getKey());
    }
}

