/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkEventMotion;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Sash
extends Control {
    boolean dragging;
    int startX;
    int startY;
    int lastX;
    int lastY;
    long defaultCursor;
    private static final int INCREMENT = 1;
    private static final int PAGE_INCREMENT = 9;

    public Sash(Composite parent, int style) {
        super(parent, Sash.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Sash.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width += 64;
            height += 3;
        } else {
            width += 3;
            height += 64;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 0x10008;
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.handle, true);
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        int type = (this.style & 0x200) != 0 ? 108 : 116;
        this.defaultCursor = OS.gdk_cursor_new(type);
    }

    void drawBand(int x, int y, int width, int height) {
        if ((this.style & 0x10000) != 0) {
            return;
        }
        long window = OS.GTK_WIDGET_WINDOW(this.parent.paintHandle());
        if (window == 0L) {
            return;
        }
        byte[] bits = new byte[]{-86, 85, -86, 85, -86, 85, -86, 85};
        long stipplePixmap = OS.gdk_bitmap_create_from_data(window, bits, 8, 8);
        long gc = OS.gdk_gc_new(window);
        long colormap = OS.gdk_colormap_get_system();
        GdkColor color = new GdkColor();
        OS.gdk_color_white(colormap, color);
        OS.gdk_gc_set_foreground(gc, color);
        OS.gdk_gc_set_stipple(gc, stipplePixmap);
        OS.gdk_gc_set_subwindow(gc, 1L);
        OS.gdk_gc_set_fill(gc, 2);
        OS.gdk_gc_set_function(gc, 2L);
        OS.gdk_draw_rectangle(window, gc, 1, x, y, width, height);
        OS.g_object_unref(stipplePixmap);
        OS.g_object_unref(gc);
    }

    long gtk_button_press_event(long widget, long eventPtr) {
        long result = super.gtk_button_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0L;
        }
        if (gdkEvent.type == 5) {
            return 0L;
        }
        if (gdkEvent.type == 6) {
            return 0L;
        }
        long window = OS.GTK_WIDGET_WINDOW(widget);
        int[] origin_x = new int[1];
        int[] origin_y = new int[1];
        OS.gdk_window_get_origin(window, origin_x, origin_y);
        this.startX = (int)(gdkEvent.x_root - (double)origin_x[0]);
        this.startY = (int)(gdkEvent.y_root - (double)origin_y[0]);
        int x = OS.GTK_WIDGET_X(this.handle);
        int y = OS.GTK_WIDGET_Y(this.handle);
        int width = OS.GTK_WIDGET_WIDTH(this.handle);
        int height = OS.GTK_WIDGET_HEIGHT(this.handle);
        this.lastX = x;
        this.lastY = y;
        Event event = new Event();
        event.time = gdkEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - width - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0L;
        }
        if (event.doit) {
            this.dragging = true;
            this.lastX = event.x;
            this.lastY = event.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - width - this.lastX;
            }
            this.parent.update(true, (this.style & 0x10000) == 0);
            this.drawBand(this.lastX, event.y, width, height);
            if ((this.style & 0x10000) != 0) {
                this.setBounds(event.x, event.y, width, height);
            }
        }
        return result;
    }

    long gtk_button_release_event(long widget, long eventPtr) {
        long result = super.gtk_button_release_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventButton.sizeof);
        int button = gdkEvent.button;
        if (button != 1) {
            return 0L;
        }
        if (!this.dragging) {
            return 0L;
        }
        this.dragging = false;
        int width = OS.GTK_WIDGET_WIDTH(this.handle);
        int height = OS.GTK_WIDGET_HEIGHT(this.handle);
        Event event = new Event();
        event.time = gdkEvent.time;
        event.x = this.lastX;
        event.y = this.lastY;
        event.width = width;
        event.height = height;
        this.drawBand(this.lastX, this.lastY, width, height);
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - width - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return result;
        }
        if (event.doit && (this.style & 0x10000) != 0) {
            this.setBounds(event.x, event.y, width, height);
        }
        return result;
    }

    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if (this.handle != 0L) {
            this.lastX = OS.GTK_WIDGET_X(this.handle);
            this.lastY = OS.GTK_WIDGET_Y(this.handle);
        }
        return 0L;
    }

    long gtk_key_press_event(long widget, long eventPtr) {
        long result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
        int keyval = gdkEvent.keyval;
        switch (keyval) {
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: {
                int xChange = 0;
                int yChange = 0;
                int stepSize = 9;
                if ((gdkEvent.state & 4) != 0) {
                    stepSize = 1;
                }
                if ((this.style & 0x200) != 0) {
                    if (keyval == 65362 || keyval == 65364) break;
                    xChange = keyval == 65361 ? -stepSize : stepSize;
                } else {
                    if (keyval == 65361 || keyval == 65363) break;
                    yChange = keyval == 65362 ? -stepSize : stepSize;
                }
                int width = OS.GTK_WIDGET_WIDTH(this.handle);
                int height = OS.GTK_WIDGET_HEIGHT(this.handle);
                int parentBorder = 0;
                int parentWidth = OS.GTK_WIDGET_WIDTH(this.parent.handle);
                int parentHeight = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
                int newX = this.lastX;
                int newY = this.lastY;
                if ((this.style & 0x200) != 0) {
                    newX = Math.min(Math.max(0, this.lastX + xChange - parentBorder - this.startX), parentWidth - width);
                } else {
                    newY = Math.min(Math.max(0, this.lastY + yChange - parentBorder - this.startY), parentHeight - height);
                }
                if (newX == this.lastX && newY == this.lastY) {
                    return result;
                }
                long window = OS.GTK_WIDGET_WINDOW(this.handle);
                int grabMask = 516;
                long gdkCursor = this.cursor != null ? this.cursor.handle : this.defaultCursor;
                int ptrGrabResult = OS.gdk_pointer_grab(window, false, grabMask, window, gdkCursor, 0);
                Event event = new Event();
                event.time = gdkEvent.time;
                event.x = newX;
                event.y = newY;
                event.width = width;
                event.height = height;
                if ((this.parent.style & 0x8000000) != 0) {
                    event.x = this.parent.getClientWidth() - width - event.x;
                }
                this.sendSelectionEvent(13, event, true);
                if (ptrGrabResult == 0) {
                    OS.gdk_pointer_ungrab(0);
                }
                if (this.isDisposed() || !event.doit) break;
                this.lastX = event.x;
                this.lastY = event.y;
                if ((this.parent.style & 0x8000000) != 0) {
                    this.lastX = this.parent.getClientWidth() - width - this.lastX;
                }
                if ((this.style & 0x10000) != 0) {
                    this.setBounds(event.x, event.y, width, height);
                    if (this.isDisposed()) break;
                }
                int cursorX = event.x;
                int cursorY = event.y;
                if ((this.style & 0x200) != 0) {
                    cursorY += height / 2;
                } else {
                    cursorX += width / 2;
                }
                this.display.setCursorLocation(this.parent.toDisplay(cursorX, cursorY));
            }
        }
        return result;
    }

    long gtk_motion_notify_event(long widget, long eventPtr) {
        int eventState;
        int eventY;
        int eventX;
        long result = super.gtk_motion_notify_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        if (!this.dragging) {
            return 0L;
        }
        GdkEventMotion gdkEvent = new GdkEventMotion();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventButton.sizeof);
        if (gdkEvent.is_hint != 0) {
            int[] pointer_x = new int[1];
            int[] pointer_y = new int[1];
            int[] mask = new int[1];
            OS.gdk_window_get_pointer(gdkEvent.window, pointer_x, pointer_y, mask);
            eventX = pointer_x[0];
            eventY = pointer_y[0];
            eventState = mask[0];
        } else {
            int[] origin_x = new int[1];
            int[] origin_y = new int[1];
            OS.gdk_window_get_origin(gdkEvent.window, origin_x, origin_y);
            eventX = (int)(gdkEvent.x_root - (double)origin_x[0]);
            eventY = (int)(gdkEvent.y_root - (double)origin_y[0]);
            eventState = gdkEvent.state;
        }
        if ((eventState & 0x100) == 0) {
            return 0L;
        }
        int x = OS.GTK_WIDGET_X(this.handle);
        int y = OS.GTK_WIDGET_Y(this.handle);
        int width = OS.GTK_WIDGET_WIDTH(this.handle);
        int height = OS.GTK_WIDGET_HEIGHT(this.handle);
        int parentBorder = 0;
        int parentWidth = OS.GTK_WIDGET_WIDTH(this.parent.handle);
        int parentHeight = OS.GTK_WIDGET_HEIGHT(this.parent.handle);
        int newX = this.lastX;
        int newY = this.lastY;
        if ((this.style & 0x200) != 0) {
            newX = Math.min(Math.max(0, eventX + x - this.startX - parentBorder), parentWidth - width);
        } else {
            newY = Math.min(Math.max(0, eventY + y - this.startY - parentBorder), parentHeight - height);
        }
        if (newX == this.lastX && newY == this.lastY) {
            return 0L;
        }
        this.drawBand(this.lastX, this.lastY, width, height);
        Event event = new Event();
        event.time = gdkEvent.time;
        event.x = newX;
        event.y = newY;
        event.width = width;
        event.height = height;
        if ((this.style & 0x10000) == 0) {
            event.detail = 1;
        }
        if ((this.parent.style & 0x8000000) != 0) {
            event.x = this.parent.getClientWidth() - width - event.x;
        }
        this.sendSelectionEvent(13, event, true);
        if (this.isDisposed()) {
            return 0L;
        }
        if (event.doit) {
            this.lastX = event.x;
            this.lastY = event.y;
            if ((this.parent.style & 0x8000000) != 0) {
                this.lastX = this.parent.getClientWidth() - width - this.lastX;
            }
        }
        this.parent.update(true, (this.style & 0x10000) == 0);
        this.drawBand(this.lastX, this.lastY, width, height);
        if ((this.style & 0x10000) != 0) {
            this.setBounds(event.x, this.lastY, width, height);
        }
        return result;
    }

    long gtk_realize(long widget) {
        this.setCursor(this.cursor != null ? this.cursor.handle : 0L);
        return super.gtk_realize(widget);
    }

    void hookEvents() {
        super.hookEvents();
        OS.gtk_widget_add_events(this.handle, 8);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.defaultCursor != 0L) {
            OS.gdk_cursor_unref(this.defaultCursor);
        }
        this.defaultCursor = 0L;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void setCursor(long cursor) {
        super.setCursor(cursor != 0L ? cursor : this.defaultCursor);
    }

    int traversalCode(int key, GdkEventKey event) {
        return 0;
    }
}

