/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class ClipboardProxy {
    Display display;
    int shellHandle;
    int atomAtom;
    int clipboardAtom;
    int motifClipboardAtom;
    int primaryAtom;
    int targetsAtom;
    int[][] convertData = new int[10][3];
    Clipboard activeClipboard = null;
    Clipboard activePrimaryClipboard = null;
    Object[] clipboardData;
    Transfer[] clipboardDataTypes;
    Object[] primaryClipboardData;
    Transfer[] primaryClipboardDataTypes;
    boolean done = false;
    Object selectionValue;
    Transfer selectionTransfer;
    Callback XtConvertSelectionCallback;
    Callback XtLoseSelectionCallback;
    Callback XtSelectionDoneCallback;
    Callback XtSelectionCallbackCallback;
    static byte[] ATOM = Converter.wcsToMbcs(null, "ATOM", true);
    static byte[] CLIPBOARD = Converter.wcsToMbcs(null, "CLIPBOARD", true);
    static byte[] PRIMARY = Converter.wcsToMbcs(null, "PRIMARY", true);
    static byte[] TARGETS = Converter.wcsToMbcs(null, "TARGETS", true);
    static byte[] _MOTIF_CLIPBOARD_TARGETS = Converter.wcsToMbcs(null, "_MOTIF_CLIPBOARD_TARGETS", true);
    static String ID = "CLIPBOARD PROXY OBJECT";

    static ClipboardProxy _getInstance(final Display display) {
        ClipboardProxy proxy = (ClipboardProxy)display.getData(ID);
        if (proxy != null) {
            return proxy;
        }
        proxy = new ClipboardProxy(display);
        display.setData(ID, proxy);
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                ClipboardProxy clipbordProxy = (ClipboardProxy)display.getData(ID);
                if (clipbordProxy == null) {
                    return;
                }
                display.setData(ID, null);
                clipbordProxy.dispose();
            }
        });
        return proxy;
    }

    ClipboardProxy(Display display) {
        this.display = display;
        this.XtConvertSelectionCallback = new Callback(this, "XtConvertSelection", 7);
        if (this.XtConvertSelectionCallback.getAddress() == 0) {
            SWT.error(3);
        }
        this.XtLoseSelectionCallback = new Callback(this, "XtLoseSelection", 2);
        if (this.XtLoseSelectionCallback.getAddress() == 0) {
            SWT.error(3);
        }
        this.XtSelectionDoneCallback = new Callback(this, "XtSelectionDone", 3);
        if (this.XtSelectionDoneCallback.getAddress() == 0) {
            SWT.error(3);
        }
        this.XtSelectionCallbackCallback = new Callback(this, "XtSelectionCallback", 7);
        if (this.XtSelectionCallbackCallback.getAddress() == 0) {
            SWT.error(3);
        }
        int widgetClass = OS.topLevelShellWidgetClass();
        this.shellHandle = OS.XtAppCreateShell(null, null, widgetClass, display.xDisplay, null, 0);
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        OS.XtRealizeWidget(this.shellHandle);
        int xDisplay = OS.XtDisplay(this.shellHandle);
        this.atomAtom = OS.XmInternAtom(xDisplay, ATOM, true);
        this.clipboardAtom = OS.XmInternAtom(xDisplay, CLIPBOARD, true);
        this.motifClipboardAtom = OS.XmInternAtom(xDisplay, _MOTIF_CLIPBOARD_TARGETS, true);
        this.primaryAtom = OS.XmInternAtom(xDisplay, PRIMARY, true);
        this.targetsAtom = OS.XmInternAtom(xDisplay, TARGETS, true);
    }

    void clear(Clipboard owner, int clipboards) {
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return;
        }
        if ((clipboards & 1) != 0 && this.activeClipboard == owner) {
            OS.XtDisownSelection(this.shellHandle, this.clipboardAtom, 0);
        }
        if ((clipboards & 2) != 0 && this.activePrimaryClipboard == owner) {
            OS.XtDisownSelection(this.shellHandle, this.primaryAtom, 0);
        }
    }

    void dispose() {
        if (this.display == null) {
            return;
        }
        if (this.shellHandle != 0) {
            OS.XtDestroyWidget(this.shellHandle);
            this.shellHandle = 0;
        }
        if (this.XtConvertSelectionCallback != null) {
            this.XtConvertSelectionCallback.dispose();
        }
        this.XtConvertSelectionCallback = null;
        if (this.XtLoseSelectionCallback != null) {
            this.XtLoseSelectionCallback.dispose();
        }
        this.XtLoseSelectionCallback = null;
        if (this.XtSelectionCallbackCallback != null) {
            this.XtSelectionCallbackCallback.dispose();
        }
        this.XtSelectionCallbackCallback = null;
        if (this.XtSelectionDoneCallback != null) {
            this.XtSelectionDoneCallback.dispose();
        }
        this.XtSelectionDoneCallback = null;
        this.activeClipboard = null;
        this.activePrimaryClipboard = null;
        this.clipboardData = null;
        this.clipboardDataTypes = null;
        this.primaryClipboardData = null;
        this.primaryClipboardDataTypes = null;
    }

    Object getContents(Transfer transfer, int clipboardType) {
        int[] types = this.getAvailableTypes(clipboardType);
        int index = -1;
        TransferData transferData = new TransferData();
        int i = 0;
        while (i < types.length) {
            transferData.type = types[i];
            if (transfer.isSupportedType(transferData)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return null;
        }
        this.done = false;
        this.selectionValue = null;
        this.selectionTransfer = transfer;
        int selection = clipboardType == 1 ? this.clipboardAtom : this.primaryAtom;
        OS.XtGetSelectionValue(this.shellHandle, selection, types[index], this.XtSelectionCallbackCallback.getAddress(), 0, 0);
        if (!this.done) {
            int xDisplay = OS.XtDisplay(this.shellHandle);
            if (xDisplay == 0) {
                return null;
            }
            int xtContext = OS.XtDisplayToApplicationContext(xDisplay);
            int selectionTimeout = OS.XtAppGetSelectionTimeout(xtContext);
            this.wait(selectionTimeout);
        }
        return !this.done ? null : this.selectionValue;
    }

    int[] getAvailableTypes(int clipboardType) {
        int selectionTimeout;
        int xtContext;
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return new int[0];
        }
        this.done = false;
        this.selectionValue = null;
        this.selectionTransfer = null;
        int selection = clipboardType == 1 ? this.clipboardAtom : this.primaryAtom;
        int target = this.targetsAtom;
        OS.XtGetSelectionValue(this.shellHandle, selection, target, this.XtSelectionCallbackCallback.getAddress(), 0, 0);
        if (!this.done) {
            xtContext = OS.XtDisplayToApplicationContext(xDisplay);
            selectionTimeout = OS.XtAppGetSelectionTimeout(xtContext);
            this.wait(selectionTimeout);
        }
        if (this.done && this.selectionValue == null) {
            this.done = false;
            target = this.motifClipboardAtom;
            OS.XtGetSelectionValue(this.shellHandle, selection, target, this.XtSelectionCallbackCallback.getAddress(), 0, 0);
            if (!this.done) {
                xtContext = OS.XtDisplayToApplicationContext(xDisplay);
                selectionTimeout = OS.XtAppGetSelectionTimeout(xtContext);
                this.wait(selectionTimeout);
            }
        }
        if (this.done && this.selectionValue == null) {
            this.done = false;
            target = this.atomAtom;
            OS.XtGetSelectionValue(this.shellHandle, selection, target, this.XtSelectionCallbackCallback.getAddress(), 0, 0);
            if (!this.done) {
                xtContext = OS.XtDisplayToApplicationContext(xDisplay);
                selectionTimeout = OS.XtAppGetSelectionTimeout(xtContext);
                this.wait(selectionTimeout);
            }
        }
        return !this.done || this.selectionValue == null ? new int[]{} : (int[])this.selectionValue;
    }

    void setContents(Clipboard owner, Object[] data, Transfer[] dataTypes, int clipboards) {
        int XtSelectionDoneProc;
        int XtLoseSelectionProc;
        int XtConvertSelectionProc;
        if ((clipboards & 1) != 0) {
            this.clipboardData = data;
            this.clipboardDataTypes = dataTypes;
            XtConvertSelectionProc = this.XtConvertSelectionCallback.getAddress();
            if (!OS.XtOwnSelection(this.shellHandle, this.clipboardAtom, 0, XtConvertSelectionProc, XtLoseSelectionProc = this.XtLoseSelectionCallback.getAddress(), XtSelectionDoneProc = this.XtSelectionDoneCallback.getAddress())) {
                DND.error(2002);
            }
            this.activeClipboard = owner;
        }
        if ((clipboards & 2) != 0) {
            this.primaryClipboardData = data;
            this.primaryClipboardDataTypes = dataTypes;
            XtConvertSelectionProc = this.XtConvertSelectionCallback.getAddress();
            if (!OS.XtOwnSelection(this.shellHandle, this.primaryAtom, 0, XtConvertSelectionProc, XtLoseSelectionProc = this.XtLoseSelectionCallback.getAddress(), XtSelectionDoneProc = this.XtSelectionDoneCallback.getAddress())) {
                DND.error(2002);
            }
            this.activePrimaryClipboard = owner;
        }
    }

    void storePtr(int ptr, int selection, int target) {
        int index = -1;
        int i = 0;
        while (i < this.convertData.length) {
            if (this.convertData[i][0] == 0) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            int[][] newConvertData = new int[this.convertData.length + 4][3];
            System.arraycopy(this.convertData, 0, newConvertData, 0, this.convertData.length);
            index = this.convertData.length;
            this.convertData = newConvertData;
        }
        this.convertData[index][0] = selection;
        this.convertData[index][1] = target;
        this.convertData[index][2] = ptr;
    }

    void wait(int timeout) {
        int xDisplay = OS.XtDisplay(this.shellHandle);
        if (xDisplay == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        Callback checkEventCallback = new Callback(this, "checkEvent", 3);
        int checkEventProc = checkEventCallback.getAddress();
        if (checkEventProc == 0) {
            SWT.error(3);
        }
        int xEvent = OS.XtMalloc(96);
        this.display.timerExec(timeout, new Runnable(){

            public void run() {
            }
        });
        while (!this.done && System.currentTimeMillis() - start < (long)timeout && this.display != null) {
            if (OS.XCheckIfEvent(xDisplay, xEvent, checkEventProc, 0) != 0) {
                OS.XtDispatchEvent(xEvent);
                continue;
            }
            this.display.sleep();
        }
        OS.XtFree(xEvent);
        checkEventCallback.dispose();
    }

    int checkEvent(int display, int event, int arg) {
        XEvent xEvent = new XEvent();
        OS.memmove(xEvent, event, 96);
        switch (xEvent.type) {
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                return 1;
            }
        }
        return 0;
    }

    int XtConvertSelection(int widget, int selection, int target, int type, int value, int length, int format) {
        int selectionAtom = 0;
        if (selection != 0) {
            int[] dest = new int[1];
            OS.memmove(dest, selection, 4);
            selectionAtom = dest[0];
        }
        if (selectionAtom == 0) {
            return 0;
        }
        Transfer[] types = null;
        if (selectionAtom == this.clipboardAtom) {
            types = this.clipboardDataTypes;
        }
        if (selectionAtom == this.primaryAtom) {
            types = this.primaryClipboardDataTypes;
        }
        if (types == null) {
            return 0;
        }
        int targetAtom = 0;
        if (target != 0) {
            int[] dest = new int[1];
            OS.memmove(dest, target, 4);
            targetAtom = dest[0];
        }
        if (targetAtom == this.atomAtom || targetAtom == this.targetsAtom || targetAtom == this.motifClipboardAtom) {
            int[] transferTypes = new int[]{targetAtom};
            int i = 0;
            while (i < types.length) {
                TransferData[] subTypes = types[i].getSupportedTypes();
                int[] newtransferTypes = new int[transferTypes.length + subTypes.length];
                System.arraycopy(transferTypes, 0, newtransferTypes, 0, transferTypes.length);
                int index = transferTypes.length;
                transferTypes = newtransferTypes;
                int j = 0;
                while (j < subTypes.length) {
                    transferTypes[index++] = subTypes[j].type;
                    ++j;
                }
                ++i;
            }
            int ptr = OS.XtMalloc(transferTypes.length * 4);
            this.storePtr(ptr, selectionAtom, targetAtom);
            OS.memmove(ptr, transferTypes, transferTypes.length * 4);
            OS.memmove(type, new int[]{targetAtom}, 4);
            OS.memmove(value, new int[]{ptr}, 4);
            OS.memmove(length, new int[]{transferTypes.length}, 4);
            OS.memmove(format, new int[]{32}, 4);
            return 1;
        }
        TransferData tdata = new TransferData();
        tdata.type = targetAtom;
        int index = -1;
        int i = 0;
        while (i < types.length) {
            if (types[i].isSupportedType(tdata)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return 0;
        }
        Object[] data = selectionAtom == this.clipboardAtom ? this.clipboardData : this.primaryClipboardData;
        types[index].javaToNative(data[index], tdata);
        if (tdata.format < 8 || tdata.format % 8 != 0) {
            OS.XtFree(tdata.pValue);
            return 0;
        }
        OS.memmove(type, new int[]{tdata.type}, 4);
        OS.memmove(value, new int[]{tdata.pValue}, 4);
        OS.memmove(length, new int[]{tdata.length}, 4);
        OS.memmove(format, new int[]{tdata.format}, 4);
        this.storePtr(tdata.pValue, selectionAtom, targetAtom);
        return 1;
    }

    int XtLoseSelection(int widget, int selection) {
        if (selection == this.clipboardAtom) {
            this.activeClipboard = null;
            this.clipboardData = null;
            this.clipboardDataTypes = null;
        }
        if (selection == this.primaryAtom) {
            this.activePrimaryClipboard = null;
            this.primaryClipboardData = null;
            this.primaryClipboardDataTypes = null;
        }
        return 0;
    }

    int XtSelectionCallback(int widget, int client_data, int selection, int type, int value, int length, int format) {
        this.done = true;
        int[] selectionType = new int[1];
        if (type != 0) {
            OS.memmove(selectionType, type, 4);
        }
        if (selectionType[0] == 0) {
            return 0;
        }
        int[] selectionLength = new int[1];
        if (length != 0) {
            OS.memmove(selectionLength, length, 4);
        }
        if (selectionLength[0] == 0) {
            return 0;
        }
        int[] selectionFormat = new int[1];
        if (format != 0) {
            OS.memmove(selectionFormat, format, 4);
        }
        if (selectionType[0] == this.atomAtom || selectionType[0] == this.targetsAtom || selectionType[0] == this.motifClipboardAtom) {
            int[] targets = new int[selectionLength[0]];
            OS.memmove(targets, value, selectionLength[0] * selectionFormat[0] / 8);
            this.selectionValue = targets;
            return 0;
        }
        if (this.selectionTransfer != null) {
            TransferData transferData = new TransferData();
            transferData.type = selectionType[0];
            transferData.length = selectionLength[0];
            transferData.format = selectionFormat[0];
            transferData.pValue = value;
            transferData.result = 1;
            this.selectionValue = this.selectionTransfer.nativeToJava(transferData);
        }
        return 0;
    }

    int XtSelectionDone(int widget, int selection, int target) {
        if (target == 0 || selection == 0) {
            return 0;
        }
        int[] selectionAtom = new int[1];
        OS.memmove(selectionAtom, selection, 4);
        int[] targetAtom = new int[1];
        OS.memmove(targetAtom, target, 4);
        int i = 0;
        while (i < this.convertData.length) {
            if (this.convertData[i][0] == selectionAtom[0] && this.convertData[i][1] == targetAtom[0]) {
                OS.XtFree(this.convertData[i][2]);
                this.convertData[i][2] = 0;
                this.convertData[i][1] = 0;
                this.convertData[i][0] = 0;
                break;
            }
            ++i;
        }
        return 0;
    }
}

