/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XFocusChangeEvent;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.IME;

public class Canvas
extends Composite {
    Caret caret;
    IME ime;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, Canvas.checkStyle(style));
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        this.drawBackground(gc, x, y, width, height, 0, 0);
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    public IME getIME() {
        this.checkWidget();
        return this.ime;
    }

    Caret getIMCaret() {
        return this.caret;
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean allChildren, boolean trim) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        super.redrawWidget(x, y, width, height, redrawAll, allChildren, trim);
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    void releaseChildren(boolean destroy) {
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
        if (this.ime != null) {
            this.ime.release(false);
            this.ime = null;
        }
        super.releaseChildren(destroy);
    }

    void reskinChildren(int flags) {
        if (this.caret != null) {
            this.caret.reskin(flags);
        }
        if (this.ime != null) {
            this.ime.reskin(flags);
        }
        super.reskinChildren(flags);
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        Control control;
        int xDisplay;
        boolean isFocus;
        this.checkWidget();
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - x;
        int deltaY = destY - y;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        if ((xDisplay = OS.XtDisplay(this.handle)) == 0) {
            return;
        }
        int xWindow = OS.XtWindow(this.handle);
        if (xWindow == 0) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNwidth;
        nArray[2] = OS.XmNheight;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (Math.min(x + width, argList[1]) >= Math.max(x, 0) && Math.min(y + height, 0 + argList[3]) >= Math.max(y, 0)) {
            int xEvent = OS.XtMalloc(96);
            OS.XSync(xDisplay, false);
            OS.XSync(xDisplay, false);
            while (OS.XCheckWindowEvent(xDisplay, xWindow, 32768, xEvent)) {
                OS.XtDispatchEvent(xEvent);
            }
            OS.XtFree(xEvent);
        }
        if ((control = this.findBackgroundControl()) == null) {
            control = this;
        }
        if (control.backgroundImage != null) {
            this.redrawWidget(x, y, width, height, false, false, false);
            this.redrawWidget(destX, destY, width, height, false, false, false);
        } else {
            boolean disjoint;
            int xGC = OS.XCreateGC(xDisplay, xWindow, 0, null);
            OS.XCopyArea(xDisplay, xWindow, xWindow, xGC, x, y, width, height, destX, destY);
            OS.XFreeGC(xDisplay, xGC);
            boolean bl2 = disjoint = destX + width < x || x + width < destX || destY + height < y || y + height < destY;
            if (disjoint) {
                OS.XClearArea(xDisplay, xWindow, x, y, width, height, true);
            } else {
                if (deltaX != 0) {
                    int newX = destX - deltaX;
                    if (deltaX < 0) {
                        newX = destX + width;
                    }
                    OS.XClearArea(xDisplay, xWindow, newX, y, Math.abs(deltaX), height, true);
                }
                if (deltaY != 0) {
                    int newY = destY - deltaY;
                    if (deltaY < 0) {
                        newY = destY + height;
                    }
                    OS.XClearArea(xDisplay, xWindow, x, newY, width, Math.abs(deltaY), true);
                }
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            int i = 0;
            while (i < children.length) {
                Control child = children[i];
                Rectangle rect = child.getBounds();
                if (Math.min(x + width, rect.x + rect.width) >= Math.max(x, rect.x) && Math.min(y + height, rect.y + rect.height) >= Math.max(y, rect.y)) {
                    child.setLocation(rect.x + deltaX, rect.y + deltaY);
                }
                ++i;
            }
        }
        if (isFocus) {
            this.caret.setFocus();
        }
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        Caret newCaret = caret;
        Caret oldCaret = this.caret;
        this.caret = newCaret;
        if (this.hasFocus()) {
            if (oldCaret != null) {
                oldCaret.killFocus();
            }
            if (newCaret != null) {
                if (newCaret.isDisposed()) {
                    this.error(5);
                }
                newCaret.setFocus();
            }
        }
    }

    boolean setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        boolean changed = super.setBounds(x, y, width, height, move, resize);
        if (isFocus) {
            this.caret.setFocus();
        }
        return changed;
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    public void setIME(IME ime) {
        this.checkWidget();
        if (ime != null && ime.isDisposed()) {
            this.error(5);
        }
        this.ime = ime;
    }

    int XExposure(int w, int client_data, int call_data, int continue_to_dispatch) {
        boolean isFocus;
        boolean bl = isFocus = this.caret != null && this.caret.isFocusCaret();
        if (isFocus) {
            this.caret.killFocus();
        }
        int result = super.XExposure(w, client_data, call_data, continue_to_dispatch);
        if (isFocus) {
            this.caret.setFocus();
        }
        return result;
    }

    int xFocusIn(XFocusChangeEvent xEvent) {
        int result = super.xFocusIn(xEvent);
        if (this.caret != null) {
            this.caret.setFocus();
        }
        return result;
    }

    int xFocusOut(XFocusChangeEvent xEvent) {
        int result = super.xFocusOut(xEvent);
        if (this.caret != null) {
            this.caret.killFocus();
        }
        return result;
    }
}

