/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.carbon.BitMap;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.PixMap;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int GRAB = 32;
    static final int MOVED = 64;
    static final int RESIZED = 128;
    static final int EXPANDING = 256;
    static final int IGNORE_WHEEL = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int THEME_BACKGROUND = 2048;
    static final int LAYOUT_NEEDED = 4096;
    static final int LAYOUT_CHANGED = 8192;
    static final int LAYOUT_CHILD = 16384;
    static final int RELEASED = 32768;
    static final int DISPOSE_SENT = 65536;
    static final int FOREIGN_HANDLE = 131072;
    static final int DRAG_DETECT = 262144;
    static final int SAFARI_EVENTS_FIX = 524288;
    static final String SAFARI_EVENTS_FIX_KEY = "org.eclipse.swt.internal.safariEventsFix";
    static final String IS_ACTIVE = "org.eclipse.swt.internal.isActive";
    static final int SKIN_NEEDED = 0x100000;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final Rect EMPTY_RECT = new Rect();

    Widget() {
    }

    public Widget(Widget parent, int style) {
        this.checkSubclass();
        this.checkParent(parent);
        this.style = style;
        this.display = parent.display;
        this.reskinWidget();
    }

    int actionProc(int theControl, int partCode) {
        return -9874;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(eventType, listener);
    }

    void _addListener(int eventType, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        return OS.CallNextEventHandler(nextHandler, theEvent);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(12, typedListener);
    }

    static int checkBits(int style, int int0, int int1, int int2, int int3, int int4, int int5) {
        int mask = int0 | int1 | int2 | int3 | int4 | int5;
        if ((style & mask) == 0) {
            style |= int0;
        }
        if ((style & int0) != 0) {
            style = style & ~mask | int0;
        }
        if ((style & int1) != 0) {
            style = style & ~mask | int1;
        }
        if ((style & int2) != 0) {
            style = style & ~mask | int2;
        }
        if ((style & int3) != 0) {
            style = style & ~mask | int3;
        }
        if ((style & int4) != 0) {
            style = style & ~mask | int4;
        }
        if ((style & int5) != 0) {
            style = style & ~mask | int5;
        }
        return style;
    }

    void calculateVisibleRegion(int control, int visibleRgn, boolean clipChildren) {
        int tempRgn = OS.NewRgn();
        if (OS.IsControlVisible(control)) {
            int childRgn = OS.NewRgn();
            int window = OS.GetControlOwner(control);
            short[] count = new short[1];
            int[] outControl = new int[1];
            OS.GetRootControl(window, outControl);
            int root = outControl[0];
            OS.GetControlRegion(root, (short)-1, visibleRgn);
            int tempControl = control;
            int lastControl = 0;
            while (tempControl != root) {
                OS.GetControlRegion(tempControl, (short)-1, tempRgn);
                OS.HIViewConvertRegion(tempRgn, tempControl, root);
                OS.SectRgn(tempRgn, visibleRgn, visibleRgn);
                if (OS.EmptyRgn(visibleRgn)) break;
                if (clipChildren || tempControl != control) {
                    OS.CountSubControls(tempControl, count);
                    int i = 0;
                    while (i < count[0]) {
                        OS.GetIndexedSubControl(tempControl, (short)(count[0] - i), outControl);
                        int child = outControl[0];
                        if (child == lastControl) break;
                        if (OS.IsControlVisible(child)) {
                            OS.GetControlRegion(child, (short)-1, tempRgn);
                            OS.HIViewConvertRegion(tempRgn, child, root);
                            OS.UnionRgn(tempRgn, childRgn, childRgn);
                        }
                        ++i;
                    }
                }
                lastControl = tempControl;
                OS.GetSuperControl(tempControl, outControl);
                tempControl = outControl[0];
            }
            OS.DiffRgn(visibleRgn, childRgn, visibleRgn);
            OS.DisposeRgn(childRgn);
        } else {
            OS.CopyRgn(tempRgn, visibleRgn);
        }
        OS.DisposeRgn(tempRgn);
    }

    void checkOpen() {
    }

    void checkOrientation(Widget parent) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && parent != null) {
            if ((parent.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((parent.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkParent(Widget parent) {
        if (parent == null) {
            this.error(4);
        }
        if (parent.isDisposed()) {
            this.error(5);
        }
        parent.checkWidget();
        parent.checkOpen();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    int colorProc(int inControl, int inMessage, int inDrawDepth, int inDrawInColor) {
        return -9874;
    }

    boolean contains(int shellX, int shellY) {
        return true;
    }

    int clockProc(int nextHandler, int theEvent, int userData) {
        int kind = OS.GetEventKind(theEvent);
        switch (kind) {
            case 1: {
                return this.kEventClockDateOrTimeChanged(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int controlProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 9: {
                return this.kEventControlActivate(nextHandler, theEvent, userData);
            }
            case 5: {
                return this.kEventControlApplyBackground(nextHandler, theEvent, userData);
            }
            case 154: {
                return this.kEventControlBoundsChanged(nextHandler, theEvent, userData);
            }
            case 13: {
                return this.kEventControlClick(nextHandler, theEvent, userData);
            }
            case 12: {
                return this.kEventControlContextualMenuClick(nextHandler, theEvent, userData);
            }
            case 10: {
                return this.kEventControlDeactivate(nextHandler, theEvent, userData);
            }
            case 4: {
                return this.kEventControlDraw(nextHandler, theEvent, userData);
            }
            case 101: {
                return this.kEventControlGetPartRegion(nextHandler, theEvent, userData);
            }
            case 1: {
                return this.kEventControlHit(nextHandler, theEvent, userData);
            }
            case 11: {
                return this.kEventControlSetCursor(nextHandler, theEvent, userData);
            }
            case 7: {
                return this.kEventControlSetFocusPart(nextHandler, theEvent, userData);
            }
            case 51: {
                return this.kEventControlTrack(nextHandler, theEvent, userData);
            }
            case 8: {
                return this.kEventControlGetFocusPart(nextHandler, theEvent, userData);
            }
            case 3: {
                return this.kEventControlHitTest(nextHandler, theEvent, userData);
            }
            case 17: {
                return this.kEventControlGetClickActivation(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int accessibilityProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                return this.kEventAccessibleGetChildAtPoint(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventAccessibleGetFocusedChild(nextHandler, theEvent, userData);
            }
            case 21: {
                return this.kEventAccessibleGetAllAttributeNames(nextHandler, theEvent, userData);
            }
            case 22: {
                return this.kEventAccessibleGetNamedAttribute(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void copyToClipboard(char[] chars) {
        if (chars.length == 0) {
            return;
        }
        OS.ClearCurrentScrap();
        int[] scrap = new int[1];
        OS.GetCurrentScrap(scrap);
        int cfstring = OS.CFStringCreateWithCharacters(0, chars, chars.length);
        if (cfstring == 0) {
            return;
        }
        byte[] buffer = null;
        try {
            CFRange range = new CFRange();
            range.length = chars.length;
            int[] size = new int[1];
            int numChars = OS.CFStringGetBytes(cfstring, range, 256, (byte)63, false, null, 0, size);
            if (numChars == 0) {
                return;
            }
            buffer = new byte[size[0]];
            numChars = OS.CFStringGetBytes(cfstring, range, 256, (byte)63, false, buffer, size[0], size);
            if (numChars == 0) {
                return;
            }
            OS.PutScrapFlavor(scrap[0], 1970567284, 0, buffer.length, buffer);
            numChars = OS.CFStringGetBytes(cfstring, range, OS.CFStringGetSystemEncoding(), (byte)63, false, null, 0, size);
            if (numChars == 0) {
                return;
            }
            buffer = new byte[size[0]];
            numChars = OS.CFStringGetBytes(cfstring, range, OS.CFStringGetSystemEncoding(), (byte)63, false, buffer, size[0], size);
            if (numChars == 0) {
                return;
            }
            OS.PutScrapFlavor(scrap[0], 0x54455854, 0, buffer.length, buffer);
            return;
        }
        finally {
            OS.CFRelease(cfstring);
        }
    }

    int createCIcon(Image image) {
        int imageHandle = image.handle;
        int width = OS.CGImageGetWidth(imageHandle);
        int height = OS.CGImageGetHeight(imageHandle);
        int bpr = OS.CGImageGetBytesPerRow(imageHandle);
        int bpp = OS.CGImageGetBitsPerPixel(imageHandle);
        int bpc = OS.CGImageGetBitsPerComponent(imageHandle);
        int alphaInfo = OS.CGImageGetAlphaInfo(imageHandle);
        int maskBpl = ((width + 7) / 8 + 3) / 4 * 4;
        int maskSize = height * maskBpl;
        int pixmapSize = height * bpr;
        int iconSize = 82 + maskSize;
        int iconHandle = OS.NewHandle(iconSize);
        if (iconHandle == 0) {
            SWT.error(2);
        }
        OS.HLock(iconHandle);
        int[] iconPtr = new int[1];
        OS.memmove(iconPtr, iconHandle, 4);
        PixMap iconPMap = new PixMap();
        iconPMap.rowBytes = (short)(bpr | 0x8000);
        iconPMap.right = (short)width;
        iconPMap.bottom = (short)height;
        iconPMap.cmpCount = (short)3;
        iconPMap.cmpSize = (short)bpc;
        iconPMap.pmTable = OS.NewHandle(0);
        iconPMap.hRes = 0x480000;
        iconPMap.vRes = 0x480000;
        iconPMap.pixelType = (short)16;
        iconPMap.pixelSize = (short)bpp;
        iconPMap.pixelFormat = (short)bpp;
        OS.memmove(iconPtr[0], iconPMap, 50);
        BitMap iconMask = new BitMap();
        iconMask.rowBytes = (short)maskBpl;
        iconMask.right = (short)width;
        iconMask.bottom = (short)height;
        OS.memmove(iconPtr[0] + 50, iconMask, 14);
        int iconData = OS.NewHandle(pixmapSize);
        OS.HLock(iconData);
        int[] iconDataPtr = new int[1];
        OS.memmove(iconDataPtr, iconData, 4);
        OS.memmove(iconDataPtr[0], image.data, pixmapSize);
        OS.HUnlock(iconData);
        OS.memmove(iconPtr[0] + 50 + 28, new int[]{iconData}, 4);
        if (alphaInfo != 4) {
            OS.memset(iconPtr[0] + 50 + 28 + 4, -1, maskSize);
        } else {
            byte[] srcData = new byte[pixmapSize];
            OS.memmove(srcData, image.data, pixmapSize);
            byte[] maskData = new byte[maskSize];
            int offset = 0;
            int maskOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if ((srcData[offset] & 0xFF) > 128) {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] | 1 << 7 - (x & 7));
                    } else {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] & ~(1 << 7 - (x & 7)));
                    }
                    offset += 4;
                    ++x;
                }
                maskOffset += maskBpl;
                ++y;
            }
            OS.memmove(iconPtr[0] + 50 + 28 + 4, maskData, maskData.length);
        }
        OS.HUnlock(iconHandle);
        return iconHandle;
    }

    void createHandle() {
    }

    int createIconRef(Image image) {
        int dataHandle;
        int dataSize;
        int imageHandle = image.handle;
        int imageData = image.data;
        int width = OS.CGImageGetWidth(imageHandle);
        int height = OS.CGImageGetHeight(imageHandle);
        int bpr = OS.CGImageGetBytesPerRow(imageHandle);
        int alphaInfo = OS.CGImageGetAlphaInfo(imageHandle);
        int type = 0;
        int maskType = 0;
        if (width == 16 && height == 16) {
            type = 1769157426;
            maskType = 1933077867;
        } else if (width == 32 && height == 32) {
            type = 1768698674;
            maskType = 1815637355;
        } else if (width == 48 && height == 48) {
            type = 1768436530;
            maskType = 1748528491;
        } else if (width == 128 && height == 128) {
            type = 1769222962;
            maskType = 1949855083;
        } else {
            int colorspace;
            type = 1769157426;
            maskType = 1933077867;
            int size = 16;
            if (width > 16 || height > 16) {
                type = 1768436530;
                maskType = 1748528491;
                size = 32;
            }
            if (width > 32 || height > 32) {
                type = 1768436530;
                maskType = 1748528491;
                size = 48;
            }
            if (width > 48 || height > 48) {
                type = 1769222962;
                maskType = 1949855083;
                size = 128;
            }
            if ((imageData = OS.NewPtr(dataSize = height * (bpr = (width = (height = size)) * 4))) == 0) {
                SWT.error(2);
            }
            if ((colorspace = OS.CGColorSpaceCreateDeviceRGB()) == 0) {
                SWT.error(2);
            }
            int context = OS.CGBitmapContextCreate(imageData, width, height, 8, bpr, colorspace, 6);
            OS.CGColorSpaceRelease(colorspace);
            if (context == 0) {
                SWT.error(2);
            }
            CGRect rect = new CGRect();
            rect.width = width;
            rect.height = height;
            OS.CGContextDrawImage(context, rect, imageHandle);
            OS.CGContextRelease(context);
        }
        if (type == 0) {
            return 0;
        }
        int iconFamily = OS.NewHandle(0);
        if (iconFamily == 0) {
            SWT.error(2);
        }
        if ((dataHandle = OS.NewHandle(dataSize = height * bpr)) == 0) {
            SWT.error(2);
        }
        int[] dataPtr = new int[1];
        OS.HLock(dataHandle);
        OS.memmove(dataPtr, dataHandle, 4);
        OS.memmove(dataPtr[0], imageData, dataSize);
        OS.HUnlock(dataHandle);
        OS.SetIconFamilyData(iconFamily, type, dataHandle);
        OS.DisposeHandle(dataHandle);
        int maskSize = width * height;
        int maskHandle = OS.NewHandle(maskSize);
        if (maskHandle == 0) {
            SWT.error(2);
        }
        OS.HLock(maskHandle);
        int[] maskPtr = new int[1];
        OS.memmove(maskPtr, maskHandle, 4);
        if (alphaInfo != 4) {
            OS.memset(maskPtr[0], 255, maskSize);
        } else {
            byte[] srcData = new byte[dataSize];
            OS.memmove(srcData, imageData, dataSize);
            byte[] maskData = new byte[maskSize];
            int offset = 0;
            int maskOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    maskData[maskOffset++] = srcData[offset];
                    offset += 4;
                    ++x;
                }
                ++y;
            }
            OS.memmove(maskPtr[0], maskData, maskData.length);
        }
        OS.HUnlock(maskHandle);
        OS.SetIconFamilyData(iconFamily, maskType, maskHandle);
        OS.DisposeHandle(maskHandle);
        if (imageData != image.data) {
            OS.DisposePtr(imageData);
        }
        int[] iconRef = new int[1];
        OS.HLock(iconFamily);
        int[] iconPtr = new int[1];
        OS.memmove(iconPtr, iconFamily, 4);
        OS.GetIconRefFromIconFamilyPtr(iconPtr[0], OS.GetHandleSize(iconFamily), iconRef);
        OS.HUnlock(iconFamily);
        OS.DisposeHandle(iconFamily);
        return iconRef[0];
    }

    void createWidget() {
        this.createHandle();
        this.register();
        this.hookEvents();
    }

    int commandProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                return this.kEventProcessCommand(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    void deregister() {
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    void destroyCIcon(int iconHandle) {
        OS.HLock(iconHandle);
        int[] iconPtr = new int[1];
        OS.memmove(iconPtr, iconHandle, 4);
        PixMap iconPMap = new PixMap();
        OS.memmove(iconPMap, iconPtr[0], 50);
        if (iconPMap.pmTable != 0) {
            OS.DisposeHandle(iconPMap.pmTable);
        }
        int[] iconData = new int[1];
        OS.memmove(iconData, iconPtr[0] + 50 + 28, 4);
        if (iconData[0] != 0) {
            OS.DisposeHandle(iconData[0]);
        }
        OS.HUnlock(iconHandle);
        OS.DisposeHandle(iconHandle);
    }

    int drawItemProc(int browser, int item, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        return 0;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    void drawBackground(int control, int context) {
    }

    void drawWidget(int control, int context, int damageRgn, int visibleRgn, int theEvent) {
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filters(int eventType) {
        return this.display.filters(eventType);
    }

    int fixMnemonic(char[] buffer) {
        int i = 0;
        int j = 0;
        while (i < buffer.length) {
            if ((buffer[j++] = buffer[i++]) != '&' || i == buffer.length) continue;
            if (buffer[i] == '&') {
                ++i;
                continue;
            }
            --j;
        }
        return j;
    }

    String getClipboardText() {
        int encoding;
        int cfstring;
        byte[] buffer;
        String result = "";
        int[] scrap = new int[1];
        OS.GetCurrentScrap(scrap);
        int[] size = new int[1];
        if (OS.GetScrapFlavorSize(scrap[0], 1970567284, size) == 0) {
            int encoding2;
            int cfstring2;
            byte[] buffer2;
            if (size[0] != 0 && OS.GetScrapFlavorData(scrap[0], 1970567284, size, buffer2 = new byte[size[0]]) == 0 && (cfstring2 = OS.CFStringCreateWithBytes(0, buffer2, buffer2.length, encoding2 = 256, false)) != 0) {
                int length = OS.CFStringGetLength(cfstring2);
                if (length != 0) {
                    char[] chars = new char[length];
                    CFRange range = new CFRange();
                    range.length = length;
                    OS.CFStringGetCharacters(cfstring2, range, chars);
                    result = new String(chars);
                }
                OS.CFRelease(cfstring2);
            }
        } else if (OS.GetScrapFlavorSize(scrap[0], 0x54455854, size) == 0 && size[0] != 0 && OS.GetScrapFlavorData(scrap[0], 0x54455854, size, buffer = new byte[size[0]]) == 0 && (cfstring = OS.CFStringCreateWithBytes(0, buffer, buffer.length, encoding = OS.CFStringGetSystemEncoding(), false)) != 0) {
            int length = OS.CFStringGetLength(cfstring);
            if (length != 0) {
                char[] chars = new char[length];
                CFRange range = new CFRange();
                range.length = length;
                OS.CFStringGetCharacters(cfstring, range, chars);
                result = new String(chars);
            }
            OS.CFRelease(cfstring);
        }
        return result;
    }

    Rectangle getControlBounds(int control) {
        CGRect rect = new CGRect();
        OS.HIViewGetFrame(control, rect);
        Rect inset = this.getInset();
        rect.x -= (float)inset.left;
        rect.y -= (float)inset.top;
        rect.width += (float)(inset.right + inset.left);
        rect.height += (float)(inset.bottom + inset.top);
        return new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
    }

    Point getControlSize(int control) {
        CGRect rect = new CGRect();
        OS.HIViewGetFrame(control, rect);
        Rect inset = this.getInset();
        int width = (int)rect.width + inset.left + inset.right;
        int height = (int)rect.height + inset.top + inset.bottom;
        return new Point(width, height);
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String key) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(IS_ACTIVE)) {
            return new Boolean(this.isActive());
        }
        if ((this.state & 4) != 0) {
            Object[] table = (Object[])this.data;
            int i = 1;
            while (i < table.length) {
                if (key.equals(table[i])) {
                    return table[i + 1];
                }
                i += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    boolean getDrawing() {
        return true;
    }

    Rect getInset() {
        return EMPTY_RECT;
    }

    public Listener[] getListeners(int eventType) {
        this.checkWidget();
        if (this.eventTable == null) {
            return new Listener[0];
        }
        return this.eventTable.getListeners(eventType);
    }

    String getName() {
        String string = this.getClass().getName();
        int index = string.lastIndexOf(46);
        if (index == -1) {
            return string;
        }
        return string.substring(index + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    int getVisibleRegion(int control, boolean clipChildren) {
        int visibleRgn = OS.NewRgn();
        this.calculateVisibleRegion(control, visibleRgn, clipChildren);
        return visibleRgn;
    }

    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        return -9874;
    }

    int hitTestProc(int browser, int item, int property, int theRect, int mouseRect) {
        return 1;
    }

    void hookEvents() {
    }

    boolean hooks(int eventType) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(eventType);
    }

    void invalidateVisibleRegion(int control) {
    }

    void invalWindowRgn(int window, int rgn) {
        OS.InvalWindowRgn(window, rgn);
    }

    boolean isActive() {
        return true;
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    boolean isDrawing() {
        return true;
    }

    boolean isEnabled() {
        return true;
    }

    public boolean isListening(int eventType) {
        this.checkWidget();
        return this.hooks(eventType);
    }

    boolean isTrimHandle(int trimHandle) {
        return false;
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    int itemCompareProc(int browser, int itemOne, int itemTwo, int sortProperty) {
        return 0;
    }

    int itemDataProc(int browser, int item, int property, int itemData, int setValue) {
        return 0;
    }

    int itemNotificationProc(int browser, int item, int message) {
        return 0;
    }

    int kEventAccessibleGetChildAtPoint(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventAccessibleGetFocusedChild(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventAccessibleGetAllAttributeNames(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventProcessCommand(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventClockDateOrTimeChanged(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlApplyBackground(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlActivate(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlBoundsChanged(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlClick(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlContextualMenuClick(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlDeactivate(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlDraw(int nextHandler, int theEvent, int userData) {
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1668575852, null, 4, null, theControl);
        int[] region = new int[1];
        OS.GetEventParameter(theEvent, 1919381096, 1919381096, null, 4, null, region);
        Display display = this.display;
        boolean oldInPaint = display.inPaint;
        display.inPaint = true;
        int[] context = new int[1];
        OS.GetEventParameter(theEvent, 1668183160, 1668183160, null, 4, null, context);
        int visibleRgn = region[0];
        this.drawBackground(theControl[0], context[0]);
        this.callPaintEventHandler(theControl[0], region[0], visibleRgn, theEvent, nextHandler);
        this.drawWidget(theControl[0], context[0], region[0], visibleRgn, theEvent);
        display.inPaint = oldInPaint;
        return 0;
    }

    int kEventControlGetClickActivation(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlGetFocusPart(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlGetPartRegion(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlHit(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlHitTest(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlSetFocusPart(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventControlTrack(int nextHandler, int theEvent, int userData) {
        int[] theControl = new int[1];
        OS.GetEventParameter(theEvent, 0x2D2D2D2D, 1668575852, null, 4, null, theControl);
        OS.CFRetain(theControl[0]);
        int result = OS.CallNextEventHandler(nextHandler, theEvent);
        OS.CFRelease(theControl[0]);
        return result;
    }

    int kEventMenuCalculateSize(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuClosed(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuCreateFrameView(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuDrawItem(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuDrawItemContent(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuGetFrameBounds(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuMatchKey(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuMeasureItemWidth(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuOpening(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMenuTargetItem(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseDragged(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseMoved(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseUp(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventMouseWheelMoved(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventSearchFieldCancelClicked(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventSearchFieldSearchClicked(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventRawKeyDown(int nextHandler, int theEvent, int userData) {
        return this.kEventRawKeyPressed(nextHandler, theEvent, userData);
    }

    int kEventRawKeyModifiersChanged(int nextHandler, int theEvent, int userData) {
        Event event;
        Display display = this.display;
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, modifiers.length * 4, null, modifiers);
        int lastModifiers = display.lastModifiers;
        int chord = OS.GetCurrentEventButtonState();
        int type = 2;
        if ((modifiers[0] & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x200) != 0 && (lastModifiers & 0x200) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x1000) != 0 && (lastModifiers & 0x1000) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x100) != 0 && (lastModifiers & 0x100) == 0) {
            type = 1;
        }
        if ((modifiers[0] & 0x800) != 0 && (lastModifiers & 0x800) == 0) {
            type = 1;
        }
        if (type == 2 && (modifiers[0] & 0x400) == 0 && (lastModifiers & 0x400) != 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 1, chord, modifiers[0]);
            this.sendKeyEvent(1, event);
        }
        event = new Event();
        this.setInputState(event, type, chord, modifiers[0]);
        if (event.keyCode == 0 && event.character == '\u0000') {
            return -9874;
        }
        boolean result = this.sendKeyEvent(type, event);
        if (type == 1 && (modifiers[0] & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
            event = new Event();
            event.keyCode = 16777298;
            this.setInputState(event, 2, chord, modifiers[0]);
            this.sendKeyEvent(2, event);
        }
        display.lastModifiers = modifiers[0];
        return result ? -9874 : 0;
    }

    int kEventRawKeyPressed(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventRawKeyRepeat(int nextHandler, int theEvent, int userData) {
        return this.kEventRawKeyPressed(nextHandler, theEvent, userData);
    }

    int kEventRawKeyUp(int nextHandler, int theEvent, int userData) {
        if (!this.sendKeyEvent(2, theEvent)) {
            return 0;
        }
        return -9874;
    }

    int kEventTextInputUnicodeForKeyEvent(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventTextInputUpdateActiveInputArea(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventTextInputOffsetToPos(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventTextInputPosToOffset(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventTextInputGetSelectedText(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowActivated(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowBoundsChanged(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowClose(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowCollapsed(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowCollapsing(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowDeactivated(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowDrawContent(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowExpanded(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowGetClickModality(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowGetRegion(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowHidden(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowHitTest(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowShown(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowUpdate(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int kEventWindowZoom(int nextHandler, int theEvent, int userData) {
        return -9874;
    }

    int keyboardProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                return this.kEventRawKeyDown(nextHandler, theEvent, userData);
            }
            case 4: {
                return this.kEventRawKeyModifiersChanged(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventRawKeyRepeat(nextHandler, theEvent, userData);
            }
            case 3: {
                return this.kEventRawKeyUp(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int menuProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1004: {
                return this.kEventMenuCalculateSize(nextHandler, theEvent, userData);
            }
            case 5: {
                return this.kEventMenuClosed(nextHandler, theEvent, userData);
            }
            case 1005: {
                return this.kEventMenuCreateFrameView(nextHandler, theEvent, userData);
            }
            case 102: {
                return this.kEventMenuDrawItem(nextHandler, theEvent, userData);
            }
            case 103: {
                return this.kEventMenuDrawItemContent(nextHandler, theEvent, userData);
            }
            case 1006: {
                return this.kEventMenuGetFrameBounds(nextHandler, theEvent, userData);
            }
            case 7: {
                return this.kEventMenuMatchKey(nextHandler, theEvent, userData);
            }
            case 100: {
                return this.kEventMenuMeasureItemWidth(nextHandler, theEvent, userData);
            }
            case 4: {
                return this.kEventMenuOpening(nextHandler, theEvent, userData);
            }
            case 6: {
                return this.kEventMenuTargetItem(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    int mouseProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 1: {
                return this.kEventMouseDown(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventMouseUp(nextHandler, theEvent, userData);
            }
            case 6: {
                return this.kEventMouseDragged(nextHandler, theEvent, userData);
            }
            case 5: {
                return this.kEventMouseMoved(nextHandler, theEvent, userData);
            }
            case 10: {
                return this.kEventMouseWheelMoved(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    public void notifyListeners(int eventType, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(eventType, event);
    }

    void postEvent(int eventType) {
        this.sendEvent(eventType, null, false);
    }

    void postEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, false);
    }

    void redrawChildren(int control) {
        int child = OS.HIViewGetFirstSubview(control);
        while (child != 0) {
            OS.HIViewSetNeedsDisplay(child, true);
            this.redrawChildren(child);
            child = OS.HIViewGetNextView(child);
        }
    }

    void redrawChildren(int control, int rgn) {
        int child = OS.HIViewGetFirstSubview(control);
        while (child != 0) {
            OS.HIViewConvertRegion(rgn, control, child);
            OS.HIViewSetNeedsDisplayInRegion(child, rgn, true);
            this.redrawChildren(child, rgn);
            OS.HIViewConvertRegion(rgn, child, control);
            child = OS.HIViewGetNextView(child);
        }
    }

    void redrawWidget(int control, boolean children) {
        if (this.display.inPaint) {
            int rgn = OS.NewRgn();
            Rect rect = new Rect();
            OS.GetControlBounds(control, rect);
            rect.right = (short)(rect.right + rect.left);
            rect.bottom = (short)(rect.bottom + rect.top);
            rect.left = 0;
            rect.top = 0;
            OS.RectRgn(rgn, rect);
            OS.HIViewConvertRegion(rgn, control, 0);
            this.invalWindowRgn(0, rgn);
            OS.DisposeRgn(rgn);
        } else {
            OS.HIViewSetNeedsDisplay(control, true);
            if (children) {
                this.redrawChildren(control);
            }
        }
    }

    void redrawWidget(int control, int x, int y, int width, int height, boolean children) {
        int rgn = OS.NewRgn();
        Rect rect = new Rect();
        OS.SetRect(rect, (short)x, (short)y, (short)(x + width), (short)(y + height));
        OS.RectRgn(rgn, rect);
        if (this.display.inPaint) {
            OS.HIViewConvertRegion(rgn, control, 0);
            this.invalWindowRgn(0, rgn);
        } else {
            OS.HIViewSetNeedsDisplayInRegion(control, rgn, true);
            if (children) {
                this.redrawChildren(control, rgn);
            }
        }
        OS.DisposeRgn(rgn);
    }

    void register() {
    }

    void release(boolean destroy) {
        if ((this.state & 0x10000) == 0) {
            this.state |= 0x10000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(destroy);
        }
        if ((this.state & 0x8000) == 0) {
            this.state |= 0x8000;
            if (destroy) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean destroy) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.deregister();
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int eventType, Listener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    protected void removeListener(int eventType, SWTEventListener handler) {
        this.checkWidget();
        if (handler == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, handler);
    }

    public void reskin(int flags) {
        this.checkWidget();
        this.reskinWidget();
        if ((flags & 1) != 0) {
            this.reskinChildren(flags);
        }
    }

    void reskinChildren(int flags) {
    }

    void reskinWidget() {
        if ((this.state & 0x100000) != 0x100000) {
            this.state |= 0x100000;
            this.display.addSkinnableWidget(this);
        }
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, listener);
    }

    int searchProc(int nextHandler, int theEvent, int userData) {
        int kind = OS.GetEventKind(theEvent);
        switch (kind) {
            case 1: {
                return this.kEventSearchFieldCancelClicked(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventSearchFieldSearchClicked(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int eventType) {
        this.sendEvent(eventType, null, true);
    }

    void sendEvent(int eventType, Event event) {
        this.sendEvent(eventType, event, true);
    }

    void sendEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = eventType;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (send) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int type, int theEvent) {
        if ((this.state & 0x80000) != 0) {
            return true;
        }
        int[] length = new int[1];
        int status = OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 4, length, null);
        if (status == 0 && length[0] > 2) {
            int count = 0;
            int[] chord = new int[1];
            OS.GetEventParameter(theEvent, 1667788658, 1835100014, null, 4, null, chord);
            int[] modifiers = new int[1];
            OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
            char[] chars = new char[length[0] / 2];
            OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, chars.length * 2, null, chars);
            int i = 0;
            while (i < chars.length) {
                Event event = new Event();
                event.character = chars[i];
                this.setInputState(event, type, chord[0], modifiers[0]);
                if (this.sendKeyEvent(type, event)) {
                    chars[count++] = chars[i];
                }
                ++i;
            }
            if (count == 0) {
                return false;
            }
            if (count != chars.length - 1) {
                OS.SetEventParameter(theEvent, 1802858089, 1970567284, count * 2, chars);
            }
            return true;
        }
        Event event = new Event();
        if (!this.setKeyState(event, type, theEvent)) {
            return true;
        }
        return this.sendKeyEvent(type, event);
    }

    boolean sendKeyEvent(int type, Event event) {
        this.sendEvent(type, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendSelectionEvent(int eventType) {
        this.sendSelectionEvent(eventType, null, false);
    }

    void sendSelectionEvent(int eventType, Event event, boolean send) {
        if (this.eventTable == null && !this.display.filters(eventType)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        int chord = OS.GetCurrentEventButtonState();
        int modifiers = OS.GetCurrentEventKeyModifiers();
        this.setInputState(event, eventType, chord, modifiers);
        this.sendEvent(eventType, event, send);
    }

    int setBounds(int control, int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int parent;
        boolean sameOrigin = true;
        boolean sameExtent = true;
        CGRect oldBounds = new CGRect();
        OS.HIViewGetFrame(control, oldBounds);
        Rect inset = this.getInset();
        oldBounds.x -= (float)inset.left;
        oldBounds.y -= (float)inset.top;
        oldBounds.width += (float)(inset.left + inset.right);
        oldBounds.height += (float)(inset.top + inset.bottom);
        if (!move) {
            x = (int)oldBounds.x;
            y = (int)oldBounds.y;
        }
        if (!resize) {
            width = (int)oldBounds.width;
            height = (int)oldBounds.height;
        }
        CGRect newBounds = new CGRect();
        newBounds.x = x + inset.left;
        newBounds.y = y + inset.top;
        newBounds.width = width - inset.right - inset.left;
        newBounds.height = height - inset.bottom - inset.top;
        sameOrigin = newBounds.x == oldBounds.x && newBounds.y == oldBounds.y;
        boolean bl = sameExtent = newBounds.width == oldBounds.width && newBounds.height == oldBounds.height;
        if (sameOrigin && sameExtent) {
            return 0;
        }
        OS.HIViewSetFrame(control, newBounds);
        this.invalidateVisibleRegion(control);
        if (!OS.HIViewIsDrawingEnabled(control) && (parent = OS.HIViewGetSuperview(control)) != 0 && OS.HIViewIsDrawingEnabled(parent)) {
            int rgn = OS.NewRgn();
            Rect rect = new Rect();
            OS.SetRect(rect, (short)oldBounds.x, (short)oldBounds.y, (short)(oldBounds.x + oldBounds.width), (short)(oldBounds.y + oldBounds.height));
            OS.RectRgn(rgn, rect);
            if (this.display.inPaint) {
                OS.HIViewConvertRegion(rgn, parent, 0);
                this.invalWindowRgn(0, rgn);
            } else {
                OS.HIViewSetNeedsDisplayInRegion(parent, rgn, true);
            }
            OS.DisposeRgn(rgn);
        }
        int result = 0;
        if (move && !sameOrigin) {
            if (events) {
                this.sendEvent(10);
            }
            result |= 0x40;
        }
        if (resize && !sameExtent) {
            if (events) {
                this.sendEvent(11);
            }
            result |= 0x80;
        }
        return result;
    }

    public void setData(Object data) {
        this.checkWidget();
        if (SAFARI_EVENTS_FIX_KEY.equals(data)) {
            this.state |= 0x80000;
            return;
        }
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = data;
        } else {
            this.data = data;
        }
    }

    public void setData(String key, Object value) {
        this.checkWidget();
        if (key == null) {
            this.error(4);
        }
        int index = 1;
        Object[] table = null;
        if ((this.state & 4) != 0) {
            table = (Object[])this.data;
            while (index < table.length) {
                if (key.equals(table[index])) break;
                index += 2;
            }
        }
        if (value != null) {
            if ((this.state & 4) != 0) {
                if (index == table.length) {
                    Object[] newTable = new Object[table.length + 2];
                    System.arraycopy(table, 0, newTable, 0, table.length);
                    table = newTable;
                    this.data = newTable;
                }
            } else {
                table = new Object[3];
                table[0] = this.data;
                this.data = table;
                this.state |= 4;
            }
            table[index] = key;
            table[index + 1] = value;
        } else if ((this.state & 4) != 0 && index != table.length) {
            int length = table.length - 2;
            if (length == 1) {
                this.data = table[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] newTable = new Object[length];
                System.arraycopy(table, 0, newTable, 0, index);
                System.arraycopy(table, index + 2, newTable, index, length - index);
                this.data = newTable;
            }
        }
        if (key.equals("org.eclipse.swt.skin.class") || key.equals("org.eclipse.swt.skin.id")) {
            this.reskin(1);
        }
    }

    boolean setInputState(Event event, int type, int chord, int modifiers) {
        if ((chord & 1) != 0) {
            event.stateMask |= 0x80000;
        }
        if ((chord & 2) != 0) {
            event.stateMask |= 0x200000;
        }
        if ((chord & 4) != 0) {
            event.stateMask |= 0x100000;
        }
        if ((chord & 8) != 0) {
            event.stateMask |= 0x800000;
        }
        if ((chord & 0x10) != 0) {
            event.stateMask |= 0x2000000;
        }
        if ((modifiers & 0x800) != 0) {
            event.stateMask |= 0x10000;
        }
        if ((modifiers & 0x200) != 0) {
            event.stateMask |= 0x20000;
        }
        if ((modifiers & 0x1000) != 0) {
            event.stateMask |= 0x40000;
        }
        if ((modifiers & 0x100) != 0) {
            event.stateMask |= 0x400000;
        }
        switch (type) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode != 0 || event.character != '\u0000') {
                    return true;
                }
                int lastModifiers = this.display.lastModifiers;
                if ((modifiers & 0x400) != 0 && (lastModifiers & 0x400) == 0) {
                    event.keyCode = 16777298;
                    return true;
                }
                if ((modifiers & 0x200) != 0 && (lastModifiers & 0x200) == 0) {
                    event.stateMask &= 0xFFFDFFFF;
                    event.keyCode = 131072;
                    return true;
                }
                if ((modifiers & 0x1000) != 0 && (lastModifiers & 0x1000) == 0) {
                    event.stateMask &= 0xFFFBFFFF;
                    event.keyCode = 262144;
                    return true;
                }
                if ((modifiers & 0x100) != 0 && (lastModifiers & 0x100) == 0) {
                    event.stateMask &= 0xFFBFFFFF;
                    event.keyCode = 0x400000;
                    return true;
                }
                if ((modifiers & 0x800) == 0 || (lastModifiers & 0x800) != 0) break;
                event.stateMask &= 0xFFFEFFFF;
                event.keyCode = 65536;
                return true;
            }
            case 2: {
                if (event.keyCode != 0 || event.character != '\u0000') {
                    return true;
                }
                int lastModifiers = this.display.lastModifiers;
                if ((modifiers & 0x400) == 0 && (lastModifiers & 0x400) != 0) {
                    event.keyCode = 16777298;
                    return true;
                }
                if ((modifiers & 0x200) == 0 && (lastModifiers & 0x200) != 0) {
                    event.stateMask |= 0x20000;
                    event.keyCode = 131072;
                    return true;
                }
                if ((modifiers & 0x1000) == 0 && (lastModifiers & 0x1000) != 0) {
                    event.stateMask |= 0x40000;
                    event.keyCode = 262144;
                    return true;
                }
                if ((modifiers & 0x100) == 0 && (lastModifiers & 0x100) != 0) {
                    event.stateMask |= 0x400000;
                    event.keyCode = 0x400000;
                    return true;
                }
                if ((modifiers & 0x800) != 0 || (lastModifiers & 0x800) == 0) break;
                event.stateMask |= 0x10000;
                event.keyCode = 65536;
                return true;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int type, int theEvent) {
        boolean isNull = false;
        int[] keyCode = new int[1];
        OS.GetEventParameter(theEvent, 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        event.keyCode = Display.translateKey(keyCode[0]);
        switch (event.keyCode) {
            case 10: {
                event.keyCode = 0x1000050;
                event.character = (char)13;
                break;
            }
            case 8: {
                event.character = (char)8;
                break;
            }
            case 13: {
                event.character = (char)13;
                break;
            }
            case 127: {
                event.character = (char)127;
                break;
            }
            case 27: {
                event.character = (char)27;
                break;
            }
            case 9: {
                event.character = (char)9;
                break;
            }
            default: {
                short regionCode;
                int[] length;
                int status;
                if ((event.keyCode == 0 || 16777258 <= event.keyCode && event.keyCode <= 0x1000050) && (status = OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 4, length = new int[1], null)) == 0 && length[0] != 0) {
                    char[] chars = new char[1];
                    OS.GetEventParameter(theEvent, 1802858089, 1970567284, null, 2, null, chars);
                    event.character = chars[0];
                }
                if (event.keyCode != 0) break;
                int kchrPtr = OS.GetScriptManagerVariable((short)38);
                if (this.display.kchrPtr != kchrPtr) {
                    this.display.kchrPtr = kchrPtr;
                    this.display.kchrState[0] = 0;
                }
                int[] layoutRef = new int[1];
                int layoutKind = 1;
                if (OS.KLGetCurrentKeyboardLayout(layoutRef) == 0) {
                    int[] layoutKindRef = new int[1];
                    OS.KLGetKeyboardLayoutProperty(layoutRef[0], 7, layoutKindRef);
                    layoutKind = layoutKindRef[0];
                }
                if (layoutKind == 2) {
                    int[] layoutPtr = new int[1];
                    OS.KLGetKeyboardLayoutProperty(layoutRef[0], 1, layoutPtr);
                    int maxStringLength = 256;
                    char[] output = new char[maxStringLength];
                    int[] actualStringLength = new int[1];
                    OS.UCKeyTranslate(layoutPtr[0], (short)keyCode[0], (short)0, 0, OS.LMGetKbdType(), 0, this.display.kchrState, maxStringLength, actualStringLength, output);
                    if (actualStringLength[0] < 1) {
                        event.keyCode = 0;
                        break;
                    }
                    event.keyCode = output[0];
                    break;
                }
                int result = OS.KeyTranslate(this.display.kchrPtr, (short)keyCode[0], this.display.kchrState);
                if (result <= 127) {
                    event.keyCode = result & 0x7F;
                    break;
                }
                int[] encoding = new int[1];
                short keyScript = (short)OS.GetScriptManagerVariable((short)22);
                if (OS.UpgradeScriptInfoToTextEncoding(keyScript, (short)-128, regionCode = (short)OS.GetScriptManagerVariable((short)40), null, encoding) == -50 && OS.UpgradeScriptInfoToTextEncoding(keyScript, (short)-128, (short)-128, null, encoding) == -50) {
                    encoding[0] = 0;
                }
                int[] encodingInfo = new int[1];
                OS.CreateTextToUnicodeInfoByEncoding(encoding[0], encodingInfo);
                if (encodingInfo[0] == 0) break;
                char[] chars = new char[1];
                int[] nchars = new int[1];
                byte[] buffer = new byte[]{1, (byte)(result & 0xFF)};
                OS.ConvertFromPStringToUnicode(encodingInfo[0], buffer, chars.length * 2, nchars, chars);
                OS.DisposeTextToUnicodeInfo(encodingInfo);
                event.keyCode = chars[0];
            }
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !isNull) {
            return false;
        }
        this.setLocationMask(event, keyCode[0]);
        int[] chord = new int[1];
        OS.GetEventParameter(theEvent, 1667788658, 1835100014, null, 4, null, chord);
        int[] modifiers = new int[1];
        OS.GetEventParameter(theEvent, 1802334052, 1835100014, null, 4, null, modifiers);
        return this.setInputState(event, type, chord[0], modifiers[0]);
    }

    void setLocationMask(Event event, int keyCode) {
        switch (keyCode) {
            case 65: 
            case 67: 
            case 69: 
            case 75: 
            case 76: 
            case 78: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 92: {
                event.keyLocation = 2;
            }
        }
    }

    void setVisible(int control, boolean visible) {
        OS.HIViewSetVisible(control, visible);
        this.invalidateVisibleRegion(control);
    }

    void setZOrder(int control, int otheControl, boolean above) {
        int inOp = above ? 1 : 2;
        OS.HIViewSetZOrder(control, inOp, otheControl);
        this.invalidateVisibleRegion(control);
    }

    int textInputProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 2: {
                return this.kEventTextInputUnicodeForKeyEvent(nextHandler, theEvent, userData);
            }
            case 1: {
                return this.kEventTextInputUpdateActiveInputArea(nextHandler, theEvent, userData);
            }
            case 3: {
                return this.kEventTextInputOffsetToPos(nextHandler, theEvent, userData);
            }
            case 4: {
                return this.kEventTextInputPosToOffset(nextHandler, theEvent, userData);
            }
            case 6: {
                return this.kEventTextInputGetSelectedText(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }

    RGBColor toRGBColor(float[] color) {
        RGBColor rgb = new RGBColor();
        rgb.red = (short)(color[0] * 65535.0f);
        rgb.green = (short)(color[1] * 65535.0f);
        rgb.blue = (short)(color[2] * 65535.0f);
        return rgb;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    int trackingProc(int browser, int itemID, int property, int theRect, int startPt, int modifiers) {
        return 1;
    }

    int windowProc(int nextHandler, int theEvent, int userData) {
        int eventKind = OS.GetEventKind(theEvent);
        switch (eventKind) {
            case 5: {
                return this.kEventWindowActivated(nextHandler, theEvent, userData);
            }
            case 27: {
                return this.kEventWindowBoundsChanged(nextHandler, theEvent, userData);
            }
            case 72: {
                return this.kEventWindowClose(nextHandler, theEvent, userData);
            }
            case 67: {
                return this.kEventWindowCollapsed(nextHandler, theEvent, userData);
            }
            case 86: {
                return this.kEventWindowCollapsing(nextHandler, theEvent, userData);
            }
            case 6: {
                return this.kEventWindowDeactivated(nextHandler, theEvent, userData);
            }
            case 2: {
                return this.kEventWindowDrawContent(nextHandler, theEvent, userData);
            }
            case 70: {
                return this.kEventWindowExpanded(nextHandler, theEvent, userData);
            }
            case 1002: {
                return this.kEventWindowGetRegion(nextHandler, theEvent, userData);
            }
            case 25: {
                return this.kEventWindowHidden(nextHandler, theEvent, userData);
            }
            case 1003: {
                return this.kEventWindowHitTest(nextHandler, theEvent, userData);
            }
            case 24: {
                return this.kEventWindowShown(nextHandler, theEvent, userData);
            }
            case 1: {
                return this.kEventWindowUpdate(nextHandler, theEvent, userData);
            }
            case 8: {
                return this.kEventWindowGetClickModality(nextHandler, theEvent, userData);
            }
            case 75: {
                return this.kEventWindowZoom(nextHandler, theEvent, userData);
            }
        }
        return -9874;
    }
}

