/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.CGPoint;
import org.eclipse.swt.internal.carbon.DataBrowserAccessibilityItemInfo;
import org.eclipse.swt.internal.carbon.DataBrowserCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserCustomCallbacks;
import org.eclipse.swt.internal.carbon.DataBrowserListViewColumnDesc;
import org.eclipse.swt.internal.carbon.DataBrowserListViewHeaderDesc;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.internal.carbon.Rect;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.TypedListener;

public class Table
extends Composite {
    TableItem[] items;
    TableColumn[] columns;
    TableItem currentItem;
    TableColumn sortColumn;
    GC paintGC;
    int sortDirection;
    int itemCount;
    int columnCount;
    int column_id;
    int idCount;
    int anchorFirst;
    int anchorLast;
    int savedAnchor;
    int headerHeight;
    int lastIndexOf;
    boolean ignoreSelect;
    boolean wasSelected;
    boolean fixScrollWidth;
    boolean drawBackground;
    Rectangle imageBounds;
    int showIndex;
    int lastHittest;
    int lastHittestColumn;
    static final int CHECK_COLUMN_ID = 1024;
    static final int COLUMN_ID = 1025;
    static final int GRID_WIDTH = 1;
    static final int ICON_AND_TEXT_GAP = 4;
    static final int CELL_CONTENT_INSET = 12;
    static final int BORDER_INSET = 1;
    static final String[] AX_ATTRIBUTES = new String[]{"AXChildren", "AXTitle"};

    public Table(Composite parent, int style) {
        super(parent, Table.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void _addListener(int eventType, Listener listener) {
        super._addListener(eventType, listener);
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i] != null) {
                this.items[i].width = -1;
            }
            ++i;
        }
    }

    TableItem _getItem(int index) {
        if ((this.style & 0x10000000) == 0) {
            return this.items[index];
        }
        if (this.items[index] != null) {
            return this.items[index];
        }
        this.items[index] = new TableItem(this, 0, -1, false);
        return this.items[index];
    }

    int callPaintEventHandler(int control, int damageRgn, int visibleRgn, int theEvent, int nextHandler) {
        GC currentGC;
        if (this.columnCount == 0 && (this.hooks(41) || this.hooks(40) || this.hooks(42))) {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
            if (width[0] == 0) {
                OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)1);
            }
        }
        if ((currentGC = this.paintGC) == null) {
            GCData data = new GCData();
            data.paintEvent = theEvent;
            data.visibleRgn = visibleRgn;
            this.paintGC = GC.carbon_new(this, data);
        }
        this.fixScrollWidth = false;
        this.drawBackground = this.findBackgroundControl() != null;
        int result = super.callPaintEventHandler(control, damageRgn, visibleRgn, theEvent, nextHandler);
        if (this.itemCount == 0 && this.drawBackground) {
            this.drawBackground = false;
            Rectangle rect = this.getClientArea();
            int headerHeight = this.getHeaderHeight();
            rect.y += headerHeight;
            rect.height -= headerHeight;
            this.fillBackground(this.handle, this.paintGC.handle, rect);
        }
        if (this.fixScrollWidth) {
            this.fixScrollWidth = false;
            if (this.setScrollWidth(this.items, true)) {
                this.redraw();
            }
        }
        if (currentGC == null) {
            this.paintGC.dispose();
            this.paintGC = null;
        }
        return result;
    }

    boolean checkData(TableItem item, boolean redraw) {
        if (item.cached) {
            return true;
        }
        if ((this.style & 0x10000000) != 0) {
            item.cached = true;
            Event event = new Event();
            event.item = item;
            event.index = this.indexOf(item);
            this.currentItem = item;
            this.sendEvent(36, event);
            this.currentItem = null;
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
            if (redraw && !this.setScrollWidth(item)) {
                item.redraw(0);
            }
        }
        return true;
    }

    void checkItems(boolean setScrollWidth) {
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, -1, count) != 0) {
            this.error(36);
        }
        if (this.itemCount != count[0]) {
            DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
            OS.GetDataBrowserCallbacks(this.handle, callbacks);
            callbacks.v1_itemNotificationCallback = 0;
            OS.SetDataBrowserCallbacks(this.handle, callbacks);
            int delta = this.itemCount - count[0];
            if (delta < 1024) {
                int[] ids = new int[delta];
                int i = 0;
                while (i < ids.length) {
                    ids[i] = count[0] + i + 1;
                    ++i;
                }
                if (OS.AddDataBrowserItems(this.handle, 0, ids.length, ids, 0) != 0) {
                    this.error(14);
                }
                OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
            } else if (OS.AddDataBrowserItems(this.handle, 0, this.itemCount, null, 0) != 0) {
                this.error(14);
            }
            callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
            OS.SetDataBrowserCallbacks(this.handle, callbacks);
        }
        if (setScrollWidth) {
            this.setScrollWidth(this.items, true);
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x10) == 0) {
            style |= 0x300;
        }
        return Table.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index) {
        TableItem item;
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            if (this.currentItem != item) {
                item.clear();
            }
            if (this.currentItem == null && this.getDrawing()) {
                int[] id = new int[]{this.getId(index)};
                OS.UpdateDataBrowserItems(this.handle, 0, id.length, id, 0, 0);
            }
            this.setScrollWidth(item);
        }
    }

    public void clear(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.clearAll();
        } else {
            int i = start;
            while (i <= end) {
                this.clear(i);
                ++i;
            }
        }
    }

    public void clear(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            if (indices[i] < 0 || indices[i] >= this.itemCount) {
                this.error(6);
            }
            ++i;
        }
        i = 0;
        while (i < indices.length) {
            this.clear(indices[i]);
            ++i;
        }
    }

    public void clearAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                item.clear();
            }
            ++i;
        }
        if (this.currentItem == null && this.getDrawing()) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        }
        this.setScrollWidth(this.items, true);
    }

    public org.eclipse.swt.graphics.Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        if (wHint == -1) {
            if (this.columnCount != 0) {
                int i = 0;
                while (i < this.columnCount) {
                    width += this.columns[i].getWidth();
                    ++i;
                }
            } else {
                int columnWidth = 0;
                GC gc = new GC(this);
                int i = 0;
                while (i < this.itemCount) {
                    TableItem item = this.items[i];
                    if (item != null) {
                        columnWidth = Math.max(columnWidth, item.calculateWidth(0, gc));
                    }
                    ++i;
                }
                gc.dispose();
                width += columnWidth + this.getInsetWidth();
            }
            if ((this.style & 0x20) != 0) {
                width += this.getCheckColumnWidth();
            }
        } else {
            width = wHint;
        }
        if (width <= 0) {
            width = 64;
        }
        int height = 0;
        height = hHint == -1 ? this.itemCount * this.getItemHeight() + this.getHeaderHeight() : hHint;
        if (height <= 0) {
            height = 64;
        }
        Rectangle rect = this.computeTrim(0, 0, width, height);
        return new org.eclipse.swt.graphics.Point(rect.width, rect.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = this.getBorderWidth();
        Rect rect = new Rect();
        OS.GetDataBrowserScrollBarInset(this.handle, rect);
        return new Rectangle(x -= rect.left + border, y -= rect.top + border, width += rect.left + rect.right + border + border, height += rect.top + rect.bottom + border + border);
    }

    boolean contains(int shellX, int shellY) {
        CGPoint pt = new CGPoint();
        int[] contentView = new int[1];
        OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), contentView);
        OS.HIViewConvertPoint(pt, this.handle, contentView[0]);
        int x = shellX - (int)pt.x;
        int y = shellY - (int)pt.y;
        if (y < this.getHeaderHeight()) {
            return false;
        }
        return this.getClientArea().contains(x, y);
    }

    void createHandle() {
        this.column_id = 1025;
        int[] outControl = new int[1];
        int window = OS.GetControlOwner(this.parent.handle);
        OS.CreateDataBrowserControl(window, null, 1819505782, outControl);
        OS.SetAutomaticControlDragTrackingEnabledForWindow(window, true);
        if (outControl[0] == 0) {
            this.error(2);
        }
        this.handle = outControl[0];
        if (!this.drawFocusRing()) {
            OS.SetControlData(this.handle, 0, 1651663986, 1, new byte[1]);
        }
        int selectionFlags = (this.style & 4) != 0 ? 66 : 8;
        OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags);
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        this.headerHeight = height[0];
        OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)0);
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
        if (OS.VERSION >= 4160) {
            OS.DataBrowserSetMetric(this.handle, 1, false, 4.0f);
        }
        int position = 0;
        if ((this.style & 0x20) != 0) {
            DataBrowserListViewColumnDesc checkColumn = new DataBrowserListViewColumnDesc();
            checkColumn.headerBtnDesc_version = 0;
            checkColumn.propertyDesc_propertyID = 1024;
            checkColumn.propertyDesc_propertyType = 1667785336;
            checkColumn.propertyDesc_propertyFlags = 1;
            int checkWidth = this.getCheckColumnWidth();
            checkColumn.headerBtnDesc_minimumWidth = (short)checkWidth;
            checkColumn.headerBtnDesc_maximumWidth = (short)checkWidth;
            checkColumn.headerBtnDesc_initialOrder = 1;
            OS.AddDataBrowserListViewColumn(this.handle, checkColumn, position++);
        }
        DataBrowserListViewColumnDesc column = new DataBrowserListViewColumnDesc();
        column.headerBtnDesc_version = 0;
        column.propertyDesc_propertyID = this.column_id;
        column.propertyDesc_propertyType = 0x3F3F3F3F;
        column.propertyDesc_propertyFlags = 327680;
        column.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
        column.headerBtnDesc_initialOrder = 1;
        OS.AddDataBrowserListViewColumn(this.handle, column, position);
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)0);
        if (OS.VERSION < 4160) {
            OS.HIViewSetDrawingEnabled(this.handle, false);
            int size = 50;
            Rect rect = new Rect();
            rect.right = rect.bottom = (short)size;
            OS.SetControlBounds(this.handle, rect);
            int bpl = size * 4;
            int[] gWorld = new int[1];
            int data = OS.NewPtr(bpl * size);
            OS.NewGWorldFromPtr(gWorld, 32, rect, 0, 0, 0, data, bpl);
            int[] curPort = new int[1];
            int[] curGWorld = new int[1];
            OS.GetGWorld(curPort, curGWorld);
            OS.SetGWorld(gWorld[0], curGWorld[0]);
            OS.DrawControlInCurrentPort(this.handle);
            OS.SetGWorld(curPort[0], curGWorld[0]);
            OS.DisposeGWorld(gWorld[0]);
            OS.DisposePtr(data);
            rect.bottom = 0;
            rect.right = 0;
            OS.SetControlBounds(this.handle, rect);
            OS.HIViewSetDrawingEnabled(this.handle, true);
        }
    }

    void createItem(TableColumn column, int index) {
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        column.id = this.column_id + this.idCount++;
        int position = index + ((this.style & 0x20) != 0 ? 1 : 0);
        if (this.columnCount != 0) {
            DataBrowserListViewColumnDesc desc = new DataBrowserListViewColumnDesc();
            desc.headerBtnDesc_version = 0;
            desc.propertyDesc_propertyID = column.id;
            desc.propertyDesc_propertyType = 0x3F3F3F3F;
            desc.propertyDesc_propertyFlags = 327680;
            desc.headerBtnDesc_maximumWidth = Short.MAX_VALUE;
            desc.headerBtnDesc_initialOrder = 1;
            desc.headerBtnDesc_btnFontStyle_just = (short)-2;
            if ((this.style & 0x1000000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = 1;
            }
            if ((this.style & 0x20000) != 0) {
                desc.headerBtnDesc_btnFontStyle_just = (short)-1;
            }
            desc.headerBtnDesc_btnFontStyle_flags = (short)(desc.headerBtnDesc_btnFontStyle_flags | 0x40);
            OS.AddDataBrowserListViewColumn(this.handle, desc, position);
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, (short)0);
        }
        if (this.columnCount == this.columns.length) {
            TableColumn[] newColumns = new TableColumn[this.columnCount + 4];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columns.length);
            this.columns = newColumns;
        }
        System.arraycopy(this.columns, index, this.columns, index + 1, this.columnCount++ - index);
        this.columns[index] = column;
        if (this.columnCount > 1) {
            int i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    Font[] cellFont;
                    Color[] cellForeground;
                    Color[] cellBackground;
                    Image[] images;
                    String[] strings = item.strings;
                    if (strings != null) {
                        String[] temp = new String[this.columnCount];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index, temp, index + 1, this.columnCount - index - 1);
                        temp[index] = "";
                        item.strings = temp;
                    }
                    if (index == 0) {
                        item.text = "";
                    }
                    if ((images = item.images) != null) {
                        Image[] temp = new Image[this.columnCount];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index, temp, index + 1, this.columnCount - index - 1);
                        item.images = temp;
                    }
                    if (index == 0) {
                        item.image = null;
                    }
                    if ((cellBackground = item.cellBackground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellBackground = temp;
                    }
                    if ((cellForeground = item.cellForeground) != null) {
                        Color[] temp = new Color[this.columnCount];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellForeground = temp;
                    }
                    if ((cellFont = item.cellFont) != null) {
                        Font[] temp = new Font[this.columnCount];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index, temp, index + 1, this.columnCount - index - 1);
                        item.cellFont = temp;
                    }
                }
                ++i;
            }
        }
        int[] lastPosition = new int[1];
        int i = 0;
        while (i < this.columnCount) {
            TableColumn c = this.columns[i];
            OS.GetDataBrowserTableViewColumnPosition(this.handle, c.id, lastPosition);
            c.lastPosition = lastPosition[0];
            ++i;
        }
    }

    void createItem(TableItem item, int index) {
        boolean add;
        int savedIndex;
        if (index < 0 || index > this.itemCount) {
            this.error(6);
        }
        if (this.savedAnchor != 0 && index <= (savedIndex = this.getIndex(this.savedAnchor))) {
            this.savedAnchor = this.getId(Math.min(this.itemCount - 1, savedIndex + 1));
        }
        boolean bl = add = this.getDrawing() || index != this.itemCount;
        if (add) {
            this.checkItems(false);
            int[] id = new int[]{this.itemCount + 1};
            if (OS.AddDataBrowserItems(this.handle, 0, 1, id, 0) != 0) {
                this.error(14);
            }
            if (index != this.itemCount) {
                this.fixSelection(index, true);
            }
        }
        if (this.itemCount == this.items.length) {
            int length = this.getDrawing() ? this.items.length + 4 : Math.max(4, this.items.length * 3 / 2);
            TableItem[] newItems = new TableItem[length];
            System.arraycopy(this.items, 0, newItems, 0, this.items.length);
            this.items = newItems;
        }
        System.arraycopy(this.items, index, this.items, index + 1, this.itemCount++ - index);
        this.items[index] = item;
        if (add) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        }
    }

    ScrollBar createScrollBar(int style) {
        return this.createStandardBar(style);
    }

    void createWidget() {
        super.createWidget();
        this.items = new TableItem[4];
        this.columns = new TableColumn[4];
        this.showIndex = -1;
        if (OS.VERSION >= 4176) {
            OS.DataBrowserChangeAttributes(this.handle, 8, 0);
        }
    }

    Color defaultBackground() {
        return this.display.getSystemColor(25);
    }

    Color defaultForeground() {
        return this.display.getSystemColor(24);
    }

    int defaultThemeFont() {
        if (this.display.smallFonts) {
            return 1;
        }
        return 3;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{this.getId(index)};
            this.deselect(ids, ids.length);
        }
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start == 0 && end == this.itemCount - 1) {
            this.deselectAll();
        } else {
            int length = end - start + 1;
            if (length <= 0) {
                return;
            }
            int[] ids = new int[length];
            int i = 0;
            while (i < length) {
                ids[i] = this.getId(end - i);
                ++i;
            }
            this.deselect(ids, length);
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            this.error(4);
        }
        int length = indices.length;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = this.getId(indices[length - i - 1]);
            ++i;
        }
        this.deselect(ids, length);
    }

    void deselect(int[] ids, int count) {
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        OS.SetDataBrowserSelectedItems(this.handle, count, ids, 3);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    public void deselectAll() {
        this.checkWidget();
        this.deselect(null, 0);
    }

    void destroyItem(TableColumn column) {
        int index = 0;
        while (index < this.columnCount) {
            if (this.columns[index] == column) break;
            ++index;
        }
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null) {
                if (this.columnCount <= 1) {
                    item.strings = null;
                    item.images = null;
                    item.cellBackground = null;
                    item.cellForeground = null;
                    item.cellFont = null;
                } else {
                    Object[] temp;
                    if (item.strings != null) {
                        String[] strings = item.strings;
                        if (index == 0) {
                            item.text = strings[1] != null ? strings[1] : "";
                        }
                        temp = new String[this.columnCount - 1];
                        System.arraycopy(strings, 0, temp, 0, index);
                        System.arraycopy(strings, index + 1, temp, index, this.columnCount - 1 - index);
                        item.strings = temp;
                    } else if (index == 0) {
                        item.text = "";
                    }
                    if (item.images != null) {
                        Image[] images = item.images;
                        if (index == 0) {
                            item.image = images[1];
                        }
                        temp = new Image[this.columnCount - 1];
                        System.arraycopy(images, 0, temp, 0, index);
                        System.arraycopy(images, index + 1, temp, index, this.columnCount - 1 - index);
                        item.images = temp;
                    } else if (index == 0) {
                        item.image = null;
                    }
                    if (item.cellBackground != null) {
                        Color[] cellBackground = item.cellBackground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellBackground, 0, temp, 0, index);
                        System.arraycopy(cellBackground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellBackground = temp;
                    }
                    if (item.cellForeground != null) {
                        Color[] cellForeground = item.cellForeground;
                        temp = new Color[this.columnCount - 1];
                        System.arraycopy(cellForeground, 0, temp, 0, index);
                        System.arraycopy(cellForeground, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellForeground = temp;
                    }
                    if (item.cellFont != null) {
                        Font[] cellFont = item.cellFont;
                        temp = new Font[this.columnCount - 1];
                        System.arraycopy(cellFont, 0, temp, 0, index);
                        System.arraycopy(cellFont, index + 1, temp, index, this.columnCount - 1 - index);
                        item.cellFont = temp;
                    }
                }
            }
            ++i;
        }
        if (this.columnCount == 1) {
            int str;
            this.column_id = column.id;
            this.idCount = 0;
            DataBrowserListViewHeaderDesc desc = new DataBrowserListViewHeaderDesc();
            desc.version = 0;
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
            desc.minimumWidth = desc.maximumWidth = width[0];
            desc.titleString = str = OS.CFStringCreateWithCharacters(0, null, 0);
            OS.SetDataBrowserListViewHeaderDesc(this.handle, this.column_id, desc);
            OS.CFRelease(str);
        } else if (OS.RemoveDataBrowserTableViewColumn(this.handle, column.id) != 0) {
            this.error(15);
        }
        System.arraycopy(this.columns, index + 1, this.columns, index, --this.columnCount - index);
        this.columns[this.columnCount] = null;
        i = index;
        while (i < this.columnCount) {
            this.columns[i].sendEvent(10);
            ++i;
        }
    }

    void destroyItem(TableItem item) {
        int[] id;
        int savedIndex;
        int index = 0;
        while (index < this.itemCount) {
            if (this.items[index] == item) break;
            ++index;
        }
        if (this.savedAnchor != 0 && index < (savedIndex = this.getIndex(this.savedAnchor))) {
            this.savedAnchor = this.getId(Math.max(0, savedIndex - 1));
        }
        if (index != this.itemCount - 1) {
            this.fixSelection(index, false);
        }
        if (OS.RemoveDataBrowserItems(this.handle, 0, (id = new int[]{this.itemCount}).length, id, 0) != 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        if (this.itemCount == 0) {
            this.setTableEmpty();
        } else {
            this.fixScrollBar();
        }
    }

    void destroyScrollBar(ScrollBar bar) {
        if ((bar.style & 0x100) != 0) {
            this.style &= 0xFFFFFEFF;
        }
        if ((bar.style & 0x200) != 0) {
            this.style &= 0xFFFFFDFF;
        }
        OS.SetDataBrowserHasScrollBars(this.handle, (this.style & 0x100) != 0, (this.style & 0x200) != 0);
    }

    int drawItemProc(int browser, int id, int property, int itemState, int theRect, int gdDepth, int colorDevice) {
        boolean wasSelected;
        int index = this.getIndex(id);
        if (index < 0 || index >= this.itemCount) {
            return 0;
        }
        int columnIndex = 0;
        if (this.columnCount > 0) {
            columnIndex = 0;
            while (columnIndex < this.columnCount) {
                if (this.columns[columnIndex].id == property) break;
                ++columnIndex;
            }
            if (columnIndex == this.columnCount) {
                return 0;
            }
        }
        Rect rect = new Rect();
        this.lastIndexOf = index;
        TableItem item = this._getItem(index);
        if ((this.style & 0x10000000) != 0 && !item.cached) {
            if (!this.checkData(item, false)) {
                return 0;
            }
            if (this.setScrollWidth(item)) {
                if (OS.GetDataBrowserItemPartBounds(this.handle, id, property, 0, rect) == 0) {
                    short x = rect.left;
                    short y = rect.top;
                    int width = rect.right - rect.left;
                    int height = rect.bottom - rect.top;
                    this.redrawWidget(this.handle, x, y, width, height, false);
                }
                return 0;
            }
        }
        OS.memmove(rect, theRect, 8);
        int x = rect.left;
        short y = rect.top;
        int width = rect.right - rect.left;
        int height = rect.bottom - rect.top;
        GC gc = this.paintGC;
        if (gc == null) {
            GCData data = new GCData();
            int[] port = new int[1];
            OS.GetPort(port);
            data.port = port[0];
            gc = GC.carbon_new(this, data);
        }
        OS.GetDataBrowserItemPartBounds(this.handle, id, property, 0, rect);
        short gridWidth = this.getLinesVisible() ? (short)1 : 0;
        int itemX = rect.left + gridWidth;
        short itemY = rect.top;
        int itemWidth = rect.right - rect.left - gridWidth;
        int itemHeight = rect.bottom - rect.top + 1;
        if (this.drawBackground) {
            this.drawBackground = false;
            Region region = new Region(this.display);
            Rectangle clientArea = this.getClientArea();
            int headerHeight = this.getHeaderHeight();
            clientArea.y += headerHeight;
            clientArea.height -= headerHeight;
            if (clientArea.height < 0) {
                clientArea.height = 0;
            }
            region.add(clientArea);
            if ((this.style & 0x20) != 0 || gridWidth != 0) {
                int rgn = OS.NewRgn();
                if ((this.style & 0x20) != 0 && OS.GetDataBrowserItemPartBounds(this.handle, id, 1024, 0, rect) == 0) {
                    OS.SetRectRgn(rgn, rect.left, (short)clientArea.y, (short)(rect.right + gridWidth), (short)(clientArea.y + clientArea.height));
                    OS.DiffRgn(region.handle, rgn, region.handle);
                }
                if (gridWidth != 0) {
                    if (this.columnCount == 0) {
                        if (OS.GetDataBrowserItemPartBounds(this.handle, id, 1025, 0, rect) == 0) {
                            OS.SetRectRgn(rgn, rect.right, (short)clientArea.y, (short)(rect.right + gridWidth), (short)(clientArea.y + clientArea.height));
                            OS.DiffRgn(region.handle, rgn, region.handle);
                        }
                    } else {
                        int i = 0;
                        while (i < this.columnCount) {
                            if (OS.GetDataBrowserItemPartBounds(this.handle, id, this.columns[i].id, 0, rect) == 0) {
                                OS.SetRectRgn(rgn, rect.right, (short)clientArea.y, (short)(rect.right + gridWidth), (short)(clientArea.y + clientArea.height));
                                OS.DiffRgn(region.handle, rgn, region.handle);
                            }
                            ++i;
                        }
                    }
                }
                OS.DisposeRgn(rgn);
            }
            gc.setClipping(region);
            this.fillBackground(this.handle, gc.handle, null);
            gc.setClipping((Rectangle)null);
            region.dispose();
        }
        OS.CGContextSaveGState(gc.handle);
        int itemRgn = OS.NewRgn();
        OS.SetRectRgn(itemRgn, (short)itemX, itemY, (short)(itemX + itemWidth), (short)(itemY + itemHeight));
        int clip = OS.NewRgn();
        OS.GetClip(clip);
        OS.SectRgn(clip, itemRgn, itemRgn);
        OS.DisposeRgn(clip);
        Region region = Region.carbon_new(this.display, itemRgn);
        Font font = item.getFont(columnIndex);
        Color background = item.getBackground(columnIndex);
        Color foreground = item.getForeground(columnIndex);
        Image image = item.getImage(columnIndex);
        String text = item.getText(columnIndex);
        gc.setClipping(region);
        gc.setFont(font);
        org.eclipse.swt.graphics.Point extent = gc.stringExtent(text);
        int contentWidth = extent.x;
        Rectangle imageBounds = null;
        int gap = 0;
        if (image != null) {
            gap = this.getGap();
            imageBounds = image.getBounds();
            contentWidth += this.imageBounds.width + gap;
        }
        int paintWidth = contentWidth;
        if (this.hooks(41)) {
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.width = contentWidth;
            event.height = itemHeight;
            this.sendEvent(41, event);
            if (itemHeight < event.height) {
                itemHeight = event.height;
                OS.SetDataBrowserTableViewRowHeight(this.handle, (short)event.height);
                this.redrawWidget(this.handle, false);
            }
            if (this.setScrollWidth(item)) {
                this.redrawWidget(this.handle, false);
            }
            contentWidth = event.width;
            gc.setClipping(region);
            gc.setFont(font);
        }
        int drawState = 16;
        if (item.background != null || item.cellBackground != null && item.cellBackground[columnIndex] != null) {
            drawState |= 8;
        }
        if ((itemState & 5) != 0) {
            drawState |= 2;
        }
        boolean bl = wasSelected = (drawState & 2) != 0;
        if ((drawState & 2) != 0 && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
            gc.setBackground(this.display.getSystemColor(26));
            gc.setForeground(this.display.getSystemColor(27));
        } else {
            gc.setBackground(background);
            gc.setForeground(foreground);
        }
        if (this.hooks(40)) {
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.x = itemX;
            event.y = itemY;
            event.width = itemWidth;
            event.height = itemHeight;
            event.detail = drawState;
            this.sendEvent(40, event);
            drawState = event.doit ? event.detail : 0;
            gc.setClipping(region);
            gc.setFont(font);
            if ((drawState & 2) != 0 && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
                gc.setBackground(this.display.getSystemColor(26));
                gc.setForeground(this.display.getSystemColor(27));
            } else {
                gc.setBackground(background);
                if (!wasSelected) {
                    gc.setForeground(foreground);
                }
            }
        }
        if (this.columnCount != 0 && columnIndex != 0) {
            TableColumn column = this.columns[columnIndex];
            if ((column.style & 0x1000000) != 0) {
                x += (width - contentWidth) / 2;
            }
            if ((column.style & 0x20000) != 0) {
                x += width - contentWidth;
            }
        }
        int stringX = x;
        int imageWidth = 0;
        if (image != null) {
            imageWidth = this.imageBounds.width + gap;
            stringX += imageWidth;
        }
        if ((drawState & 2) != 0 && ((this.style & 0x10000) != 0 || columnIndex == 0)) {
            if ((this.style & 0x8000) == 0 || this.hasFocus()) {
                if ((this.style & 0x10000) != 0) {
                    gc.fillRectangle(itemX, itemY, itemWidth, itemHeight - 1);
                    drawState &= 0xFFFFFFF7;
                } else if (columnIndex == 0) {
                    gc.fillRectangle(stringX - 1, y, contentWidth - imageWidth + 2, itemHeight - 1);
                    drawState &= 0xFFFFFFF7;
                }
            } else if ((drawState & 8) != 0) {
                gc.setBackground(background);
            }
        }
        if ((drawState & 8) != 0) {
            if (this.columnCount == 0) {
                gc.fillRectangle(stringX - 1, y, contentWidth - imageWidth + 2, itemHeight - 1);
            } else {
                gc.fillRectangle(itemX, itemY, itemWidth, itemHeight);
            }
        }
        if ((drawState & 0x10) != 0) {
            if (image != null) {
                int imageX = x;
                int imageY = y + (height - this.imageBounds.height) / 2;
                gc.drawImage(image, 0, 0, imageBounds.width, imageBounds.height, imageX, imageY, this.imageBounds.width, this.imageBounds.height);
            }
            gc.drawString(text, stringX, y + (height - extent.y) / 2, true);
        }
        if (this.hooks(42)) {
            Event event = new Event();
            event.item = item;
            event.index = columnIndex;
            event.gc = gc;
            event.x = x;
            event.y = y;
            event.width = paintWidth;
            event.height = itemHeight;
            event.detail = drawState;
            this.sendEvent(42, event);
        }
        OS.CGContextRestoreGState(gc.handle);
        OS.DisposeRgn(itemRgn);
        if (gc != this.paintGC) {
            gc.dispose();
        }
        return 0;
    }

    void enableWidget(boolean enabled) {
        super.enableWidget(enabled);
        this.redrawWidget(this.handle, false);
    }

    void fixScrollBar() {
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        int maximum = Math.max(0, this.getItemHeight() * this.itemCount - this.getClientArea().height);
        if (top[0] > maximum) {
            OS.SetDataBrowserScrollPosition(this.handle, maximum, left[0]);
        }
    }

    void fixSelection(int index, boolean add) {
        int[] selection = this.getSelectionIndices();
        if (selection.length == 0) {
            return;
        }
        int newCount = 0;
        int offset = add ? 1 : -1;
        boolean fix = false;
        boolean down = this.sortDirection == 1024 && this.sortColumn != null;
        int i = 0;
        while (i < selection.length) {
            if (!add && selection[i] == index) {
                fix = true;
            } else {
                int newIndex = newCount++;
                int sel = selection[i];
                selection[newIndex] = this.getId(sel);
                if (down && sel < index || !down && sel >= index) {
                    int n = newIndex;
                    selection[n] = selection[n] + offset;
                    fix = true;
                }
            }
            ++i;
        }
        if (fix) {
            this.select(selection, newCount, true);
        }
    }

    String[] getAxAttributes() {
        return AX_ATTRIBUTES;
    }

    public int getBorderWidth() {
        this.checkWidget();
        int border = 0;
        byte[] hasBorder = new byte[1];
        OS.GetControlData(this.handle, (short)0, 1651663986, 1, hasBorder, null);
        if (hasBorder[0] != 0) {
            int[] outMetric = new int[1];
            OS.GetThemeMetric(7, outMetric);
            border += outMetric[0] - 1;
        }
        return border;
    }

    int getCheckColumnWidth() {
        int inset = 0;
        if (OS.VERSION >= 4160) {
            float[] metric = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, metric);
            inset = (int)metric[0];
        } else {
            inset = 12;
        }
        int[] checkWidth = new int[1];
        OS.GetThemeMetric(50, checkWidth);
        return checkWidth[0] + inset * 2;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        int border = this.getBorderWidth();
        Rect rect = new Rect();
        Rect inset = new Rect();
        OS.GetControlBounds(this.handle, rect);
        OS.GetDataBrowserScrollBarInset(this.handle, inset);
        int width = Math.max(0, rect.right - rect.left - inset.right - border - border);
        int height = Math.max(0, rect.bottom - rect.top - inset.bottom - border - border);
        return new Rectangle(inset.left + border, inset.top + border, width, height);
    }

    public TableColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this.columns[index];
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int[] position = new int[1];
        int i = 0;
        while (i < this.columnCount) {
            TableColumn column = this.columns[i];
            OS.GetDataBrowserTableViewColumnPosition(this.handle, column.id, position);
            if ((this.style & 0x20) != 0) {
                position[0] = position[0] - 1;
            }
            order[position[0]] = i++;
        }
        return order;
    }

    public TableColumn[] getColumns() {
        this.checkWidget();
        TableColumn[] result = new TableColumn[this.columnCount];
        System.arraycopy(this.columns, 0, result, 0, this.columnCount);
        return result;
    }

    int getGap() {
        if (OS.VERSION >= 4160) {
            float[] metric = new float[1];
            OS.DataBrowserGetMetric(this.handle, 2, null, metric);
            return (int)metric[0];
        }
        return 4;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        return height[0];
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        return height[0] != 0;
    }

    int getId(int index) {
        if (this.sortDirection == 1024 && this.sortColumn != null) {
            return this.itemCount - index;
        }
        return index + 1;
    }

    int getIndex(int id) {
        if (this.sortDirection == 1024 && this.sortColumn != null) {
            return this.itemCount - id;
        }
        return id - 1;
    }

    int getInsetWidth() {
        if (OS.VERSION >= 4160) {
            float[] metric = new float[1];
            OS.DataBrowserGetMetric(this.handle, 1, null, metric);
            return (int)metric[0] * 2;
        }
        return 24;
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        return this._getItem(index);
    }

    public TableItem getItem(org.eclipse.swt.graphics.Point point) {
        this.checkWidget();
        this.checkItems(true);
        if (point == null) {
            this.error(4);
        }
        short[] height = new short[1];
        OS.GetDataBrowserTableViewRowHeight(this.handle, height);
        Rect rect = new Rect();
        Point pt = new Point();
        OS.SetPt(pt, (short)point.x, (short)point.y);
        int lastHittestIndex = this.getIndex(this.lastHittest);
        if (lastHittestIndex >= 0 && lastHittestIndex < this.itemCount && this.lastHittestColumn != 0 && OS.GetDataBrowserItemPartBounds(this.handle, this.lastHittest, this.lastHittestColumn, 0, rect) == 0) {
            rect.bottom = (short)(rect.top + height[0]);
            if (OS.PtInRect(pt, rect)) {
                return this._getItem(lastHittestIndex);
            }
            if (rect.top <= pt.v && pt.v < rect.bottom) {
                int j = 0;
                while (j < this.columnCount) {
                    if (OS.GetDataBrowserItemPartBounds(this.handle, this.lastHittest, this.columns[j].id, 0, rect) == 0) {
                        rect.bottom = (short)(rect.top + height[0]);
                        if (OS.PtInRect(pt, rect)) {
                            return this._getItem(lastHittestIndex);
                        }
                    }
                    ++j;
                }
                return null;
            }
        }
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        short[] header = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, header);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = -1;
        int[] offsets = nArray;
        int i = 0;
        while (i < offsets.length) {
            int index = (top[0] - header[0] + point.y) / height[0] + offsets[i];
            if (index >= 0 && index < this.itemCount) {
                int columnId;
                int n = columnId = this.columnCount == 0 ? this.column_id : this.columns[0].id;
                if (OS.GetDataBrowserItemPartBounds(this.handle, this.getId(index), columnId, 0, rect) == 0) {
                    rect.bottom = (short)(rect.top + height[0]);
                    if (rect.top <= pt.v && pt.v < rect.bottom) {
                        if (this.columnCount == 0) {
                            if (OS.PtInRect(pt, rect)) {
                                return this._getItem(index);
                            }
                        } else {
                            int j = 0;
                            while (j < this.columnCount) {
                                if (OS.GetDataBrowserItemPartBounds(this.handle, this.getId(index), this.columns[j].id, 0, rect) == 0) {
                                    rect.bottom = (short)(rect.top + height[0]);
                                    if (OS.PtInRect(pt, rect)) {
                                        return this._getItem(index);
                                    }
                                }
                                ++j;
                            }
                        }
                        return null;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, height) != 0) {
            this.error(11);
        }
        return height[0];
    }

    public TableItem[] getItems() {
        this.checkWidget();
        TableItem[] result = new TableItem[this.itemCount];
        if ((this.style & 0x10000000) != 0) {
            int i = 0;
            while (i < this.itemCount) {
                result[i] = this._getItem(i);
                ++i;
            }
        } else {
            System.arraycopy(this.items, 0, result, 0, this.itemCount);
        }
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int[] attrib = new int[1];
            OS.DataBrowserGetAttributes(this.handle, attrib);
            return (attrib[0] & 6) != 0;
        }
        return false;
    }

    public TableItem[] getSelection() {
        this.checkWidget();
        int ptr = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize(ptr) / 4;
        TableItem[] result = new TableItem[count];
        if (count > 0) {
            OS.HLock(ptr);
            int[] id = new int[1];
            OS.memmove(id, ptr, 4);
            if (this.sortDirection == 1024 && this.sortColumn != null) {
                int offset = id[0];
                int i = 0;
                while (i < count) {
                    OS.memmove(id, offset, 4);
                    result[i] = this._getItem(this.getIndex(id[0]));
                    ++i;
                    offset += 4;
                }
            } else {
                int offset = id[0] + (count - 1) * 4;
                int i = 0;
                while (i < count) {
                    OS.memmove(id, offset, 4);
                    result[i] = this._getItem(this.getIndex(id[0]));
                    ++i;
                    offset -= 4;
                }
            }
            OS.HUnlock(ptr);
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] count = new int[1];
        if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, count) != 0) {
            this.error(36);
        }
        return count[0];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] first = new int[1];
        int[] last = new int[1];
        if (OS.GetDataBrowserSelectionAnchor(this.handle, first, last) != 0) {
            return -1;
        }
        return this.getIndex(first[0]);
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int ptr = OS.NewHandle(0);
        if (OS.GetDataBrowserItems(this.handle, 0, true, 1, ptr) != 0) {
            this.error(9);
        }
        int count = OS.GetHandleSize(ptr) / 4;
        int[] result = new int[count];
        if (count > 0) {
            OS.HLock(ptr);
            OS.memmove(result, ptr, 4);
            OS.memmove(result, result[0], count * 4);
            OS.HUnlock(ptr);
            if (this.sortDirection == 1024 && this.sortColumn != null) {
                int i = 0;
                while (i < count) {
                    result[i] = this.getIndex(result[i]);
                    ++i;
                }
            } else {
                int start = 0;
                int end = count - 1;
                while (start <= end) {
                    int temp = result[start];
                    result[start] = this.getIndex(result[end]);
                    result[end] = this.getIndex(temp);
                    ++start;
                    --end;
                }
            }
        }
        OS.DisposeHandle(ptr);
        return result;
    }

    public TableColumn getSortColumn() {
        this.checkWidget();
        return this.sortColumn;
    }

    public int getSortDirection() {
        this.checkWidget();
        return this.sortDirection;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        return top[0] / this.getItemHeight();
    }

    /*
     * Unable to fully structure code
     */
    int helpProc(int inControl, int inGlobalMouse, int inRequest, int outContentProvided, int ioHelpContent) {
        block16: {
            if (this.toolTipText != null) break block16;
            switch (inRequest) {
                case 0: {
                    if (this.toolTipText != null && this.toolTipText.length() != 0) break;
                    rect = new Rect();
                    window = OS.GetControlOwner(this.handle);
                    OS.GetWindowBounds(window, (short)33, rect);
                    windowLeft = rect.left;
                    windowTop = rect.top;
                    pt = new Point();
                    OS.memmove(pt, new int[]{inGlobalMouse}, 4);
                    pt.h = (short)(pt.h - windowLeft);
                    pt.v = (short)(pt.v - windowTop);
                    toolTipText = null;
                    tagSide = 23;
                    inPt = new CGPoint();
                    contentView = new int[1];
                    OS.HIViewFindByID(OS.HIViewGetRoot(OS.GetControlOwner(this.handle)), OS.kHIViewWindowContentID(), contentView);
                    OS.HIViewConvertPoint(inPt, this.handle, contentView[0]);
                    pt.h = (short)(pt.h - (int)inPt.x);
                    pt.v = (short)(pt.v - (int)inPt.y);
                    windowLeft = (short)(windowLeft + (int)inPt.x);
                    windowTop = (short)(windowTop + (int)inPt.y);
                    x = pt.h;
                    y = pt.v;
                    headerHeight = this.getHeaderHeight();
                    if (headerHeight == 0 || y < 0 || y >= headerHeight) ** GOTO lbl47
                    startX = 0;
                    i = 0;
                    while (i < this.columnCount) {
                        column = this.columns[i];
                        width = column.lastWidth;
                        if (startX > x || x >= startX + width) ** GOTO lbl43
                        toolTipText = column.toolTipText;
                        rect.left = (short)startX;
                        rect.top = 0;
                        rect.right = (short)(rect.left + width);
                        rect.bottom = (short)(rect.top + headerHeight);
                        tagSide = 10;
                        ** GOTO lbl87
lbl43:
                        // 1 sources

                        startX += width;
                        ++i;
                    }
                    ** GOTO lbl87
lbl47:
                    // 1 sources

                    item = null;
                    index = this.getIndex(this.lastHittest);
                    if (index >= 0 && index < this.itemCount && OS.GetDataBrowserItemPartBounds(this.handle, this.lastHittest, this.lastHittestColumn, 0x2D2D2D2D, rect) == 0) {
                        item = this._getItem(index);
                    }
                    if (item != null) {
                        columnIndex = 0;
                        column = null;
                        if (this.columnCount > 0) {
                            i = 0;
                            while (i < this.columnCount) {
                                if (this.columns[i].id == this.lastHittestColumn) {
                                    column = this.columns[i];
                                    columnIndex = i;
                                    break;
                                }
                                ++i;
                            }
                        }
                        columnId = this.lastHittestColumn;
                        gc = new GC(this);
                        inset = this.getInsetWidth();
                        width = item.calculateWidth(columnIndex, gc) + inset;
                        gc.dispose();
                        if (this.columnCount == 0) {
                            columnWidth = this.getClientArea().width;
                        } else {
                            w = new short[1];
                            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, columnId, w);
                            columnWidth = w[0];
                        }
                        if (width > columnWidth) {
                            toolTipText = item.getText(columnIndex);
                            image = item.getImage(columnIndex);
                            imageWidth = image != null ? image.getBounds().width + this.getGap() : 0;
                            v0 = style = column == null ? 16384 : column.style;
                            if ((style & 16384) != 0) {
                                rect.left = (short)(rect.left + imageWidth);
                                rect.right = (short)(rect.left + width - imageWidth - inset);
                            }
                            if ((style & 131072) != 0) {
                                rect.left = (short)(rect.right - width + imageWidth + inset);
                            }
                            if ((style & 0x1000000) != 0) {
                                rect.left = (short)(rect.left + imageWidth);
                            }
                        }
                    }
lbl87:
                    // 9 sources

                    if (toolTipText == null || toolTipText.length() == 0) break;
                    buffer = new char[toolTipText.length()];
                    toolTipText.getChars(0, buffer.length, buffer, 0);
                    length = this.fixMnemonic(buffer);
                    if (this.display.helpString != 0) {
                        OS.CFRelease(this.display.helpString);
                    }
                    this.display.helpString = OS.CFStringCreateWithCharacters(0, buffer, length);
                    helpContent = new HMHelpContentRec();
                    OS.memmove(helpContent, ioHelpContent, 534);
                    this.display.helpWidget = this;
                    helpContent.version = 3;
                    helpContent.tagSide = (short)tagSide;
                    helpContent.absHotRect_left = (short)(rect.left + windowLeft);
                    helpContent.absHotRect_top = (short)(rect.top + windowTop);
                    helpContent.absHotRect_right = (short)(rect.right + windowLeft);
                    helpContent.absHotRect_bottom = (short)(rect.bottom + windowTop);
                    helpContent.content0_contentType = 1667658612;
                    helpContent.content0_tagCFString = this.display.helpString;
                    helpContent.content1_contentType = 1667658612;
                    helpContent.content1_tagCFString = this.display.helpString;
                    OS.memmove(ioHelpContent, helpContent, 534);
                    OS.memmove(outContentProvided, new short[1], 2);
                    return 0;
                }
            }
        }
        return super.helpProc(inControl, inGlobalMouse, inRequest, outContentProvided, ioHelpContent);
    }

    int hitTestProc(int browser, int id, int property, int theRect, int mouseRect) {
        this.lastHittest = id;
        this.lastHittestColumn = property;
        return 1;
    }

    void hookEvents() {
        super.hookEvents();
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        callbacks.version = 0;
        OS.InitDataBrowserCallbacks(callbacks);
        callbacks.v1_itemDataCallback = this.display.itemDataProc;
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        DataBrowserCustomCallbacks custom = new DataBrowserCustomCallbacks();
        custom.version = 0;
        OS.InitDataBrowserCustomCallbacks(custom);
        custom.v1_drawItemCallback = this.display.drawItemProc;
        custom.v1_hitTestCallback = this.display.hitTestProc;
        custom.v1_trackingCallback = this.display.trackingProc;
        OS.SetDataBrowserCustomCallbacks(this.handle, custom);
    }

    public int indexOf(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        int i = 0;
        while (i < this.columnCount) {
            if (this.columns[i] == column) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOf(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (1 <= this.lastIndexOf && this.lastIndexOf < this.itemCount - 1) {
            if (this.items[this.lastIndexOf] == item) {
                return this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf + 1] == item) {
                return ++this.lastIndexOf;
            }
            if (this.items[this.lastIndexOf - 1] == item) {
                return --this.lastIndexOf;
            }
        }
        if (this.lastIndexOf < this.itemCount / 2) {
            int i = 0;
            while (i < this.itemCount) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                ++i;
            }
        } else {
            int i = this.itemCount - 1;
            while (i >= 0) {
                if (this.items[i] == item) {
                    this.lastIndexOf = i;
                    return this.lastIndexOf;
                }
                --i;
            }
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        return OS.IsDataBrowserItemSelected(this.handle, this.getId(index));
    }

    int itemDataProc(int browser, int id, int property, int itemData, int setValue) {
        int index = this.getIndex(id);
        if (index < 0 || index >= this.items.length) {
            return 0;
        }
        switch (property) {
            case 1024: {
                TableItem item = this._getItem(index);
                if (!this.checkData(item, false)) {
                    return 0;
                }
                if (setValue != 0) {
                    boolean bl = item.checked = !item.checked;
                    if (item.checked && item.grayed) {
                        OS.SetDataBrowserItemDataButtonValue(itemData, (short)2);
                    } else {
                        boolean theData = item.checked;
                        OS.SetDataBrowserItemDataButtonValue(itemData, (short)(theData ? 1 : 0));
                    }
                    Event event = new Event();
                    event.item = item;
                    event.detail = 32;
                    this.sendSelectionEvent(13, event, false);
                    if (item.checked) break;
                    item.redraw(1024);
                    break;
                }
                int theData = 0;
                if (item.checked) {
                    theData = item.grayed ? 2 : 1;
                }
                OS.SetDataBrowserItemDataButtonValue(itemData, (short)theData);
            }
        }
        return 0;
    }

    int itemNotificationProc(int browser, int id, int message) {
        if (message == 13) {
            boolean resized = false;
            short[] width = new short[1];
            int[] position = new int[1];
            TableColumn[] columns = this.getColumns();
            int i = 0;
            while (i < this.columnCount) {
                TableColumn column = columns[i];
                if (!column.isDisposed()) {
                    OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, width);
                    if (width[0] != column.lastWidth) {
                        column.resized(width[0]);
                        resized = true;
                    }
                }
                if (!column.isDisposed()) {
                    OS.GetDataBrowserTableViewColumnPosition(this.handle, column.id, position);
                    if (position[0] != column.lastPosition) {
                        column.lastPosition = position[0];
                        column.sendEvent(10);
                        resized = true;
                    }
                }
                ++i;
            }
            int[] property = new int[1];
            OS.GetDataBrowserSortProperty(this.handle, property);
            if (property[0] != 0) {
                if (!resized) {
                    int i2 = 0;
                    while (i2 < this.columnCount) {
                        TableColumn column = columns[i2];
                        if (property[0] == column.id) {
                            column.sendSelectionEvent(this.display.clickCount == 2 ? 14 : 13);
                            break;
                        }
                        ++i2;
                    }
                }
                OS.SetDataBrowserSortProperty(this.handle, 0);
                if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
                    OS.SetDataBrowserSortProperty(this.handle, this.sortColumn.id);
                    int order = this.sortDirection == 1024 ? 2 : 1;
                    OS.SetDataBrowserSortOrder(this.handle, (short)order);
                }
            }
            return 0;
        }
        if (message == 6 && (this.style & 2) != 0 && this.getData("org.eclipse.swt.internal.dragStarted") != null) {
            this.ignoreSelect = true;
            OS.SetDataBrowserSelectedItems(this.handle, 1, new int[]{id}, 0);
            this.ignoreSelect = false;
            return 0;
        }
        int index = this.getIndex(id);
        if (index < 0 || index >= this.items.length) {
            return 0;
        }
        switch (message) {
            case 5: {
                this.savedAnchor = 0;
                break;
            }
            case 6: {
                int[] selectionCount = new int[1];
                if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, selectionCount) != 0 || selectionCount[0] != 0) break;
                this.savedAnchor = id;
            }
        }
        switch (message) {
            case 5: 
            case 6: {
                TableItem item = this._getItem(index);
                this.wasSelected = true;
                if (this.ignoreSelect) break;
                int[] first = new int[1];
                int[] last = new int[1];
                OS.GetDataBrowserSelectionAnchor(this.handle, first, last);
                boolean selected = false;
                if ((this.style & 2) != 0) {
                    int modifiers = OS.GetCurrentEventKeyModifiers();
                    if ((modifiers & 0x200) != 0) {
                        selected = message == 5 ? first[0] == id || last[0] == id : id == this.anchorFirst || id == this.anchorLast;
                    } else if ((modifiers & 0x100) != 0) {
                        selected = true;
                    } else {
                        selected = first[0] == last[0];
                        index = this.getIndex(last[0]);
                        if (index >= 0 && index < this.items.length) {
                            item = this._getItem(index);
                        }
                    }
                } else {
                    boolean bl = selected = message == 5;
                }
                if (!selected) break;
                this.anchorFirst = first[0];
                this.anchorLast = last[0];
                Event event = new Event();
                event.item = item;
                this.sendSelectionEvent(13, event, false);
                break;
            }
            case 7: {
                this.wasSelected = true;
                if (this.display.clickCount != 2) break;
                Event event = new Event();
                event.item = this._getItem(index);
                this.sendSelectionEvent(14, event, false);
            }
        }
        return 0;
    }

    int kEventAccessibleGetNamedAttribute(int nextHandler, int theEvent, int userData) {
        int code = -9874;
        int[] stringRef = new int[1];
        OS.GetEventParameter(theEvent, 1635020397, 1667658612, null, 4, null, stringRef);
        int length = 0;
        if (stringRef[0] != 0) {
            length = OS.CFStringGetLength(stringRef[0]);
        }
        char[] buffer = new char[length];
        CFRange range = new CFRange();
        range.length = length;
        OS.CFStringGetCharacters(stringRef[0], range, buffer);
        String attributeName = new String(buffer);
        if (attributeName.equals("AXHeader")) {
            short[] height = new short[1];
            OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
            if (height[0] == 0) {
                code = 0;
            }
        } else {
            int[] ref = new int[1];
            OS.GetEventParameter(theEvent, 1634689642, 1667658873, null, 4, null, ref);
            int axuielementref = ref[0];
            DataBrowserAccessibilityItemInfo itemInfo = new DataBrowserAccessibilityItemInfo();
            int err = OS.AXUIElementGetDataBrowserItemInfo(axuielementref, this.handle, 0, itemInfo);
            if (err == 0 && itemInfo.v0_columnProperty != 0 && itemInfo.v0_item != 0 && itemInfo.v0_propertyPart == 0) {
                int index;
                int columnIndex = 0;
                columnIndex = 0;
                while (columnIndex < this.columnCount) {
                    if (this.columns[columnIndex].id == itemInfo.v0_columnProperty) break;
                    ++columnIndex;
                }
                if ((columnIndex != this.columnCount || this.columnCount == 0) && (index = this.getIndex(itemInfo.v0_item)) >= 0 && index < this.itemCount) {
                    TableItem tableItem = this._getItem(index);
                    if (attributeName.equals("AXRole") || attributeName.equals("AXRoleDescription")) {
                        String roleText = "AXStaticText";
                        buffer = new char[roleText.length()];
                        roleText.getChars(0, buffer.length, buffer, 0);
                        stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                        if (stringRef[0] != 0) {
                            if (attributeName.equals("AXRole")) {
                                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                            } else {
                                int stringRef2 = OS.HICopyAccessibilityRoleDescription(stringRef[0], 0);
                                OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, new int[]{stringRef2});
                                OS.CFRelease(stringRef2);
                            }
                            OS.CFRelease(stringRef[0]);
                            code = 0;
                        }
                    } else if (attributeName.equals("AXChildren")) {
                        int children = OS.CFArrayCreateMutable(0, 0, 0);
                        OS.SetEventParameter(theEvent, 1635022444, 1667657057, 4, new int[]{children});
                        OS.CFRelease(children);
                        code = 0;
                    } else if (attributeName.equals("AXTitle") || attributeName.equals("AXDescription")) {
                        String text = tableItem.getText(columnIndex);
                        buffer = new char[text.length()];
                        text.getChars(0, buffer.length, buffer, 0);
                        stringRef[0] = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                        if (stringRef[0] != 0) {
                            OS.SetEventParameter(theEvent, 1635022444, 1667658612, 4, stringRef);
                            OS.CFRelease(stringRef[0]);
                            code = 0;
                        }
                    }
                }
            }
        }
        if (this.accessible != null) {
            code = this.accessible.internal_kEventAccessibleGetNamedAttribute(nextHandler, theEvent, code);
        }
        return code;
    }

    int kEventMouseDown(int nextHandler, int theEvent, int userData) {
        int index;
        int result = super.kEventMouseDown(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        this.wasSelected = false;
        result = OS.CallNextEventHandler(nextHandler, theEvent);
        if (this.isDisposed()) {
            return 0;
        }
        if (!this.wasSelected && OS.IsDataBrowserItemSelected(this.handle, this.lastHittest) && (index = this.getIndex(this.lastHittest)) >= 0 && index < this.itemCount) {
            Event event = new Event();
            event.item = this._getItem(index);
            this.sendSelectionEvent(13, event, false);
        }
        return result;
    }

    int kEventControlGetClickActivation(int nextHandler, int theEvent, int userData) {
        OS.SetEventParameter(theEvent, 1668047203, 1668047203, 4, new int[]{3});
        return 0;
    }

    int kEventControlSetCursor(int nextHandler, int theEvent, int userData) {
        if (!this.isEnabledCursor()) {
            return 0;
        }
        if (this.isEnabledModal()) {
            Point pt = new Point();
            int sizeof = 4;
            OS.GetEventParameter(theEvent, 1835822947, 1363439732, null, sizeof, null, pt);
            if (!this.contains(pt.h, pt.v)) {
                return -9874;
            }
        }
        return super.kEventControlSetCursor(nextHandler, theEvent, userData);
    }

    int kEventUnicodeKeyPressed(int nextHandler, int theEvent, int userData) {
        int result = super.kEventUnicodeKeyPressed(nextHandler, theEvent, userData);
        if (result == 0) {
            return result;
        }
        int[] keyboardEvent = new int[1];
        OS.GetEventParameter(theEvent, 1953721189, 1702261350, null, keyboardEvent.length * 4, null, keyboardEvent);
        int[] keyCode = new int[1];
        OS.GetEventParameter(keyboardEvent[0], 1801678692, 1835100014, null, keyCode.length * 4, null, keyCode);
        switch (keyCode[0]) {
            case 49: {
                int[] first = new int[1];
                int[] last = new int[1];
                if (OS.GetDataBrowserSelectionAnchor(this.handle, first, last) != 0 || first[0] == 0) break;
                TableItem item = this._getItem(this.getIndex(first[0]));
                if ((this.style & 0x20) == 0) break;
                item.setChecked(!item.getChecked(), true);
                break;
            }
            case 36: 
            case 76: {
                this.sendSelectionEvent(14);
                break;
            }
            case 125: 
            case 126: {
                if (this.itemCount == 0) break;
                int[] top = new int[1];
                int[] left = new int[1];
                OS.GetDataBrowserScrollPosition(this.handle, top, left);
                boolean selectItem = false;
                int[] selectionCount = new int[1];
                if (OS.GetDataBrowserItemCount(this.handle, 0, true, 1, selectionCount) == 0) {
                    boolean bl = selectItem = this.savedAnchor != 0 && selectionCount[0] == 0;
                }
                if (selectItem) {
                    int index = this.getIndex(this.savedAnchor) + (keyCode[0] == 125 ? 1 : -1);
                    index = Math.max(0, Math.min(this.itemCount - 1, index));
                    int[] itemId = new int[]{this.getId(index)};
                    OS.SetDataBrowserSelectedItems(this.handle, 1, itemId, 1);
                    result = 0;
                } else {
                    result = OS.CallNextEventHandler(nextHandler, theEvent);
                }
                OS.GetDataBrowserScrollPosition(this.handle, top, null);
                OS.SetDataBrowserScrollPosition(this.handle, top[0], left[0]);
                this.redrawBackgroundImage();
            }
        }
        return result;
    }

    void releaseChildren(boolean destroy) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                ++i;
            }
            this.items = null;
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (column != null && !column.isDisposed()) {
                    column.release(false);
                }
                ++i;
            }
            this.columns = null;
        }
        super.releaseChildren(destroy);
    }

    void releaseWidget() {
        super.releaseWidget();
        this.currentItem = null;
        this.sortColumn = null;
        this.paintGC = null;
        this.imageBounds = null;
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
    }

    public void remove(int index) {
        int[] id;
        int savedIndex;
        TableItem item;
        this.checkWidget();
        this.checkItems(true);
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        if ((item = this.items[index]) != null) {
            item.release(false);
        }
        if (this.savedAnchor != 0 && index < (savedIndex = this.getIndex(this.savedAnchor))) {
            this.savedAnchor = this.getId(Math.max(0, savedIndex - 1));
        }
        if (index != this.itemCount - 1) {
            this.fixSelection(index, false);
        }
        if (OS.RemoveDataBrowserItems(this.handle, 0, (id = new int[]{this.itemCount}).length, id, 0) != 0) {
            this.error(15);
        }
        System.arraycopy(this.items, index + 1, this.items, index, --this.itemCount - index);
        this.items[this.itemCount] = null;
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        if (this.itemCount == 0) {
            this.setTableEmpty();
        } else {
            this.fixScrollBar();
        }
    }

    public void remove(int start, int end) {
        this.checkWidget();
        this.checkItems(true);
        if (start > end) {
            return;
        }
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.removeAll();
        } else {
            int length = end - start + 1;
            int[] indices = new int[length];
            int i = 0;
            while (i < length) {
                indices[i] = i + start;
                ++i;
            }
            this.remove(indices);
        }
    }

    public void remove(int[] indices) {
        this.checkWidget();
        this.checkItems(true);
        if (indices == null) {
            this.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        if (start < 0 || start > end || end >= this.itemCount) {
            this.error(6);
        }
        int duplicates = 0;
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            if (newIndices[i] == last) {
                ++duplicates;
            }
            last = newIndices[i];
            ++i;
        }
        int[] id = new int[newIndices.length - duplicates];
        int idIndex = id.length - 1;
        last = -1;
        int i2 = 0;
        while (i2 < newIndices.length) {
            int index = newIndices[i2];
            if (index != last) {
                int savedIndex;
                TableItem item = this.items[index];
                if (item != null && !item.isDisposed()) {
                    item.release(false);
                }
                if (this.savedAnchor != 0 && index < (savedIndex = this.getIndex(this.savedAnchor))) {
                    this.savedAnchor = this.getId(Math.max(0, savedIndex - 1));
                }
                if (index != this.itemCount - 1) {
                    this.fixSelection(index, false);
                }
                id[idIndex--] = this.itemCount--;
                System.arraycopy(this.items, index + 1, this.items, index, this.itemCount - index);
                this.items[this.itemCount] = null;
                last = index;
            }
            ++i2;
        }
        if (OS.RemoveDataBrowserItems(this.handle, 0, id.length, id, 0) != 0) {
            this.error(15);
        }
        OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        if (this.itemCount == 0) {
            this.setTableEmpty();
        } else {
            this.fixScrollBar();
        }
    }

    public void removeAll() {
        this.checkWidget();
        int i = 0;
        while (i < this.itemCount) {
            TableItem item = this.items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        OS.RemoveDataBrowserItems(this.handle, 0, 0, null, 0);
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        this.setTableEmpty();
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resetVisibleRegion(int control) {
        super.resetVisibleRegion(control);
        if (this.showIndex != -1) {
            this.showIndex(this.showIndex);
        }
    }

    void reskinChildren(int flags) {
        int i;
        if (this.items != null) {
            i = 0;
            while (i < this.itemCount) {
                TableItem item = this.items[i];
                if (item != null) {
                    item.reskin(flags);
                }
                ++i;
            }
        }
        if (this.columns != null) {
            i = 0;
            while (i < this.columnCount) {
                TableColumn column = this.columns[i];
                if (!column.isDisposed()) {
                    column.reskin(flags);
                }
                ++i;
            }
        }
        super.reskinChildren(flags);
    }

    public void select(int index) {
        this.checkWidget();
        this.checkItems(false);
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{this.getId(index)};
            this.select(ids, ids.length, false);
        }
    }

    public void select(int start, int end) {
        this.checkWidget();
        this.checkItems(false);
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        if (start == 0 && end == this.itemCount - 1) {
            this.selectAll();
        } else {
            start = Math.max(0, start);
            end = Math.min(end, this.itemCount - 1);
            int length = end - start + 1;
            int[] ids = new int[length];
            int i = 0;
            while (i < length) {
                ids[i] = this.getId(end - i);
                ++i;
            }
            this.select(ids, length, false);
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        this.checkItems(false);
        if (indices == null) {
            this.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = indices[length - i - 1];
            if (index >= 0 && index < this.itemCount) {
                ids[count++] = this.getId(index);
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, false);
        }
    }

    void selectIndices(int[] indices, int count, boolean clear) {
        int i = 0;
        while (i < count) {
            indices[i] = this.getId(indices[i]);
            ++i;
        }
        this.select(indices, count, clear);
    }

    void select(int[] ids, int count, boolean clear) {
        this.ignoreSelect = true;
        int[] selectionFlags = null;
        if ((this.style & 4) != 0) {
            selectionFlags = new int[1];
            OS.GetDataBrowserSelectionFlags(this.handle, selectionFlags);
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0] & 0xFFFFFFBF);
        }
        int operation = 1;
        if ((this.style & 2) != 0 && !clear) {
            operation = 0;
        }
        OS.SetDataBrowserSelectedItems(this.handle, count, ids, operation);
        if ((this.style & 4) != 0) {
            OS.SetDataBrowserSelectionFlags(this.handle, selectionFlags[0]);
        }
        this.ignoreSelect = false;
    }

    public void selectAll() {
        this.checkWidget();
        this.checkItems(false);
        if ((this.style & 4) != 0) {
            return;
        }
        this.select(null, 0, false);
    }

    void setBackground(float[] color) {
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize, boolean events) {
        int result = super.setBounds(x, y, width, height, move, resize, events);
        if (this.showIndex != -1) {
            this.showIndex(this.showIndex);
        }
        return result;
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
        if (this.columnCount == 0) {
            if (order.length != 0) {
                this.error(5);
            }
            return;
        }
        if (order.length != this.columnCount) {
            this.error(5);
        }
        int[] oldOrder = this.getColumnOrder();
        boolean reorder = false;
        boolean[] seen = new boolean[this.columnCount];
        int i = 0;
        while (i < order.length) {
            int index = order[i];
            if (index < 0 || index >= this.columnCount) {
                this.error(5);
            }
            if (seen[index]) {
                this.error(5);
            }
            seen[index] = true;
            if (order[i] != oldOrder[i]) {
                reorder = true;
            }
            ++i;
        }
        if (reorder) {
            TableColumn column;
            int x = 0;
            short[] width = new short[1];
            int[] oldX = new int[oldOrder.length];
            int i2 = 0;
            while (i2 < oldOrder.length) {
                int index = oldOrder[i2];
                TableColumn column2 = this.columns[index];
                oldX[index] = x;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column2.id, width);
                x += width[0];
                ++i2;
            }
            x = 0;
            int[] newX = new int[order.length];
            int i3 = 0;
            while (i3 < order.length) {
                int index = order[i3];
                column = this.columns[index];
                int position = (this.style & 0x20) != 0 ? i3 + 1 : i3;
                OS.SetDataBrowserTableViewColumnPosition(this.handle, column.id, position);
                column.lastPosition = position;
                newX[index] = x;
                OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, width);
                x += width[0];
                ++i3;
            }
            TableColumn[] newColumns = new TableColumn[this.columnCount];
            System.arraycopy(this.columns, 0, newColumns, 0, this.columnCount);
            int i4 = 0;
            while (i4 < this.columnCount) {
                column = newColumns[i4];
                if (!column.isDisposed() && newX[i4] != oldX[i4]) {
                    column.sendEvent(10);
                }
                ++i4;
            }
        }
    }

    void setFontStyle(Font font) {
        super.setFontStyle(font);
        if (this.items == null) {
            return;
        }
        int i = 0;
        while (i < this.items.length) {
            TableItem item = this.items[i];
            if (item != null) {
                item.width = -1;
            }
            ++i;
        }
        this.setScrollWidth(this.items, true);
        this.setItemHeight(null);
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        short[] height = new short[1];
        OS.GetDataBrowserListViewHeaderBtnHeight(this.handle, height);
        if (height[0] != 0 != show) {
            OS.SetDataBrowserListViewHeaderBtnHeight(this.handle, (short)(show ? this.headerHeight : 0));
            this.invalidateVisibleRegion(this.handle);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.checkItems(true);
        count = Math.max(0, count);
        if (count == this.itemCount) {
            return;
        }
        this.setRedraw(false);
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        DataBrowserCallbacks callbacks = new DataBrowserCallbacks();
        OS.GetDataBrowserCallbacks(this.handle, callbacks);
        callbacks.v1_itemNotificationCallback = 0;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        if (count < this.itemCount) {
            boolean fixAnchor;
            int oldAnchor = this.savedAnchor;
            int selectionCount = this.getSelectionCount();
            int index = count;
            int[] id = new int[this.itemCount - count];
            while (index < this.itemCount) {
                TableItem item = this.items[index];
                if (item != null) {
                    item.release(false);
                }
                id[index - count] = index + 1;
                ++index;
            }
            if (OS.RemoveDataBrowserItems(this.handle, 0, id.length, id, 0) != 0) {
                this.error(15);
            }
            boolean bl = fixAnchor = selectionCount != 0 && this.getSelectionCount() == 0;
            if (fixAnchor || this.savedAnchor != 0 && this.savedAnchor != oldAnchor) {
                this.savedAnchor = this.getId(Math.max(0, count - 1));
            }
        }
        int length = Math.max(4, (count + 3) / 4 * 4);
        TableItem[] newItems = new TableItem[length];
        System.arraycopy(this.items, 0, newItems, 0, Math.min(count, this.itemCount));
        this.items = newItems;
        if ((this.style & 0x10000000) == 0) {
            int i = this.itemCount;
            while (i < count) {
                this.items[i] = new TableItem(this, 0, i, false);
                ++i;
            }
        }
        this.itemCount = count;
        OS.AddDataBrowserItems(this.handle, 0, this.itemCount, null, 0);
        callbacks.v1_itemNotificationCallback = this.display.itemNotificationProc;
        OS.SetDataBrowserCallbacks(this.handle, callbacks);
        this.fixScrollBar();
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection == 1024) {
            OS.UpdateDataBrowserItems(this.handle, 0, 0, null, 0, 0);
        }
        this.setRedraw(true);
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
        if (itemHeight != -1) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)itemHeight);
        }
    }

    void setItemHeight(Image image) {
        Rectangle bounds;
        Rectangle rectangle = bounds = image != null ? image.getBounds() : this.imageBounds;
        if (bounds == null) {
            return;
        }
        this.imageBounds = bounds;
        short[] height = new short[1];
        if (OS.GetDataBrowserTableViewRowHeight(this.handle, height) == 0 && height[0] < bounds.height) {
            OS.SetDataBrowserTableViewRowHeight(this.handle, (short)bounds.height);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
        if (OS.VERSION >= 4160) {
            int attrib = 6;
            OS.DataBrowserChangeAttributes(this.handle, show ? attrib : 0, !show ? attrib : 0);
            this.redraw();
        }
    }

    public void setRedraw(boolean redraw) {
        this.checkWidget();
        super.setRedraw(redraw);
        if (redraw && this.drawCount == 0) {
            if (this.items.length > 4 && this.items.length - this.itemCount > 3) {
                int length = Math.max(4, (this.itemCount + 3) / 4 * 4);
                TableItem[] newItems = new TableItem[length];
                System.arraycopy(this.items, 0, newItems, 0, this.itemCount);
                this.items = newItems;
            }
            this.checkItems(true);
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean[] horiz = new boolean[1];
        boolean[] vert = new boolean[1];
        OS.GetDataBrowserHasScrollBars(this.handle, horiz, vert);
        if ((bar.style & 0x100) != 0) {
            horiz[0] = visible;
        }
        if ((bar.style & 0x200) != 0) {
            vert[0] = visible;
        }
        if (!visible) {
            bar.redraw();
            bar.deregister();
        }
        if (OS.SetDataBrowserHasScrollBars(this.handle, horiz[0], vert[0]) == 0) {
            if (visible) {
                bar.handle = this.findStandardBar(bar.style);
                bar.register();
                bar.hookEvents();
                bar.redraw();
            } else {
                bar.handle = 0;
            }
            return true;
        }
        if (!visible) {
            bar.register();
        }
        return false;
    }

    boolean setScrollWidth(TableItem item) {
        if (this.columnCount != 0) {
            return false;
        }
        if (this.currentItem != null) {
            if (this.currentItem != item) {
                this.fixScrollWidth = true;
            }
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        GC gc = new GC(this);
        int newWidth = item.calculateWidth(0, gc);
        gc.dispose();
        short[] width = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
        if (width[0] < (newWidth += this.getInsetWidth())) {
            OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, (short)newWidth);
            return true;
        }
        return false;
    }

    boolean setScrollWidth(TableItem[] items, boolean set) {
        if (this.columnCount != 0) {
            return false;
        }
        if (this.currentItem != null) {
            this.fixScrollWidth = true;
            return false;
        }
        if (!this.getDrawing()) {
            return false;
        }
        GC gc = new GC(this);
        short newWidth = 0;
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            if (item != null) {
                newWidth = Math.max(newWidth, item.calculateWidth(0, gc));
            }
            ++i;
        }
        gc.dispose();
        newWidth += this.getInsetWidth();
        if (!set) {
            short[] width = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, width);
            if (width[0] >= newWidth) {
                return false;
            }
        }
        OS.SetDataBrowserTableViewNamedColumnWidth(this.handle, this.column_id, newWidth);
        return true;
    }

    public void setSelection(int index) {
        this.checkWidget();
        this.checkItems(false);
        this.deselectAll();
        this.setSelection(index, false);
    }

    void setSelection(int index, boolean notify) {
        if (index >= 0 && index < this.itemCount) {
            int[] ids = new int[]{this.getId(index)};
            this.select(ids, ids.length, true);
            this.showIndex(index);
            if (notify) {
                Event event = new Event();
                event.item = this._getItem(index);
                this.sendSelectionEvent(13, event, false);
            }
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        this.checkItems(false);
        this.deselectAll();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        if (this.itemCount == 0 || start >= this.itemCount) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, this.itemCount - 1);
        int length = end - start + 1;
        int[] ids = new int[length];
        int i = 0;
        while (i < length) {
            ids[i] = this.getId(end - i);
            ++i;
        }
        this.select(ids, length, true);
        this.showIndex(this.getIndex(ids[0]));
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        this.checkItems(false);
        if (indices == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = indices[length - i - 1];
            if (index >= 0 && index < this.itemCount) {
                ids[count++] = this.getId(index);
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, true);
            this.showIndex(this.getIndex(ids[0]));
        }
    }

    public void setSelection(TableItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TableItem[]{item});
    }

    public void setSelection(TableItem[] items) {
        this.checkWidget();
        this.checkItems(false);
        if (items == null) {
            this.error(4);
        }
        this.deselectAll();
        int length = items.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] ids = new int[length];
        int count = 0;
        int i = 0;
        while (i < length) {
            int index = this.indexOf(items[length - i - 1]);
            if (index != -1) {
                ids[count++] = this.getId(index);
            }
            ++i;
        }
        if (count > 0) {
            this.select(ids, count, true);
            this.showIndex(this.getIndex(ids[0]));
        }
    }

    public void setSortColumn(TableColumn column) {
        this.checkWidget();
        if (column != null && column.isDisposed()) {
            this.error(5);
        }
        if (column == this.sortColumn) {
            return;
        }
        int[] indices = this.getSelectionIndices();
        this.sortColumn = column;
        int id = 0;
        int order = 1;
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            id = this.sortColumn.id;
            if (this.sortDirection == 1024) {
                order = 2;
            }
        }
        OS.SetDataBrowserSortProperty(this.handle, id);
        OS.SetDataBrowserSortOrder(this.handle, (short)order);
        this.selectIndices(indices, indices.length, true);
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
        if (direction != 128 && direction != 1024 && direction != 0) {
            return;
        }
        if (direction == this.sortDirection) {
            return;
        }
        int[] indices = this.getSelectionIndices();
        this.sortDirection = direction;
        int id = 0;
        int order = 1;
        if (this.sortColumn != null && !this.sortColumn.isDisposed() && this.sortDirection != 0) {
            id = this.sortColumn.id;
            if (this.sortDirection == 1024) {
                order = 2;
            }
        }
        OS.SetDataBrowserSortProperty(this.handle, id);
        OS.SetDataBrowserSortOrder(this.handle, (short)order);
        this.selectIndices(indices, indices.length, true);
    }

    void setTableEmpty() {
        OS.SetDataBrowserScrollPosition(this.handle, 0, 0);
        this.savedAnchor = 0;
        this.anchorLast = 0;
        this.anchorFirst = 0;
        this.itemCount = 0;
        this.items = new TableItem[4];
        if (this.imageBounds != null) {
            this.imageBounds = null;
            this.setFontStyle(this.font);
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        this.checkItems(false);
        int itemHeight = this.getItemHeight();
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        top[0] = Math.max(0, Math.min(itemHeight * this.itemCount + this.getHeaderHeight() - this.getClientArea().height, index * itemHeight));
        OS.SetDataBrowserScrollPosition(this.handle, top[0], left[0]);
    }

    public void showColumn(TableColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (this.columnCount <= 1 || index < 0 || index >= this.columnCount) {
            return;
        }
        short[] w = new short[1];
        OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, column.id, w);
        int width = w[0];
        int x = 0;
        int i = 0;
        while (i < index) {
            w = new short[1];
            OS.GetDataBrowserTableViewNamedColumnWidth(this.handle, this.columns[i].id, w);
            x += w[0];
            ++i;
        }
        int[] top = new int[1];
        int[] left = new int[1];
        OS.GetDataBrowserScrollPosition(this.handle, top, left);
        if (x < left[0]) {
            OS.SetDataBrowserScrollPosition(this.handle, top[0], x);
        } else {
            Rectangle rect = this.getClientArea();
            int maxWidth = rect.width;
            if (x + (width = Math.min(width, maxWidth)) > left[0] + maxWidth) {
                left[0] = x + width - maxWidth;
                OS.SetDataBrowserScrollPosition(this.handle, top[0], left[0]);
            }
        }
    }

    void showIndex(int index) {
        if (index >= 0 && index < this.itemCount) {
            Rectangle rect = this.getClientArea();
            if (rect.height < this.getItemHeight() || !OS.IsControlVisible(this.handle)) {
                this.showIndex = index;
                return;
            }
            this.showIndex = -1;
            TableItem item = this._getItem(index);
            Rectangle itemRect = item.getBounds(0);
            if (!itemRect.isEmpty() && rect.contains(itemRect.x, itemRect.y) && rect.contains(itemRect.x, itemRect.y + itemRect.height)) {
                return;
            }
            int[] top = new int[1];
            int[] left = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, top, left);
            OS.RevealDataBrowserItem(this.handle, this.getId(index), 0, (byte)2);
            int[] newTop = new int[1];
            int[] newLeft = new int[1];
            OS.GetDataBrowserScrollPosition(this.handle, newTop, newLeft);
            if (this.horizontalBar != null && newLeft[0] != left[0]) {
                this.horizontalBar.redraw();
            }
            if (this.verticalBar != null && newTop[0] != top[0]) {
                this.verticalBar.redraw();
            }
        }
    }

    public void showItem(TableItem item) {
        int index;
        this.checkWidget();
        this.checkItems(false);
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if ((index = this.indexOf(item)) != -1) {
            this.showIndex(index);
        }
    }

    public void showSelection() {
        this.checkWidget();
        this.checkItems(false);
        int index = this.getSelectionIndex();
        if (index >= 0) {
            this.showIndex(index);
        }
    }

    int trackingProc(int browser, int id, int property, int theRect, int startPt, int modifiers) {
        return 1;
    }
}

