/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    long boxHandle;
    long arrowHandle;
    long arrowBoxHandle;
    long separatorHandle;
    long labelHandle;
    long imageHandle;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    boolean drawHotImage;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        this.createWidget(parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        int count = parent.getItemCount();
        if (index < 0 || index > count) {
            this.error(6);
        }
        this.createWidget(index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        if ((this.style & 2) == 0) {
            long l = this.boxHandle = (this.parent.style & 0x20000) != 0 ? OS.gtk_hbox_new(false, 0) : OS.gtk_vbox_new(false, 0);
            if (this.boxHandle == 0L) {
                this.error(2);
            }
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0L) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new();
            if (this.imageHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.boxHandle, this.imageHandle);
            OS.gtk_container_add(this.boxHandle, this.labelHandle);
            if ((this.parent.style & 0x200) != 0) {
                OS.gtk_box_set_child_packing(this.boxHandle, this.imageHandle, false, false, 0, 0);
                OS.gtk_box_set_child_packing(this.boxHandle, this.labelHandle, false, false, 2, 0);
            }
        }
        int bits = 62;
        switch (this.style & bits) {
            case 2: {
                this.handle = OS.gtk_hbox_new(false, 0);
                if (this.handle == 0L) {
                    this.error(2);
                }
                boolean isVertical = (this.parent.style & 0x200) != 0;
                long l = this.separatorHandle = isVertical ? OS.gtk_hseparator_new() : OS.gtk_vseparator_new();
                if (this.separatorHandle == 0L) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request(this.separatorHandle, isVertical ? 15 : 6, isVertical ? 6 : 15);
                OS.gtk_widget_set_size_request(this.handle, isVertical ? 15 : 6, isVertical ? 6 : 15);
                OS.gtk_container_add(this.handle, this.separatorHandle);
                break;
            }
            case 4: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                this.arrowBoxHandle = OS.gtk_hbox_new(false, 0);
                if (this.arrowBoxHandle == 0L) {
                    this.error(2);
                }
                this.arrowHandle = OS.gtk_arrow_new(1, 0);
                if (this.arrowHandle == 0L) {
                    this.error(2);
                }
                OS.gtk_widget_set_size_request(this.arrowHandle, 8, 6);
                OS.gtk_container_add(this.handle, this.arrowBoxHandle);
                OS.gtk_container_add(this.arrowBoxHandle, this.boxHandle);
                OS.gtk_container_add(this.arrowBoxHandle, this.arrowHandle);
                break;
            }
            case 16: 
            case 32: {
                this.handle = OS.gtk_toggle_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_toggle_button_set_mode(this.handle, false);
                OS.gtk_container_add(this.handle, this.boxHandle);
                break;
            }
            default: {
                this.handle = OS.gtk_button_new();
                if (this.handle == 0L) {
                    this.error(2);
                }
                OS.gtk_container_add(this.handle, this.boxHandle);
            }
        }
        if ((this.style & 2) == 0) {
            int[] relief = new int[1];
            OS.gtk_widget_style_get(this.parent.handle, OS.button_relief, relief, 0L);
            OS.gtk_button_set_relief(this.handle, relief[0]);
        }
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        if ((this.parent.state & 0x1000) != 0) {
            this.setForegroundColor(this.parent.getForegroundColor());
        }
        if ((this.parent.state & 0x4000) != 0) {
            this.setFontDescription(this.parent.getFontDescription());
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.showWidget(index);
        this.parent.relayout();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    void deregister() {
        super.deregister();
        if (this.labelHandle != 0L) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar parent = this.parent;
        super.dispose();
        parent.relayout();
    }

    public Rectangle getBounds() {
        int height;
        int width;
        int y;
        int x;
        this.checkWidget();
        this.parent.forceResize();
        long topHandle = this.topHandle();
        if (OS.GTK_VERSION < OS.VERSION(2, 4, 0) && this.control != null && !this.control.isDisposed()) {
            int border = OS.gtk_container_get_border_width(this.parent.handle);
            byte[] shadowType = Converter.wcsToMbcs(null, "shadow_type", true);
            int[] shadow = new int[1];
            OS.gtk_widget_style_get(this.parent.handle, shadowType, shadow, 0L);
            if (shadow[0] != 0) {
                border += OS.gtk_style_get_xthickness(OS.gtk_widget_get_style(this.parent.handle));
            }
            if ((this.parent.style & 0x200) != 0) {
                x = border;
                y = OS.GTK_WIDGET_Y(topHandle) + border;
                width = OS.GTK_WIDGET_WIDTH(this.parent.handle) - border * 2;
                height = OS.GTK_WIDGET_HEIGHT(topHandle);
            } else {
                x = OS.GTK_WIDGET_X(topHandle) + border;
                y = border;
                width = OS.GTK_WIDGET_WIDTH(topHandle);
                height = OS.GTK_WIDGET_HEIGHT(this.parent.handle) - border * 2;
            }
        } else {
            x = OS.GTK_WIDGET_X(topHandle);
            y = OS.GTK_WIDGET_Y(topHandle);
            width = OS.GTK_WIDGET_WIDTH(topHandle);
            height = OS.GTK_WIDGET_HEIGHT(topHandle);
        }
        if ((this.parent.style & 0x8000000) != 0) {
            x = this.parent.getClientWidth() - width - x;
        }
        if ((this.style & 2) != 0 && this.control != null) {
            height = Math.max(height, 23);
        }
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        long topHandle = this.topHandle();
        return OS.GTK_WIDGET_SENSITIVE(topHandle);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_toggle_button_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        this.parent.forceResize();
        long topHandle = this.topHandle();
        return OS.GTK_WIDGET_WIDTH(topHandle);
    }

    long gtk_button_press_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        double x = gdkEvent.x;
        gdkEvent.x += (double)OS.GTK_WIDGET_X(this.handle);
        double y = gdkEvent.y;
        gdkEvent.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        long result = this.parent.gtk_button_press_event(widget, event);
        gdkEvent.x = x;
        gdkEvent.y = y;
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        return result;
    }

    long gtk_button_release_event(long widget, long event) {
        GdkEventButton gdkEvent = new GdkEventButton();
        OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
        double x = gdkEvent.x;
        gdkEvent.x += (double)OS.GTK_WIDGET_X(this.handle);
        double y = gdkEvent.y;
        gdkEvent.y += (double)OS.GTK_WIDGET_Y(this.handle);
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        long result = this.parent.gtk_button_release_event(widget, event);
        gdkEvent.x = x;
        gdkEvent.y = y;
        OS.memmove(event, gdkEvent, (long)GdkEventButton.sizeof);
        return result;
    }

    long gtk_clicked(long widget) {
        long eventPtr;
        Event event = new Event();
        if ((this.style & 4) != 0 && (eventPtr = OS.gtk_get_current_event()) != 0L) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, eventPtr, (long)GdkEvent.sizeof);
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: {
                    double[] x_win = new double[1];
                    double[] y_win = new double[1];
                    OS.gdk_event_get_coords(eventPtr, x_win, y_win);
                    int x = OS.GTK_WIDGET_X(this.arrowHandle) - OS.GTK_WIDGET_X(this.handle);
                    int width = OS.GTK_WIDGET_WIDTH(this.arrowHandle);
                    if (((this.parent.style & 0x4000000) != 0 || x > (int)x_win[0]) && ((this.parent.style & 0x4000000) == 0 || (int)x_win[0] > x + width)) break;
                    event.detail = 4;
                    long topHandle = this.topHandle();
                    event.x = OS.GTK_WIDGET_X(topHandle);
                    if ((this.parent.style & 0x8000000) != 0) {
                        event.x = this.parent.getClientWidth() - OS.GTK_WIDGET_WIDTH(topHandle) - event.x;
                    }
                    event.y = OS.GTK_WIDGET_Y(topHandle) + OS.GTK_WIDGET_HEIGHT(topHandle);
                }
            }
            OS.gdk_event_free(eventPtr);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13, event, false);
        return 0L;
    }

    long gtk_enter_notify_event(long widget, long event) {
        int index;
        ImageList imageList;
        this.parent.gtk_enter_notify_event(widget, event);
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && this.imageHandle != 0L && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(this.hotImage)) != -1) {
            long pixbuf = imageList.getPixbuf(index);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
        }
        return 0L;
    }

    long gtk_event_after(long widget, long gdkEvent) {
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, (long)GdkEvent.sizeof);
        switch (event.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, gdkEvent, (long)GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
            }
        }
        return 0L;
    }

    long gtk_focus_out_event(long widget, long event) {
        OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        this.parent.lastFocus = this;
        return 0L;
    }

    long gtk_leave_notify_event(long widget, long event) {
        this.parent.gtk_leave_notify_event(widget, event);
        if (this.drawHotImage) {
            int index;
            ImageList imageList;
            this.drawHotImage = false;
            if (this.imageHandle != 0L && this.image != null && (imageList = this.parent.imageList) != null && (index = imageList.indexOf(this.image)) != -1) {
                long pixbuf = imageList.getPixbuf(index);
                OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            }
        }
        return 0L;
    }

    long gtk_map(long widget) {
        this.parent.fixZOrder();
        return 0L;
    }

    long gtk_mnemonic_activate(long widget, long arg1) {
        return this.parent.gtk_mnemonic_activate(widget, arg1);
    }

    boolean hasFocus() {
        return OS.GTK_WIDGET_HAS_FOCUS(this.handle);
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.closures[8], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[14], 0, this.display.closures[14], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[29], 0, this.display.closures[29], false);
        if (this.labelHandle != 0L) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.closures[32], false);
        }
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[22], 0, this.display.closures[22], false);
        int mask = 32518;
        OS.gtk_widget_add_events(this.handle, mask);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[2], 0, this.display.closures[2], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[4], 0, this.display.closures[4], false);
        OS.g_signal_connect_closure_by_id(this.handle, this.display.signalIds[16], 0, this.display.closures[16], false);
        long topHandle = this.topHandle();
        OS.g_signal_connect_closure_by_id(topHandle, this.display.signalIds[30], 0, this.display.closures[30], true);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        ToolItem[] tabList = this.parent._getTabItemList();
        if (tabList != null) {
            int i = 0;
            while (i < tabList.length) {
                if (tabList[i] == this) {
                    return true;
                }
                ++i;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        int index = this.parent.indexOf(this);
        if (index == 0) {
            return true;
        }
        ToolItem previous = this.parent.getItem(index - 1);
        return (previous.getStyle() & 2) != 0;
    }

    void register() {
        super.register();
        if (this.labelHandle != 0L) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0L;
        this.labelHandle = 0L;
        this.separatorHandle = 0L;
        this.arrowHandle = 0L;
        this.boxHandle = 0L;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            if (this.separatorHandle != 0L) {
                OS.gtk_widget_hide(this.separatorHandle);
            }
            Rectangle itemRect = this.getBounds();
            this.control.setSize(itemRect.width, itemRect.height);
            OS.gtk_widget_set_size_request(this.handle, itemRect.width, itemRect.height);
            Rectangle rect = this.control.getBounds();
            rect.x = itemRect.x + (itemRect.width - rect.width) / 2;
            rect.y = itemRect.y + (itemRect.height - rect.height) / 2;
            this.control.setLocation(rect.x, rect.y);
        } else if (this.separatorHandle != 0L) {
            OS.gtk_widget_show(this.separatorHandle);
        }
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.parent.relayout();
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        long topHandle = this.topHandle();
        OS.gtk_widget_set_sensitive(topHandle, enabled);
        if (enabled) {
            int[] x = new int[1];
            int[] y = new int[1];
            OS.gdk_window_get_pointer(this.parent.paintWindow(), x, y, null);
            if (this.getBounds().contains(x[0], y[0])) {
                OS.gtk_widget_hide(this.handle);
                OS.gtk_widget_show(this.handle);
            }
        } else if (OS.GTK_VERSION >= OS.VERSION(2, 14, 0)) {
            OS.gtk_widget_set_state(topHandle, 0);
        }
    }

    boolean setFocus() {
        if ((this.style & 2) != 0) {
            return false;
        }
        if (!OS.gtk_widget_get_child_visible(this.handle)) {
            return false;
        }
        OS.GTK_WIDGET_SET_FLAGS(this.handle, 2048);
        OS.gtk_widget_grab_focus(this.handle);
        boolean result = OS.gtk_widget_is_focus(this.handle);
        if (!result) {
            OS.GTK_WIDGET_UNSET_FLAGS(this.handle, 2048);
        }
        return result;
    }

    void setFontDescription(long font) {
        OS.gtk_widget_modify_font(this.handle, font);
        if (this.labelHandle != 0L) {
            OS.gtk_widget_modify_font(this.labelHandle, font);
        }
        if (this.imageHandle != 0L) {
            OS.gtk_widget_modify_font(this.imageHandle, font);
        }
    }

    void setForegroundColor(GdkColor color) {
        this.setForegroundColor(this.handle, color);
        if (this.labelHandle != 0L) {
            this.setForegroundColor(this.labelHandle, color);
        }
        if (this.imageHandle != 0L) {
            this.setForegroundColor(this.imageHandle, color);
        }
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (this.imageHandle == 0L) {
            return;
        }
        if (image != null) {
            int imageIndex;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((imageIndex = imageList.indexOf(image)) == -1) {
                imageIndex = imageList.add(image);
            } else {
                imageList.put(imageIndex, image);
            }
            long pixbuf = imageList.getPixbuf(imageIndex);
            OS.gtk_image_set_from_pixbuf(this.imageHandle, pixbuf);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            OS.gtk_image_set_from_pixbuf(this.imageHandle, 0L);
            OS.gtk_widget_hide(this.imageHandle);
        }
        this.parent.relayout();
    }

    void setOrientation() {
        if ((this.parent.style & 0x4000000) != 0) {
            if (this.handle != 0L) {
                OS.gtk_widget_set_direction(this.handle, 2);
            }
            if (this.labelHandle != 0L) {
                OS.gtk_widget_set_direction(this.labelHandle, 2);
            }
            if (this.imageHandle != 0L) {
                OS.gtk_widget_set_direction(this.imageHandle, 2);
            }
            if (this.separatorHandle != 0L) {
                OS.gtk_widget_set_direction(this.separatorHandle, 2);
            }
            if (this.arrowHandle != 0L) {
                OS.gtk_widget_set_direction(this.arrowHandle, 2);
            }
            if (this.boxHandle != 0L) {
                OS.gtk_widget_set_direction(this.boxHandle, 2);
            }
            if (this.arrowBoxHandle != 0L) {
                OS.gtk_widget_set_direction(this.arrowBoxHandle, 2);
            }
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
        OS.gtk_toggle_button_set_active(this.handle, selected);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0L, 0L, 8L);
    }

    boolean setTabItemFocus(boolean next) {
        return this.setFocus();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0L) {
            return;
        }
        char[] chars = this.fixMnemonic(string);
        byte[] buffer = Converter.wcsToMbcs(null, chars, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, buffer);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.parent.toolTipText == null) {
            Shell shell = this.parent._getShell();
            this.setToolTipText(shell, string);
        }
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String newString) {
        shell.setToolTipText(this.handle, newString);
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0) {
            return;
        }
        boolean isVertical = (this.parent.style & 0x200) != 0;
        OS.gtk_widget_set_size_request(this.separatorHandle, width, isVertical ? 6 : 15);
        OS.gtk_widget_set_size_request(this.handle, width, isVertical ? 6 : 15);
        this.parent.relayout();
    }

    void showWidget(int index) {
        if (this.handle != 0L) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.boxHandle != 0L) {
            OS.gtk_widget_show(this.boxHandle);
        }
        if (this.separatorHandle != 0L) {
            OS.gtk_widget_show(this.separatorHandle);
        }
        if (this.arrowBoxHandle != 0L) {
            OS.gtk_widget_show(this.arrowBoxHandle);
        }
        if (this.arrowHandle != 0L) {
            OS.gtk_widget_show(this.arrowHandle);
        }
        OS.gtk_toolbar_insert_widget(this.parent.handle, this.handle, null, null, index);
    }
}

