/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;

public class Slider
extends Control {
    boolean dragSent = false;

    public Slider(Composite parent, int style) {
        super(parent, Slider.checkStyle(style));
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return Slider.checkBits(style, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        int hScroll = this.display.scrolledMarginX;
        int vScroll = this.display.scrolledMarginY;
        if ((this.style & 0x100) != 0) {
            width += hScroll * 10;
            height += vScroll;
        } else {
            width += hScroll;
            height += vScroll * 10;
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        int[] argList = new int[]{OS.XmNancestorSensitive, 1, OS.XmNhighlightThickness, this.display.textHighlightThickness, OS.XmNborderWidth, (this.style & 0x800) != 0 ? 1 : 0, OS.XmNorientation, (this.style & 0x100) != 0 ? 2 : 1, OS.XmNtraversalOn, 1};
        int parentHandle = this.parent.handle;
        this.handle = OS.XmCreateScrollBar(parentHandle, null, argList, argList.length / 2);
        if (this.handle == 0) {
            this.error(2);
        }
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNincrement;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNmaximum;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNminimum;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNpageIncrement;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNvalue;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    public int getThumb() {
        this.checkWidget();
        int[] nArray = new int[2];
        nArray[0] = OS.XmNsliderSize;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        return argList[1];
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.XtAddCallback(this.handle, OS.XmNvalueChangedCallback, windowProc, 24);
        OS.XtAddCallback(this.handle, OS.XmNdragCallback, windowProc, 15);
        OS.XtAddCallback(this.handle, OS.XmNtoBottomCallback, windowProc, 22);
        OS.XtAddCallback(this.handle, OS.XmNtoTopCallback, windowProc, 23);
        OS.XtAddCallback(this.handle, OS.XmNincrementCallback, windowProc, 18);
        OS.XtAddCallback(this.handle, OS.XmNdecrementCallback, windowProc, 13);
        OS.XtAddCallback(this.handle, OS.XmNpageIncrementCallback, windowProc, 21);
        OS.XtAddCallback(this.handle, OS.XmNpageDecrementCallback, windowProc, 20);
    }

    void overrideTranslations() {
        OS.XtOverrideTranslations(this.handle, this.display.tabTranslations);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void sendScrollEvent(int detail) {
        Event event = new Event();
        event.detail = detail;
        this.postEvent(13, event);
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] argList = new int[]{OS.XmNincrement, value};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] argList = new int[]{OS.XmNmaximum, value};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        int[] nArray = new int[6];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        nArray[4] = OS.XmNsliderSize;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        if (argList[3] - value - argList[5] < 0) {
            argList[5] = argList[3] - value;
        }
        argList[1] = value;
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] argList = new int[]{OS.XmNpageIncrement, value};
        OS.XtSetValues(this.handle, argList, argList.length / 2);
    }

    public void setSelection(int value) {
        this.checkWidget();
        int[] argList = new int[]{OS.XmNvalue, value};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setThumb(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        int[] nArray = new int[4];
        nArray[0] = OS.XmNminimum;
        nArray[2] = OS.XmNmaximum;
        int[] argList = nArray;
        OS.XtGetValues(this.handle, argList, argList.length / 2);
        value = Math.min(value, argList[3] - argList[1]);
        int[] argList2 = new int[]{OS.XmNsliderSize, value};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList2, argList2.length / 2);
        this.display.setWarnings(warnings);
    }

    public void setValues(int selection, int minimum, int maximum, int thumb, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum < 0) {
            return;
        }
        if (thumb < 1) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        thumb = Math.min(thumb, maximum - minimum);
        int[] argList = new int[]{OS.XmNvalue, selection, OS.XmNminimum, minimum, OS.XmNmaximum, maximum, OS.XmNsliderSize, thumb, OS.XmNincrement, increment, OS.XmNpageIncrement, pageIncrement};
        boolean warnings = this.display.getWarnings();
        this.display.setWarnings(false);
        OS.XtSetValues(this.handle, argList, argList.length / 2);
        this.display.setWarnings(warnings);
    }

    int XButtonPress(int w, int client_data, int call_data, int continue_to_dispatch) {
        int result = super.XButtonPress(w, client_data, call_data, continue_to_dispatch);
        if (result != 0) {
            return result;
        }
        this.dragSent = false;
        return result;
    }

    int XmNdecrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000001);
        return 0;
    }

    int XmNdragCallback(int w, int client_data, int call_data) {
        this.dragSent = true;
        this.sendScrollEvent(1);
        return 0;
    }

    int XmNincrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000002);
        return 0;
    }

    int XmNpageDecrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000005);
        return 0;
    }

    int XmNpageIncrementCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000006);
        return 0;
    }

    int XmNtoBottomCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000008);
        return 0;
    }

    int XmNtoTopCallback(int w, int client_data, int call_data) {
        this.sendScrollEvent(0x1000007);
        return 0;
    }

    int XmNvalueChangedCallback(int w, int client_data, int call_data) {
        if (!this.dragSent) {
            this.sendScrollEvent(1);
            this.dragSent = false;
        }
        this.sendScrollEvent(0);
        return 0;
    }
}

