/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSColorPanel;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ColorDialog
extends Dialog {
    RGB rgb;
    boolean selected;

    public ColorDialog(Shell parent) {
        this(parent, 65536);
    }

    public ColorDialog(Shell parent, int style) {
        super(parent, ColorDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    void changeColor(long id2, long sel, long sender) {
        this.selected = true;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public RGB open() {
        NSColor color;
        NSColorPanel panel = NSColorPanel.sharedColorPanel();
        if (this.rgb != null) {
            NSColor color2 = NSColor.colorWithDeviceRed((float)this.rgb.red / 255.0f, (float)this.rgb.green / 255.0f, (float)this.rgb.blue / 255.0f, 1.0);
            panel.setColor(color2);
        }
        SWTPanelDelegate delegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
        long jniRef = OS.NewGlobalRef(this);
        if (jniRef == 0L) {
            SWT.error(2);
        }
        OS.object_setInstanceVariable(delegate.id, Display.SWT_OBJECT, jniRef);
        panel.setDelegate(delegate);
        this.rgb = null;
        this.selected = false;
        panel.orderFront(null);
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(this);
        NSApplication.sharedApplication().runModalForWindow(panel);
        display.setModalDialog(null);
        panel.setDelegate(null);
        delegate.release();
        OS.DeleteGlobalRef(jniRef);
        if (this.selected && (color = panel.color()) != null) {
            color = color.colorUsingColorSpaceName(OS.NSCalibratedRGBColorSpace);
            this.rgb = new RGB((int)(color.redComponent() * 255.0), (int)(color.greenComponent() * 255.0), (int)(color.blueComponent() * 255.0));
        }
        return this.rgb;
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    void windowWillClose(long id2, long sel, long sender) {
        NSApplication.sharedApplication().stop(null);
    }
}

