/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhEvent_t;
import org.eclipse.swt.internal.photon.PhPoint_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.WidgetTable;

public class ToolItem
extends Item {
    ToolBar parent;
    Control control;
    String toolTipText;
    int toolTipHandle;
    Image hotImage;
    Image disabledImage;
    int button;
    int arrow;

    public ToolItem(ToolBar parent, int style) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, parent.getItemCount());
    }

    public ToolItem(ToolBar parent, int style, int index) {
        super(parent, ToolItem.checkStyle(style));
        this.parent = parent;
        parent.createItem(this, index);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            ToolItem.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int style) {
        return ToolItem.checkBits(style, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            ToolItem.error(43);
        }
    }

    void click() {
        this.click(this.handle);
    }

    int createArrowImage() {
        short width = 5;
        short height = 4;
        int image = OS.PhCreateImage(null, width, height, 33, 0, 0, 0);
        if (image == 0) {
            SWT.error(2);
        }
        PhDim_t dim = new PhDim_t();
        dim.w = width;
        dim.h = height;
        int mc = OS.PmMemCreateMC(image, dim, new PhPoint_t());
        if (mc == 0) {
            SWT.error(2);
        }
        int prevContext = OS.PmMemStart(mc);
        OS.PgSetFillColor(0xFFFFFF);
        OS.PgDrawIRect(0, 0, width, height, 32);
        OS.PgSetStrokeColor(0);
        OS.PgSetFillColor(0);
        short[] sArray = new short[6];
        sArray[1] = 1;
        sArray[2] = 2;
        sArray[3] = 3;
        sArray[4] = 4;
        sArray[5] = 1;
        short[] points = sArray;
        OS.PgDrawPolygon(points, points.length / 2, new PhPoint_t(), 4144);
        OS.PmMemFlush(mc, image);
        OS.PmMemStop(mc);
        OS.PmMemReleaseMC(mc);
        OS.PhDCSetCurrent(prevContext);
        OS.PhMakeTransBitmap(image, 0xFFFFFF);
        return image;
    }

    void createHandle(int index) {
        this.state |= 8;
        int count = this.parent.getItemCount();
        if (index < 0 || index > count) {
            ToolItem.error(6);
        }
        int parentHandle = this.parent.handle;
        if ((this.style & 2) != 0) {
            int[] nArray = new int[6];
            nArray[0] = 1023;
            nArray[1] = 2;
            nArray[3] = 1008;
            nArray[4] = 0x100000;
            nArray[5] = 0x3F00000;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(OS.PtContainer(), parentHandle, args.length / 3, args);
            if (this.handle == 0) {
                ToolItem.error(2);
            }
        } else if ((this.style & 4) != 0) {
            int[] nArray = new int[6];
            nArray[0] = 11002;
            nArray[3] = 11000;
            nArray[4] = 512;
            nArray[5] = 512;
            int[] args = nArray;
            this.handle = OS.PtCreateWidget(OS.PtGroup(), parentHandle, args.length / 3, args);
            if (this.handle == 0) {
                ToolItem.error(2);
            }
            boolean rightAligned = (this.parent.style & 0x20000) != 0;
            int[] nArray2 = new int[12];
            nArray2[0] = 3003;
            nArray2[3] = 1006;
            nArray2[5] = 1024;
            nArray2[6] = 3016;
            nArray2[7] = rightAligned ? 0 : 3;
            nArray2[9] = 2015;
            nArray2[11] = 136;
            args = nArray2;
            this.button = OS.PtCreateWidget(OS.PtButton(), this.handle, args.length / 3, args);
            if (this.button == 0) {
                ToolItem.error(2);
            }
            int arrowImage = this.createArrowImage();
            int[] nArray3 = new int[15];
            nArray3[0] = 1006;
            nArray3[2] = 1024;
            nArray3[3] = 3001;
            nArray3[4] = arrowImage;
            nArray3[6] = 3003;
            nArray3[7] = 4;
            nArray3[9] = 2005;
            nArray3[10] = 1;
            nArray3[12] = 2015;
            nArray3[14] = 68;
            args = nArray3;
            this.arrow = OS.PtCreateWidget(OS.PtButton(), this.handle, args.length / 3, args);
            OS.free(arrowImage);
            if (this.arrow == 0) {
                ToolItem.error(2);
            }
        } else {
            boolean rightAligned = (this.parent.style & 0x20000) != 0;
            boolean toggle = (this.style & 0x30) != 0;
            int[] nArray = new int[12];
            nArray[0] = 3003;
            nArray[3] = 1006;
            nArray[5] = 1024;
            nArray[6] = 3016;
            nArray[7] = rightAligned ? 0 : 3;
            nArray[9] = 1006;
            nArray[10] = toggle ? 8 : 0;
            nArray[11] = 8;
            int[] args = nArray;
            this.handle = this.button = OS.PtCreateWidget(OS.PtButton(), parentHandle, args.length / 3, args);
            if (this.handle == 0) {
                ToolItem.error(2);
            }
        }
        if (index != count) {
            int i = 0;
            int child = OS.PtWidgetChildBack(parentHandle);
            if (child != 0) {
                child = OS.PtWidgetChildBack(child);
            }
            while (i != index && child != 0) {
                child = OS.PtWidgetBrotherInFront(child);
                ++i;
            }
            OS.PtWidgetInsert(this.topHandle(), child, 1);
        }
        if (OS.PtWidgetIsRealized(parentHandle)) {
            OS.PtRealizeWidget(this.topHandle());
        }
    }

    void createWidget(int index) {
        super.createWidget(index);
        this.setDefaultFont();
    }

    void deregister() {
        super.deregister();
        if ((this.style & 4) != 0) {
            WidgetTable.remove(this.button);
            WidgetTable.remove(this.arrow);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        super.destroyWidget();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int topHandle = this.topHandle();
        PhArea_t area = new PhArea_t();
        OS.PtWidgetArea(topHandle, area);
        int x = area.pos_x;
        int y = area.pos_y;
        short width = area.size_w;
        short height = area.size_h;
        int child = OS.PtWidgetChildBack(this.parent.handle);
        if (child != 0) {
            OS.PtWidgetArea(child, area);
            x += area.pos_x;
            y += area.pos_y;
        }
        return new Rectangle(x, y, width, height);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int topHandle = this.topHandle();
        return (OS.PtWidgetFlags(topHandle) & 0x20000) == 0;
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return false;
        }
        return (OS.PtWidgetFlags(this.handle) & 2) != 0;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        int topHandle = this.topHandle();
        int[] nArray = new int[3];
        nArray[0] = 1023;
        int[] args = nArray;
        OS.PtGetResources(topHandle, args.length / 3, args);
        return args[1];
    }

    boolean hasFocus() {
        return OS.PtIsFocused(this.handle) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        int windowProc = this.display.windowProc;
        OS.PtAddEventHandler(this.handle, 32, windowProc, 32);
        OS.PtAddCallback(this.button, 2009, windowProc, 2009);
        if ((this.style & 4) != 0) {
            OS.PtAddCallback(this.arrow, 2009, windowProc, 2009);
        }
        OS.PtAddCallback(this.handle, 2011, windowProc, 2011);
    }

    int hotkeyProc(int widget, int data, int info) {
        if (this.setFocus()) {
            this.click();
        }
        return 0;
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    int Ph_EV_BOUNDARY(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        PhEvent_t ev = new PhEvent_t();
        OS.memmove(ev, cbinfo.event, 40);
        switch (ev.subtype) {
            case 2: {
                int[] nArray = new int[3];
                nArray[0] = 3010;
                int[] args = nArray;
                OS.PtGetResources(this.button, args.length / 3, args);
                int length = OS.strlen(args[1]);
                byte[] font = new byte[length + 1];
                OS.memmove(font, args[1], length);
                this.destroyToolTip(this.toolTipHandle);
                this.toolTipHandle = this.createToolTip(this.toolTipText, this.button, font);
                break;
            }
            case 3: {
                this.destroyToolTip(this.toolTipHandle);
                this.toolTipHandle = 0;
            }
        }
        return 2;
    }

    int Pt_CB_ACTIVATE(int widget, int info) {
        Event event = new Event();
        if (widget == this.arrow) {
            event.detail = 4;
            int topHandle = this.topHandle();
            PhArea_t area = new PhArea_t();
            OS.PtWidgetArea(topHandle, area);
            event.x = area.pos_x;
            event.y = area.pos_y + area.size_h;
        } else if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.postEvent(13, event);
        return 0;
    }

    int Pt_CB_LOST_FOCUS(int widget, int info) {
        this.parent.lastFocus = this;
        return 0;
    }

    void register() {
        super.register();
        if ((this.style & 4) != 0) {
            WidgetTable.put(this.button, this);
            WidgetTable.put(this.arrow, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.button = 0;
        this.arrow = 0;
        this.parent = null;
    }

    void releaseWidget() {
        if (this.control != null) {
            this.setControl(null);
        }
        super.releaseWidget();
        if (this.toolTipHandle != 0) {
            this.destroyToolTip(this.toolTipHandle);
        }
        if (this.parent.lastFocus == this) {
            this.parent.lastFocus = null;
        }
        this.toolTipHandle = 0;
        this.control = null;
        this.hotImage = null;
        this.disabledImage = null;
        this.toolTipText = null;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            ToolItem.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void selectRadio() {
        int index = 0;
        ToolItem[] items = this.parent.getItems();
        while (index < items.length && items[index] != this) {
            ++index;
        }
        int i = index - 1;
        while (i >= 0 && items[i].setRadioSelection(false)) {
            --i;
        }
        int j = index + 1;
        while (j < items.length && items[j].setRadioSelection(false)) {
            ++j;
        }
        this.setSelection(true);
    }

    void setBackgroundPixel(int pixel) {
        OS.PtSetResource(this.handle, 2002, pixel, 0);
        if ((this.style & 4) != 0) {
            OS.PtSetResource(this.button, 2002, pixel, 0);
            OS.PtSetResource(this.arrow, 2002, pixel, 0);
        }
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                ToolItem.error(5);
            }
            if (control.parent != this.parent) {
                ToolItem.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        Control oldControl = this.control;
        this.control = control;
        if (oldControl != null) {
            OS.PtReParentWidget(oldControl.handle, this.parent.parentingHandle());
        }
        if (control != null && !control.isDisposed()) {
            OS.PtReParentWidget(control.handle, this.handle);
            control.setBounds(this.getBounds());
        }
    }

    void setDefaultFont() {
        if (this.display.defaultFont != null) {
            this.setFont(this.parent.defaultFont());
        }
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            ToolItem.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
    }

    public void setEnabled(boolean enabled) {
        this.checkWidget();
        int topHandle = this.topHandle();
        int flags = enabled ? 0 : 0x1020000;
        OS.PtSetResource(topHandle, 1006, flags, 0x1020000);
        if ((this.style & 4) != 0) {
            OS.PtSetResource(this.button, 1006, flags, 0x1020000);
            OS.PtSetResource(this.arrow, 1006, flags, 0x1020000);
        }
    }

    boolean setFocus() {
        if ((this.style & 2) != 0) {
            return false;
        }
        int focusHandle = (this.style & 4) != 0 ? this.button : this.handle;
        Shell shell = this.parent.getShell();
        if (shell.activeMenu != null) {
            return false;
        }
        OS.PtContainerGiveFocus(focusHandle, null);
        return OS.PtIsFocused(focusHandle) != 0;
    }

    void setFont(byte[] font) {
        int ptr = OS.malloc(font.length);
        OS.memmove(ptr, font, font.length);
        this.setFont(ptr);
        OS.free(ptr);
    }

    void setFont(int font) {
        int[] nArray = new int[12];
        nArray[0] = 3010;
        nArray[1] = font;
        nArray[3] = 23003;
        nArray[4] = font;
        nArray[6] = 10008;
        nArray[7] = font;
        nArray[9] = 21001;
        nArray[10] = font;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
        if ((this.style & 4) != 0) {
            OS.PtSetResources(this.button, args.length / 3, args);
            OS.PtSetResources(this.arrow, args.length / 3, args);
        }
    }

    void setForegroundPixel(int pixel) {
        OS.PtSetResource(this.handle, 2001, pixel, 0);
        if ((this.style & 4) != 0) {
            OS.PtSetResource(this.button, 2001, pixel, 0);
            OS.PtSetResource(this.arrow, 2001, pixel, 0);
        }
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            ToolItem.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if ((this.parent.style & 0x800000) != 0) {
            this.setImage(image);
        }
        this.hotImage = image;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            ToolItem.error(5);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if ((this.parent.style & 0x800000) != 0 && this.hotImage != null) {
            return;
        }
        int imageHandle = 0;
        int type = 1;
        if (image != null) {
            imageHandle = this.copyPhImage(image.handle);
            type = this.text.length() != 0 ? 8 : 4;
        }
        int[] nArray = new int[6];
        nArray[0] = 3001;
        nArray[1] = imageHandle;
        nArray[3] = 3003;
        nArray[4] = type;
        int[] args = nArray;
        OS.PtSetResources(this.button, args.length / 3, args);
        if (imageHandle != 0) {
            OS.free(imageHandle);
        }
        if ((this.style & 4) != 0 && OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidget(this.handle);
        }
    }

    boolean setRadioSelection(boolean value) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != value) {
            this.setSelection(value);
            this.postEvent(13);
        }
        return true;
    }

    public void setSelection(boolean selected) {
        this.checkWidget();
        if ((this.style & 0x32) == 0) {
            return;
        }
        OS.PtSetResource(this.handle, 1006, selected ? 2 : 0, 2);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            ToolItem.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        super.setText(string);
        char[] text = new char[string.length()];
        string.getChars(0, text.length, text, 0);
        char mnemonic = this.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        int ptr1 = OS.malloc(buffer.length);
        OS.memmove(ptr1, buffer, buffer.length);
        int ptr2 = 0;
        if (mnemonic != '\u0000') {
            byte[] buffer2 = Converter.wcsToMbcs(null, new char[]{mnemonic}, true);
            ptr2 = OS.malloc(buffer2.length);
            OS.memmove(ptr2, buffer2, buffer2.length);
        }
        this.replaceMnemonic(mnemonic, true, true);
        int type = 1;
        if (this.image != null) {
            type = 8;
        }
        int[] nArray = new int[9];
        nArray[0] = 3011;
        nArray[1] = ptr1;
        nArray[3] = 3003;
        nArray[4] = type;
        nArray[6] = 3018;
        nArray[7] = ptr2;
        int[] args = nArray;
        OS.PtSetResources(this.button, args.length / 3, args);
        OS.free(ptr1);
        OS.free(ptr2);
        if ((this.style & 4) != 0 && OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidget(this.handle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }

    public void setWidth(int width) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (width < 0) {
            return;
        }
        int topHandle = this.topHandle();
        OS.PtSetResource(topHandle, 1023, width, 0);
        if (this.control != null && !this.control.isDisposed()) {
            this.control.setBounds(this.getBounds());
        }
    }
}

