/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        return ProgressBar.checkBits(style |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = wHint;
        int height = hHint;
        if ((this.style & 0x100) != 0) {
            if (width == -1) {
                width = 64;
            }
            if (height == -1) {
                height = 15;
            }
        } else {
            if (height == -1) {
                height = 64;
            }
            if (width == -1) {
                width = 15;
            }
        }
        PhRect_t rect = new PhRect_t();
        PhArea_t area = new PhArea_t();
        rect.lr_x = (short)(width - 1);
        rect.lr_y = (short)(height - 1);
        OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
        width = area.size_w;
        height = area.size_h;
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int clazz = this.display.PtProgress;
        int parentHandle = this.parent.parentingHandle();
        int gaugeFlags = (this.style & 2) != 0 ? 128 : 0;
        int[] nArray = new int[12];
        nArray[0] = 1006;
        nArray[2] = 1024;
        nArray[3] = 21000;
        nArray[4] = gaugeFlags;
        nArray[5] = 128;
        nArray[6] = 21005;
        nArray[7] = (this.style & 0x100) != 0 ? 1 : 0;
        nArray[9] = 1008;
        nArray[11] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            ProgressBar.error(2);
        }
    }

    byte[] defaultFont() {
        return this.display.GAUGE_FONT;
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 21004;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getState() {
        this.checkWidget();
        return 0;
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = this.getMinimum();
        if (minimum >= 0 && minimum < value) {
            OS.PtSetResource(this.handle, 21003, value, 0);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = this.getMaximum();
        if (value >= 0 && value < maximum) {
            OS.PtSetResource(this.handle, 21002, value, 0);
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 21004, value, 0);
    }

    public void setState(int state) {
        this.checkWidget();
    }

    int traversalCode(int key_sym, PhKeyEvent_t ke) {
        return 0;
    }

    int widgetClass() {
        return OS.PtProgress();
    }
}

