/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhArea_t;
import org.eclipse.swt.internal.photon.PhDim_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.TypedListener;

public class List
extends Scrollable {
    public List(Composite parent, int style) {
        super(parent, List.checkStyle(style));
    }

    static int checkStyle(int style) {
        return List.checkBits(style, 4, 2, 0, 0, 0, 0);
    }

    public void add(String string) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtListAddItems(this.handle, new int[]{ptr}, 1, 0);
        OS.free(ptr);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            List.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void add(String string, int index) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        if (index == -1) {
            List.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        int result = OS.PtListAddItems(this.handle, new int[]{ptr}, 1, index + 1);
        OS.free(ptr);
        if (result != 0) {
            int[] nArray = new int[3];
            nArray[0] = 23014;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            if (index >= 0 && index <= args[1]) {
                List.error(14);
            }
            List.error(6);
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int[] nArray = new int[9];
        nArray[0] = 1023;
        nArray[3] = 1024;
        nArray[6] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int resizeFlags = 0x900000;
        OS.PtSetResource(this.handle, 1008, resizeFlags, 0x3F00000);
        if (!OS.PtWidgetIsRealized(this.handle)) {
            OS.PtExtentWidgetFamily(this.handle);
        }
        PhDim_t dim = new PhDim_t();
        OS.PtWidgetPreferredSize(this.handle, dim);
        int width = dim.w;
        int height = dim.h;
        OS.PtSetResource(this.handle, 1008, 0, 0x3F00000);
        OS.PtSetResources(this.handle, args.length / 3, args);
        if (args[7] <= 0) {
            width += 64;
            height += 64;
        }
        if (wHint != -1 || hHint != -1) {
            ScrollBar scroll;
            PhRect_t rect = new PhRect_t();
            PhArea_t area = new PhArea_t();
            rect.lr_x = (short)(wHint - 1);
            rect.lr_y = (short)(hHint - 1);
            OS.PtSetAreaFromWidgetCanvas(this.handle, rect, area);
            if (wHint != -1) {
                width = area.size_w;
                scroll = this.getVerticalBar();
                if (scroll != null) {
                    width += scroll.getSize().x;
                }
            }
            if (hHint != -1) {
                height = area.size_h;
                scroll = this.getHorizontalBar();
                if (scroll != null) {
                    height += scroll.getSize().y;
                }
            }
        }
        return new Point(width, height);
    }

    void createHandle(int index) {
        this.state |= 8;
        int clazz = this.display.PtList;
        int parentHandle = this.parent.parentingHandle();
        int mode = 33312;
        if ((this.style & 2) != 0) {
            mode = (this.style & 0x40) != 0 ? 35968 : 33280;
        }
        mode |= 0x9000;
        boolean hasBorder = (this.style & 0x800) != 0;
        int listFlags = 3;
        int[] nArray = new int[15];
        nArray[0] = 1006;
        nArray[1] = hasBorder ? 256 : 0;
        nArray[2] = 256;
        nArray[3] = 23007;
        nArray[4] = mode;
        nArray[6] = 1006;
        nArray[7] = 524416;
        nArray[8] = 524416;
        nArray[9] = 23002;
        nArray[10] = (this.style & 0x200) != 0 ? 2 : 0;
        nArray[11] = listFlags;
        nArray[12] = 1008;
        nArray[14] = 0x3F00000;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(clazz, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            List.error(2);
        }
        this.createStandardScrollBars();
    }

    int defaultBackground() {
        return this.display.LIST_BACKGROUND;
    }

    byte[] defaultFont() {
        return this.display.LIST_FONT;
    }

    int defaultForeground() {
        return this.display.LIST_FOREGROUND;
    }

    public void deselect(int index) {
        this.checkWidget();
        if (index < 0) {
            return;
        }
        OS.PtListUnselectPos(this.handle, index + 1);
    }

    public void deselect(int start, int end) {
        this.checkWidget();
        if (start > end) {
            return;
        }
        if ((this.style & 4) != 0) {
            int[] nArray = new int[3];
            nArray[0] = 23014;
            int[] args = nArray;
            OS.PtGetResources(this.handle, args.length / 3, args);
            int count = args[1];
            int index = Math.min(count - 1, end);
            if (index >= start) {
                this.deselect(index);
            }
            return;
        }
        int i = start;
        while (i <= end) {
            OS.PtListUnselectPos(this.handle, i + 1);
            ++i;
        }
    }

    public void deselect(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int i = 0;
        while (i < indices.length) {
            int index = indices[i];
            if (index != -1) {
                OS.PtListUnselectPos(this.handle, index + 1);
            }
            ++i;
        }
    }

    public void deselectAll() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        int i = 0;
        while (i < count) {
            OS.PtListUnselectPos(this.handle, i + 1);
            ++i;
        }
    }

    public int getFocusIndex() {
        return this.getSelectionIndex();
    }

    public String getItem(int index) {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23014;
        nArray[3] = 23001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (index < 0 || index >= args[1]) {
            List.error(6);
        }
        int[] items = new int[1];
        OS.memmove(items, args[4] + index * 4, 4);
        int length = OS.strlen(items[0]);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, items[0], length);
        char[] unicode = Converter.mbcsToWcs(null, buffer);
        return new String(unicode);
    }

    public int getItemCount() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getItemHeight() {
        this.checkWidget();
        int[] nArray = new int[9];
        nArray[0] = 23016;
        nArray[3] = 23014;
        nArray[6] = 23003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[4] == 0) {
            int ptr = OS.malloc(1);
            OS.memset(ptr, 0, 1);
            PhRect_t rect = new PhRect_t();
            OS.PfExtentText(rect, null, args[7], ptr, 1);
            OS.free(ptr);
            int inset = 4;
            return inset + (rect.lr_y - rect.ul_y + 1);
        }
        return args[1] / args[4];
    }

    public String[] getItems() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23014;
        nArray[3] = 23001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int[] items = new int[args[1]];
        OS.memmove(items, args[4], args[1] * 4);
        String[] result = new String[args[1]];
        int i = 0;
        while (i < args[1]) {
            int length = OS.strlen(items[i]);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, items[i], length);
            char[] unicode = Converter.mbcsToWcs(null, buffer);
            result[i] = new String(unicode);
            ++i;
        }
        return result;
    }

    public String[] getSelection() {
        this.checkWidget();
        int[] indices = this.getSelectionIndices();
        String[] result = new String[indices.length];
        int i = 0;
        while (i < indices.length) {
            result[i] = this.getItem(indices[i]);
            ++i;
        }
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 23015;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getSelectionIndex() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23015;
        nArray[3] = 23006;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] == 0) {
            return -1;
        }
        short[] buffer = new short[1];
        OS.memmove(buffer, args[4], 2);
        return buffer[0] - 1;
    }

    public int[] getSelectionIndices() {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23015;
        nArray[3] = 23006;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        short[] indices = new short[args[1]];
        OS.memmove(indices, args[4], args[1] * 2);
        int[] result = new int[args[1]];
        int i = 0;
        while (i < args[1]) {
            result[i] = indices[i] - 1;
            ++i;
        }
        return result;
    }

    public int getTopIndex() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 23008;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1] - 1;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 23010, windowProc, 23010);
        OS.PtAddCallback(this.handle, 2009, windowProc, 2009);
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        return OS.PtListItemPos(this.handle, buffer) - 1;
    }

    public int indexOf(String string, int start) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        if (start == 0) {
            return this.indexOf(string);
        }
        int[] nArray = new int[6];
        nArray[0] = 23014;
        nArray[3] = 23001;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        if (start < 0 || start >= count) {
            return -1;
        }
        int[] item = new int[1];
        int index = start;
        while (index < count) {
            OS.memmove(item, args[4] + index * 4, 4);
            int length = OS.strlen(item[0]);
            byte[] buffer = new byte[length];
            OS.memmove(buffer, item[0], length);
            if (string.equals(new String(Converter.mbcsToWcs(null, buffer)))) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public boolean isSelected(int index) {
        this.checkWidget();
        int[] nArray = new int[6];
        nArray[0] = 23015;
        nArray[3] = 23006;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        short[] buffer = new short[1];
        int i = 0;
        while (i < args[1]) {
            OS.memmove(buffer, args[4] + i * 2, 2);
            if (buffer[0] == index + 1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    int Pt_CB_ACTIVATE(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.cbdata == 0) {
            return 2;
        }
        int[] click_count = new int[1];
        OS.memmove(click_count, cbinfo.cbdata, 4);
        if (click_count[0] > 1) {
            this.postEvent(14);
        }
        return 0;
    }

    int Pt_CB_SELECTION(int widget, int info) {
        this.postEvent(13);
        return 0;
    }

    public void remove(int index) {
        int result;
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (index < 0 || index >= args[1]) {
            List.error(6);
        }
        if ((result = OS.PtListDeleteItemPos(this.handle, 1, index + 1)) != 0) {
            List.error(15);
        }
    }

    public void remove(String string) {
        this.checkWidget();
        int index = this.indexOf(string, 0);
        if (index == -1) {
            List.error(5);
        }
        this.remove(index);
    }

    public void remove(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        if (indices.length == 0) {
            return;
        }
        int[] newIndices = new int[indices.length];
        System.arraycopy(indices, 0, newIndices, 0, indices.length);
        this.sort(newIndices);
        int start = newIndices[newIndices.length - 1];
        int end = newIndices[0];
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        if (start < 0 || start > end || end >= count) {
            List.error(6);
        }
        int last = -1;
        int i = 0;
        while (i < newIndices.length) {
            int index = newIndices[i];
            if (last != index) {
                int result = OS.PtListDeleteItemPos(this.handle, 1, index + 1);
                if (result != 0) {
                    List.error(15);
                }
                last = index;
            }
            ++i;
        }
    }

    public void remove(int start, int end) {
        int count;
        int result;
        this.checkWidget();
        if (start > end) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (start < 0 || start > end || end >= args[1]) {
            List.error(6);
        }
        if ((result = OS.PtListDeleteItemPos(this.handle, count = end - start + 1, start + 1)) != 0) {
            List.error(15);
        }
    }

    public void removeAll() {
        this.checkWidget();
        OS.PtListDeleteAllItems(this.handle);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            List.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void select(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        if (count == 0 || start >= count) {
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.style & 4) != 0) {
            this.select(start);
            return;
        }
        int gotoIndex = -1;
        int index = end;
        while (index >= start) {
            gotoIndex = index;
            OS.PtListSelectPos(this.handle, index + 1);
            --index;
        }
        if (gotoIndex != -1) {
            OS.PtListGotoPos(this.handle, gotoIndex + 1);
        }
    }

    public void select(int[] indices) {
        int length;
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        if ((length = indices.length) == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        int gotoIndex = -1;
        int i = 0;
        while (i < length) {
            int index = indices[i];
            if (index >= 0 && index < count) {
                gotoIndex = index;
                OS.PtListSelectPos(this.handle, index + 1);
            }
            ++i;
        }
        if (gotoIndex != -1) {
            OS.PtListGotoPos(this.handle, gotoIndex + 1);
        }
    }

    public void select(int index) {
        this.checkWidget();
        if (index < 0) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (index < args[1]) {
            OS.PtListSelectPos(this.handle, index + 1);
            OS.PtListGotoPos(this.handle, index + 1);
        }
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        int i = 0;
        while (i < count) {
            OS.PtListSelectPos(this.handle, i + 1);
            ++i;
        }
    }

    public void setItem(int index, String string) {
        this.checkWidget();
        if (string == null) {
            List.error(4);
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (index < 0 || index >= args[1]) {
            List.error(6);
        }
        byte[] buffer = Converter.wcsToMbcs(null, string, true);
        int ptr = OS.malloc(buffer.length);
        OS.memmove(ptr, buffer, buffer.length);
        OS.PtListReplaceItemPos(this.handle, new int[]{ptr}, 1, index + 1);
        OS.free(ptr);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        if (items == null) {
            List.error(4);
        }
        int i = 0;
        while (i < items.length) {
            if (items[i] == null) {
                List.error(5);
            }
            ++i;
        }
        OS.PtListDeleteAllItems(this.handle);
        int[] itemsPtr = new int[items.length];
        int i2 = 0;
        while (i2 < itemsPtr.length) {
            byte[] buffer = Converter.wcsToMbcs(null, items[i2], true);
            int ptr = OS.malloc(buffer.length);
            OS.memmove(ptr, buffer, buffer.length);
            itemsPtr[i2] = ptr;
            ++i2;
        }
        OS.PtListAddItems(this.handle, itemsPtr, itemsPtr.length, 0);
        i2 = 0;
        while (i2 < itemsPtr.length) {
            OS.free(itemsPtr[i2]);
            ++i2;
        }
    }

    public void setSelection(int start, int end) {
        this.checkWidget();
        if (end < 0 || start > end || (this.style & 4) != 0 && start != end) {
            this.deselectAll();
            return;
        }
        int[] nArray = new int[3];
        nArray[0] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int count = args[1];
        if (count == 0 || start >= count) {
            this.deselectAll();
            return;
        }
        start = Math.max(0, start);
        end = Math.min(end, count - 1);
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(start, end);
    }

    public void setSelection(int index) {
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        this.select(index);
    }

    public void setSelection(int[] indices) {
        this.checkWidget();
        if (indices == null) {
            List.error(4);
        }
        this.deselectAll();
        int length = indices.length;
        if (length == 0 || (this.style & 4) != 0 && length > 1) {
            return;
        }
        this.select(indices);
    }

    public void setSelection(String[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            List.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        if ((this.style & 2) != 0) {
            this.deselectAll();
        }
        int i = length - 1;
        while (i >= 0) {
            int index = 0;
            String string = items[i];
            if (string != null) {
                while ((index = this.indexOf(string, index)) != -1) {
                    this.select(index);
                    if ((this.style & 4) != 0) {
                        return;
                    }
                    ++index;
                }
            }
            --i;
        }
        if ((this.style & 4) != 0) {
            this.deselectAll();
        }
    }

    public void setTopIndex(int index) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 23008, index + 1, 0);
    }

    public void showSelection() {
        this.checkWidget();
        int[] nArray = new int[15];
        nArray[0] = 23015;
        nArray[3] = 23006;
        nArray[6] = 23008;
        nArray[9] = 23009;
        nArray[12] = 23014;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        if (args[1] == 0) {
            return;
        }
        short[] buffer = new short[1];
        OS.memmove(buffer, args[4], 2);
        int index = buffer[0] - 1;
        int topIndex = args[7] - 1;
        int visibleCount = args[10];
        int count = args[13];
        int bottomIndex = Math.min(topIndex + visibleCount - 1, count);
        if (topIndex <= index && index <= bottomIndex) {
            return;
        }
        int lastIndex = Math.max(1, count - visibleCount + 1);
        int newTop = Math.min(Math.max(index - visibleCount / 2, 1), lastIndex);
        OS.PtSetResource(this.handle, 23008, newTop, 0);
    }

    int widgetClass() {
        return OS.PtList();
    }
}

