/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Resource;

public class Path
extends Resource {
    public int handle;

    public Path(Device device) {
        super(device);
        SWT.error(16);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, Path path, float flatness) {
        super(device);
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
        flatness = Math.max(0.0f, flatness);
        SWT.error(16);
        if (this.handle == 0) {
            SWT.error(2);
        }
        this.init();
    }

    public Path(Device device, PathData data) {
        this(device);
        if (data == null) {
            SWT.error(4);
        }
        this.init(data);
    }

    public void addArc(float x, float y, float width, float height, float startAngle, float arcAngle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void addPath(Path path) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.isDisposed()) {
            SWT.error(5);
        }
    }

    public void addRectangle(float x, float y, float width, float height) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void addString(String string, float x, float y, Font font) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (font == null) {
            SWT.error(4);
        }
        if (font.isDisposed()) {
            SWT.error(5);
        }
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        return false;
    }

    public void close() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void cubicTo(float cx1, float cy1, float cx2, float cy2, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void getBounds(float[] bounds) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        if (bounds.length < 4) {
            SWT.error(5);
        }
    }

    public void getCurrentPoint(float[] point) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (point == null) {
            SWT.error(4);
        }
        if (point.length < 2) {
            SWT.error(5);
        }
    }

    public PathData getPathData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return null;
    }

    public void lineTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void moveTo(float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    public void quadTo(float cx, float cy, float x, float y) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void destroy() {
        this.handle = 0;
    }

    void init(PathData data) {
        byte[] types = data.types;
        float[] points = data.points;
        int i = 0;
        int j = 0;
        while (i < types.length) {
            switch (types[i]) {
                case 1: {
                    this.moveTo(points[j++], points[j++]);
                    break;
                }
                case 2: {
                    this.lineTo(points[j++], points[j++]);
                    break;
                }
                case 4: {
                    this.cubicTo(points[j++], points[j++], points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 3: {
                    this.quadTo(points[j++], points[j++], points[j++], points[j++]);
                    break;
                }
                case 5: {
                    this.close();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Path {*DISPOSED*}";
        }
        return "Path {" + this.handle + "}";
    }
}

