/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;

public final class Font
extends Resource {
    public byte[] handle;

    Font(Device device) {
        super(device);
    }

    public Font(Device device, FontData fd) {
        super(device);
        if (fd == null) {
            SWT.error(4);
        }
        this.init(fd.getName(), fd.getHeight(), fd.getStyle(), fd.stem);
        this.init();
    }

    public Font(Device device, FontData[] fds) {
        super(device);
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fds.length) {
            if (fds[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        FontData fd = fds[0];
        this.init(fd.getName(), fd.getHeight(), fd.getStyle(), fd.stem);
        this.init();
    }

    public Font(Device device, String name, int height, int style) {
        super(device);
        if (name == null) {
            SWT.error(4);
        }
        this.init(name, height, style, null);
        this.init();
    }

    void destroy() {
        this.handle = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        byte[] h = ((Font)object).handle;
        if (h == this.handle) {
            return true;
        }
        if (h == null || this.handle == null) {
            return false;
        }
        if (h.length != this.handle.length) {
            return false;
        }
        int i = 0;
        while (i < h.length) {
            if (this.handle[i] != h[i]) {
                return false;
            }
            if (this.handle[i] == 0) break;
            ++i;
        }
        return true;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return new FontData[]{new FontData(this.handle)};
    }

    public int hashCode() {
        if (this.handle == null) {
            return 0;
        }
        return this.handle.hashCode();
    }

    public boolean isDisposed() {
        return this.handle == null;
    }

    void init(String name, int height, int style, byte[] stem) {
        if (height < 0) {
            SWT.error(5);
        }
        if (stem != null) {
            this.handle = stem;
        } else {
            byte[] buffer;
            byte[] description = Converter.wcsToMbcs(null, name, true);
            int osStyle = 0;
            if ((style & 1) != 0) {
                osStyle |= 1;
            }
            if ((style & 2) != 0) {
                osStyle |= 2;
            }
            if (OS.PfGenerateFontName(description, osStyle, height, buffer = new byte[80]) != 0) {
                this.handle = buffer;
            }
            if (this.handle == null) {
                byte[] defaultFont = this.device.systemFont.handle;
                int fontID = OS.PfDecomposeStemToID(defaultFont);
                if (fontID != 0) {
                    int desc = OS.PfFontDescription(fontID);
                    int length = OS.strlen(desc);
                    byte[] defaultFontName = new byte[length + 1];
                    OS.memmove(defaultFontName, desc, length);
                    OS.PfFreeFont(fontID);
                    if (OS.PfGenerateFontName(defaultFontName, osStyle, height, buffer) != 0) {
                        this.handle = buffer;
                    }
                }
                if (this.handle == null) {
                    this.handle = defaultFont;
                }
            }
        }
        if (this.handle == null) {
            SWT.error(2);
        }
    }

    public static Font photon_new(Device device, byte[] stem) {
        Font font = new Font(device);
        font.init(null, 0, 0, stem);
        return font;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        int index = 0;
        while (index < this.handle.length) {
            if (this.handle[index] == 0) break;
            ++index;
        }
        String text = new String(this.handle, 0, index);
        return "Font {" + text + "}";
    }
}

