/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.FontDetails;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PgDisplaySettings_t;
import org.eclipse.swt.internal.photon.PgVideoModeInfo_t;
import org.eclipse.swt.internal.photon.PhRect_t;

public abstract class Device
implements Drawable {
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    boolean disposed;
    Font systemFont;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData data) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (data != null) {
                this.debug = data.debug;
                this.tracking = data.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(data);
            this.init();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData data) {
    }

    protected void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == object) {
                    this.objects[i] = null;
                    this.errors[i] = null;
                    return;
                }
                ++i;
            }
        }
    }

    public Rectangle getBounds() {
        this.checkDevice();
        PhRect_t rect = new PhRect_t();
        OS.PhWindowQueryVisible(0, 0, OS.PhInputGroup(0), rect);
        int width = rect.lr_x - rect.ul_x + 1;
        int height = rect.lr_y - rect.ul_y + 1;
        return new Rectangle(rect.ul_x, rect.ul_y, width, height);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        PhRect_t rect = new PhRect_t();
        OS.PhWindowQueryVisible(2, 0, OS.PhInputGroup(0), rect);
        int width = rect.lr_x - rect.ul_x + 1;
        int height = rect.lr_y - rect.ul_y + 1;
        return new Rectangle(rect.ul_x, rect.ul_y, width, height);
    }

    public int getDepth() {
        this.checkDevice();
        PgDisplaySettings_t settings = new PgDisplaySettings_t();
        OS.PgGetVideoMode(settings);
        PgVideoModeInfo_t mode_info = new PgVideoModeInfo_t();
        OS.PgGetVideoModeInfo((short)settings.mode, mode_info);
        return mode_info.bits_per_pixel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData data = new DeviceData();
        data.debug = this.debug;
        data.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int count = 0;
                int length = this.objects.length;
                int i = 0;
                while (i < length) {
                    if (this.objects[i] != null) {
                        ++count;
                    }
                    ++i;
                }
                int index = 0;
                data.objects = new Object[count];
                data.errors = new Error[count];
                int i2 = 0;
                while (i2 < length) {
                    if (this.objects[i2] != null) {
                        data.objects[index] = this.objects[i2];
                        data.errors[index] = this.errors[i2];
                        ++index;
                    }
                    ++i2;
                }
            }
        } else {
            data.objects = new Object[0];
            data.errors = new Error[0];
        }
        return data;
    }

    public Point getDPI() {
        this.checkDevice();
        return new Point(96, 96);
    }

    public FontData[] getFontList(String faceName, boolean scalable) {
        this.checkDevice();
        int flags = 112;
        int nfonts = OS.PfQueryFonts(-1, flags |= scalable ? 1 : 2, 0, 0);
        if (nfonts <= 0) {
            return new FontData[0];
        }
        int list_ptr = OS.malloc(nfonts * 128);
        nfonts = OS.PfQueryFonts(-1, flags, list_ptr, nfonts);
        int ptr = list_ptr;
        int nFds = 0;
        FontData[] fds = new FontData[faceName != null ? 4 : nfonts];
        FontDetails details = new FontDetails();
        int i = 0;
        while (i < nfonts) {
            OS.memmove(details, ptr, 128);
            char[] chars = Converter.mbcsToWcs(null, details.desc);
            int index = 0;
            while (index < chars.length) {
                if (chars[index] == '\u0000') break;
                ++index;
            }
            String name = new String(chars, 0, index);
            if (faceName == null || Compatibility.equalsIgnoreCase(faceName, name)) {
                int size = details.losize == 0 && details.hisize == 0 ? 9 : details.losize;
                flags = details.flags & 0xFFFFFFCF;
                while (flags != 0) {
                    int style;
                    if ((flags & 1) != 0) {
                        style = 0;
                        flags &= 0xFFFFFFFE;
                    } else if ((flags & 2) != 0) {
                        style = 1;
                        flags &= 0xFFFFFFFD;
                    } else if ((flags & 4) != 0) {
                        style = 2;
                        flags &= 0xFFFFFFFB;
                    } else {
                        if ((flags & 8) == 0) break;
                        style = 3;
                        flags &= 0xFFFFFFF7;
                    }
                    if (nFds == fds.length) {
                        FontData[] newFds = new FontData[fds.length + nfonts];
                        System.arraycopy(fds, 0, newFds, 0, nFds);
                        fds = newFds;
                    }
                    fds[nFds++] = new FontData(name, size, style);
                }
            }
            ptr += 128;
            ++i;
        }
        OS.free(list_ptr);
        if (nFds == fds.length) {
            return fds;
        }
        FontData[] result = new FontData[nFds];
        System.arraycopy(fds, 0, result, 0, nFds);
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        int color = 0;
        switch (id) {
            case 2: {
                color = 0;
                break;
            }
            case 4: {
                color = 0x800000;
                break;
            }
            case 6: {
                color = 32768;
                break;
            }
            case 8: {
                color = 0x808000;
                break;
            }
            case 10: {
                color = 128;
                break;
            }
            case 12: {
                color = 0x800080;
                break;
            }
            case 14: {
                color = 32896;
                break;
            }
            case 15: {
                color = 0x808080;
                break;
            }
            case 16: {
                color = 0x404040;
                break;
            }
            case 3: {
                color = 0xFF0000;
                break;
            }
            case 5: {
                color = 65280;
                break;
            }
            case 7: {
                color = 0xFFFF00;
                break;
            }
            case 9: {
                color = 255;
                break;
            }
            case 11: {
                color = 0xFF00FF;
                break;
            }
            case 13: {
                color = 65535;
                break;
            }
            case 1: {
                color = 0xFFFFFF;
            }
        }
        return Color.photon_new(this, color);
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return false;
    }

    protected void init() {
        this.systemFont = this.getSystemFont();
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String path) {
        this.checkDevice();
        if (path == null) {
            SWT.error(4);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int i = 0;
            while (i < this.objects.length) {
                if (this.objects[i] == null) {
                    this.objects[i] = object;
                    this.errors[i] = new Error();
                    return;
                }
                ++i;
            }
            Object[] newObjects = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, newObjects, 0, this.objects.length);
            newObjects[this.objects.length] = object;
            this.objects = newObjects;
            Error[] newErrors = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, newErrors, 0, this.errors.length);
            newErrors[this.errors.length] = new Error();
            this.errors = newErrors;
        }
    }

    protected void release() {
    }

    public void setWarnings(boolean warnings) {
        this.checkDevice();
    }
}

