/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        if (Display.getSheetEnabled() && parent != null && (style & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        String directoryPath = null;
        NSOpenPanel panel = NSOpenPanel.openPanel();
        OS.objc_msgSend(panel.id, OS.sel_setShowsHiddenFiles_, true);
        panel.setCanCreateDirectories(true);
        panel.setAllowsMultipleSelection((this.style & 2) != 0);
        panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        panel.setMessage(NSString.stringWith(this.message != null ? this.message : ""));
        panel.setCanChooseFiles(false);
        panel.setCanChooseDirectories(true);
        NSApplication application = NSApplication.sharedApplication();
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            application.beginSheet(panel, this.parent.view.window(), null, 0, 0);
        }
        Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        display.setModalDialog(this);
        NSString dir = this.filterPath != null && this.filterPath.length() > 0 ? NSString.stringWith(this.filterPath) : null;
        int response = panel.runModalForDirectory(dir, null);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            application.endSheet(panel, 0);
        }
        display.setModalDialog(null);
        if (response == 1) {
            NSString filename = panel.filename();
            directoryPath = this.filterPath = filename.getString();
        }
        return directoryPath;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

